package com.digiwin.mobile.mobileuibot.task.model;

import org.apache.commons.lang3.StringUtils;

/**
 * <p>功能描述：试验优测judgment_type类型枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileProcessStatusEnum
 * @Author: xujinc
 * @Date: 2023/08/31 15:59
 */
public enum MobileInspectionStatusEnum {
    // 已检测
    HAS_CHECKED("1", "已检测"),

    // 待检测
    WAIT_CHECK("2", "待检测");

    private String status;

    private String name;

    MobileInspectionStatusEnum(String status, String name) {
        this.status = status;
        this.name = name;
    }

    public String getStatus() {
        return status;
    }

    public String getName() {
        return name;
    }

    public static String getNameByStatus(String status) {
        for (MobileInspectionStatusEnum item : MobileInspectionStatusEnum.values()) {
            if (item.getStatus().equals(status)) {
                return item.getName();
            }
        }
        return StringUtils.EMPTY;
    }
}
