package com.digiwin.mobile.mobileuibot.task.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：APC处理历程节点状态枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskProgressStateEnum
 * @Author: Zaregoto
 * @Date: 2021/5/24 15:59
 */
public enum ReconciliationProgressReasonEnum {
    A1("A1", "A1-顾问测试中"),

    A2("A2", "A2-软代程序调整中"),

    A3("A3", "A3-客户延续需求调整中"),

    A4("A4", "A4-项目整批出货"),

    A5("A5", " A5-客户欲退货"),

    C0("C0", "C0-其他（需说明原因）"),

    C1("C1", "C1-仍在合理验收期测试中"),

    C10("C10", "C10-需整合测试（含与其他产品线整合测试）"),

    C11("C11", "C11-争议处理中（需说明原因）"),

    C12("C12", "C12-待销退/法务处理中"),

    C14("C14", "C14-项目暂停"),

    C2("C2", "C2-个案程序仍有BUG调整中"),

    C3("C3", "C3-顾问修订规格中（内部因素）"),

    C4("C4", "C4-客户大幅调整需求（外部因素）"),

    C5("C5", "C5-客户未进行验收"),

    C6("C6", " C6-顾问无法排验收时程"),

    C99("C99", "C99-依阶段验收"),

    D02("D02", "D02-已开鼎捷发票"),

    D03("D03", "D03-问题处理中，预估本月请款"),

    D04("D04", "D04-依合约开立"),

    D11("D11", "D11-客户验证中"),

    D12("D12", "D12-待与客户协商"),

    D13("D13", "D13-待客户回复"),

    D14("D14", "D14-待客户追加预算"),

    D15("D15", "D15-与客户协调中，暂不可开发票"),

    D16("D16", "D16-跨产品整合，暂不可开发票"),

    D17("D17", "D17-客户未使用，协调中"),

    D18("D18", "D18-争议处理"),

    D21("D21", "D21-扣抵订单"),

    D22("D22", "D22-扣抵0元订单"),

    D23("D23", "D23-客户换货处理"),

    D24("D24", "D24-待销退"),

    D25("D25", "D25-待开境外发票"),

    D26("D26", "D26-内部转拨"),

    D27("D27", "D27-单据不完整"),

    E01("E01", "E01-本月可收款"),

    E02("E02", "E02-依票期收款"),

    E03("E03", "E03-扣抵时数"),

    E04("E04", "E04-扣预付款"),

    E05("E05", "E05-客户指定付款时间"),

    E06("E06", "E06-部份扣抵、部份请款"),

    E11("E11", "E11-与客户对帐中"),

    E12("E12", "E12-客户认为尚有问题不付款"),

    E13("E13", "E13-客户要求上线验证无误才付款"),

    E14("E14", "E14-待协作厂商完成验收后才能请款"),

    E15("E15", "E15-客户不付款，需跨单位协商"),

    E16("E16", "E16-问题项目"),

    E17("E17", "E17-待与客户协商"),

    E18("E18", "E18-待客户移机后付款"),

    E19("E19", "E19-问题处理中"),

    E20("E20", "E20-整合问题"),

    E21("E21", "E21-客户要求换开发票"),

    E22("E22", "E22-待销退后部份请款"),

    E23("E23", "E23-客户换货"),

    E24("E24", "E24-待指结"),

    E25("E25", "E25-业务赠送"),

    E26("E26", "E26-客户退货处理中"),

    E98("E98", "E98-发存证信函"),

    E99("E99", "E99-送交法务处理"),
    ;

    private String code;

    private String desc;

    ReconciliationProgressReasonEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<Map<String, Object>> getReasonList() {
        List<Map<String, Object>> reasonList = new LinkedList<>();
        for (ReconciliationProgressReasonEnum reasonEnum : ReconciliationProgressReasonEnum.values()) {
            Map<String, Object> reasonMap = new HashMap<>(1);
            reasonMap.put("code", reasonEnum.getCode());
            reasonMap.put("desc", reasonEnum.getDesc());
            reasonList.add(reasonMap);
        }
        return reasonList;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
