package com.digiwin.mobile.mobileuibot.task.model;

import org.apache.commons.lang3.StringUtils;

/**
 * <p>功能描述：任务节点状态枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskProductStateEnum
 * @Author: xujinc
 * @Date: 2023/6/14 15:59
 */
public enum TaskChangeFlagEnum {
    // 新
    NEW("1", "新"),

    // 删
    DELETE("2", "删"),

    // 改
    MODIFY("3", "改"),

    // 原
    OROGIN("4", "原");

    private String type;

    private String name;

    TaskChangeFlagEnum(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static String getNameByType(String type) {
        for (TaskChangeFlagEnum tasChangeFlagEnum : TaskChangeFlagEnum.values()) {
            if (tasChangeFlagEnum.getType().equals(type)) {
                return tasChangeFlagEnum.getName();
            }
        }
        return StringUtils.EMPTY;
    }
}
