package com.digiwin.mobile.mobileuibot.task.model;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentPerson;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgressWorkItem;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcWorkflowPreSign;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.bpm.model.DigiwinBpmRedoTask;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.Data;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.util.*;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskProgressPerson
 * @Author: Zaregoto
 * @Date: 2021/5/24 15:21
 */
@Data
public class TaskProgressPerson extends BaseMobileComponentPerson implements Serializable {
    private static final long serialVersionUID = 73041690817205732L;

    private static LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);

    private String closedTime;
    private String comment;
    private String commentDesc;
    private String createTime;
    private String id;
    private Boolean isReassign;
    private String reassignContent;
    //状态：1、已完成；2、进行中；3、未开始
    private Integer state;
    private String stateName;
    private DigiwinIamUserInfo digiwinIamUserInfo;
    private Attachment file;
    //具体的状态名字修改，走PC的判断逻辑
    private List<StateAttribute> stateAttribute;
    private Integer subState;
    //回复的前缀，目前支持的是退回重办和退回重签
    private String commetPrefix;

    /**
     * 是否代理人，作用于展示代理标签
     */
    private Boolean isProxy = false;

    /**
     * 是否有子节点
     */
    private String node;

    /**
     * 标签
     */
    private List<Tag> tags;

    private Integer createType;

    private static final int[] WARNING_SUB_STATE = {60, 150};
    private static final int[] WITHDRAW_SUB_STATE = {70, 250};

    // 状态属性设置
    private List<Card.DesignerRawCard.Content> stateAttrSetting;
    // 附件设置
    private Card.DesignerRawCard.Content attachmentSetting;

    public TaskProgressPerson() {
    }


    //用来处理状态名称和样式
    public static TaskProgressPerson handleStateStyle(String locale, TaskProgressPerson taskProgressPerson) {
        List styleList = new ArrayList();
        String stateContent = "";
        StateAttribute style = new StateAttribute("", "#ff5100", "#ff5100");
        if (taskProgressPerson.getSubState() != null) {
            if (Arrays.stream(WARNING_SUB_STATE).anyMatch(i -> i == taskProgressPerson.getSubState())) {
                stateContent = localeService.getLanguageValue(locale, "已") +
                        ((60 == taskProgressPerson.getSubState())
                                ? localeService.getLanguageValue(locale, "退回重签")
                                : localeService.getLanguageValue(locale, "退回重办"));
                taskProgressPerson.setCommetPrefix(localeService.getLanguageValue(locale, "退回意见:"));
                style.setBorderColor("#ffa500");
                style.setColor("#ffa500");
                style.setContent(stateContent);
                styleList.add(style);
                //计算createBy状态
                String createType = "";
                StateAttribute createTypeStyle = new StateAttribute("", "#ffa500", "#ffa500");
                if (taskProgressPerson.getCreateType() != null) {
                    switch (taskProgressPerson.getCreateType()) {
                        case 0:
                            createType = "";
                            break;
                        case 1:
                            createType = localeService.getLanguageValue(locale, "转派");
                            break;
                        case 2:
                            createType = localeService.getLanguageValue(locale, "退回重签");
                            break;
                        case 3:
                            createType = localeService.getLanguageValue(locale, "退回重办");
                            break;
                        case 4:
                            createType = localeService.getLanguageValue(locale, "加签");
                            break;
                        case 5:
                            createType = localeService.getLanguageValue(locale, "外部新增");
                            break;
                        case 6:
                            createType = localeService.getLanguageValue(locale, "取回重签");
                            break;
                        case 7:
                            createType = localeService.getLanguageValue(locale, "数据转派");
                            break;
                        case 8:
                            createType = localeService.getLanguageValue(locale, "取回重办");
                            break;
                    }
                    createTypeStyle.setContent(createType);
                }
                styleList.add(createTypeStyle);
                taskProgressPerson.setStateAttribute(styleList);
                return taskProgressPerson;
            }
            if (Arrays.stream(WITHDRAW_SUB_STATE).anyMatch(i -> i == taskProgressPerson.getSubState())) {
                stateContent = localeService.getLanguageValue(locale, "已") +
                        localeService.getLanguageValue(locale, "撤回");
                taskProgressPerson.setCommetPrefix(localeService.getLanguageValue(locale, "签核意见:"));
                style.setContent(stateContent);
                styleList.add(style);
                //计算createBy状态
                String createType = "";
                StateAttribute createTypeStyle = new StateAttribute("", "#ffa500", "#ffa500");
                if (taskProgressPerson.getCreateType() != null) {
                    switch (taskProgressPerson.getCreateType()) {
                        case 0:
                            createType = "";
                            break;
                        case 1:
                            createType = localeService.getLanguageValue(locale, "转派");
                            break;
                        case 2:
                            createType = localeService.getLanguageValue(locale, "退回重签");
                            break;
                        case 3:
                            createType = localeService.getLanguageValue(locale, "退回重办");
                            break;
                        case 4:
                            createType = localeService.getLanguageValue(locale, "加签");
                            break;
                        case 5:
                            createType = localeService.getLanguageValue(locale, "外部新增");
                            break;
                        case 6:
                            createType = localeService.getLanguageValue(locale, "取回重签");
                            break;
                        case 7:
                            createType = localeService.getLanguageValue(locale, "数据转派");
                            break;
                        case 8:
                            createType = localeService.getLanguageValue(locale, "取回重办");
                            break;
                    }
                    createTypeStyle.setContent(createType);
                }
                styleList.add(createTypeStyle);
                taskProgressPerson.setStateAttribute(styleList);
                return taskProgressPerson;
            }
        }

        if (taskProgressPerson.getIsReassign() != null && taskProgressPerson.getIsReassign()) {
            stateContent = localeService.getLanguageValue(locale, "转派");
        } else {
            if (taskProgressPerson.getState() != null) {
                switch (taskProgressPerson.getState()) {
                    case -1:
                    case 0:
                        stateContent = localeService.getLanguageValue(locale, "未开始");
                        style.setBorderColor("#5b5b66");
                        style.setColor("#5b5b66");
                        break;
                    case 1:
                        stateContent = localeService.getLanguageValue(locale, "进行中");
                        //因为PC没显示，所以显示为null，
                        stateContent = null;
                        break;
                    case 2:
                        stateContent = localeService.getLanguageValue(locale, "已暂停");
                        break;
                    case 3:
                        stateContent = localeService.getLanguageValue(locale, "已完成");
                        style.setBorderColor("#31b344");
                        style.setColor("#31b344");
                        break;
                    case 4:
                        stateContent = localeService.getLanguageValue(locale, "已撤销");
                        break;
                    case 5:
                        stateContent = localeService.getLanguageValue(locale, "已中止");
                        break;
                    case 6:
                        stateContent = localeService.getLanguageValue(locale, "退回");
                        break;
                    case 7:
                        stateContent = localeService.getLanguageValue(locale, "加签");
                        break;
                    case 8:
                        stateContent = localeService.getLanguageValue(locale, "取回重办");
                        break;
                    case 9:
                        stateContent = localeService.getLanguageValue(locale, "已通知");
                        break;
                    case 10:
                        stateContent = localeService.getLanguageValue(locale, "已会办");
                        break;
                    default:
                        stateContent = "";
                        break;
                }
            }
        }
        taskProgressPerson.setCommetPrefix(localeService.getLanguageValue(locale, "签核意见:"));
        style.setContent(stateContent);
        styleList.add(style);
        //计算createBy状态
        String createType = "";
        StateAttribute createTypeStyle = new StateAttribute("", "#ffa500", "#ffa500");
        if (taskProgressPerson.getCreateType() != null) {
            switch (taskProgressPerson.getCreateType()) {
                case 0:
                    createType = "";
                    break;
                case 1:
                    createType = localeService.getLanguageValue(locale, "转派");
                    break;
                case 2:
                    createType = localeService.getLanguageValue(locale, "退回重签");
                    break;
                case 3:
                    createType = localeService.getLanguageValue(locale, "退回重办");
                    break;
                case 4:
                    createType = localeService.getLanguageValue(locale, "加签");
                    break;
                case 5:
                    createType = localeService.getLanguageValue(locale, "外部新增");
                    break;
                case 6:
                    createType = localeService.getLanguageValue(locale, "取回重签");
                    break;
                case 7:
                    createType = localeService.getLanguageValue(locale, "数据转派");
                    break;
                case 8:
                    createType = localeService.getLanguageValue(locale, "取回重办");
                    break;
            }
            createTypeStyle.setContent(createType);
        }
        styleList.add(createTypeStyle);
        taskProgressPerson.setStateAttribute(styleList);
        return taskProgressPerson;
    }

    public static TaskProgressPerson create(String locale, DigiwinAtmcTaskProgressWorkItem digiwinAtmcTaskProcessWorkItem) {
        TaskProgressPerson taskProgressPerson = new TaskProgressPerson();
        taskProgressPerson.setClosedTime(digiwinAtmcTaskProcessWorkItem.getClosedTime());
        taskProgressPerson.setComment(digiwinAtmcTaskProcessWorkItem.getComment());
        taskProgressPerson.setCreateTime(digiwinAtmcTaskProcessWorkItem.getCreateTime());
        taskProgressPerson.setId(digiwinAtmcTaskProcessWorkItem.getId() + "");
        taskProgressPerson.setIsReassign(digiwinAtmcTaskProcessWorkItem.getReassign() != null
                && !digiwinAtmcTaskProcessWorkItem.getReassign().isEmpty());
        if (taskProgressPerson.getIsReassign()) {
            taskProgressPerson.setReassignContent(localeService.getLanguageValue(locale, "转派"));
        }
        taskProgressPerson.setUserId(digiwinAtmcTaskProcessWorkItem.getPerformerId());
        taskProgressPerson.setName(digiwinAtmcTaskProcessWorkItem.getPerformerName());
        // 根据performerType为998时，结合agentPerformerName展示签核历程
        if (Integer.valueOf(998).equals(digiwinAtmcTaskProcessWorkItem.getPerformerType())) {
            taskProgressPerson.setIsProxy(true);
            taskProgressPerson.setUserId(digiwinAtmcTaskProcessWorkItem.getAgentPerformerId());
            taskProgressPerson.setName(digiwinAtmcTaskProcessWorkItem.getAgentPerformerName());
        }
        //算出签核状态名字和样式
        taskProgressPerson.setState(digiwinAtmcTaskProcessWorkItem.getState());
        taskProgressPerson.setSubState(digiwinAtmcTaskProcessWorkItem.getSubState());
        taskProgressPerson.setCreateType(digiwinAtmcTaskProcessWorkItem.getCreateType());
        taskProgressPerson = handleStateStyle(locale, taskProgressPerson);
        return taskProgressPerson;
    }

    public static TaskProgressPerson create(DigiwinAtmcTaskProgressWorkItem item, String activityType, String locale) {
        TaskProgressPerson taskProgressPerson = new TaskProgressPerson();
        if (ObjectUtils.isEmpty(item.getClosedTime())) {
            taskProgressPerson.setClosedTime(item.getClosedTime());
        } else {
            taskProgressPerson.setClosedTime(item.getClosedTime().replace("/", "-"));
        }
        if (ObjectUtils.isEmpty(item.getClosedTime())) {
            taskProgressPerson.setCreateTime(item.getCreateTime());
        } else {
            taskProgressPerson.setCreateTime(item.getCreateTime().replace("/", "-"));
        }
        taskProgressPerson.setComment(item.getComment());
        taskProgressPerson.setId(item.getId() + "");
        taskProgressPerson.setComment(item.getComment());
        taskProgressPerson.setUserId(item.getPerformerId());
        taskProgressPerson.setName(item.getPerformerName());
        // 根据performerType为998时，结合agentPerformerName展示签核历程
        if (Integer.valueOf(998).equals(item.getPerformerType())) {
            taskProgressPerson.setIsProxy(true);
            taskProgressPerson.setUserId(item.getAgentPerformerId());
            taskProgressPerson.setName(item.getAgentPerformerName());
        }
        //算出流程状态名字和样式
        taskProgressPerson.setState(item.getState());
        taskProgressPerson.setSubState(item.getSubState());
        taskProgressPerson.setCreateType(item.getCreateType());
        taskProgressPerson = getWorkflowStateTitle(activityType, taskProgressPerson, locale);
        return taskProgressPerson;
    }

    public static TaskProgressPerson create(String locale, DigiwinBpmRedoTask digiwinBpmRedoTask) {
        TaskProgressPerson taskProgressPerson = new TaskProgressPerson();
        taskProgressPerson.setName(digiwinBpmRedoTask.getPerformer());

        return taskProgressPerson;
    }

    public static TaskProgressPerson create(DigiwinAtmcWorkflowPreSign.Item item) {
        TaskProgressPerson taskProgressPerson = new TaskProgressPerson();
        taskProgressPerson.setName(item.getPerformerName());
        taskProgressPerson.setUserId(item.getPerformerId());
        return taskProgressPerson;
    }

    public static TaskProgressPerson create(String locale, DigiwinReassignReport reassignReport, Integer state) {
        TaskProgressPerson taskProgressPerson = new TaskProgressPerson();
        taskProgressPerson.setClosedTime(reassignReport.getCreateDate());
        taskProgressPerson.setName(reassignReport.getOldPerformerName() +
                localeService.getLanguageValue(locale, "留言") + ": ");
        taskProgressPerson.setComment(reassignReport.getComment());
        taskProgressPerson.setId(reassignReport.getOperatorId());
        taskProgressPerson.setIsReassign(true);
        taskProgressPerson.setState(state);
        taskProgressPerson = handleStateStyle(locale, taskProgressPerson);
        return taskProgressPerson;
    }

    public static TaskProgressPerson getWorkflowStateTitle(String activityType, TaskProgressPerson taskProgressPerson, String locale) {
        List<StateAttribute> styleList = new ArrayList<>();
        String stateContent = "";
        StateAttribute style = new StateAttribute("", "#59cb65", "#59cb65");
        switch (taskProgressPerson.getState()) {
            case 1:
            case 2: {
                if ("UserTask".equals(activityType)) {
                    stateContent = localeService.getLanguageValue(locale, "待审核");
                    break;
                }
                if ("ManualTask".equals(activityType)) {
                    stateContent = localeService.getLanguageValue(locale, "待提交");
                    break;
                }
                stateContent = localeService.getLanguageValue(locale, "未阅");
                break;
            }
            case 3:
                stateContent = getWorkflowStatusWithSubState(taskProgressPerson.getSubState(), activityType, locale);
                break;
            default:
                stateContent = "";
        }
        style.setContent(stateContent);
        styleList.add(style);
        taskProgressPerson.setStateAttribute(styleList);
        return taskProgressPerson;
    }

    /**
     * 计算流程进度具体状态
     *
     * @param subState
     * @param activityType
     * @return
     */
    public static String getWorkflowStatusWithSubState(Integer subState, String activityType, String locale) {
        switch (subState) {
            case 10:
                if ("UserTask".equals(activityType)) {
                    return localeService.getLanguageValue(locale, "已通过");
                }
                if ("ManualTask".equals(activityType)) {
                    return localeService.getLanguageValue(locale, "已提交");
                }
                return localeService.getLanguageValue(locale, "已阅");

            case 20:
            case 30:
            case 80:
            case 90:
            case 120:
            case 130:
            case 160:
            case 180:
            case 210:
            case 220:
            case 240:
            case 270:
            case 280:
            case 290:
            case 310:
            case 320:
            case 330:
                if ("UserTask".equals(activityType)) {
                    return localeService.getLanguageValue(locale, "无需审核");
                }
                return localeService.getLanguageValue(locale, "已关闭");
            case 50:
                if ("UserTask".equals(activityType)) {
                    return localeService.getLanguageValue(locale, "已向前加签");
                }
                return "";
            case 60:
            case 70:
            case 150:
                return localeService.getLanguageValue(locale, "已退回");
            case 110:
                if ("UserTask".equals(activityType) || "ManualTask".equals(activityType)) {
                    return localeService.getLanguageValue(locale, "已转派");
                }
                return "";
            case 140:
                if ("UserTask".equals(activityType)) {
                    return localeService.getLanguageValue(locale, "已向后加签");
                }
                return "";
            case 170:
                if ("UserTask".equals(activityType)) {
                    return localeService.getLanguageValue(locale, "已拒绝");
                }
                return "";
            case 230:
            case 260:
                if ("UserTask".equals(activityType)) {
                    return localeService.getLanguageValue(locale, "已自动跳过");
                }
                return "";
            case 250:
                return localeService.getLanguageValue(locale, "已撤回");
            default:
                return "";
        }
    }

    public static List<StateAttribute> buildStateAttribute(List<Card.DesignerRawCard.Content> rawContents, Map<String, Object> map) {
        if (CollectionUtils.isEmpty(rawContents) || map == null) {
            return null;
        }
        List<StateAttribute> styleList = new ArrayList<>();
        for (Card.DesignerRawCard.Content rawContent : rawContents) {
            // 非状态枚举类型直接返回
            if (!"STATE_ENUM".equals(rawContent.getType())) {
                continue;
            }
            String value = StringUtil.valueOf(map.get(rawContent.getSchema()));
            if (StringUtil.isEmpty(value)) {
                continue;
            }
            Card.DesignerRawCard.Content.EnumObj enumObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), new TypeReference<Card.DesignerRawCard.Content.EnumObj>() {
            });
            if (enumObj == null) {
                continue;
            }
            List<Card.DesignerRawCard.Content.EnumObj.Option> options = enumObj.getOptions();
            if (CollectionUtils.isEmpty(options)) {
                continue;
            }
            Optional<Card.DesignerRawCard.Content.EnumObj.Option> optional = options.stream().filter(r -> value.equals(r.getId())).findFirst();
            if (!optional.isPresent()) {
                continue;
            }
            Card.DesignerRawCard.Content.EnumObj.Option option = optional.get();
            styleList.add(new StateAttribute(option.getText(), option.getBorderColor(), option.getColor()));
        }
        return styleList;
    }

    public static Attachment<AttachmentRawDataDigiwinAthena> buildFile(Card.DesignerRawCard.Content rawContent, Map<String, Object> map) {
        if (map == null || rawContent == null || rawContent.getSchema() == null) {
            return null;
        }
        // 非附件类型直接返回
        if (!"FILE_UPLOAD".equals(rawContent.getType())) {
            return null;
        }
        Attachment<AttachmentRawDataDigiwinAthena> attachment = Card.getAttachment(rawContent.getSetting(), map.get(rawContent.getSchema()), rawContent.getLabel());
        // 无附件直接返回
        if (CollectionUtils.isEmpty(attachment.getFileList())) {
            return null;
        }
        return attachment;
    }
}
