package com.digiwin.mobile.mobileuibot.task.model;

/**
 * <p>功能描述：任务节点状态枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskProgressStateEnum
 * @Author: Zaregoto
 * @Date: 2021/5/24 15:59
 */
public enum TaskProgressStateEnum {
    // 已完成
    DONE(1),
    // 进行中
    DOING(2),
    // 未开始
    TODO(3);

    private Integer value;

    TaskProgressStateEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static TaskProgressStateEnum getByPcStateNumber(Integer pcStateNumber) {
        switch (pcStateNumber) {
            case 0:
            case -1:
                return TODO;
            case 1:
            case 6:
                return DOING;
            case 3:
                return DONE;
            default:
                return DONE;
        }
    }
}
