package com.digiwin.mobile.mobileuibot.task.model;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.DataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfig;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.pattern.bean.PatternDetail;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TodoList;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.test.TestV1ToV2Util;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.Data;
import lombok.ToString;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：任务清单接口使用的任务卡数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Task
 * @Author: Zaregoto
 * @Date: 2021/5/13 15:08
 */
@Data
@ToString
public class TaskSummary implements Serializable {
    private static final long serialVersionUID = -4831571307134460840L;

    private String contentUrl;
    private Boolean emergency;
    private String endTime;
    private String startTime;
    private String eocName;
    private Boolean exception;
    private TaskExtraParameter extraParameter;
    private String dataId;
    private Boolean importance;
    private String jumpPageId;
    private String jumpPageTitle;
    private String name;
    private String subName;
    private Boolean newly;
    private String projectName;
    private Boolean proxy;
    private TaskPerson proxyPerson;
    private String sourceTenantName;
    private String state;

    /*应用其中type字段，1：打开新页面；2、底部弹窗打开新页面；3：调用接口，成功后返回上一页并刷新；31：调用接口，
    成功后跳转提交成功页面(此时返回不会返回到提交按钮页面)；4：返回上一页；41：接收回调，在点击时返回上一页，同时将接收的回调传给前一页面；
    5：Toast提示；6：右侧弹窗选择明细后跳转页面，此时requestUrl为获取明细接口；71：调用蓝牙打印组件；72：调用扫码组件（连续扫描）；
    81：顺时针旋转内容90度并全屏展示；82：逆时针旋转内容90度并全屏展示;9:用webview打开网页
     */
    //应用requestUrl表示跳转地址
    private Action action;
    /**
     * 任务是否已完成
     */
    private Boolean finished;
    /**
     * 行事历团队名称
     */
    private String calenderTeamName;

    /**
     * 执行人名称
     */
    private String executorName;

    /**
     * 是否为团队行事历的入口
     */
    private Boolean teamEnter = false;
    /**
     * 是否为团队任务
     */
    private Boolean isTeamTask = false;

    /**
     * 是否为PCC任务
     */
    private Boolean isPccTask = false;

    /**
     * 是否授权
     */
    private Boolean hasAppPermission = true;

    /**
     * 引擎中是否有待处理
     */
    private Boolean engineHasWaittingData = true;

    /**
     * 是否退回或退回重签
     */
    private Boolean reexecute = false;

    /**
     * 是否加签
     */
    private Boolean addTask = false;

    /**
     * 转派
     */
    private Boolean reassign = false;

    /**
     * 已变更
     */
    private Boolean dataChangeRead;

    /**
     * 变更中
     */
    private Boolean hasDataChanged;

    /**
     * 是否交接，  approvalStateCode = 'handover' 或 item.handover 为 true
     */
    private String approvalStateCode;

    /**
     * 是否交接，  approvalStateCode = 'handover' 或 item.handover 为 true
     */
    private Boolean handover = false;

    /**
     * 是否分享至他人
     */
    private Boolean pinning;

    /**
     * 数据变更状态（已变更/变更中）
     */
    private String dataChangeStatus;

    /**
     * 任务状态信息-底部蓝色框文案
     */
    private String taskStatusMsg;

    private String tmActivityId;

    private String tmActivityName;

    /**
     * 原始项目名称
     */
    private String originProjectName;

    /**
     * 前台卡面展示的开始时间
     */
    private String showPlanEndTimeMin;

    /**
     * 前台卡面展示的结束时间
     */
    private String showPlanEndTimeMax;

    /**
     * 逾时
     */
    private Boolean overdue;

    /**
     * 任务状态信息-自定义标签
     */
    private List<DigiwinAtmcLabel> labels;

    /**
     * 任务类型排序信息
     */
    private DigiwinAtmcOrder order;

    /**
     * 条目已经分组好的信息（不是分组能展示的所有种类）
     */
    private DigiwinAtmcGroup group;

    /**
     * 配置信息
     */
    private List<DigiwinAtmcCardConfigItem> cardConfig;

    private Map<String, Object> businessMessage;

    /**
     * 是否为三方待办任务
     */
    private Boolean isTripartiteTodo = false;

    /**
     * 副标题
     */
    private String subTitle;

    /**
     * 描述
     */
    private String description;

    public Boolean getIsPccTask() {
        if (ObjectUtils.isNotEmpty(this.extraParameter) &&
                (StringUtil.isNotEmpty(this.extraParameter.getTmTaskId()) && StringUtil.isNotEmpty(this.extraParameter.getTmActivityId()))) {
            return TaskStringUtil.isPccTask(this.extraParameter.getTmTaskId(), this.extraParameter.getTmActivityId());
        }
        return this.isPccTask;
    }

    public TaskSummary() {
    }

    public static TaskSummary create(String locale, String iamUserToken,
                                     DigiwinAtmcBacklog digiwinAtmcBacklog, String jumpPageId, List<CustomTaskConfig> customTaskConfigList,
                                     boolean isMyCalender, String currentUserId, boolean isTeamTask, String url,
                                     Map<String, Integer> taskTypeData, Map<String, Integer> taskFlowData,
                                     Map<String, Integer> taskReadStatusData, Map<String, Integer> taskStatusData,
                                     Map<String, DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter> customFilter,
                                     Map<String, Set<String>> customSelectOptionMap, Set<String> orderCodeSetFromBacklogs,
                                     LocaleService localeService) {
        TaskSummary taskSummary = create(locale, iamUserToken, digiwinAtmcBacklog, jumpPageId, customTaskConfigList, isMyCalender, currentUserId, isTeamTask, localeService);
        taskTypeData.put(digiwinAtmcBacklog.getTmActivityId() + "_" + digiwinAtmcBacklog.getBacklogId(), 1);
        taskFlowData.put(buildFlowKey(digiwinAtmcBacklog), 1);
        taskReadStatusData.put(buildReadStatusKey(digiwinAtmcBacklog), 1);
        taskStatusData.put(buildStatusKey(digiwinAtmcBacklog), 1);

        // 自定义筛选和排序条件,从列表接口每个条目的cardConfig字段的filter字段里获取
        if (!CollectionUtils.isEmpty(digiwinAtmcBacklog.getCardConfig())) {
            digiwinAtmcBacklog.getCardConfig().stream()
                    .forEach(item -> {
                        String aliasField = item.getAliasField();
                        Optional<DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter> cardConfigFilterOpt = Optional.ofNullable(item)
                                .map(DigiwinAtmcCardConfigItem::getConfig)
                                .map(DigiwinAtmcCardConfigItemSetInfo::getFilter);
                        if (cardConfigFilterOpt.isPresent()) {
                            customFilter.putIfAbsent(aliasField, cardConfigFilterOpt.get());

                            // 自定义筛选-select选项值获取,收集每个卡片BusinessMessage有此值的
                            if (DataTypeEnum.SELECT.getName().equalsIgnoreCase(cardConfigFilterOpt.get().getDataType())
                                    && !CollectionUtils.isEmpty(digiwinAtmcBacklog.getBusinessMessage())) {
                                List<String> aliasFieldValList = (List<String>) MapUtil.getOrDefault(digiwinAtmcBacklog.getBusinessMessage(), aliasField, Collections.emptyList());
                                if (!CollectionUtils.isEmpty(aliasFieldValList)) {
                                    Set<String> customSelectOptionList = customSelectOptionMap.get(aliasField);
                                    customSelectOptionList = CollectionUtils.isEmpty(customSelectOptionList) ? new HashSet<>() : customSelectOptionList;
                                    customSelectOptionList.addAll(aliasFieldValList);
                                    customSelectOptionMap.put(aliasField, customSelectOptionList);
                                }
                            }
                        }

                        Optional<DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigOrder> cardConfigOrderOpt = Optional.ofNullable(item)
                                .map(DigiwinAtmcCardConfigItem::getConfig)
                                .map(DigiwinAtmcCardConfigItemSetInfo::getOrder);
                        if (cardConfigOrderOpt.isPresent()) {
                            orderCodeSetFromBacklogs.add(aliasField);
                        }
                    });
        }

//        if (StringUtils.hasLength(url)) {
//            taskSummary.getAction().setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
//            url = url
//                    // 由于KM目前没有获取任务所属应用id的接口，故在配置应用时按相应规律进行配置
//                    // appId=租户id(首字母小写)-租户id
//                    .replaceAll("\\$\\{appId}", org.apache.commons.lang3.StringUtils.uncapitalize(digiwinAtmcBacklog.getTenantId())
//                            + "-" + digiwinAtmcBacklog.getTenantId())
////                    .replaceAll("\\$\\{customTaskUrl}", customTaskUrl)
//                    .replaceAll("\\$\\{tmActivityId}", digiwinAtmcBacklog.getTmActivityId())
//                    .replaceAll("\\$\\{tmTaskId}", digiwinAtmcBacklog.getTmTaskId())
//                    .replaceAll("\\$\\{backlogId}", String.valueOf(digiwinAtmcBacklog.getBacklogId()))
//                    .replaceAll("\\$\\{mobile_user_token}", iamUserToken)
//                    .replaceAll("\\$\\{tenantId}", digiwinAtmcBacklog.getTenantId());
//            taskSummary.getAction().setRequestUrl(url);
//        }
        return taskSummary;
    }

    private static String buildStatusKey(DigiwinAtmcBacklog digiwinAtmcBacklog) {
        StringBuffer key = new StringBuffer();
        if (digiwinAtmcBacklog.getOverdue() || digiwinAtmcBacklog.getException()) {
            //逾期/异常
            key.append(DigiwinAtmcBacklog.TASK_STATUS_OVERDUEEXCEPTION);
        } else if (digiwinAtmcBacklog.getEmergency()) {
            //紧急
            key.append(DigiwinAtmcBacklog.TASK_STATUS_EMERGENCY);
        } else if (digiwinAtmcBacklog.getHasDataChanged()) {
            //已变更
            key.append(DigiwinAtmcBacklog.TASK_STATUS_DATACHANGEREAD);
        } else if (digiwinAtmcBacklog.getImportance()) {
            //特别关注
            key.append(DigiwinAtmcBacklog.TASK_STATUS_IMPORTANCE);
        } else if (BooleanUtils.isNotTrue(digiwinAtmcBacklog.getHasAppPermission())) {
            //未授权
            key.append(DigiwinAtmcBacklog.TASK_STATUS_HASAPPPERMISSION);
        } else if (digiwinAtmcBacklog.getReexecute()) {
            //退回或退回重签
            key.append(DigiwinAtmcBacklog.TASK_STATUS_REEXECUTE);
        } else if (digiwinAtmcBacklog.getAddTask()) {
            //加签
            key.append(DigiwinAtmcBacklog.TASK_STATUS_ADDTASK);
        } else {
            //其他
            key.append(DigiwinAtmcBacklog.TASK_STATUS_OTHER);
        }
        key.append("_").append(digiwinAtmcBacklog.getBacklogId());
        return key.toString();
    }

    private static String buildFlowKey(DigiwinAtmcBacklog digiwinAtmcBacklog) {
        StringBuffer key = new StringBuffer();
        if (digiwinAtmcBacklog.getReassign()) {
            //转派
            key.append(DigiwinAtmcBacklog.TASK_OTHERTASKINFO_REASSIGN);
        } else if ("handover".equalsIgnoreCase(digiwinAtmcBacklog.getApprovalStateCode())
                || BooleanUtils.isTrue(digiwinAtmcBacklog.getHandover())) {
            //交接
            key.append(DigiwinAtmcBacklog.TASK_OTHERTASKINFO_HANDOVER);
        } else if (!digiwinAtmcBacklog.getIsOwner()) {
            //代理
            key.append(DigiwinAtmcBacklog.TASK_OTHERTASKINFO_AGENT);
        } else if (BooleanUtils.isTrue(digiwinAtmcBacklog.getPinning())) {
            //他人分享
            key.append(DigiwinAtmcBacklog.TASK_OTHERTASKINFO_PINNING);
        } else {
            //其他
            key.append(DigiwinAtmcBacklog.TASK_OTHERTASKINFO_OTHER);
        }
        key.append("_").append(digiwinAtmcBacklog.getBacklogId());
        return key.toString();
    }

    private static String buildReadStatusKey(DigiwinAtmcBacklog digiwinAtmcBacklog) {
        StringBuffer key = new StringBuffer();
        //未读
        if (digiwinAtmcBacklog.getReadCount() == 0) {
            key.append(DigiwinAtmcBacklog.TASK_READ_STATUS_UNREAD);
            //已读
        } else {
            key.append(DigiwinAtmcBacklog.TASK_READ_STATUS_READ);
        }
        key.append("_").append(digiwinAtmcBacklog.getBacklogId());
        return key.toString();
    }

    public static TaskSummary create(String locale, String iamUserToken,
                                     DigiwinAtmcBacklog digiwinAtmcBacklog, String jumpPageId, List<CustomTaskConfig> customTaskConfigList,
                                     boolean isMyCalender, String currentUserId, boolean isTeamTask, LocaleService localeService) {
        TaskSummary taskSummary = new TaskSummary();
        // FIXME 非逾期任务才拼上GET接口的URL，展示在App上；逾期任务不展示内容，所以不需要URL
//        if (!digiwinAtmcBacklog.getOverdue()) {

        String urlTemplate = AppContext.getBaseUrl()
                + "/mobile/v1/task/card/content?"
                + "dataId=%s&iamUserToken=%s&tenantId=%s&locale=%s&tmCategory=%s&tmPattern=%s&type=%s&tmTaskId=%s&tmActivityId=%s&proxyToken=%s";
        taskSummary.setContentUrl(
                String.format(urlTemplate,
                        digiwinAtmcBacklog.getBacklogId(),
                        iamUserToken, digiwinAtmcBacklog.getTenantId(), locale,
                        digiwinAtmcBacklog.getTmCategory(), digiwinAtmcBacklog.getTmPattern(),
                        digiwinAtmcBacklog.getType() + "",
                        digiwinAtmcBacklog.getTmTaskId(),
                        digiwinAtmcBacklog.getTmActivityId(),
                        digiwinAtmcBacklog.getProxyToken() == null ? "" : digiwinAtmcBacklog.getProxyToken()
                )
        );

//        }
        taskSummary.setEmergency(digiwinAtmcBacklog.getEmergency());
        taskSummary.setEndTime(digiwinAtmcBacklog.getEndTime());
        taskSummary.setStartTime(digiwinAtmcBacklog.getStartTime());
        taskSummary.setEocName(digiwinAtmcBacklog.getEocName());
        taskSummary.setException(digiwinAtmcBacklog.getException());
        taskSummary.setExtraParameter(new TaskExtraParameter(
                digiwinAtmcBacklog.getAppCode(),
                digiwinAtmcBacklog.getTmActivityId(), digiwinAtmcBacklog.getTmCategory(),
                digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmTaskId()));
        taskSummary.setDataId(digiwinAtmcBacklog.getBacklogId() + "");
        taskSummary.setImportance(digiwinAtmcBacklog.getImportance());
        if (digiwinAtmcBacklog.isTypeOfManualTask()) {
            jumpPageId = PageSettingIdPresetEnum.MOBILE_MANUAL_TASK_DETAIL.toString();
            taskSummary.setJumpPageId(jumpPageId);
        } else {
            if (TestV1ToV2Util.exist(digiwinAtmcBacklog.getTmActivityId())) {
                taskSummary.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
            } else {
                taskSummary.setJumpPageId(Optional.ofNullable(jumpPageId).orElse(""));
            }
        }
        taskSummary.setSourceTenantName(StringUtils.hasLength(digiwinAtmcBacklog.getSourceTenantName()) ? digiwinAtmcBacklog.getSourceTenantName() : null);

        // 任务名称
        taskSummary.setName(digiwinAtmcBacklog.getName());

        // 签核类型需要加上任务节点，前端会改变字体大小，展示在任务名称后面
        if (TaskStringUtil.isNeedSubName(digiwinAtmcBacklog)) {
            taskSummary.setSubName(digiwinAtmcBacklog.getSubName());
        }

        taskSummary.setNewly(digiwinAtmcBacklog.getReadCount() == 0);
        taskSummary.setProxy(digiwinAtmcBacklog.getIsOwner() == null ? false : !digiwinAtmcBacklog.getIsOwner());
        taskSummary.setProxyPerson(TaskPerson.create(locale, digiwinAtmcBacklog, isMyCalender));

        taskSummary.setOriginProjectName(digiwinAtmcBacklog.getProjectName());
        taskSummary.setTmActivityId(digiwinAtmcBacklog.getTmActivityId());
        taskSummary.setTmActivityName(digiwinAtmcBacklog.getTmActivityName());

        // 任务流程状态标签（撤回/加签/退回）
        taskSummary.setState(TaskStringUtil.getTaskStateText(digiwinAtmcBacklog) == null ? "" : TaskStringUtil.getTaskStateText(digiwinAtmcBacklog));

        // 数据变更状态标签（已变更/变更中）
        taskSummary.setDataChangeStatus(TaskStringUtil.getDataChangeStatusText(digiwinAtmcBacklog, localeService, locale));

        taskSummary.setIsTeamTask(isTeamTask);
        taskSummary.setHasAppPermission(digiwinAtmcBacklog.getHasAppPermission());
        taskSummary.setPinning(digiwinAtmcBacklog.getPinning());
        taskSummary.setEngineHasWaittingData(digiwinAtmcBacklog.getEngineHasWaittingData());
        taskSummary.setReexecute(digiwinAtmcBacklog.getReexecute());
        taskSummary.setAddTask(digiwinAtmcBacklog.getAddTask());
        taskSummary.setReassign(digiwinAtmcBacklog.getReassign());
        taskSummary.setDataChangeRead(digiwinAtmcBacklog.getDataChangeRead());
        taskSummary.setHasDataChanged(digiwinAtmcBacklog.getHasDataChanged());
        taskSummary.setApprovalStateCode(digiwinAtmcBacklog.getApprovalStateCode());
        taskSummary.setHandover(digiwinAtmcBacklog.getHandover());
        taskSummary.setOverdue(digiwinAtmcBacklog.getOverdue());

        // 卡面时间展示
        if (BooleanUtils.isNotTrue(digiwinAtmcBacklog.getMerge())) {
            // 如果不是合并任务卡，不展示时间段
            taskSummary.setShowPlanEndTimeMax(digiwinAtmcBacklog.getEndTime());
        } else if (Objects.equals(digiwinAtmcBacklog.getPlanEndTimeMin(), digiwinAtmcBacklog.getPlanEndTimeMax())) {
            // 如果是合并任务卡且开始和结束时间一致，也不展示时间段
            taskSummary.setShowPlanEndTimeMax(digiwinAtmcBacklog.getPlanEndTimeMax());
        } else {
            // 如果是合并任务卡且开始和结束时间不一致，展示时间段
            taskSummary.setShowPlanEndTimeMin(digiwinAtmcBacklog.getPlanEndTimeMin());
            taskSummary.setShowPlanEndTimeMax(digiwinAtmcBacklog.getPlanEndTimeMax());
        }

        // 底部蓝色框内容 （分享，代理，转派等）
        taskSummary.setTaskStatusMsg(buildTaskStatusMsg(digiwinAtmcBacklog, localeService, locale));

        // 自定义标签 按权重从大到小排序，没有权重的放后面
        if (!CollectionUtils.isEmpty(digiwinAtmcBacklog.getLabels())) {
            List<DigiwinAtmcLabel> sortedLabels = digiwinAtmcBacklog.getLabels().stream()
                    .filter(e -> StringUtils.hasLength(e.getOrderWeight()))
                    .sorted(Comparator.comparing(DigiwinAtmcLabel::getOrderWeight, Comparator.comparingInt(Integer::parseInt)))
                    .collect(Collectors.toList());

            sortedLabels.addAll(digiwinAtmcBacklog.getLabels().stream()
                    .filter(e -> !StringUtils.hasLength(e.getOrderWeight())).collect(Collectors.toList()));
            taskSummary.setLabels(sortedLabels);
        }

        // 自定义分组
        taskSummary.setGroup(digiwinAtmcBacklog.getGroup());

        // 任务类型排序信息
        taskSummary.setOrder(digiwinAtmcBacklog.getOrder());

        taskSummary.setBusinessMessage(digiwinAtmcBacklog.getBusinessMessage());

        taskSummary.setCardConfig(digiwinAtmcBacklog.getCardConfig());

        // 项目简介
        taskSummary.setProjectName(ProjectStringUtil.getProjectNameOnCard(
                locale, digiwinAtmcBacklog.getProjectStartTime(),
                digiwinAtmcBacklog.getProjectEndTime(), digiwinAtmcBacklog.getProjectName(),
                TaskStringUtil.isPccTask(digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId())));

        //将和行事历有关的任务，设置state，0代表未完成，1代表已完成
        if (digiwinAtmcBacklog.getExtendData() != null && digiwinAtmcBacklog.getExtendData().getFinished()) {
            taskSummary.setFinished(true);
        } else {
            taskSummary.setFinished(false);
        }
        taskSummary.setCalenderTeamName(digiwinAtmcBacklog.getCalenderTeamName());
        if (!isMyCalender) {
            taskSummary.setTeamEnter(true);
            if (digiwinAtmcBacklog.getOwnerUserId().equals(currentUserId)) {
                taskSummary.setExecutorName("");
            } else {
                taskSummary.setExecutorName(digiwinAtmcBacklog.getOwnerUserName());
            }

        } else {
            taskSummary.setTeamEnter(false);
        }

        taskSummary.setAction(buildAction(digiwinAtmcBacklog, customTaskConfigList,
                locale, iamUserToken, taskSummary.getJumpPageId(), isTeamTask, false));
        return taskSummary;
    }

    public static Action buildAction(DigiwinAtmcBacklog digiwinAtmcBacklog, List<CustomTaskConfig> customTaskConfigList,
                                     String locale, String iamUserToken, String jumpPageId, boolean isTeamTask, boolean isNeedTaskExtraParameter) {
        /**
         * action操作须放在最后处理，方便逻辑上厘清
         */
        //2022.04.13，Liux。增加action返回对象参数，是为了任务卡支持跳H5功能。
        CustomTaskConfig targetCustomTaskConfig = null;
        for (CustomTaskConfig tempCustomTaskConfig : customTaskConfigList) {
            String tmTaskId = tempCustomTaskConfig.getTmTaskId();
            String tmActivityId = tempCustomTaskConfig.getTmActivityId();

            if (digiwinAtmcBacklog.isEqualWithBacklogInTaskIdAndActivityId(tmTaskId, tmActivityId)) {
                targetCustomTaskConfig = tempCustomTaskConfig;
                break;
            }
        }
        Action action = new Action();
        boolean isCustomH5Task = targetCustomTaskConfig != null;
        if (isCustomH5Task) {
            String requestUrl = targetCustomTaskConfig.getCustomTaskUrl(locale, iamUserToken, digiwinAtmcBacklog);

            action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
            action.setRequestUrl(requestUrl);
            action.setIsThirdPartyRequestUrl(true);
        } else {
            // 有jumpPageId，表明是移动平台支持用动态渲染页面打开的任务详情；反之则不是
            if (StringUtils.hasLength(jumpPageId)) {
                action.setDataId(String.valueOf(digiwinAtmcBacklog.getBacklogId()));
                action.setJumpPageId(jumpPageId);
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                JSONObject rawData = new JSONObject(2);
                if (StringUtils.hasLength(digiwinAtmcBacklog.getProxyToken())) {
                    rawData.put("digi-proxy-token", digiwinAtmcBacklog.getProxyToken());
                }
                rawData.put("isTeamTask", isTeamTask);
                rawData.put("pinning", digiwinAtmcBacklog.getPinning());
                if (isNeedTaskExtraParameter) {
                    rawData.put("taskExtraParameter", new TaskExtraParameter(
                            digiwinAtmcBacklog.getAppCode(),
                            digiwinAtmcBacklog.getTmActivityId(), digiwinAtmcBacklog.getTmCategory(),
                            digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmTaskId()));
                }
                action.setRawData(rawData);
            } else {
                action.setDataId(String.valueOf(digiwinAtmcBacklog.getBacklogId()));
                action.setRequestUrl("/mobile/v1/pattern/jump/info?type=search");
                DigiwinAtmcSearchResult result = new DigiwinAtmcSearchResult();
                result.setEndTime(digiwinAtmcBacklog.getEndTime());
                result.setId(digiwinAtmcBacklog.getBacklogId());
                result.setName(digiwinAtmcBacklog.getName());
                result.setStartTime(digiwinAtmcBacklog.getStartTime());
                result.setType(PatternDetail.PATTERN_TYPE_TASK);
                result.setCode(String.valueOf(digiwinAtmcBacklog.getBacklogId()));
                result.setEngineType("TaskEngine");
                action.setRawData(result);
            }
        }
        return action;
    }


    private static String buildTaskStatusMsg(DigiwinAtmcBacklog digiwinAtmcBacklog, LocaleService localeService, String locale) {
        // 分享
        if (BooleanUtils.isTrue(digiwinAtmcBacklog.getPinning())) {
            return String.format(localeService.getLanguageValue(locale, "由%s分享"), digiwinAtmcBacklog.getOwnerUserName());
        }

        // 代理+辅助
        if (BooleanUtils.isFalse(digiwinAtmcBacklog.getIsOwner()) && StringUtils.hasLength(digiwinAtmcBacklog.getAuxiliaryTenantName())) {
            return String.format(localeService.getLanguageValue(locale, "代%s处理, 辅助%s"), digiwinAtmcBacklog.getOwnerUserName(), digiwinAtmcBacklog.getAuxiliaryTenantName());
        }

        // 代理
        if (BooleanUtils.isFalse(digiwinAtmcBacklog.getIsOwner())) {
            return String.format(localeService.getLanguageValue(locale, "代%s处理"), digiwinAtmcBacklog.getOwnerUserName());
        }
        // 辅助
        if (StringUtils.hasLength(digiwinAtmcBacklog.getAuxiliaryTenantName())) {
            return String.format(localeService.getLanguageValue(locale, "辅助%s"), digiwinAtmcBacklog.getAuxiliaryTenantName());
        }
        // 转派
        if (BooleanUtils.isTrue(digiwinAtmcBacklog.getReassign())) {
            return String.format(localeService.getLanguageValue(locale, "转派"));
        }
        // 外部供应商
        if (StringUtils.hasLength(digiwinAtmcBacklog.getSourceTenantName())) {
            return String.format(localeService.getLanguageValue(locale, "来自%s"), digiwinAtmcBacklog.getSourceTenantName());
        }
        // 供应商为就绪，展示原因
        if (StringUtils.hasLength(digiwinAtmcBacklog.getCrossTenantError())) {
            return digiwinAtmcBacklog.getCrossTenantError();
        }
        return "";
    }

    public static List<TaskSummary> createByBacklogs(List<DigiwinAtmcBacklog> teamBacklogs,
                                                     TaskFilterService taskFilterService, CustomTaskConfigService
                                                             customTaskConfigService, PageTaskRelationService pageTaskRelationService,
                                                     String locale, String iamUserToken, String userId, LocaleService localeService,
                                                     String tenantId, ActivityFilterService activityFilterService, String tenantVersion) {
//        // 按endTime升序排序，方便App端直接渲染界面
//        teamBacklogs.sort((o1, o2) -> {
//            LocalDateTime o1EndTime = DateTimeUtil.parseUseDefaultPattern(o1.getEndTime());
//            LocalDateTime o2EndTime = DateTimeUtil.parseUseDefaultPattern(o2.getEndTime());
//            if (o1EndTime.isBefore(o2EndTime)) {
//                return -1;
//            } else if (o1EndTime.isEqual(o2EndTime)) {
//                return 0;
//            } else {
//                return 1;
//            }
//        });
        List<PageTaskRelation> pageTaskRelationList =
                activityFilterService.listAthenaOfPageTaskRelations(tenantId, tenantVersion);

        // 获取CustomTaskConfig相关文档数据
        List<CustomTaskConfig> customTaskConfigList = customTaskConfigService.listCustomTaskConfig();

        // FIXME 两重循环应该有优化空间，后续再考虑看看
        List<TaskSummary> taskSummaries = teamBacklogs.stream().map(digiwinAtmcBacklog -> {
            Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId =
                    pageTaskRelationList.stream().filter(
                                    pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(
                                            digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId()))
                            .findFirst();
            Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(
                            pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(
                                    digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory()))
                    .findFirst();
            String jumpPageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ?
                    optPageTaskRelationTaskIdAndActivityId.get().getPageId() :
                    (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");

            return TaskSummary.create(locale, iamUserToken, digiwinAtmcBacklog, jumpPageId,
                    customTaskConfigList, true, userId, true, localeService);
        }).collect(Collectors.toList());
        return taskSummaries;
    }

    /**
     * 查阅状态（未读优先）->任务时间(按完成时间升序)
     *
     * @param teamList
     * @return List<TaskSummary>
     */
    public static List<TaskSummary> sortTeamList(List<TaskSummary> teamList) {
        return teamList.stream().sorted((o1, o2) -> {
                    if (o1.getNewly() ^ o2.getNewly()) {
                        return o1.getNewly() ? -1 : 1;
                    }
                    LocalDateTime o1EndTime = DateTimeUtil.parseUseDefaultPattern(o1.getEndTime());
                    LocalDateTime o2EndTime = DateTimeUtil.parseUseDefaultPattern(o2.getEndTime());
                    if (!o1EndTime.isEqual(o2EndTime)) {
                        return o1EndTime.isBefore(o2EndTime) ? -1 : 1;
                    }
                    return 0;
                }
        ).collect(Collectors.toList());
    }

    public static TaskSummary createTripartiteTodo(String locale, TodoList todoData, LocaleService localeService) {
        TaskSummary taskSummary = new TaskSummary();
        taskSummary.setDataId(String.valueOf(todoData.getId()));
        taskSummary.setIsTripartiteTodo(true);
        taskSummary.setHasAppPermission(true);
        taskSummary.setNewly(todoData.getIsRead() == 0);
        Action action = new Action();
        if (StringUtil.isNotEmpty(todoData.getMobileUrl())) {
            action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
            //配置了移动的url可以点击
            action.setRequestUrl(todoData.getMobileUrl());
            action.setOpenWebPageTitle(todoData.getAppName());
        } else {
            //未配置移动url不可以点击，给toast提示
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            action.setToastMsg(localeService.getLanguageValue(locale, "移动端暂不支持,请前往PC端查看"));
        }
        taskSummary.setAction(action);
        //这三字段有semc提供接口给客户传过来,如果都为空(客户传输数据问题),需求做兜底处理
        if ((StringUtil.isEmpty(todoData.getMobileMainTitle()) && StringUtil.isEmpty(todoData.getMobileSubTitle())
                && StringUtil.isEmpty(todoData.getMobileLabel())) && StringUtil.isNotEmpty(todoData.getToDoData())) {
            Map<String, String> map = JsonUtil.jsonStringToObject(todoData.getToDoData(), new TypeReference<Map<String, String>>() {
            });
            List<String> valueList = new ArrayList<>(map.values());
            int size = valueList.size();
            if (1 == size) {
                taskSummary.setName(localeService.getLanguageValue(locale, valueList.get(0)));
            }
            if (2 == size) {
                taskSummary.setName(localeService.getLanguageValue(locale, valueList.get(0)));
                taskSummary.setSubTitle(localeService.getLanguageValue(locale, valueList.get(1)));
            }
            if (size > 2) {
                taskSummary.setName(localeService.getLanguageValue(locale, valueList.get(0)));
                taskSummary.setSubTitle(localeService.getLanguageValue(locale, valueList.get(1)));
                String description = String.join("; ", valueList.subList(2, valueList.size()));
                taskSummary.setDescription(localeService.getLanguageValue(locale, description));
            }
        } else {
            taskSummary.setName(localeService.getLanguageValue(locale, todoData.getMobileMainTitle()));
            taskSummary.setSubTitle(todoData.getMobileSubTitle());
            taskSummary.setDescription(todoData.getMobileLabel());
        }

        return taskSummary;
    }

}