package com.digiwin.mobile.mobileuibot.task.model;

/**
 * <p>功能描述：Tbds检测结果状态枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TbdsOpStatusEnum
 * @Author: wuyangz
 * @Date: 20230704
 */
public enum TbdsOpStatusEnum {
    TEST_IN_PROGRESS("检测进行中", 58),

    TEST_COMPLETED("检测完成", 59),

    NO_START("未开始", 10),

    IN_PROGRESS("进行中", 20),

    COMPLETED("已完成", 30),
    ;
    private String name;

    private Integer value;

    TbdsOpStatusEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }

    public static TbdsOpStatusEnum getEnumByValue(Integer value) {
        for (TbdsOpStatusEnum item : TbdsOpStatusEnum.values()) {
            if (value.equals(item.getValue())) {
                return item;
            }
        }
        return null;
    }
}
