package com.digiwin.mobile.mobileuibot.task.service;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBTaskCard;
import com.digiwin.mobile.mobileuibot.task.model.ApiRequestTaskSummary;
import com.digiwin.mobile.mobileuibot.task.model.SaveCardSwitchRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveCommonrFilterRecordRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveGroupRecordRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveModuleInfoRequest;
import com.digiwin.mobile.mobileuibot.task.model.SaveSeniorFilterRecordRequest;
import com.digiwin.mobile.mobileuibot.task.model.TaskContentResult;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskService
 * @Author: Zaregoto
 * @Date: 2021/5/17 0:37
 */
public interface TaskService {

    TaskContentResult getTaskContentResult(String dataId, String iamUserToken, String tenantId, String locale,
                                           String tmCategory, String tmPattern, String type, String tmTaskId, String tmActivityId, String proxyToken);

    /**
     * 根据给定的任务关卡状态过滤，返回任务进度信息
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param requestData
     * @param taskProgressStateEnum
     * @return
     */
    List<TaskProgress> getTaskProgressList(String locale, String iamUserToken, String tenantId,
                                           Map<String, Object> requestData, TaskProgressStateEnum taskProgressStateEnum);

    /**
     * 获取Athena任务中心的任务卡列表
     *
     * @param apiRequest
     * @return
     */
    List<DigiwinAtmcBacklog> getDigiwinAtmcBacklogList(ApiRequest apiRequest) throws IOException;

    /**
     * 获取在途宝 浮层 发车/在途卡
     *
     * @param apiRequest
     * @return
     */
    List<ZTBTaskCard> getZtbFloatTaskCard(ApiRequest apiRequest) throws IOException;

    /**
     * 获取在途宝 在途卡剩余数量
     *
     * @param apiRequest
     * @return
     */
    long getZtbTransportTaskCardCount(ApiRequest apiRequest) throws IOException;

    /**
     * 任务卡关注，取消关注
     *
     * @param apiRequest
     * @return
     */
    Boolean taskImportance(ApiRequest apiRequest, Boolean isCare);

    /**
     * 分享任务卡取消查看
     *
     * @param apiRequest
     * @return
     */
    Boolean cancelPinning(ApiRequest apiRequest);

    /**
     * 保存分组信息
     *
     * @param apiRequest
     * @return
     */
    Boolean saveSwitchGroupRecord(SaveGroupRecordRequest apiRequest);

    /**
     * 保存排序信息
     *
     * @param apiRequest
     * @return
     */
    Boolean saveModuleInfo(SaveModuleInfoRequest apiRequest);

    /**
     * 保存开关信息
     *
     * @param apiRequest
     * @return
     */
    Boolean saveCardSwitch(SaveCardSwitchRequest apiRequest);

    /**
     * 保存普通筛选信息
     *
     * @param apiRequest
     * @return
     */
    Boolean saveCommonFilterRecord(SaveCommonrFilterRecordRequest apiRequest);

    /**
     * 保存高级筛选信息
     *
     * @param apiRequest
     * @return
     */
    Boolean saveSeniorFilterRecord(SaveSeniorFilterRecordRequest apiRequest);

    /**
     * 扫码搜索-跳转任务卡或者任务清单action
     *
     * @param apiRequest
     * @param conditionList
     * @return
     */
    Action buildQrCodeSearchTaskAction(ApiRequest apiRequest, Map<String, Object> conditionList);
}
