package com.digiwin.mobile.mobileuibot.task.service;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListOption;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListSortrSelectedOption;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskListStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mapper.db1.PersonalConfigurationMapper;
import com.digiwin.mobile.mobileuibot.model.db1.PersonalConfiguration;
import com.digiwin.mobile.mobileuibot.model.db1.UserTaskFilter;
import com.digiwin.mobile.mobileuibot.mysql.service.UserTaskFilterService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcDomain;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskCardAbstract;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgress;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBTaskCard;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.task.model.*;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/5/17 0:39
 */
@Service("taskService")
public class TaskServiceImpl implements TaskService {

    private static final Logger logger = LoggerFactory.getLogger(TaskServiceImpl.class);

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private TaskFilterService taskFilterService;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    @Resource
    private PersonalConfigurationMapper personalConfigurationMapper;

    @Resource
    private PageTaskRelationService pageTaskRelationService;

    @Autowired
    private UiBotModelBuildMyTaskListStrategy uiBotModelBuildMyTaskListStrategy;

    @Autowired
    private CustomTaskConfigService customTaskConfigService;

    @Autowired
    private UserTaskFilterService userTaskFilterService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private ActivityFilterService activityFilterService;



    @Override
    public TaskContentResult getTaskContentResult(String dataId, String iamUserToken, String tenantId, String locale,
                                                  String tmCategory, String tmPattern, String type, String tmTaskId, String tmActivityId, String proxyToken) {
        /**
         * 根据category和pattern的组合情况，决定使用哪一种任务卡详情的展示对象
         * 2021年5月迭代只做正常的签核型，其他的后面再加
         * TODO 2021年8月新做通用处理型任务
         */
        String message = "";
        String abnormalMsg = "";
        List<String> messageList = new ArrayList<>();
        List<String> cardState = new ArrayList<>();

        DigiwinAtmcBacklog atmcBacklogForFilter = new DigiwinAtmcBacklog();
        atmcBacklogForFilter.setTmCategory(tmCategory);
        atmcBacklogForFilter.setTmPattern(tmPattern);
        atmcBacklogForFilter.setTmTaskId(tmTaskId);
        atmcBacklogForFilter.setTmActivityId(tmActivityId);
        atmcBacklogForFilter.setType(Integer.parseInt(type));

//        if (this.taskFilterService.isSupportedTaskByDigiwinAtmcBacklog(atmcBacklogForFilter)) {
        DigiwinAtmcTaskCardAbstract detail =
                this.digiwinAtmcProxyService.getDigiwinAtmcBacklogCardAbstract(locale, iamUserToken, tenantId, dataId, proxyToken);
        // 不需要使用UIBot解析逻辑
        message = detail.getTaskContentMsg();
        abnormalMsg = detail.getAbnormaContentMsg();
        messageList = detail.getTaskContentMsgList();
        cardState = detail.getCardState();
//        }
        return new TaskContentResult(!CollectionUtils.isEmpty(cardState), message, messageList, abnormalMsg);
    }

    @Override
    public List<TaskProgress> getTaskProgressList(String locale, String iamUserToken, String tenantId,
                                                  Map<String, Object> requestData, TaskProgressStateEnum taskProgressStateEnum) {
        List<DigiwinAtmcTaskProgress> digiwinAtmcTaskProgressList =
                this.digiwinAtmcProxyService.getApprovalTaskSignoffProgress(
                        locale, iamUserToken, tenantId, requestData);
        List<TaskProgress> taskProgressList = digiwinAtmcTaskProgressList.stream().map(
                        digiwinAtmcTaskProcess -> TaskProgress.create(locale, digiwinAtmcTaskProcess))
                .collect(Collectors.toList());
        if (null != taskProgressStateEnum) {
            taskProgressList = taskProgressList.stream().filter(
                    taskProgress -> taskProgress.getState().equals(taskProgressStateEnum.getValue())
            ).collect(Collectors.toList());
        }
        List<String> userIds = new ArrayList<>();
        for (TaskProgress taskProgress : taskProgressList) {
            if (taskProgress.getPersonList() != null && taskProgress.getPersonList().size() > 0) {
                for (TaskProgressPerson taskProgressPerson : taskProgress.getPersonList()) {
                    userIds.add(taskProgressPerson.getUserId());
                }
            }
        }
        List<DigiwinIamUserInfo> iamUserInfos = digiwinIamProxyService.userList(userIds, iamUserToken, locale);
        if (iamUserInfos != null && iamUserInfos.size() > 0) {
            for (TaskProgress taskProgress : taskProgressList) {
                if (taskProgress.getPersonList() != null && taskProgress.getPersonList().size() > 0) {
                    for (TaskProgressPerson taskProgressPerson : taskProgress.getPersonList()) {
                        for (DigiwinIamUserInfo digiwinIamUserInfo : iamUserInfos) {
                            if (digiwinIamUserInfo.getId().equals(taskProgressPerson.getUserId())) {
                                taskProgressPerson.setDigiwinIamUserInfo(digiwinIamUserInfo);
                                break;
                            }
                        }
                    }
                }
            }
        }
        return taskProgressList;
    }

    @Override
    public List<DigiwinAtmcBacklog> getDigiwinAtmcBacklogList(ApiRequest apiRequest)
            throws IOException {
        List<DigiwinAtmcBacklog> myBacklogs =
                this.digiwinAtmcProxyService.listMyBacklog(apiRequest.getClientId(),
                        apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());

        if (myBacklogs.isEmpty()) {
            return myBacklogs;
        }

        String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List<TaskFilter> filterList = activityFilterService.listValidInAthenaOfTaskFilter(apiRequest.getTenantId(), tenantVersion);
        myBacklogs =
                myBacklogs.stream().filter(backlog -> taskFilterService.isSupportedTaskByDigiwinAtmcBacklog(backlog, filterList))
                        .collect(Collectors.toList());

        if (myBacklogs.isEmpty()) {
            return myBacklogs;
        }

        // 按endTime升序排序，方便App端直接渲染界面
        myBacklogs.sort((o1, o2) -> {
            LocalDateTime o1EndTime = DateTimeUtil.parseUseDefaultPattern(o1.getEndTime());
            LocalDateTime o2EndTime = DateTimeUtil.parseUseDefaultPattern(o2.getEndTime());
            if (o1EndTime.isBefore(o2EndTime)) {
                return -1;
            } else if (o1EndTime.isEqual(o2EndTime)) {
                return 0;
            } else {
                return 1;
            }
        });

        return myBacklogs;
    }

    @Override
    public List<ZTBTaskCard> getZtbFloatTaskCard(ApiRequest apiRequest) throws IOException {
        List<DigiwinAtmcBacklog> myBacklogs = this.getDigiwinAtmcBacklogList(apiRequest);
        // 过滤发车任务卡、在途卡
        List<DigiwinAtmcBacklog> departures = myBacklogs.stream()
                .filter(log -> TaskStringUtil.isZtbDepartureTaskCard(log.getTmTaskId(), log.getTmActivityId()))
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(departures)) {
            departures = myBacklogs.stream()
                    .filter(log -> TaskStringUtil.isZtbTransportTaskCard(log.getTmTaskId(), log.getTmActivityId()))
                    .collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(departures)) {
            return Collections.emptyList();
        }
        // 首页弹窗只出现任务完成时间最近的一个
        String endTime = departures.get(0).getEndTime();
        String hour = endTime.substring(0, endTime.length() - 6);
        departures = departures.stream().filter(log -> hour.equals(log.getEndTime().substring(0, log.getEndTime().length() - 6)))
                .collect(Collectors.toList());
        if (departures.size() > 5) {
            departures = departures.subList(0, 5);
        }
        return departures.stream().map(backlog -> {
            ZTBTaskCard card = new ZTBTaskCard();
            card.setTaskCardType(1);
            BeanUtils.copyProperties(backlog, card);
            if (TaskStringUtil.isZtbDepartureTaskCard(card.getTmTaskId(), card.getTmActivityId())) {
                card.setTaskCardType(0);
            }
            ApiRawData apiRawData = new ApiRawData();
            apiRawData.put("digi-proxy-token", card.getProxyToken());
            UiBotModel pcUiBotModel = digiwinPcUiBotProxyService
                    .getTaskTemplateShowByBacklogId(apiRequest.getLocale(), apiRequest.getIamUserToken(),
                            apiRequest.getTenantId(), StringUtil.valueOf(card.getBacklogId()), card.getTmTaskId(),
                            card.getTmActivityId(), apiRawData);

            String taskNo = "";
            String transportNo = "";
            List<Map<String, Object>> deliveryDetailList =
                    (List<Map<String, Object>>) pcUiBotModel.getPageData().get("cargo_information");
            if (!CollectionUtils.isEmpty(deliveryDetailList)) {
                taskNo = String.valueOf(deliveryDetailList.get(0).get("task_no"));
                transportNo = String.valueOf(deliveryDetailList.get(0).get("transport_no"));
            }
            DigiwinTransportResponse transportMainInfo = digiwinEspProxyService
                    .getTransportMainInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                            apiRequest.getLocale(), transportNo);

            card.setPcUiBotModel(pcUiBotModel);
            card.setTransport(transportMainInfo);
            card.setTaskNo(taskNo);
            card.setTransportNo(transportNo);
            return card;
        }).collect(Collectors.toList());
    }

    @Override
    public long getZtbTransportTaskCardCount(ApiRequest apiRequest) throws IOException {
        List<DigiwinAtmcBacklog> myBacklogs = this.getDigiwinAtmcBacklogList(apiRequest);
        return myBacklogs.stream()
                .filter(log -> TaskStringUtil.isZtbTransportTaskCard(log.getTmTaskId(), log.getTmActivityId())).count();
    }


    @Override
    public Boolean taskImportance(ApiRequest apiRequest, Boolean isCare) {
        String importanceValue = BooleanUtils.isTrue(isCare) ? "1" : "0";
        Boolean isSuccess = null;
        try {
            isSuccess = this.digiwinAtmcProxyService.backlogImportance(apiRequest.getDataId(), apiRequest.getLocale(),
                    apiRequest.getIamUserToken(), apiRequest.getTenantId(), importanceValue);
        } catch (Exception e) {
            logger.error("TaskServiceImpl taskImportance error :", e);
        }
        return isSuccess;
    }

    @Override
    public Boolean cancelPinning(ApiRequest apiRequest) {
        Map<String, Object> cancelPinningParamMap = new HashMap<>();
        cancelPinningParamMap.put("mainTaskId", Long.valueOf(apiRequest.getDataId()));
        cancelPinningParamMap.put("pinningUser", apiRequest.getUserId());
        cancelPinningParamMap.put("type", 2);
        Boolean isSuccess = null;
        try {
            isSuccess = this.digiwinAtmcProxyService.cancelPinning(apiRequest.getLocale(),
                    apiRequest.getIamUserToken(), apiRequest.getTenantId(), cancelPinningParamMap);
        } catch (Exception e) {
            logger.error("TaskServiceImpl cancelPinning error :", e);
        }
        return isSuccess;
    }

    @Override
    public Boolean saveSwitchGroupRecord(SaveGroupRecordRequest apiRequest) {
        Boolean isSuccess = false;
        UserTaskFilter userTaskFilter = new UserTaskFilter();
        userTaskFilter.setUserId(apiRequest.getUserId());
        userTaskFilter.setTenantId(apiRequest.getTenantId());
        try {
            isSuccess = userTaskFilterService.insertUserTaskFilterByGroupFilterIds(userTaskFilter, apiRequest.getGroupKey());
        } catch (Exception e) {
            logger.error("TaskServiceImpl saveSwitchGroupRecord error :", e);
        }
        return isSuccess;
    }

    @Override
    public Boolean saveModuleInfo(SaveModuleInfoRequest apiRequest) {
        Boolean isSuccess = null;

        UserTaskFilter userTaskFilter = new UserTaskFilter();
        userTaskFilter.setUserId(apiRequest.getUserId());
        userTaskFilter.setTenantId(apiRequest.getTenantId());

        String sortFilter = "";
        if (!CollectionUtils.isEmpty(apiRequest.getSortFilterList())) {
            List<CardListSortrSelectedOption> cardListSortrSelectedOptionList = apiRequest.getSortFilterList().stream().map(item -> {
                CardListSortrSelectedOption cardListSortrSelectedOption = new CardListSortrSelectedOption();
                cardListSortrSelectedOption.setCode(item.getFilterId());
                if (!CollectionUtils.isEmpty(item.getFilterOptionList())) {
                    List<String> selectOptionList = item.getFilterOptionList().stream()
                            .filter(e -> BooleanUtils.isTrue(e.getIsSelect()))
                            .map(CardListOption::getFilterOptionId).collect(Collectors.toList());
                    cardListSortrSelectedOption.setValueOptionList(selectOptionList);
                }
                return cardListSortrSelectedOption;
            }).collect(Collectors.toList());
            sortFilter = JsonUtil.javaObjectToJsonString(cardListSortrSelectedOptionList);
        }
        try {
            isSuccess = userTaskFilterService.insertUserTaskFilterBySortFilterIds(userTaskFilter, sortFilter);

        } catch (Exception e) {
            logger.error("TaskServiceImpl saveModuleInfo error :", e);
        }
        return isSuccess;
    }

    @Override
    public Boolean saveCardSwitch(SaveCardSwitchRequest apiRequest) {
        Map<String, String> params = new HashMap<>(2);
        params.put("userId", apiRequest.getUserId());
        params.put("tenantId", apiRequest.getTenantId());
        PersonalConfiguration personalConfiguration = personalConfigurationMapper.getByMap(params);
        Date currentTime = new Date(System.currentTimeMillis());
        if (null == personalConfiguration) {
            // 新增
            personalConfiguration = new PersonalConfiguration();
            personalConfiguration.setUserId(apiRequest.getUserId());
            personalConfiguration.setTenantId(apiRequest.getTenantId());
            personalConfiguration.setCreateTime(currentTime);
            handlePersonalConfiguration(apiRequest, personalConfiguration);
            return personalConfigurationMapper.insertData(personalConfiguration);
        }
        // 修改
        personalConfiguration.setUpdateTime(currentTime);
        handlePersonalConfiguration(apiRequest, personalConfiguration);
        return personalConfigurationMapper.updateData(personalConfiguration);
    }

    @Override
    public Boolean saveCommonFilterRecord(SaveCommonrFilterRecordRequest apiRequest) {
        Boolean isSuccess = false;
        UserTaskFilter userTaskFilter = new UserTaskFilter();
        userTaskFilter.setUserId(apiRequest.getUserId());
        userTaskFilter.setTenantId(apiRequest.getTenantId());
        try {
            String commonFilter = "";
            if (!CollectionUtils.isEmpty(apiRequest.getSelectedOptionList())) {
                commonFilter = JsonUtil.javaObjectToJsonString(apiRequest.getSelectedOptionList());
            }
            isSuccess = userTaskFilterService.insertUserTaskFilterByCommonFilter(userTaskFilter, commonFilter);
        } catch (Exception e) {
            logger.error("TaskServiceImpl saveCommonFilterRecord error :", e);
        }
        return isSuccess;
    }

    @Override
    public Boolean saveSeniorFilterRecord(SaveSeniorFilterRecordRequest apiRequest) {
        Boolean isSuccess = false;
        UserTaskFilter userTaskFilter = new UserTaskFilter();
        userTaskFilter.setUserId(apiRequest.getUserId());
        userTaskFilter.setTenantId(apiRequest.getTenantId());
        try {
            String seniorFilter = "";
            if (!CollectionUtils.isEmpty(apiRequest.getSelectedOptionList())) {
                seniorFilter = JsonUtil.javaObjectToJsonString(apiRequest.getSelectedOptionList());
            }
            isSuccess = userTaskFilterService.insertUserTaskFilterBySeniorFilter(userTaskFilter, seniorFilter);
        } catch (Exception e) {
            logger.error("TaskServiceImpl saveSwitchGroupRecord error :", e);
        }
        return isSuccess;
    }

    @Override
    public Action buildQrCodeSearchTaskAction(ApiRequest apiRequest, Map<String, Object> condition) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_QRCODE_SEARCH_TODO_LIST.toString());
        action.setJumpPageTitle(localeService.getLanguageValue(apiRequest.getLocale(), "任务查询"));
        if (ObjectUtils.isEmpty(condition.get("d"))) {
            return action;
        }
        Map<String, Object> data = (Map<String, Object>) condition.get("d");

        // 先根据kw查询
        if (data.containsKey("kw")) {
            String kw = MapUtils.getString(data, "kw");
            if (StringUtils.isNotEmpty(kw)) {
                // pc搜索接口多条件需要以空格来分隔
                kw = kw.replaceAll("&", " ");
                Set<String> searchedBacklogIds = digiwinAtmcProxyService.taskSearch(kw, apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), apiRequest.getLocale(), apiRequest.getClientId());
                return buildResp(searchedBacklogIds, action, apiRequest);
            }
        }

        // 再根据bk查询
        if (data.containsKey("bk")) {
            Map<String, Object> bk = (Map<String, Object>) MapUtil.getOrDefault(data, "bk", Collections.emptyMap());

            Map<String, Object> domainSearchMap = new HashMap<>();
            domainSearchMap.put("method", "withBK");
            Map<String, Object> parameterMap = new HashMap<>();
            parameterMap.put("domainType", "task");
            parameterMap.put("domainSearch", domainSearchMap);

            Map<String, Object> param = new HashMap<>(2);
            param.put("parameter", parameterMap);
            param.put("data", bk);
            DigiwinAtmcDomain domainSearchResp = digiwinAtmcProxyService.domainSearch(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), param);
            if (Objects.nonNull(domainSearchResp)) {
                Set<String> searchedBacklogIds = domainSearchResp.getDomainList().stream().map(e -> e.getDomainId().toString()).collect(Collectors.toSet());
                return buildResp(searchedBacklogIds, action, apiRequest);
            }
        }
        return action;
    }

    private Action buildResp(Set<String> searchedBacklogIds, Action action, ApiRequest apiRequest) {
        if (CollectionUtils.isEmpty(searchedBacklogIds)) {
            return action;
        }

        List<DigiwinAtmcBacklog> digiwinAtmcBacklogList = digiwinAtmcProxyService.getBacklogListByIds(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), new ArrayList<>(searchedBacklogIds));
        if (CollectionUtils.isEmpty(digiwinAtmcBacklogList)) {
            return action;
        }

        String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List<TaskFilter> filterList = activityFilterService.listValidInAthenaOfTaskFilter(apiRequest.getTenantId(), tenantVersion);
        // 过滤支持的任务类型
        digiwinAtmcBacklogList =
                digiwinAtmcBacklogList.stream().filter(backlog -> taskFilterService.isSupportedTaskByDigiwinAtmcBacklog(backlog, filterList))
                        .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(digiwinAtmcBacklogList)) {
            return action;
        }

        // 如果只有一条，直接返回任务详情，否则返回任务卡列表
        if (digiwinAtmcBacklogList.size() == 1) {
            TodoList todoList = new TodoList();
            uiBotModelBuildMyTaskListStrategy
                    .paddingMobileTaskListFormWithOutFilterList(apiRequest, digiwinAtmcBacklogList, todoList, false, tenantVersion);
            return Optional.ofNullable(todoList.getTodoList()).map(e -> e.get(0)).map(TaskSummary::getAction).orElse(action);
        }
        Map<String, Object> rawDataMap = new HashMap<>(1);
        rawDataMap.put("searchedBacklogList", digiwinAtmcBacklogList);
        action.setRawData(rawDataMap);
        return action;
    }

    private void handlePersonalConfiguration(SaveCardSwitchRequest apiRequest, PersonalConfiguration personalConfiguration) {
        if ("eocName".equalsIgnoreCase(apiRequest.getId())) {
            personalConfiguration.setShowEoc(apiRequest.getIsSelect());
        }
        if ("engineHasWaittingData".equalsIgnoreCase(apiRequest.getId())) {
            personalConfiguration.setShowHandledCard(apiRequest.getIsSelect());
        }
    }
}
