package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;

/**
 * 第三方h5页面：不支持查看任务详情,返回空组件
 * 目前使用场景：企微发生消息
 *
 * @author yanfeng
 * @date 2024/01/04
 */
@Component("emptyPageStrategy")
public class EmptyPageStrategy implements UiBotModelBuildStrategy {

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);

        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        List<UiBotLayout> emptyLayout = uiBotModel.getLayout();
        UiBotPageData emptyPageData = uiBotModel.getPageData();

        String blankAreaSchema = UUIDUtil.getUuid();
        emptyLayout.add(new UiBotLayout(blankAreaSchema, BlankArea.COMPONENT_TYPE));
        emptyPageData.put(blankAreaSchema, BlankArea.create(326, 1.0));

        String emptySchema = UUIDUtil.getUuid();
        emptyLayout.add(new UiBotLayout(emptySchema, Empty.COMPONENT_TYPE));
        emptyPageData.put(emptySchema, Empty.create(localeService.getLanguageValue(apiRequest.getLocale(), "移动端暂不支持查看\n" +
                "可前往web端查看"), true, 10, 1000, 240, 240, "#D2D2E6", "IMAGE_TASK_FINISH"));
        return uiBotModel;
    }
}
