package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccApiDataWrapper;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.CompletableFuture;

/**
 * PCC-未启动的项目卡页面
 *
 * @author yanfeng
 * @date 2024/01/04
 */
@Component("projectPccNotStartedStrategy")
public class ProjectPccNotStartedStrategy implements UiBotModelBuildStrategy {
    public static final String MAINTENANCE_PROJECT_DTD = "maintenanceProject_DTD";

    @Autowired
    private LocaleService localeService;

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        return getUiBotModel(pageSetting, apiRequest);
    }


    private @NotNull UiBotModel getUiBotModel(PageSetting pageSetting, ApiRequest apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        String tmTaskId = String.valueOf(rawData.get("tmTaskId"));
        boolean isShare = Boolean.parseBoolean(String.valueOf(rawData.get("isShare")));
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        List<UiBotLayout> emptyLayout = uiBotModel.getLayout();
        UiBotPageData emptyPageData = uiBotModel.getPageData();
        String titleBodySchema = UUIDUtil.getUuid();
        emptyLayout.add(new UiBotLayout(titleBodySchema, TitleBody.COMPONENT_TYPE));
        String blankAreaSchema = UUIDUtil.getUuid();
        emptyLayout.add(new UiBotLayout(blankAreaSchema, BlankArea.COMPONENT_TYPE));
        emptyPageData.put(blankAreaSchema, BlankArea.create(326, 1.0));

        String emptySchema = UUIDUtil.getUuid();
        emptyLayout.add(new UiBotLayout(emptySchema, Empty.COMPONENT_TYPE));
        emptyPageData.put(emptySchema, Empty.create(localeService.getLanguageValue(apiRequest.getLocale(), "此专案尚未启动，建议去PC端维护"), true, 10, 1000, 240, 240, "#D2D2E6", "IMAGE_TASK_FINISH"));

        if (StringUtils.isEmpty(tmTaskId)) {
            return uiBotModel;
        }

        DigiwinAtmcEnginePanelInfo atmcEnginePanelInfo = null;
        DigiwinAtmcPanel atmcPanel = null;
        List<DigiwinAtmcReassignUser> batchReassignUsers = Collections.emptyList();
        UiBotModel pcUiBotModel = null;
        PccApiDataWrapper<PccProjectInfo> pccProjectInfo = null;

        try {
            String tmActivityId = "";
            boolean pccProjectTypeIsNew = ProjectStringUtil.PCC_NEW_PROJECT_TYPE.equalsIgnoreCase(tmTaskId);
            if (!pccProjectTypeIsNew) {
                CompletableFuture<DigiwinAtmcPanel> digiwinAtmcPanelCompletableFuture = CompletableFuture.supplyAsync(() -> this.digiwinAtmcProxyService.getTaskPanel(
                                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId())
                        , this.threadPoolTaskExecutor);
                atmcPanel = digiwinAtmcPanelCompletableFuture.get();
            } else {
                CompletableFuture<DigiwinAtmcEnginePanelInfo> digiwinAtmcEnginePanelInfoCompletableFuture = CompletableFuture.supplyAsync(() -> this.digiwinAtmcProxyService.getEnginePanelInfoByTaskId(
                                apiRequest.getDataId() + "",
                                apiRequest.getClientId(),
                                apiRequest.getIamUserToken(),
                                apiRequest.getTenantId(),
                                apiRequest.getLocale())
                        , this.threadPoolTaskExecutor);
                atmcEnginePanelInfo = digiwinAtmcEnginePanelInfoCompletableFuture.get();
            }
            if (!pccProjectTypeIsNew) {
                if (null != atmcPanel) {
                    tmTaskId = atmcPanel.getTask().getTmTaskId();
                    Optional<DigiwinAtmcActivity> optActivity = atmcPanel.getActivities().stream().filter(atmcActivity ->
                            ProjectStringUtil.PCC_OLD_PROJECT_TYPE_PROGRESS_TRACK_ACTIVITY.equalsIgnoreCase(atmcActivity.getId())
                    ).findFirst();
                    if (!optActivity.isPresent()) {
                        return UiBotModel.emptyUiBotModel();
                    }
                    tmActivityId = optActivity.get().getId();
                }
            } else {
                if (null != atmcEnginePanelInfo) {
                    tmTaskId = atmcEnginePanelInfo.getTask().getTmTaskId();
                    List<DigiwinAtmcEngineActivity> activityList = atmcEnginePanelInfo.getRoute().getSelectRoute().getActivities();
                    List<DigiwinAtmcEngineTaskCode> taskCodes = new ArrayList<>();
                    for (DigiwinAtmcEngineActivity activity : activityList) {
                        if (activity != null && activity.getTaskCodes() != null) {
                            taskCodes.addAll(activity.getTaskCodes());
                        }
                    }
                    Optional<DigiwinAtmcEngineTaskCode> taskCodeOptional = taskCodes.stream().filter(taskCode ->
                            MAINTENANCE_PROJECT_DTD.equalsIgnoreCase(taskCode.getId())
                    ).findFirst();
                    if (!taskCodeOptional.isPresent()) {
                        return UiBotModel.emptyUibotModel(apiRequest.getLocale());
                    }
                    tmActivityId = taskCodeOptional.get().getId();
                    atmcPanel = new DigiwinAtmcPanel();
                    atmcPanel.setTask(atmcEnginePanelInfo.getTask());
                }
            }

            if (StringUtils.isNotBlank(tmTaskId)) {
                String finalTmTaskId = tmTaskId;
                String finalTmActivityId = tmActivityId;
                CompletableFuture<List<Map<String, Object>>> listCompletableFuture = CompletableFuture.supplyAsync(() ->
                                this.digiwinPcUiBotProxyService
                                        .getProjectDetailByProjectId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                                                apiRequest.getDataId(), finalTmTaskId, finalTmActivityId)
                        , this.threadPoolTaskExecutor);
                List<Map<String, Object>> projectDetailDataStateList = listCompletableFuture.get();
                if (!CollectionUtils.isEmpty(projectDetailDataStateList)) {
                    Map<String, Object> projectDetailDataState = projectDetailDataStateList.get(0);

                    CompletableFuture<UiBotModel> pcUiBotModelCompletableFuture = CompletableFuture.supplyAsync(() ->
                                    this.digiwinPcUiBotProxyService.actionShow(
                                            apiRequest.getLocale(), apiRequest.getIamUserToken(),
                                            JsonUtil.javaObjectToJsonString(projectDetailDataState))
                            , this.threadPoolTaskExecutor);
                    pcUiBotModel = pcUiBotModelCompletableFuture.get();
                    // 获取项目详情
                    Map<String, Object> bodyPayloadMap = new HashMap<>(4);
                    String actionId = "project.info.get";
                    bodyPayloadMap.put("actionId", actionId);
                    bodyPayloadMap.put("businessUnit", pcUiBotModel.getExecuteContext().get("businessUnit"));

                    Map<String, Object> taskWithBacklogData =
                            (Map<String, Object>) pcUiBotModel.getExecuteContext().get("taskWithBacklogData");
                    Map<String, Object> bpmData = (Map<String, Object>) taskWithBacklogData.get("bpmData");
                    List<Map<String, Object>> projectDataList = (List<Map<String, Object>>) bpmData.get("project_data");

                    Map<String, Object> parameter = new HashMap<>(1);
                    parameter.put("project_info", projectDataList);

                    bodyPayloadMap.put("parameter", parameter);

                    CompletableFuture<PccApiDataWrapper<PccProjectInfo>> pccApiDataWrapperCompletableFuture = CompletableFuture.supplyAsync(() ->
                                    this.digiwinAtdmProxyService.dataQueryByActionProjectInfo(apiRequest.getLocale(), apiRequest.getIamUserToken(),
                                            JsonUtil.javaObjectToJsonString(bodyPayloadMap), apiRequest.getTenantId())
                            , this.threadPoolTaskExecutor);
                    pccProjectInfo = pccApiDataWrapperCompletableFuture.get();
                }
            }
            if (atmcEnginePanelInfo != null && ObjectUtils.isNotEmpty(atmcEnginePanelInfo.getTask())) {
                DigiwinAtmcEnginePanelInfo finalAtmcEnginePanelInfo = atmcEnginePanelInfo;
                CompletableFuture<List<DigiwinAtmcReassignUser>> digiwinAtmcReassignUser = CompletableFuture.supplyAsync(() ->
                        this.digiwinAtmcProxyService
                                .batchGetProjectReassignUsers(finalAtmcEnginePanelInfo.getTask(), apiRequest.getIamUserToken(),
                                        apiRequest.getLocale(), apiRequest.getTenantId()), this.threadPoolTaskExecutor);
                batchReassignUsers = digiwinAtmcReassignUser.get();
            }

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        // 支持转派功能，只有非分享的项目中控台的项目卡才支持转派
        if (atmcEnginePanelInfo != null && atmcEnginePanelInfo.getReassign() != null && !isShare) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            atmcEnginePanelInfo.getReassign().put("reassignUsers", batchReassignUsers);
            Map<String, Object> buttonActionRawData = new HashMap<>(atmcEnginePanelInfo.getReassign());
            buttonActionRawData.put("appCode", atmcEnginePanelInfo.getTask().getAppCode());
            buttonActionRawData.put("projectDetail", atmcEnginePanelInfo.getTask());
            buttonActionRawData.put("project_type", atmcEnginePanelInfo.getTask().getTmTaskId());

            buttons.add(Button.createApprovalReassign(apiRequest.getDataId() + "",
                    buttonActionRawData,
                    apiRequest.getLocale(), "PROJECT", 58926));

            Map<String, Object> rawDataInAppbarButton = new HashMap<>(atmcEnginePanelInfo.getReassign());
            rawDataInAppbarButton.put("appCode", atmcEnginePanelInfo.getTask().getAppCode());
            rawDataInAppbarButton.put("project_type", atmcEnginePanelInfo.getTask().getTmTaskId());
            buttons.add(Button.createProjectShareWithOthers(apiRequest.getDataId(),
                    JsonUtil.objectToJavaObject(rawDataInAppbarButton, Map.class),
                    apiRequest.getLocale(), localeService));
        }
        List<UiBotLayout> layouts = uiBotModel.getLayout();
        if ((ObjectUtils.isNotEmpty(pccProjectInfo) && pccProjectInfo != null && !CollectionUtils.isEmpty(pccProjectInfo.getProjectInfoList()))) {
            for (UiBotLayout layout : layouts) {
                if (TitleBody.COMPONENT_TYPE.equals(layout.getType())) {
                    if (ObjectUtils.isNotEmpty(atmcPanel)) {
                        TitleBody titleBody = TitleBody.create(apiRequest, pageSetting, pcUiBotModel,
                                pccProjectInfo.getProjectInfoList().get(0), atmcPanel, pageDescBuilderFactory);
                        uiBotModel.getPageData().put(layout.getSchema(), titleBody);
                    }
                    break;
                }
            }
        }

        return uiBotModel;
    }
}