package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabBuilder;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOne;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOneBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizApproval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.Optional;

/**
 * <p>功能描述：构建签核型任务画面的策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildBizApprovalStrategy
 * @Author: Zaregoto
 * @Date: 2021/5/20 16:13
 */
@Component("taskDetailBuildBizApprovalStrategy")
public class TaskDetailBuildBizApprovalStrategy implements TaskDetailBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildBizApprovalStrategy.class);

    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;

    @Autowired
    private CardOneBizApprovalBuilder cardOneBizApprovalBuilder;

    @Autowired
    private BizApprovalTabBuilder bizApprovalTabBuilder;

    @Autowired
    private BottomButtonBizApprovalBuilder bottomButtonBizApprovalBuilder;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private LocaleService localeService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.TASK_TYPE_BIZ_APPROVAL;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        UiBotModel pageModel = pageSetting.getPageModel();
        TaskDetailBizApproval taskDetailBizApproval = new TaskDetailBizApproval();
        for (UiBotLayout layout : pageModel.getLayout()) {
            String layoutType = layout.getType();
            switch (layoutType) {
                case TitleBody.COMPONENT_TYPE:
                    taskDetailBizApproval.put(layout.getSchema(),
                            ModuleUtils.buildTitle(pcUiBotModel, pcUiBotModel.getPageData(),
                                    (DigiwinAtmcBacklogDetail) args[0], apiRequest, true, true));
                    break;
                case PageDesc.COMPONENT_TYPE:
                    taskDetailBizApproval.put(layout.getSchema(),
                            this.pageDescBuilderFactory.get(TaskStringUtil.TASK_TYPE_BIZ_APPROVAL)
                                    .build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, args));
                    break;
                case CardOne.COMPONENT_TYPE:
                    taskDetailBizApproval.put(layout.getSchema(),
                            this.cardOneBizApprovalBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                                    CardOne.class, args));
                    break;
                case "TABS":
                    BizApprovalTabList tabs = this.bizApprovalTabBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                            BizApprovalTabList.class);
                    tabs.forEach(tab -> {
                        tab.setMScrollMode(CustomTabScrollModeEnum.NO_SCROLL.getMode());
                    });
                    taskDetailBizApproval.put(layout.getSchema(), tabs);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    taskDetailBizApproval.put(layout.getSchema(),
                            this.bottomButtonBizApprovalBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                                    BottomButtonList.class, args));
                    break;
                default:
                    // 什么都不做
                    break;
            }
        }
        return taskDetailBizApproval;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        // PCC手动任务签核(后置任务)
        if (Arrays.asList("manual_DTD_AssignmentApproval4", "PWD_AbnormalApproval").contains(Optional.ofNullable(pcUiBotModel.getExecuteContext()).map(r -> r.getString("tmActivityId")).orElse(""))) {
            UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
            // 创建空组件
            UiBotModel empty = UiBotModel.createEmptyComponent(
                    localeService.getLanguageValue(apiRequest.getLocale(), "此作业未配置移动端界面，暂不支持查看\n请前往Web端查阅处理"),
                    false,
                    null);
            uiBotModel.getLayout().addAll(empty.getLayout());
            uiBotModel.getPageData().putAll(empty.getPageData());
            return uiBotModel;
        }
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        UiBotModel uiBotModel = uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
//        // PC定制签核型任务处理
//        if (Boolean.TRUE.equals(pcUiBotModel.getIsPcCustomize())) {
//            // 删除 CARD_ONE 和 TABS 组件
//            List<UiBotLayout> layouts = uiBotModel.getLayout().stream()
//                    .filter(layout -> CardOne.COMPONENT_TYPE.equals(layout.getType()) || "TABS".equals(layout.getType()))
//                    .collect(Collectors.toList());
//            for (UiBotLayout layout : layouts) {
//                uiBotModel.getPageData().remove(layout.getSchema());
//            }
//            uiBotModel.getLayout().removeAll(layouts);
//
//            // 创建空组件
//            UiBotModel empty = UiBotModel.createEmptyComponent(
//                    localeService.getLanguageValue(apiRequest.getLocale(), "此作业未配置移动端界面，暂不支持查看\n请前往Web端查阅处理"),
//                    false,
//                    null);
//            uiBotModel.getLayout().addAll(empty.getLayout());
//            uiBotModel.getPageData().putAll(empty.getPageData());
//        }
        return uiBotModel;
    }
}
