package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabsComponent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBodyBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableScriptFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>功能描述：构建回报型任务画面的策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildBizReportStrategy
 * @Author: Zaregoto
 * @Date: 2021/6/14 18:41
 */
@Slf4j
@Component("taskDetailBuildBizAssistanStrategy")
public class TaskDetailBuildBizAssistanStrategy implements TaskDetailBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;

    @Autowired
    private TitleBodyBizReportBuilder titleBodyBizReportBuilder;

    @Autowired
    private BottomButtonBizReportBuilder bottomButtonBizReportBuilder;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private RuleService ruleService;

    @Autowired
    private ColumnTagService columnTagService;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    // FIXME 判断的位置要调整，不然当pageSetting中的底部按钮layout不是放在底部时，判断会不正确
    private Boolean hasEditableColumn = false;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.TASK_TYPE_BIZ_ASSISTAN;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);
        int dynamicComponentPlaceholderIndex = 0;
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        for (int i = 0; i < pageSettingModel.getLayout().size(); i++) {
            UiBotLayout pageSettingLayout = pageSettingModel.getLayout().get(i);
            String type = pageSettingLayout.getType();
            switch (type) {
                case TitleBody.COMPONENT_TYPE:
                    taskDetailBizReport.put(pageSettingLayout.getSchema(),
                            this.titleBodyBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
                    break;
                case "${COMPONENT_TYPE}":
                    dynamicComponentPlaceholderIndex = i;
                    handleHead(pcUiBotModel, taskDetailBizReport, true);
                    break;
                case TabsComponent.COMPONENT_TYPE:
                    //找到对应table组件
                    List<String> tableTargetLayoutTypeList = new ArrayList<>();
                    tableTargetLayoutTypeList.add("TABLE");
                    List<String> tableParentLayoutTypeList = new ArrayList<>();
                    tableParentLayoutTypeList.add("FORM_LIST");
                    UiBotModel tableUiBotModel = pcUiBotModel.searchPcTargetModel(tableTargetLayoutTypeList, tableParentLayoutTypeList, false);
                    UiBotPageData tablePageData = tableUiBotModel.getPageData();
                    List<UiBotLayout> tableLayoutList = tableUiBotModel.getLayout();
                    if (!tableLayoutList.isEmpty()) {
                        //找到tab标题
                        List<String> contentTargetLayoutTypeList = new ArrayList<>();
                        contentTargetLayoutTypeList.add("CONTENT_QUERY_BUTTON");
                        UiBotModel contentUiBotModel = pcUiBotModel.searchPcTargetModel(contentTargetLayoutTypeList, new ArrayList<>(), true);
                        List<UiBotQueryButton> queryButtonList = Optional.ofNullable(contentUiBotModel.getLayout().stream().findFirst()
                                .orElse(new UiBotLayout()).getQueryButtons()).orElse(new ArrayList<UiBotQueryButton>());
                        if (queryButtonList.size() >= 1) {
                            //至少有一个tab签
                            String tabTitle1 = queryButtonList.stream().findFirst().orElse(new UiBotQueryButton()).getQueryTitle();
                            tabTitle1 = tabTitle1 == null ? "" : tabTitle1;
                            TabsComponent tabsComponent = TabsComponent.build(tableLayoutList.get(0), tablePageData, tabTitle1);
                            if (queryButtonList.size() > 1) {
                                //有不止一个tab签
                                for (int j = 1; j < queryButtonList.size(); j++) {
                                    Map<String, Object> map = JsonUtil.objectToJavaObject(queryButtonList.get(j), Map.class);
                                    map.put("executeContext", pcUiBotModel.getExecuteContext());
                                    UiBotModel tabUibotModel = digiwinPcUiBotProxyService.actionShow(apiRequest.getLocale(), apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString(map));
                                    UiBotModel tableUiBotModel2 = tabUibotModel.searchPcTargetModel(tableTargetLayoutTypeList, tableParentLayoutTypeList, false);
                                    tabsComponent.addTab(tableUiBotModel2.getLayout().get(0),
                                            tableUiBotModel2.getPageData(), queryButtonList.get(j).getQueryTitle());
                                    handleHead(tabUibotModel, taskDetailBizReport, false);
                                }
                            }
                            taskDetailBizReport.put(pageSettingLayout.getSchema(), tabsComponent);
                        } else {
                            //一个tab签都没有，展示空组件
                        }

                    }

                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    taskDetailBizReport.put(pageSettingLayout.getSchema(),
                            this.bottomButtonBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                                    BottomButtonList.class, args));
                    break;
                case BlankArea.COMPONENT_TYPE:
                    taskDetailBizReport.put(pageSettingLayout.getSchema(),
                            JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(pageSettingModel.getPageData().get(pageSettingLayout.getSchema())), BlankArea.class));
                    break;
                default:
                    break;
            }
        }
        pageSettingModel.getLayout().addAll(dynamicComponentPlaceholderIndex,
                taskDetailBizReport.getActualLayoutList());
        // 去除占位符的那个layout
        pageSettingModel.getLayout().remove(
                dynamicComponentPlaceholderIndex + taskDetailBizReport.getActualLayoutList().size());

        return taskDetailBizReport;
    }

    /**
     * 单头处理
     *
     * @param uiBotModel
     * @param taskDetailBizReport
     */
    void handleHead(UiBotModel uiBotModel, TaskDetailBizReport taskDetailBizReport, boolean first) {
        List<String> targetLayoutTypeList = new ArrayList<>();
        targetLayoutTypeList.add("LABEL");
        List<String> parentLayoutTypeList = new ArrayList<>();
        parentLayoutTypeList.add("FORM_LIST");
        UiBotModel labelUiBotModel = uiBotModel.searchPcTargetModel(targetLayoutTypeList, parentLayoutTypeList, true);
        List<UiBotLayout> labelLayoutList = labelUiBotModel.getLayout();
        for (UiBotLayout layout : labelLayoutList) {
            Field field = Field.create(layout.getHeaderName(), layout.getType(),
                    (String) labelUiBotModel.getPageData().get(layout.getSchema()), layout.getSchema());
            if (StringUtils.hasLength(field.getValue())) {
                field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
                field.setLabelStyleType(1);
                field.setValueStyleType(2);
                taskDetailBizReport.put(layout.getSchema(), field);
            }
            if (first) {
                UiBotLayout applayout = new UiBotLayout();
                applayout.setSchema(layout.getSchema());
                applayout.setType(Field.COMPONENT_TYPE);
                taskDetailBizReport.addActualLayout(applayout);
            }
        }
    }

    private void processDynamicComponents(ApiRequest apiRequest, UiBotModel pcUiBotModel, UiBotLayout pageSettingModel,
                                          TaskDetailBizReport taskDetailBizReport, Object... args) {
        String locale = apiRequest.getLocale();

        // 找到实际明细数据的layout
        UiBotTargetLayoutSearchResult searchResult = pcUiBotModel.searchPcTargetLayout();

        if (!searchResult.found()) {
            return;
        }
        UiBotLayout pcDataLayout = searchResult.getTargetUiBotLayout();
        if (pcDataLayout.isTypeOfTable()) {
            this.processDynamicComponentsWithPcTable(apiRequest, pcUiBotModel, taskDetailBizReport, locale, pcDataLayout, args);
        } else if (pcDataLayout.isTypeOfFormList()) {
            this.processDynamicComponentsWithPcFormList(apiRequest, pcUiBotModel, taskDetailBizReport, locale, pcDataLayout, args);
        } else {
            return;
        }
    }

    private void processDynamicComponentsWithPcTable(ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                                     TaskDetailBizReport taskDetailBizReport, String locale, UiBotLayout pcDataLayout,
                                                     Object... args) {
        String schema = pcDataLayout.getSchema();
        // 因为是TABLE类型的layout，所以数据一定是数组
        List<Map<String, Object>> bizDataList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizDataList, "pagedata." + schema + " cannot be null");

        // FIXME 6月需求只针对一笔的回报型任务做了设计与开发，后期应该会需要调整成通用的
        if (bizDataList.size() != 1) {
            taskDetailBizReport.addEmptyComponent(apiRequest);
            return;
        }

        List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return;
        }
        List<UiBotTableScriptFilter> scriptFilterList = pcDataLayout.getScriptFilters();

        // 分解出明细数据一行的字段列表
        List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions(tableColumnDefinitionList);

        // FIXME 获取移动端的规则库。后续需要和PC端UIBot负责人商量更合适的做法
        List<Rule> mobileRuleList = this.ruleService.findByRulePath(schema);

        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(schema);

        // 设置传入的布尔值，给后面建按钮时使用
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);

        for (Map<String, Object> bizData : bizDataList) {
            taskDetailBizReport.addMobileComponentsByColumnAndBizData(
                    locale, tableColumns, pcUiBotModel, bizData,
                    (DigiwinAtmcBacklogDetail) args[0], mobileRuleList, columnTagList, apiRequest);
        }
    }

    private void processDynamicComponentsWithPcFormList(ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                                        TaskDetailBizReport taskDetailBizReport, String locale, UiBotLayout pcDataLayout,
                                                        Object... args) {
        String schema = pcDataLayout.getSchema();
        // 因为是FORM_LIST类型的layout，所以数据一定是对象
        Map<String, Object> bizData = (Map<String, Object>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizData, "pagedata." + schema + " cannot be null");

        // FIXME 获取移动端的规则库。后续需要和PC端UIBot负责人商量更合适的做法
        List<Rule> mobileRuleList = this.ruleService.findByRulePath(schema);

        List<UiBotLayout> pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(mobileRuleList);
        List<UiBotTableColumn> tableColumns = pcFieldLayoutList.stream()
                .map(UiBotLayout::parseToTableColumn)
                .collect(Collectors.toList());


        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(schema);

        // 设置传入的布尔值，给后面建按钮时使用
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);

        taskDetailBizReport.addMobileComponentsByColumnAndBizData(
                locale, tableColumns, pcUiBotModel, bizData,
                (DigiwinAtmcBacklogDetail) args[0], mobileRuleList, columnTagList, apiRequest);
    }


    /**
     * 处理画面中已固定内容的组件
     *
     * @param apiRequest
     * @param pageSetting
     * @param pcUiBotModel
     * @param layout
     * @param taskDetailBizReport
     * @param args
     */
    private void processFixedComponents(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                        UiBotLayout layout, TaskDetailBizReport taskDetailBizReport, Object... args) {
        PageDescBuilder pageDescBuilder = this.pageDescBuilderFactory.get(TaskStringUtil.TASK_TYPE_BIZ_REPORT);
        if (layout.getType().equalsIgnoreCase(pageDescBuilder.getMobileComponentType())) {
            taskDetailBizReport.put(layout.getSchema(), pageDescBuilder.buildEmpty());
        } else if (layout.getType().equalsIgnoreCase(this.titleBodyBizReportBuilder.getMobileComponentType())) {
            taskDetailBizReport.put(layout.getSchema(),
                    this.titleBodyBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
        } else if (layout.getType().equalsIgnoreCase(this.bottomButtonBizReportBuilder.getMobileComponentType())) {
            taskDetailBizReport.put(layout.getSchema(),
                    this.bottomButtonBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                            BottomButtonList.class, args));
        } else if (layout.getType().equalsIgnoreCase(TabsComponent.COMPONENT_TYPE)) {
            taskDetailBizReport.put(layout.getSchema(),
                    new TabsComponent());
        }
    }
}
