package com.digiwin.mobile.mobileuibot.task.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.PopPromptMsg;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabBuilder;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabList;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOne;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOneBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizApproval;
import io.micrometer.core.instrument.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：APP我的任务详情页(tmPattern=BUSINESS、tmCategory=DATA_ENTRY_DRIVEN)</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildBizDataEntryDrivenStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/1/10 13:16
 */
@Slf4j
@Component
public class TaskDetailBuildBizDataEntryDrivenStrategy implements TaskDetailBuildStrategy {
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;

    @Autowired
    private CardOneBizApprovalBuilder cardOneBizApprovalBuilder;

    @Autowired
    private BizApprovalTabBuilder bizApprovalTabBuilder;

    @Autowired
    private BottomButtonBizApprovalBuilder bottomButtonBizApprovalBuilder;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private LocaleService localeService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.TASK_TYPE_BIZ_DATA_ENTRY_DRIVEN;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        UiBotModel pageModel = pageSetting.getPageModel();
        TaskDetailBizApproval taskDetailBizApproval = new TaskDetailBizApproval();
        for (UiBotLayout layout : pageModel.getLayout()) {
            String layoutType = layout.getType();
            switch (layoutType) {
                case TitleBody.COMPONENT_TYPE:
                    taskDetailBizApproval.put(layout.getSchema(),
                            ModuleUtils.buildTitle(pcUiBotModel, pcUiBotModel.getPageData(),
                                    (DigiwinAtmcBacklogDetail) args[0], apiRequest, true, true));
                    break;
                case PageDesc.COMPONENT_TYPE:
                    taskDetailBizApproval.put(layout.getSchema(),
                            this.pageDescBuilderFactory.get(TaskStringUtil.TASK_TYPE_BIZ_APPROVAL)
                                    .build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, args));
                    break;
                case CardOne.COMPONENT_TYPE:
                    taskDetailBizApproval.put(layout.getSchema(),
                            this.cardOneBizApprovalBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                                    CardOne.class, args));
                    break;
                case "TABS":
                    BizApprovalTabList tabs = this.bizApprovalTabBuilder.buildAllTabs(apiRequest, pcUiBotModel);
//                    BizApprovalTabList tabs = this.bizApprovalTabBuilder.build(apiRequest, pageSetting, pcUiBotModel,
//                            BizApprovalTabList.class);
                    tabs.forEach(tab -> {
                        tab.setMScrollMode(CustomTabScrollModeEnum.NO_SCROLL.getMode());
                    });
                    taskDetailBizApproval.put(layout.getSchema(), tabs);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
//                    if ("userTask_bottomButtons".equals(layout.getSchema())) {
//                        // 人工签核卡
//                        taskDetailBizApproval.put(layout.getSchema(), this.buildUserTaskButton(layout.getSchema(), apiRequest, pageSetting, pcUiBotModel, args));
//                    } else if ("manualTask_bottomButtons".equals(layout.getSchema())) {
//                        // 人工任务卡
//                        taskDetailBizApproval.put(layout.getSchema(), this.buildManualTaskButton(layout.getSchema(), apiRequest, pageSetting, pcUiBotModel, args));
//                    }
                    break;
                default:
                    // 什么都不做
                    break;
            }
        }
        return taskDetailBizApproval;
    }

    public BottomButtonList buildUserTaskButton(String schema, ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object[] args) {
        String locale = apiRequest.getLocale();

        List<UiBotAction> uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        // 获得实际业务的数据对象
        String bizDataSchema = "";
        UiBotTargetLayoutSearchResult layoutSearchResult = pcUiBotModel.searchPcTargetLayout();
        if (layoutSearchResult.found()) {
            bizDataSchema = layoutSearchResult.getTargetUiBotLayout().getSchema();
        } else {
            return BottomButtonList.createEmpty();
        }
        Object bizData = pcUiBotModel.getPageData().get(bizDataSchema);
        if (bizData == null) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof List) {
            if (((List<?>) bizData).isEmpty()) {
                return BottomButtonList.createEmpty();
            }
        }
        if (bizData instanceof Map) {
            if (((Map) bizData).isEmpty()) {
                return BottomButtonList.createEmpty();
            }
        }

        // 构造出一级按钮和下级按钮
        BottomButtonList result = new BottomButtonList();
        Map<String, UiBotAction> allActionMap = new HashMap<>();
        //2022年5月6日 方法重构，是页面按钮对象能封装到allActionMap中。
        //根据serviceId.name，按数据顺序整理出所有uibotaction对象
        for (UiBotAction uiBotAction : uiBotActions) {
            String serviceIdName = uiBotAction.getActionServiceIdName();
            if (uiBotAction.isAgreeAction(serviceIdName)) {
                allActionMap.put("workflow-act-agree", uiBotAction);
//            } else if (uiBotAction.isReexecuteAction(serviceIdName)) {
//                allActionMap.put("reexecute", uiBotAction);
            } else {
                String targetServiceIdName = uiBotAction.getUsefulActionServiceIdName();
                if (uiBotAction.isAgreeAction(targetServiceIdName)) {
                    allActionMap.put("workflow-act-agree", uiBotAction);
//                } else if (uiBotAction.isReexecuteAction(targetServiceIdName)) {
//                    allActionMap.put("reexecute", uiBotAction);
                } else {
                    allActionMap.put(targetServiceIdName, uiBotAction);
                }
            }
        }


        UiBotModel pageSettingModel = pageSetting.getPageModel();
        String bottomButtonDataSchema = schema;

        Map<String, Object> pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray =
                (JSONArray) JSON.toJSON(pageData.get(bottomButtonDataSchema));
        //加签按钮添加应用参数appCode
        String appCode = null;
        if (!ObjectUtils.isEmpty(args)) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = (DigiwinAtmcBacklogDetail) args[0];
            appCode = digiwinAtmcBacklogDetail.getAppCode();
        }

        for (int i = 0; i < bottomButtonDataArray.size(); i++) {
            JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(i);
            String id = bottomButtonJsonObj.getString("id");

            BottomButtonDigiwinAthena bottomButton;
            if ("other".equalsIgnoreCase(id)) {
                // 手工造的 其他按钮
                bottomButton = BottomButtonDigiwinAthena.create(
                        BottomButtonStyleEnum.NORMAL.getValue(), "...");
            } else if ("redo".equalsIgnoreCase(id)) {
                // 手工造的 退回按钮
                bottomButton = BottomButtonDigiwinAthena.create(
                        BottomButtonStyleEnum.NORMAL.getValue(), LocaleUtil.getMobileTextByKey(locale, "退回"));
            } else {
                UiBotAction pcUiBotAction = allActionMap.get(id);
                //空判断，不为空则造按钮，为空的话不用造该按钮
                if (null != pcUiBotAction) {
                    // 同意按钮

                    // action获取
                    JSONObject buttonActionJsonObj = bottomButtonJsonObj.getJSONObject("action");
                    String jumpPageId = buttonActionJsonObj.getString("jumpPageId");
                    Integer buttonType = buttonActionJsonObj.getInteger("type");
                    bottomButton = BottomButtonDigiwinAthena.create(pcUiBotAction,
                            bizDataSchema, bizData, null,
                            new Action(jumpPageId,
                                    LocaleUtil.getMobileTextByKey(locale, jumpPageId),
                                    buttonType),
                            bottomButtonJsonObj.getInteger("iconData"), id, appCode);
                } else {
                    continue;
                }
            }
            JSONArray childrenBottomButtonArray = bottomButtonJsonObj.getJSONArray("children");
            for (int j = 0; null != childrenBottomButtonArray && j < childrenBottomButtonArray.size(); j++) {
                JSONObject childBottomButtonJsonObj = childrenBottomButtonArray.getJSONObject(j);
                String childBottomButtonId = childBottomButtonJsonObj.getString("id");
                UiBotAction childUiBotAction = allActionMap.get(childBottomButtonId);

                // FIXME 按钮会少，因为数据库中配置的和athena给的不一样
                if (null == childUiBotAction) {
                    continue;
                }

                // action获取
                JSONObject childBottomButtonActionJsonObj = childBottomButtonJsonObj.getJSONObject("action");
                String jumpPageId = childBottomButtonActionJsonObj.getString("jumpPageId");
                String jumpPageTitle = childBottomButtonActionJsonObj.getString("jumpPageTitle");
                Integer buttonType = childBottomButtonActionJsonObj.getInteger("type");
                jumpPageTitle = LocaleUtil.getMobileTextByKey(locale, jumpPageTitle);
                if (StringUtils.isBlank(jumpPageTitle)) {
                    jumpPageTitle = LocaleUtil.getMobileTextByKey(locale, jumpPageId);
                }
                BottomButtonDigiwinAthena childBottomButton;
                Action childBottomButtonAction = new Action(jumpPageId,
                        jumpPageTitle,
                        buttonType);

                // FIXME 写死的逻辑，只有退回重签需要这个签核进度的数据
                if ("workflow-act-return".equalsIgnoreCase(childBottomButtonId)) {
                    childBottomButton = BottomButtonDigiwinAthena.create(childUiBotAction,
                            bizDataSchema, bizData,
                            TaskDataExtractUtil.getSignoffProgressData(pcUiBotModel.getPageData()),
                            childBottomButtonAction,
                            childBottomButtonJsonObj.getInteger("iconData"), childBottomButtonId, appCode);
                } else {
                    childBottomButton = BottomButtonDigiwinAthena.create(childUiBotAction,
                            bizDataSchema, bizData, null,
                            childBottomButtonAction,
                            childBottomButtonJsonObj.getInteger("iconData"), childBottomButtonId, appCode);
                }
                ModuleUtils.addRefreshPageId(childBottomButton, apiRequest.getPageId());
                bottomButton.addChildBottomButton(childBottomButton);
            }

            //当该按钮配置了二层按钮，且二层按钮web端没有的时候则跳出本层循环
            int isHaveChildren = bottomButton.getChildren().size();
            if (null != childrenBottomButtonArray) {
                if (isHaveChildren == 0) {
                    continue;
                }
            } else {
                ModuleUtils.addRefreshPageId(bottomButton, apiRequest.getPageId());
            }

            result.add(bottomButton);
        }

        return result;
    }

    public BottomButtonList buildManualTaskButton(String schema, ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object[] args) {
        String locale = apiRequest.getLocale();

        List<UiBotAction> uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        // 获得实际业务的数据对象
        String bizDataSchema = "";
        UiBotTargetLayoutSearchResult layoutSearchResult = pcUiBotModel.searchPcTargetLayout();
        if (layoutSearchResult.found()) {
            bizDataSchema = layoutSearchResult.getTargetUiBotLayout().getSchema();
        } else {
            return BottomButtonList.createEmpty();
        }
        Object bizData = pcUiBotModel.getPageData().get(bizDataSchema);
        if (bizData == null) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof List) {
            if (((List<?>) bizData).isEmpty()) {
                return BottomButtonList.createEmpty();
            }
        }
        if (bizData instanceof Map) {
            if (((Map) bizData).isEmpty()) {
                return BottomButtonList.createEmpty();
            }
        }

        // 构造出一级按钮和下级按钮
        BottomButtonList result = new BottomButtonList();
        Map<String, UiBotAction> allActionMap = new HashMap<>();
        //2022年5月6日 方法重构，是页面按钮对象能封装到allActionMap中。
        //根据serviceId.name，按数据顺序整理出所有uibotaction对象
        for (UiBotAction uiBotAction : uiBotActions) {
            String serviceIdName = uiBotAction.getActionServiceIdName();
            if ("workflow-act-submit".equalsIgnoreCase(serviceIdName)) {
                allActionMap.put("workflow-act-submit", uiBotAction);
            } else if ("basic-data-update".equalsIgnoreCase(uiBotAction.getActionType())) {
                allActionMap.put("basic-data-update", uiBotAction);
            } else {
                String targetServiceIdName = uiBotAction.getUsefulActionServiceIdName();
                if ("workflow-act-submit".equalsIgnoreCase(targetServiceIdName)) {
                    allActionMap.put("workflow-act-submit", uiBotAction);
                }
            }
        }


        UiBotModel pageSettingModel = pageSetting.getPageModel();
        String bottomButtonDataSchema = schema;

        Map<String, Object> pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray =
                (JSONArray) JSON.toJSON(pageData.get(bottomButtonDataSchema));
        //加签按钮添加应用参数appCode
        String appCode = null;
//        if (!ObjectUtils.isEmpty(args)) {
//            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = (DigiwinAtmcBacklogDetail) args[0];
//            appCode = digiwinAtmcBacklogDetail.getAppCode();
//        }

        for (int i = 0; i < bottomButtonDataArray.size(); i++) {
            JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(i);
            String id = bottomButtonJsonObj.getString("id");

            BottomButtonDigiwinAthena bottomButton;
//            if ("other".equalsIgnoreCase(id)) {
//                // 手工造的 其他按钮
//                bottomButton = BottomButtonDigiwinAthena.create(
//                        BottomButtonStyleEnum.NORMAL.getValue(), "...");
//            } else if ("redo".equalsIgnoreCase(id)) {
//                // 手工造的 退回按钮
//                bottomButton = BottomButtonDigiwinAthena.create(
//                        BottomButtonStyleEnum.NORMAL.getValue(), LocaleUtil.getMobileTextByKey(locale, "退回"));
//            } else {
            UiBotAction pcUiBotAction = allActionMap.get(id);
            //空判断，不为空则造按钮，为空的话不用造该按钮
            if (null != pcUiBotAction) {
                // 同意按钮

                // action获取
                bottomButton = BottomButtonDigiwinAthena.create(pcUiBotAction,
                        bizDataSchema, bizData, null,
                        new Action(ActionTypeEnum.CALL_API.getValue()),
                        null, id, appCode);
            } else {
                continue;
            }
//            }
//            JSONArray childrenBottomButtonArray = bottomButtonJsonObj.getJSONArray("children");
//            for (int j = 0; null != childrenBottomButtonArray && j < childrenBottomButtonArray.size(); j++) {
//                JSONObject childBottomButtonJsonObj = childrenBottomButtonArray.getJSONObject(j);
//                String childBottomButtonId = childBottomButtonJsonObj.getString("id");
//                UiBotAction childUiBotAction = allActionMap.get(childBottomButtonId);
//
//                // FIXME 按钮会少，因为数据库中配置的和athena给的不一样
//                if (null == childUiBotAction) {
//                    continue;
//                }
//
//                // action获取
//                JSONObject childBottomButtonActionJsonObj = childBottomButtonJsonObj.getJSONObject("action");
//                String jumpPageId = childBottomButtonActionJsonObj.getString("jumpPageId");
//                String jumpPageTitle = childBottomButtonActionJsonObj.getString("jumpPageTitle");
//                Integer buttonType = childBottomButtonActionJsonObj.getInteger("type");
//                jumpPageTitle = LocaleUtil.getMobileTextByKey(locale, jumpPageTitle);
//                if (StringUtils.isBlank(jumpPageTitle)) {
//                    jumpPageTitle = LocaleUtil.getMobilePageTitleByPageIdKey(locale, jumpPageId);
//                }
//                BottomButtonDigiwinAthena childBottomButton;
//                Action childBottomButtonAction = new Action(jumpPageId,
//                        jumpPageTitle,
//                        buttonType);
//
//                // FIXME 写死的逻辑，只有退回重签需要这个签核进度的数据
//                if ("workflow-act-return".equalsIgnoreCase(childBottomButtonId)) {
//                    childBottomButton = BottomButtonDigiwinAthena.create(childUiBotAction,
//                            bizDataSchema, bizData,
//                            TaskDataExtractUtil.getSignoffProgressData(pcUiBotModel.getPageData()),
//                            childBottomButtonAction,
//                            childBottomButtonJsonObj.getInteger("iconData"), childBottomButtonId, appCode);
//                } else {
//                    childBottomButton = BottomButtonDigiwinAthena.create(childUiBotAction,
//                            bizDataSchema, bizData, null,
//                            childBottomButtonAction,
//                            childBottomButtonJsonObj.getInteger("iconData"), childBottomButtonId, appCode);
//                }
//                ModuleUtils.addRefreshPageId(childBottomButton, apiRequest.getPageId());
//                bottomButton.addChildBottomButton(childBottomButton);
//            }

//            //当该按钮配置了二层按钮，且二层按钮web端没有的时候则跳出本层循环
//            int isHaveChildren = bottomButton.getChildren().size();
//            if (null != childrenBottomButtonArray) {
//                if (isHaveChildren == 0) {
//                    continue;
//                }
//            } else {
            ModuleUtils.addRefreshPageId(bottomButton, apiRequest.getPageId());
//            }

            result.add(bottomButton);
        }

        return result;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        UiBotModel uiBotModel = uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
        uiBotModel.setBeforeAction(this.buildBeforeAction(apiRequest.getLocale()));
//        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
//        // 创建空组件
//        UiBotModel empty = UiBotModel.createEmptyComponent(
//                localeService.getLanguageValue(apiRequest.getLocale(), "移动端不支持该任务，请回到web端处理"),
//                false,
//                null);
//        uiBotModel.getLayout().addAll(empty.getLayout());
//        uiBotModel.getPageData().putAll(empty.getPageData());
        return uiBotModel;
    }

    private Action<Map<String, Object>> buildBeforeAction(String locale) {
        Action<Map<String, Object>> action = new Action<>();
        action.setType(ActionTypeEnum.POP_PROMPT.getValue());
        PopPromptMsg popPromptMsg = new PopPromptMsg();
        popPromptMsg.setTitle(localeService.getLanguageValue(locale, "提示"));
        popPromptMsg.setContent(localeService.getLanguageValue(locale, "此作业未配置移动端界面，暂不支持提交操作\n请前往Web端查阅处理"));
        Button<Map<String, Object>> button = new Button<>();
        button.setName(localeService.getLanguageValue(locale, "确定"));
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        button.setAction(new Action<>(ActionTypeEnum.BACK.getValue()));
        popPromptMsg.setButtonList(Collections.singletonList(button));
        action.setPopPromptMsg(popPromptMsg);
        return action;
    }
}
