package com.digiwin.mobile.mobileuibot.task.strategy;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFill;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFillData;
import com.digiwin.mobile.mobileuibot.core.component.basic.TextMulti;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButtonLabelStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBodyBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleConditionOperatorTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.core.rule.relation.*;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgress;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableScriptFilter;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：构建回报型任务画面的策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildBizReportStrategy
 * @Author: Zaregoto
 * @Date: 2021/6/14 18:41
 */
@Slf4j
@Component("taskDetailBuildBizReportStrategy")
public class TaskDetailBuildBizReportStrategy implements TaskDetailBuildStrategy {


    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;

    @Autowired
    private TitleBodyBizReportBuilder titleBodyBizReportBuilder;

    @Autowired
    private BottomButtonBizReportBuilder bottomButtonBizReportBuilder;

    @Autowired
    private RuleService ruleService;

    @Autowired
    private ColumnTagService columnTagService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    // FIXME 判断的位置要调整，不然当pageSetting中的底部按钮layout不是放在底部时，判断会不正确
    private Boolean hasEditableColumn = false;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.TASK_TYPE_BIZ_REPORT;
    }

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);

        /**
         * 根据pageSetting中设置的layout设置最终结果中动态组件的部分。固定的部分则傅pageSetting中已经固定的部分
         * 动态的部分使用${COMPONENT_TYPE}来表示layout.type，用${componentSchema}来表示layout.schema
         * 最终结果中使用实际字段的名称作为key，组件对象作为value
         */
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        int dynamicComponentPlaceholderIndex = 0;
        for (int i = 0; i < pageSettingModel.getLayout().size(); i++) {
            UiBotLayout pageSettingLayout = pageSettingModel.getLayout().get(i);
            if ("${COMPONENT_TYPE}".equalsIgnoreCase(pageSettingLayout.getType())) {
                // 动态的部分
                dynamicComponentPlaceholderIndex = i;
                this.processDynamicComponents(apiRequest, pcUiBotModel, pageSettingLayout, taskDetailBizReport, args);
            } else {
                // 固定的部分
                this.processFixedComponents(apiRequest, pageSetting, pcUiBotModel, pageSettingLayout,
                        taskDetailBizReport, args);
            }
        }

        pageSettingModel.getLayout().addAll(dynamicComponentPlaceholderIndex,
                taskDetailBizReport.getActualLayoutList());

        // 去除组件动态占位符的那个layout
        pageSettingModel.getLayout().remove(
                dynamicComponentPlaceholderIndex + taskDetailBizReport.getActualLayoutList().size());

        return taskDetailBizReport;
    }


    private void processDynamicComponents(ApiRequest apiRequest, UiBotModel pcUiBotModel, UiBotLayout pageSettingModel,
                                          TaskDetailBizReport taskDetailBizReport, Object... args) {
        String locale = apiRequest.getLocale();

        // 找到实际明细数据的layout
        UiBotTargetLayoutSearchResult searchResult = pcUiBotModel.searchPcTargetLayout();

        if (!searchResult.found()) {
            return;
        }

        /**
         * 获取最新一条别人的签核数据。获取方法是取workitemList属性不为null，且状态是已完成的最后一个元素。
         * 可以用倒数是因为athena数据，是按时间正序排签核关卡的
         */
        List<DigiwinAtmcTaskProgress> digiwinAtmcTaskProgressList =
                ((List<DigiwinAtmcTaskProgress>) args[1]).stream()
                        .filter(taskProgress ->
                                TaskProgressStateEnum.getByPcStateNumber(taskProgress.getState()) == TaskProgressStateEnum.DONE
                                        && !CollectionUtils.isEmpty(taskProgress.getWorkitemList()))
                        .collect(Collectors.toList());
        int taskProgressListSize = digiwinAtmcTaskProgressList.size();
        DigiwinAtmcTaskProgress latestAtmcTaskProgress = taskProgressListSize > 0 ?
                digiwinAtmcTaskProgressList.get(taskProgressListSize - 1) : null;

        // TODO 以下签核数据的展示，要考虑抽取成公用逻辑，用模板模式来复用
        /**
         * 如果有签核数据，则增加签核数据组件展示。
         * 签核的内容仍属于字段，需要放在详情内所有字段的前面优先处理。
         * 但如果详情内存在一些任务上方要优先展示的快捷操作（如AUTO_FILL组件），那这些逻辑会在最后方法内完成
         */
        if (null != latestAtmcTaskProgress && args[0] instanceof DigiwinAtmcBacklogDetail) {
            String performerName = latestAtmcTaskProgress.getWorkitemList().get(0).getPerformerName();
            if (!StringUtils.hasLength(performerName)) {
                performerName = UiBotTableColumn.VALUE_EMPTY_SYMBOL;
            }
            String comment = latestAtmcTaskProgress.getWorkitemList().get(0).getComment();
            if (!StringUtils.hasLength(comment)) {
                comment = UiBotTableColumn.VALUE_EMPTY_SYMBOL;
            }
            String time = latestAtmcTaskProgress.getWorkitemList().get(0).getClosedTime();
            if (!StringUtils.hasLength(time)) {
                time = UiBotTableColumn.VALUE_EMPTY_SYMBOL;
            }

            DigiwinAtmcBacklogDetail backlogDetail = (DigiwinAtmcBacklogDetail) args[0];
            LinkedHashMap<String, String> schemaAndNameMap = new LinkedHashMap<>(3);
            schemaAndNameMap.put("performerName", LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "人"));
            schemaAndNameMap.put("comment", LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "原因"));
            schemaAndNameMap.put("time", LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "时间"));
            for (String schema : schemaAndNameMap.keySet()) {
                String fieldLabel = backlogDetail.getApprovalState()
                        + (Locale.US.toString().equals(apiRequest.getLocale()) ? " " : "")
                        + schemaAndNameMap.get(schema);
                MobileComponent mobileComponent = null;
                if (schema.equals("performerName")) {
                    mobileComponent = InputSingleText.create(fieldLabel, performerName, false);
                } else if (schema.equals("comment")) {
                    mobileComponent = TextMulti.create(fieldLabel, comment, apiRequest.getLocale());
                } else {
                    mobileComponent = InputSingleText.create(fieldLabel, time, false);
                }
                taskDetailBizReport.addMobileComponent(schema, mobileComponent);
            }

            // 界面下方业务字段列表的第一个layout
            UiBotLayout firstActualLayout = taskDetailBizReport.getActualLayoutList().get(0);
            if (taskDetailBizReport.get(firstActualLayout.getSchema()) instanceof BaseInputMobileComponent) {
                // 两栏位一个只读，另一个可写入时，用区块分割线
                taskDetailBizReport.addMobileComponent(Divider.create(DividerTypeEnum.BLOCK_DIVIDER));
            } else {
                // 两栏位均为只读时无分割线
            }
        }

        UiBotLayout pcDataLayout = searchResult.getTargetUiBotLayout();
        if (pcDataLayout.isTypeOfTable()) {
            this.processDynamicComponentsWithPcTable(apiRequest, pcUiBotModel, taskDetailBizReport, locale, pcDataLayout, args);
        } else if (pcDataLayout.isTypeOfFormList()) {
            this.processDynamicComponentsWithPcFormList(apiRequest, pcUiBotModel, taskDetailBizReport, locale, pcDataLayout, args);
        } else {
            return;
        }

        Map<String, Object> approvalDescription = Optional.ofNullable(pcUiBotModel).map(UiBotModel::getPageData).map(UiBotPageData::getUiBotApprovalDescription).orElse(new HashMap<>());
        String beforeTaskNo = (String) MapUtil.getOrDefault(approvalDescription, "before_task_no", "");
        if (StringUtils.hasLength(beforeTaskNo)) {
            PageButton pageButton = new PageButton();
            pageButton.setName(localeService.getLanguageValue(locale, "查看前置任务"));
            pageButton.setStyle(2);
            pageButton.setLabelStyle(PageButtonLabelStyleEnum.EDIT.getType());

            Action pageButtonAction = new Action();
            pageButtonAction.setJumpPageTitle(pageButton.getName());
            pageButtonAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PREVIOUS_MANUAL_TASK_DETAIL.toString());
            pageButtonAction.setType(2);
            Map<String, Object> rawData = new HashMap<>(2);
            rawData.put("project_no", approvalDescription.get("project_no"));
            rawData.put("task_no", approvalDescription.get("task_no"));
            pageButtonAction.setRawData(rawData);
            pageButton.setAction(pageButtonAction);
            taskDetailBizReport.addMobileComponent(8, pageButton);
        }
    }

    private void processDynamicComponentsWithPcTable(ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                                     TaskDetailBizReport taskDetailBizReport, String locale, UiBotLayout pcDataLayout,
                                                     Object... args) {
        String schema = pcDataLayout.getSchema();
        // 因为是TABLE类型的layout，所以数据一定是数组
        List<Map<String, Object>> bizDataList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizDataList, "pagedata." + schema + " cannot be null");

        String tmActivityId = Optional.ofNullable(pcUiBotModel.getExecuteContext())
                .map(e->e.getString("tmActivityId"))
                .orElse("");
        if (CollectionUtils.isEmpty(bizDataList) && Objects.equals(tmActivityId, "manual_DTD_Assignment")) {
            taskDetailBizReport.addCustomContentComponent(apiRequest);
            return;
        }

        // FIXME 6月需求只针对一笔的回报型任务做了设计与开发，后期应该会需要调整成通用的
        if (bizDataList.size() != 1) {
            taskDetailBizReport.addEmptyComponent(apiRequest);
            return;
        }

        List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return;
        }
        List<UiBotTableScriptFilter> scriptFilterList = pcDataLayout.getScriptFilters();

        // 分解出明细数据一行的字段列表
        List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions(tableColumnDefinitionList);

        // FIXME 获取移动端的规则库。后续需要和PC端UIBot负责人商量更合适的做法
        List<Rule> mobileRuleList = this.ruleService.findByRulePath(schema);

        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(schema);

        // 设置传入的布尔值，给后面建按钮时使用
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);

        // 是否是撤回
        Optional.ofNullable(pcUiBotModel).map(UiBotModel::getActions).ifPresent(actions -> {
            if (!CollectionUtils.isEmpty(actions)) {
                pcUiBotModel.getVariableMaps().put("withdraw", actions.stream().anyMatch(item -> Objects.equals("esp_bm.pisc.task.update", item.getActionId())));
            }
        });

        pcUiBotModel.getVariableMaps().put("progressCancel", digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "progressCancel"));
        pcUiBotModel.getVariableMaps().put("isWorkReportRequired", digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "isWorkReportRequired"));
        //交付设计器.工时不可为0
        Map<String, Object> variableListSimpleMap = digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), Arrays.asList("isworkHourZero", "isAllowReportAfter"));
        Boolean isworkHourZero = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean(map, "isworkHourZero")).orElse(true);
        pcUiBotModel.getVariableMaps().put("isworkHourZero", isworkHourZero);
        for (Map<String, Object> bizData : bizDataList) {
            taskDetailBizReport.addMobileComponentsByColumnAndBizData(
                    locale, tableColumns, pcUiBotModel, bizData,
                    (DigiwinAtmcBacklogDetail) args[0], mobileRuleList, columnTagList, apiRequest);
        }
        variableListSimpleMap = Optional.ofNullable(variableListSimpleMap).orElseGet(HashMap::new);
        variableListSimpleMap.put("withdraw", pcUiBotModel.getVariableMaps().get("withdraw"));
        // 手动报工一些定制规则
        handleTaskDetailBizReportRule(taskDetailBizReport, variableListSimpleMap);

        // 是否团队任务。若是，则所有可操作的按钮都不展示
        boolean taskInReadOnlyMode = apiRequest.getRawData().getBooleanValue("isTeamTask");
        if (!taskInReadOnlyMode) {
            // 所有字段上方任务的快捷操作（如AUTO_FILL组件）
            JSONArray operations = pcDataLayout.getOperations();
            if (!CollectionUtils.isEmpty(operations)) {
                List<AutoFillData> autoFillDataList = new LinkedList<>();
                String reportAtOnceName = this.localeService.getLanguageValue(locale, "一键报工");
                for (int i = 0; i < operations.size(); i++) {
                    // FIXME 后续接上KM的话，这里使用中文匹配的做法就要改，不然会有问题 by mowj 20220117
                    String title = operations.getJSONObject(i).getString("title").trim();
                    if (Objects.equals(title, reportAtOnceName)) {
                        autoFillDataList.add(AutoFillData.create(reportAtOnceName, pcDataLayout, bizDataList.get(0), variableListSimpleMap));
                    }
                }
                // 代为报工, 出现条件：任务类型：ORD手动报工且交付设计器.任务负责人代为报工：true，否则按钮不出现
                String taskCategory = (String) MapUtil.getOrDefault(bizDataList.get(0), "task_category", "");
                Boolean isExistReplaceReport = digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), apiRequest.getLocale(), "reportWorkByTaskLiable");
                if (BooleanUtils.isTrue(isExistReplaceReport) && "ORD".equalsIgnoreCase(taskCategory)) {
                    autoFillDataList.add(AutoFillData.create(apiRequest, taskDetailBizReport, localeService, isworkHourZero));
                }
                AutoFill autoFill = new AutoFill();
                autoFill.setData(autoFillDataList);
                taskDetailBizReport.addMobileComponent(0, autoFill);
            }
        }
    }

    private void handleTaskDetailBizReportRule(TaskDetailBizReport taskDetailBizReport, Map<String, Object> variableListSimpleMap) {
        Boolean withdraw = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean(map, "withdraw")).orElse(false);
        // 如果是撤回，不需要走下面的规则
        if (BooleanUtils.isTrue(withdraw)) {
            return;
        }

        // 去掉报工类型名称
        if (taskDetailBizReport.containsKey("report_type_name")) {
            taskDetailBizReport.remove("report_type_name");
        }

        Boolean isworkHourZero = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean(map, "isworkHourZero")).orElse(true);
        // 交付设计器打开时.工时不可为0且不可为空
        if (Objects.nonNull(taskDetailBizReport.get("work_hours")) && BooleanUtils.isTrue(isworkHourZero)) {
            InputNumeric workHours = JsonUtil.objectToJavaObject(taskDetailBizReport.get("work_hours"), InputNumeric.class);
            workHours.setRequired(true);
            taskDetailBizReport.put("work_hours", workHours);
        }

        // 交付设计器允许事后报工
        Boolean isAllowReportAfter = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean(map, "isAllowReportAfter")).orElse(false);

        // 报工日期
        if (Objects.nonNull(taskDetailBizReport.get("report_date"))) {
            InputCalendar reportDate = JsonUtil.objectToJavaObject(taskDetailBizReport.get("report_date"), InputCalendar.class);
            // 交付设计器允许事后报工打开，报工日期必填， 报工日期的可选范围为实际开始日至系统日
            if (BooleanUtils.isTrue(isAllowReportAfter)) {
                if (Objects.nonNull(taskDetailBizReport.get("actual_start_date"))) {
                    InputCalendar actualStartDate = JsonUtil.objectToJavaObject(taskDetailBizReport.get("actual_start_date"), InputCalendar.class);
                    if (CollectionUtils.isEmpty(actualStartDate.getDateValueList())) {
                        reportDate.setMinDateSelectable(reportDate.getMinDate());
                    } else {
                        reportDate.setMinDateSelectable(actualStartDate.getDateValueList().get(0));
                    }
                }
                reportDate.setRequired(true);
                reportDate.setMaxDateSelectable(InputCalendarDate.createToday());
            } else {
                reportDate.setEnable(false);
                List<InputCalendarDate> dateValueList = new ArrayList<>(1);
                dateValueList.add(InputCalendarDate.createToday());
                reportDate.setDateValueList(dateValueList);
            }

            //报工日期默认系统日
            reportDate.getDateValueList().add(InputCalendarDate.createToday());
            taskDetailBizReport.put("report_date", reportDate);
        }

        // 实际开始日
        if (Objects.nonNull(taskDetailBizReport.get("actual_start_date"))) {
            InputCalendar actualStartDate = JsonUtil.objectToJavaObject(taskDetailBizReport.get("actual_start_date"), InputCalendar.class);
            RelationRule relationRule = Optional.ofNullable(actualStartDate.getRelationRule()).orElse(new RelationRule());
            List<CommonRule> ruleList = Optional.ofNullable(relationRule.getRuleList()).orElse(new ArrayList<>());

            //实际开始日期有变化则需要置空实际结束日期
            CommonRule commonRule1 = new CommonRule();
            commonRule1.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
            commonRule1.setTargetSchema("actual_finish_date");
            commonRule1.setTargetText("");
            commonRule1.setTargetHidden(null);
            commonRule1.setTargetEnable(true);
            //防呆，选择的时间不能小于开始的时间
            List<TargetDatetime> targetDatetimes = new ArrayList<>();
            TargetDatetime targetDatetime1 = new TargetDatetime();
            targetDatetime1.setDatetimeType(1);
            targetDatetime1.setLinkageSchema("actual_start_date");
            targetDatetimes.add(targetDatetime1);
            commonRule1.setTargetDatetime(targetDatetimes);
            ruleList.add(commonRule1);

            if (BooleanUtils.isTrue(isAllowReportAfter)) {
                // 报工日期的可选范围为实际开始日至系统日
                CommonRule commonRule = new CommonRule();
                commonRule.setTargetSchema("report_date");
                commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                TargetDatetime targetDatetime = new TargetDatetime();
                targetDatetime.setLinkageSchema("actual_start_date");
                targetDatetime.setDatetimeType(1);
                commonRule.setTargetDatetime(Collections.singletonList(targetDatetime));
                ruleList.add(commonRule);
            } else {
                CommonRule commonRule = new CommonRule();
                commonRule.setTargetSchema("actual_finish_date");
                commonRule.setCondition(CommonRuleCondition.CONDITION_EQUAL.getType());
                commonRule.setTargetText(DateTimeUtil.getTodayDateTextInMobileShowDefaultPattern());
                OperatorData operatorData = new OperatorData();
                operatorData.setOperatorSchema("complete_rate");
                operatorData.setOperatorType(RuleConditionOperatorTypeEnum.EQUALS.getType());
                operatorData.setOperatorValue("100");
                operatorData.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                commonRule.setOperatorData(operatorData);
                commonRule.setTargetHidden(false);
                commonRule.setTargetEnable(false);
                commonRule.setTargetRequired(false);
                ruleList.add(commonRule);
            }
            relationRule.setRuleList(ruleList);
            actualStartDate.setRelationRule(relationRule);
            taskDetailBizReport.put("actual_start_date", actualStartDate);
        }

        // 实际完成日
        if (Objects.nonNull(taskDetailBizReport.get("actual_finish_date"))) {
            InputCalendar actualFinishDate = JsonUtil.objectToJavaObject(taskDetailBizReport.get("actual_finish_date"), InputCalendar.class);
            // 交付设计器允许事后报工打开，报工日期必填， 报工日期的可选范围为实际开始日至系统日
            if (BooleanUtils.isTrue(isAllowReportAfter)) {
                if (Objects.nonNull(taskDetailBizReport.get("actual_start_date"))) {
                    InputCalendar actualStartDate = JsonUtil.objectToJavaObject(taskDetailBizReport.get("actual_start_date"), InputCalendar.class);
                    if (CollectionUtils.isEmpty(actualStartDate.getDateValueList())) {
                        actualFinishDate.setMinDateSelectable(actualFinishDate.getMinDate());
                    } else {
                        actualFinishDate.setMinDateSelectable(actualStartDate.getDateValueList().get(0));
                    }
                }
                actualFinishDate.setMaxDateSelectable(InputCalendarDate.createToday());
            } else {
                actualFinishDate.setEnable(false);
                actualFinishDate.setDateValueList(Collections.singletonList(InputCalendarDate.createToday()));
            }
            taskDetailBizReport.put("actual_finish_date", actualFinishDate);
        }

        // 完成率
        if (Objects.nonNull(taskDetailBizReport.get("complete_rate"))) {
            InputNumeric completeRate = JsonUtil.objectToJavaObject(taskDetailBizReport.get("complete_rate"), InputNumeric.class);
            RelationRule relationRule = Optional.ofNullable(completeRate.getRelationRule()).orElse(new RelationRule());
            List<CommonRule> ruleList = Optional.ofNullable(relationRule.getRuleList()).orElse(new ArrayList<>());
            if (BooleanUtils.isTrue(isAllowReportAfter)) {
                // 是当完成率=100时 实际完成日不可编辑，赋系统时间
                CommonRule commonRule = new CommonRule();
                commonRule.setTargetSchema("actual_finish_date");
                commonRule.setCondition(CommonRuleCondition.CONDITION_EQUAL.getType());
                OperatorData operatorData = new OperatorData();
                operatorData.setOperatorType(RuleConditionOperatorTypeEnum.EQUALS.getType());
                operatorData.setOperatorValue("100");
                operatorData.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                commonRule.setOperatorData(operatorData);
                commonRule.setTargetHidden(false);
                commonRule.setTargetEnable(true);
                commonRule.setTargetRequired(true);
                ruleList.add(commonRule);
            } else {
                // 是当完成率=100时 实际完成日不可编辑，赋系统时间
                CommonRule commonRule = new CommonRule();
                commonRule.setTargetSchema("actual_finish_date");
                commonRule.setCondition(CommonRuleCondition.CONDITION_EQUAL.getType());
                commonRule.setTargetText(DateTimeUtil.getTodayDateTextInMobileShowDefaultPattern());
                OperatorData operatorData = new OperatorData();
                operatorData.setOperatorType(RuleConditionOperatorTypeEnum.EQUALS.getType());
                operatorData.setOperatorValue("100");
                operatorData.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                commonRule.setOperatorData(operatorData);
                commonRule.setTargetHidden(false);
                commonRule.setTargetEnable(false);
                commonRule.setTargetRequired(false);
                ruleList.add(commonRule);
            }
            relationRule.setRuleList(ruleList);
            completeRate.setRelationRule(relationRule);
            taskDetailBizReport.put("complete_rate", completeRate);
        }
    }

    private void processDynamicComponentsWithPcFormList(ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                                        TaskDetailBizReport taskDetailBizReport, String locale, UiBotLayout pcDataLayout,
                                                        Object... args) {
        String schema = pcDataLayout.getSchema();
        // 因为是FORM_LIST类型的layout，所以数据一定是对象
        Map<String, Object> bizData = (Map<String, Object>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizData, "pagedata." + schema + " cannot be null");

        // FIXME 获取移动端的规则库。后续需要和PC端UIBot负责人商量更合适的做法
        List<Rule> mobileRuleList = this.ruleService.findByRulePath(schema);

        List<UiBotLayout> pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(mobileRuleList);
        List<UiBotTableColumn> tableColumns = pcFieldLayoutList.stream()
                .map(UiBotLayout::parseToTableColumn)
                .collect(Collectors.toList());


        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(schema);

        // 设置传入的布尔值，给后面建按钮时使用
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);

        // 是否团队任务。若是，则所有可操作的按钮都不展示
        boolean taskInReadOnlyMode = apiRequest.getRawData().getBooleanValue("isTeamTask");
        if (taskInReadOnlyMode) {
            // 所有字段上方任务的快捷操作（如AUTO_FILL组件）
            JSONArray operations = pcDataLayout.getOperations();
            if (!CollectionUtils.isEmpty(operations)) {
                List<AutoFillData> autoFillDataList = new LinkedList<>();
                String reportAtOnceName = this.localeService.getLanguageValue(locale, "一键报工");
                for (int i = 0; i < operations.size(); i++) {
                    // FIXME 后续接上KM的话，这里使用中文匹配的做法就要改，不然会有问题 by mowj 20220117
                    String title = operations.getJSONObject(i).getString("title").trim();
                    if (Objects.equals(title, reportAtOnceName)) {
                        autoFillDataList.add(AutoFillData.create(reportAtOnceName, pcDataLayout, bizData, Collections.emptyMap()));
                    }
                }
                AutoFill autoFill = new AutoFill();
                autoFill.setData(autoFillDataList);
                taskDetailBizReport.addMobileComponent(0, autoFill);
            }
        }
        pcUiBotModel.getVariableMaps().put("progressCancel", digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "progressCancel"));
        pcUiBotModel.getVariableMaps().put("isWorkReportRequired", digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "isWorkReportRequired"));
        taskDetailBizReport.addMobileComponentsByColumnAndBizData(
                locale, tableColumns, pcUiBotModel, bizData,
                (DigiwinAtmcBacklogDetail) args[0], mobileRuleList, columnTagList, apiRequest);
    }

    /**
     * 处理画面中已固定内容的组件
     *
     * @param apiRequest
     * @param pageSetting
     * @param pcUiBotModel
     * @param layout
     * @param taskDetailBizReport
     * @param args
     */
    private void processFixedComponents(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                        UiBotLayout layout, TaskDetailBizReport taskDetailBizReport, Object... args) {
        PageDescBuilder pageDescBuilder = this.pageDescBuilderFactory.get(TaskStringUtil.TASK_TYPE_BIZ_REPORT);
        if (layout.getType().equalsIgnoreCase(pageDescBuilder.getMobileComponentType())) {
            taskDetailBizReport.put(layout.getSchema(), pageDescBuilder.buildEmpty());
        } else if (layout.getType().equalsIgnoreCase(this.titleBodyBizReportBuilder.getMobileComponentType())) {
            taskDetailBizReport.put(layout.getSchema(),
                    this.titleBodyBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
        } else if (layout.getType().equalsIgnoreCase(this.bottomButtonBizReportBuilder.getMobileComponentType())) {
            List<UiBotAction> uiBotActions = pcUiBotModel.getActions();
            if (!CollectionUtils.isEmpty(uiBotActions)) {
                uiBotActions.forEach(e -> {
                    if (BottomButtonBizReportBuilder.BUTTON_MAP.containsKey(e.getActionId())) {
                        e.put("confirmPop_content", localeService.getLanguageValue(apiRequest.getLocale(), "是否确认提交？"));
                    }
                });
            }
            taskDetailBizReport.put(layout.getSchema(),
                    this.bottomButtonBizReportBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                            BottomButtonList.class, args));
        } else {

        }
    }
}
