package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.PopPromptMsg;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabBuilder;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalTabList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOne;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOneBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizApproval;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Map;

/**
 * <p>功能描述：APP我的任务详情页(随心控(人工型：code+_task_manual;审核型：code+_task_approve))</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildBizSmartAdjustStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/7/5 15:09
 */
@Slf4j
@Component
public class TaskDetailBuildBizSmartAdjustStrategy implements TaskDetailBuildStrategy {
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;

    @Autowired
    private CardOneBizApprovalBuilder cardOneBizApprovalBuilder;

    @Autowired
    private BizApprovalTabBuilder bizApprovalTabBuilder;

    @Autowired
    private BottomButtonBizApprovalBuilder bottomButtonBizApprovalBuilder;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private PageSettingService pageSettingService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_CODE_SMART_ADJUST;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        UiBotModel pageModel = pageSetting.getPageModel();
        TaskDetailBizApproval taskDetailBizApproval = new TaskDetailBizApproval();
        for (UiBotLayout layout : pageModel.getLayout()) {
            String layoutType = layout.getType();
            switch (layoutType) {
                case TitleBody.COMPONENT_TYPE:
                    taskDetailBizApproval.put(layout.getSchema(),
                            ModuleUtils.buildTitle(pcUiBotModel, pcUiBotModel.getPageData(),
                                    (DigiwinAtmcBacklogDetail) args[0], apiRequest, true, true));
                    break;
                case PageDesc.COMPONENT_TYPE:
                    taskDetailBizApproval.put(layout.getSchema(),
                            this.pageDescBuilderFactory.get(TaskStringUtil.TASK_TYPE_BIZ_APPROVAL)
                                    .build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, args));
                    break;
                case CardOne.COMPONENT_TYPE:
                    taskDetailBizApproval.put(layout.getSchema(),
                            this.cardOneBizApprovalBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                                    CardOne.class, args));
                    break;
                case "TABS":
                    BizApprovalTabList tabs = this.bizApprovalTabBuilder.buildAllTabs(apiRequest, pcUiBotModel);
                    tabs.forEach(tab -> {
                        tab.setMScrollMode(CustomTabScrollModeEnum.NO_SCROLL.getMode());
                    });
                    taskDetailBizApproval.put(layout.getSchema(), tabs);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    break;
                default:
                    // 什么都不做
                    break;
            }
        }
        return taskDetailBizApproval;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        PageSetting newPageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_MY_BIZ_SMART_ADJUST_TASK_DETAIL.name());
        TaskDetail taskDetail = this.build(apiRequest, newPageSetting, pcUiBotModel, args);
        UiBotModel uiBotModel = uiBotModelBuildService.buildModel(newPageSetting, taskDetail, true);
        uiBotModel.setBeforeAction(this.buildBeforeAction(apiRequest.getLocale()));
        return uiBotModel;
    }

    private Action<Map<String, Object>> buildBeforeAction(String locale) {
        Action<Map<String, Object>> action = new Action<>();
        action.setType(ActionTypeEnum.POP_PROMPT.getValue());
        PopPromptMsg popPromptMsg = new PopPromptMsg();
        popPromptMsg.setTitle(localeService.getLanguageValue(locale, "提示"));
        popPromptMsg.setContent(localeService.getLanguageValue(locale, "此作业未配置移动端界面，暂不支持提交操作\n请前往Web端查阅处理"));
        Button<Map<String, Object>> button = new Button<>();
        button.setName(localeService.getLanguageValue(locale, "确定"));
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        button.setAction(new Action<>(ActionTypeEnum.BACK.getValue()));
        popPromptMsg.setButtonList(Collections.singletonList(button));
        action.setPopPromptMsg(popPromptMsg);
        return action;
    }
}
