package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizApprovalBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotPageDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableScriptFilter;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailItemDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>功能描述：构建任务详情中，明细条目的详情画面的策略。本策略更通用</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildDetailItemDetailStrategy
 * @Author: Zaregoto
 * @Date: 2021/6/14 18:41
 */
@Component("taskDetailBuildDetailItemDetailStrategy")
public class TaskDetailBuildDetailItemDetailStrategy implements TaskDetailBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(
            TaskDetailBuildDetailItemDetailStrategy.class);

    @Autowired
    private BottomButtonBizApprovalBuilder bottomButtonBizApprovalBuilder;

    @Autowired
    private RuleService ruleService;

    @Autowired
    private ColumnTagService columnTagService;

    // FIXME 判断的位置要调整，不然当pageSetting中的底部按钮layout不是放在底部时，判断会不正确
    private Boolean hasEditableColumn = false;

    @Override
    public String getTaskDetailType() {
        return PageSettingIdPresetEnum.MOBILE_ATHENA_DETAIL_ITEM_DETAIL.toString();
    }

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        TaskDetailItemDetail taskDetailItemDetail = new TaskDetailItemDetail();
        /**
         * 根据pageSetting中设置的layout设置最终结果中动态组件的部分。固定的部分则傅pageSetting中已经固定的部分
         * 动态的部分使用${COMPONENT_TYPE}来表示layout.type，用${componentSchema}来表示layout.schema
         * 最终结果中使用实际字段的名称作为key，组件对象作为value
         */
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        int dynamicComponentPlaceholderIndex = 0;
        for (int i = 0; i < pageSettingModel.getLayout().size(); i++) {
            UiBotLayout pageSettingLayout = pageSettingModel.getLayout().get(i);
            if ("${COMPONENT_TYPE}".equalsIgnoreCase(pageSettingLayout.getType())) {
                // 动态的部分
                dynamicComponentPlaceholderIndex = i;
                this.processDynamicComponents(apiRequest, pcUiBotModel, pageSettingLayout,
                        taskDetailItemDetail, args);
            } else {
                // 固定的部分
                this.processFixedComponents(apiRequest, pageSetting, pcUiBotModel, pageSettingLayout,
                        taskDetailItemDetail, args);
            }
        }
        pageSettingModel.getLayout().addAll(dynamicComponentPlaceholderIndex,
                taskDetailItemDetail.getActualLayoutList());

        // 去除占位符的那个layout
        pageSettingModel.getLayout().remove(
                dynamicComponentPlaceholderIndex + taskDetailItemDetail.getActualLayoutList().size());

        return taskDetailItemDetail;
    }

    // FIXME 有大段逻辑和TaskDetailBuildBizReportStrategy中相同方法签名的方法相同，需要提取以复用
    private void processDynamicComponents(ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                          UiBotLayout pageSettingModel, TaskDetailItemDetail taskDetailItemDetail,
                                          Object... args) {
        String locale = apiRequest.getLocale();

        // 找到实际明细数据的layout
        UiBotTargetLayoutSearchResult layoutSearchResult = pcUiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return;
        }
        UiBotLayout pcDataLayout = layoutSearchResult.getTargetUiBotLayout();
        if (pcDataLayout.isTypeOfTable()) {
            this.processDynamicComponentsWithPcTable(apiRequest, pcUiBotModel, taskDetailItemDetail, locale, pcDataLayout, args);
        } else if (pcDataLayout.isTypeOfFormList()) {
            this.processDynamicComponentsWithPcFormList(apiRequest, pcUiBotModel, taskDetailItemDetail, locale, pcDataLayout, args);
        } else {
            return;
        }
    }

    private void processDynamicComponentsWithPcTable(ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                                     TaskDetailItemDetail taskDetailItemDetail, String locale, UiBotLayout pcDataLayout,
                                                     Object... args) {
        String schema = pcDataLayout.getSchema();
        // 因为是TABLE类型的layout，所以数据一定是数组
        List<Map<String, Object>> bizDataList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizDataList, "pagedata." + schema + " cannot be null");

        List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return;
        }
        List<UiBotTableScriptFilter> scriptFilterList = pcDataLayout.getScriptFilters();

        // 分解出明细数据一行的字段列表
        List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions(tableColumnDefinitionList);

        // FIXME 获取移动端的规则库。后续需要和PC端UIBot负责人商量更合适的做法
        List<Rule> mobileRuleList = this.ruleService.findByRulePath(schema);

        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(schema);

        // 设置传入的布尔值，给后面建按钮时使用
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);

        for (Map<String, Object> bizData : bizDataList) {
            String dataKey = PcUiBotPageDataUtil.getBizDataKey(pcUiBotModel, schema, bizData);
            // 只筛选出对应的业务数据，然后结束
            if (dataKey.equalsIgnoreCase(apiRequest.getExtraParameter().getDataKey())) {
                taskDetailItemDetail.addMobileComponentsByColumnAndBizData(locale, tableColumns, pcUiBotModel, bizData,
                        (DigiwinAtmcBacklogDetail) args[0], mobileRuleList, columnTagList, apiRequest);
                break;
            }
        }
    }

    private void processDynamicComponentsWithPcFormList(ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                                        TaskDetailItemDetail taskDetailItemDetail, String locale, UiBotLayout pcDataLayout,
                                                        Object... args) {
        String schema = pcDataLayout.getSchema();
        // 因为是FORM_LIST类型的layout，所以数据一定是对象
        Map<String, Object> bizData = (Map<String, Object>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizData, "pagedata." + schema + " cannot be null");

        List<UiBotLayout> pcFieldLayoutList = pcDataLayout.decomposeFieldsWithPcFormList(null);
        List<UiBotTableColumn> tableColumns = pcFieldLayoutList.stream()
                .map(UiBotLayout::parseToTableColumn)
                .collect(Collectors.toList());


        // FIXME 获取移动端的规则库。后续需要和PC端UIBot负责人商量更合适的做法
        List<Rule> mobileRuleList = this.ruleService.findByRulePath(schema);

        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(schema);

        // 设置传入的布尔值，给后面建按钮时使用
        this.hasEditableColumn = tableColumns.stream().anyMatch(UiBotTableColumn::canEdit);

        String dataKey = PcUiBotPageDataUtil.getBizDataKey(pcUiBotModel, schema, bizData);
        // 只筛选出对应的业务数据，然后结束
        if (dataKey.equalsIgnoreCase(apiRequest.getExtraParameter().getDataKey())) {
            taskDetailItemDetail.addMobileComponentsByColumnAndBizData(locale, tableColumns, pcUiBotModel, bizData,
                    (DigiwinAtmcBacklogDetail) args[0], mobileRuleList, columnTagList, apiRequest);
        }
    }

    /**
     * 处理画面中已固定内容的组件
     *
     * @param apiRequest
     * @param pageSetting
     * @param pcUiBotModel
     * @param layout
     * @param taskDetailItemDetail
     * @param args
     */
    private void processFixedComponents(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                        UiBotLayout layout, TaskDetailItemDetail taskDetailItemDetail, Object... args) {
        String locale = apiRequest.getLocale();
        if (layout.getType().equalsIgnoreCase(this.bottomButtonBizApprovalBuilder.getMobileComponentType())) {
            BottomButtonList bottomButtonList = new BottomButtonList();
            bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
            if (this.hasEditableColumn) {
                bottomButtonList.add(BottomButtonDigiwinAthena.createStressDoneButton(locale));
            }
            taskDetailItemDetail.put(layout.getSchema(), bottomButtonList);
        } else {

        }
    }
}
