package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;

/**
 * <p>功能描述：任务详情界面构造策略接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildStrategy
 * @Author: Zaregoto
 * @Date: 2021/5/20 16:12
 */
public interface TaskDetailBuildStrategy {

    String getTaskDetailType();

    /**
     * 原移动任务卡统一接口，返回TaskDetail
     *
     * @param apiRequest
     * @param pageSetting
     * @param pcUiBotModel
     * @param args
     * @return
     */
    @Deprecated
    TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args);

    /**
     * 新移动任务卡统一接口，返回uibotModel
     *
     * @param apiRequest
     * @param pageSetting
     * @param pcUiBotModel
     * @param args
     * @return
     */
    UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args);
}
