package com.digiwin.mobile.mobileuibot.task.strategy;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildStrategyFactory
 * @Author: Zaregoto
 * @Date: 2021/5/20 16:14
 */
@Component("taskDetailBuildStrategyFactory")
public class TaskDetailBuildStrategyFactory implements InitializingBean, ApplicationContextAware {

    private static final Map<String, TaskDetailBuildStrategy> TASKDETAIL_BUILD_MAP = new HashMap<>();

    private ApplicationContext appContext;

    public TaskDetailBuildStrategy get(String key) {
        return TASKDETAIL_BUILD_MAP.get(key);
    }

    @Override public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 TaskDetailBuildStrategy 注册到 TASKDETAIL_BUILD_MAP
        this.appContext.getBeansOfType(TaskDetailBuildStrategy.class).values().forEach(
            strategy -> TASKDETAIL_BUILD_MAP.put(strategy.getTaskDetailType(), strategy));
    }

    @Override public void setApplicationContext(ApplicationContext applicationContext)
        throws BeansException {
        this.appContext = applicationContext;
    }
}
