package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：异常回报的明细详情页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildApcAbnormalReportDetailStrategy
 * @Author: Liux
 * @Date: 2022年7月19日10点34分
 */
@Component("taskDetailBuildApcAbnormalReportDetailStrategy")
public class TaskDetailBuildApcAbnormalReportDetailStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildApcAbnormalReportDetailStrategy.class);

    @Autowired
    private RuleService ruleService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();
        UiBotModel pcUiBotModel = JsonUtil.objectToJavaObject(rawData.get("pcUiBotModel"), UiBotModel.class);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(locale);
        }
        List<Map<String, Object>> woOpReportAbnormalList = (List<Map<String, Object>>) rawData.get("wo_op_report_abnormal");
        UiBotExecuteContext executeContext = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("executeContext"), UiBotExecuteContext.class);
        if (null == executeContext) {
            //防呆
            executeContext = pcUiBotModel.getExecuteContext();
        }
        Map<String, Object> businessUnit = (Map<String, Object>) apiRequest.getRawData().get("businessUnit");
        if (businessUnit.isEmpty()) {
            //防呆
            businessUnit = (Map<String, Object>) executeContext.get("businessUnit");
        }
        List<Rule> ruleList = ruleService.findByRulePathAndPageId("wo_op_report_data", apiRequest.getPageId());
        List<UiBotLayout> pcButtonLayout = pcUiBotModel.getLayout();

        List<UiBotAction> pcButtonActions = pcUiBotModel.getLayout().stream().filter(layout -> "apc_project_schedule-task-detail-waitting".equals(layout.getType()))
                .findFirst()
                .map(UiBotLayout::getActions)
                .orElse(Collections.emptyList());
        // 拼成最终数据
        stopWatch.start("Build ApcAbnormalReport Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        List<UiBotRule> uiBotRuleList = pcUiBotModel.getRules();

        // 设计器「異常回報允許上傳附件」=tue,显示附件组件，否则隐藏
        Boolean abnormalReturns = digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), KnowledgeMapsConstant.APC_ABNORMAL_RETURNS);
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            Optional<UiBotRule> ruleOptional = uiBotRuleList.stream().filter(uiBotRule -> "wo_op_report_data".equalsIgnoreCase(uiBotRule.getPath())
                    && fieldSchema.equalsIgnoreCase(uiBotRule.getSchema())).findFirst();
            UiBotRule uiBotRule = ruleOptional.isPresent() ? ruleOptional.get() : null;
            switch (layout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect inputWindowSingleSelect = InputWindowSingleSelect.create(
                            layout,
                            AppContext.getBaseUrl() + "/mobile/v1/proxy/abnormalReport/abnormalReasonlist",
                            locale,
                            rawData, ruleList);
                    uiBotModel.getPageData().put(fieldSchema, inputWindowSingleSelect);
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    InputMultiText inputMultiText = new InputMultiText();
                    inputMultiText.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
                    inputMultiText.setRequired(false);
                    inputMultiText.setText("");
                    inputMultiText.setTitle(localeService.getLanguageValue(locale, "异常原因描述"));
                    uiBotModel.getPageData().put(fieldSchema, inputMultiText);
                    break;
                case Attachment.COMPONENT_TYPE:
                    UiBotLayout uiBotLayout = new UiBotLayout();
                    Boolean isFind = false;
                    for (UiBotLayout pcLayout : pcButtonLayout) {
                        if ("wo_op_report_data".equalsIgnoreCase(pcLayout.getId())) {
                            for (UiBotTableColumnDefinition definition : pcLayout.getColumnDefs()) {
                                if (isFind) {
                                    break;
                                }
                                for (UiBotTableColumn tableColumn : definition.getColumns()) {
                                    if (tableColumn.getSchema().equalsIgnoreCase(layout.getSchema())) {
                                        uiBotLayout = JsonUtil.objectToJavaObject(tableColumn, UiBotLayout.class);
                                        isFind = true;
                                        break;
                                    }
                                }
                            }
                            break;
                        }
                        if (isFind) {
                            break;
                        }
                    }
                    Attachment attachment = Attachment.create(uiBotLayout, uiBotRule);
                    // S4 APC 进度回报任务-异常回报-异常原因附件档案-附件大小限制20M，个数限制10M，不区分文档、图片还是视频、音频
                    attachment.setMaxSize(1024 * 1024 * 20L);
                    attachment.setLimit(10);
                    attachment.setHidden(!(ObjectUtils.isNotEmpty(abnormalReturns) && BooleanUtils.isTrue(abnormalReturns)));
                    uiBotModel.getPageData().put(fieldSchema, attachment);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                    //取消按钮
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
                    //异常提交
                    Map<String, Object> abnormalReportRawData = new HashMap<>();
                    abnormalReportRawData.put("iamUserToken", apiRequest.getIamUserToken());
                    abnormalReportRawData.put("locale", apiRequest.getLocale());
                    abnormalReportRawData.put("clientId", apiRequest.getClientId());

                    UiBotAction pcUiBotAction = new UiBotAction();
                    Map<String, Object> extendFields = new HashMap<>();
                    if (pcButtonActions.size() > 0) {
                        //进度回报的异常提交定制
                        pcUiBotAction = pcButtonActions.stream().filter(
                                        item -> item.getType().equalsIgnoreCase("apc_ProgressToAbnormal"))
                                .findFirst().orElse(null);
                        Map<String, Object> submitWoOpReportData = new HashMap<>();
                        submitWoOpReportData.put("wo_op_report_data", woOpReportAbnormalList);
                        abnormalReportRawData.put("data", submitWoOpReportData);

                        Map<String, Object> woOpReportDataParameter = new HashMap<>();
                        woOpReportDataParameter.put("process_category", "2");
                        for (Map<String, Object> map : woOpReportAbnormalList) {
                            map.put("process_category", "2");
                        }
                        woOpReportDataParameter.put("wo_op_report_data", woOpReportAbnormalList);
                        extendFields.put("parameter", woOpReportDataParameter);
                        extendFields.put("actionId", "wo.op.report.progress.info.process");

                    } else {
                        //工时回报的异常提交定制
                        pcButtonActions = pcButtonLayout.stream().filter(
                                        item -> item.getSchema() != null && item.getSchema().equalsIgnoreCase("customData"))
                                .findFirst().orElse(new UiBotLayout()).getActions();
                        pcUiBotAction = pcButtonActions.stream().filter(
                                        item -> item.getId().equalsIgnoreCase("submit-abnormal"))
                                .findFirst().orElse(null);
                        Map<String, Object> submitWoOpReportAbnormal = new HashMap<>();
                        submitWoOpReportAbnormal.put("wo_op_report_abnormal", woOpReportAbnormalList);
                        abnormalReportRawData.put("data", submitWoOpReportAbnormal);

                        Map<String, Object> abnormalReportParameter = new HashMap<>();
                        abnormalReportParameter.put("wo_op_report_abnormal", woOpReportAbnormalList);
                        extendFields.put("parameter", abnormalReportParameter);
                        extendFields.put("actionId", "bm.wrsc.wo.op.report.abnormal.create");
                    }
                    extendFields.put("businessUnit", businessUnit);
                    extendFields.put("executeContext", executeContext);
                    abnormalReportRawData.put("action", pcUiBotAction);

                    abnormalReportRawData.put("extendFields", extendFields);
                    BottomButtonDigiwinAthena abnormalReportSubmitButton = BottomButtonDigiwinAthena.
                            createAbnormalReportSubmitButton(locale, abnormalReportRawData);
                    ModuleUtils.addRefreshPageId(abnormalReportSubmitButton, apiRequest.getRefreshPageId());
                    bottomButtonList.add(abnormalReportSubmitButton);
                    uiBotModel.getPageData().put(fieldSchema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/mobile_athena_apc_abnormal_report_detail.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
