package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：进度回报的明细详情页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildApcProjectScheduleReportDetailStrategy
 * @Author: Liux
 * @Date: 2022年6月29日 11点55分
 */
@Deprecated
@Component("taskDetailBuildApcProjectScheduleReportDetailStrategy")
public class TaskDetailBuildApcProjectScheduleReportDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildApcProjectScheduleReportDetailStrategy.class);

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        Integer total = (Integer) apiRequest.getRawData().get("total");
        SingleSelectList singleSelectList = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("singleSelectList"), SingleSelectList.class);
        UiBotModel pcUiBotModel = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("pcUiBotModel"), UiBotModel.class);
        List<Map<String, Object>> woOpReportDataList = (List<Map<String, Object>>) apiRequest.getRawData().get("wo_op_report_data");

        List<UiBotAction> pcButtonActions = pcUiBotModel.getActions();
        // 拼成最终数据
        stopWatch.start("Build ApcWorkingHourReportDetail Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case SingleSelectList.COMPONENT_TYPE:
                    uiBotModel.getPageData().put(fieldSchema, singleSelectList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
                    Map<String, Object> processReportRawData = new HashMap<>();
                    processReportRawData.put("iamUserToken", apiRequest.getIamUserToken());
                    processReportRawData.put("locale", apiRequest.getLocale());
                    processReportRawData.put("clientId", apiRequest.getClientId());

                    Map<String, Object> submitWoOpReportData = new HashMap<>();
                    submitWoOpReportData.put("wo_op_report_data", woOpReportDataList);
                    processReportRawData.put("data", submitWoOpReportData);
                    UiBotAction pcUiBotAction = pcButtonActions.stream().filter(
                            item -> item.getType().equalsIgnoreCase("apc_ProgressToSubmit"))
                            .findFirst().orElse(null);
                    processReportRawData.put("action", pcUiBotAction);

                    Map<String, Object> extendFields = new HashMap<>();
                    Map<String, Object> processReportParameter = new HashMap<>();
                    Map<String, String> processCategory = new HashMap<>();
                    processCategory.put("process_category", "1");
                    for (Map<String, Object> woOpReportData : woOpReportDataList) {
                        woOpReportData.putAll(processCategory);
                    }
                    processReportParameter.putAll(processCategory);
                    processReportParameter.put("wo_op_report_data", woOpReportDataList);
                    extendFields.put("parameter", processReportParameter);
                    extendFields.put("actionId", "wo.op.report.progress.info.process");
                    processReportRawData.put("extendFields", extendFields);
                    processReportRawData.put("total", total);
                    BottomButtonDigiwinAthena submitButton = BottomButtonDigiwinAthena.createProcessReportSubmitButton(locale, processReportRawData);
                    ModuleUtils.addRefreshPageId(submitButton, apiRequest.getRefreshPageId());
                    bottomButtonList.add(submitButton);
                    uiBotModel.getPageData().put(fieldSchema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }

        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/mobile_athena_apc_project_schedule_report_detail.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
