package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCard;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabsComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.BaseTitleBodyBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildBizReportStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_LIST;

/**
 * <p>功能描述：进度回报的条目详情列表页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildApcProjectScheduleReportListStrategy
 * @Author: Liux
 * @Date: 2022年6月29日 11点55分
 */
@Slf4j
@Component("taskDetailBuildApcProjectScheduleReportListStrategy")
public class TaskDetailBuildApcProjectScheduleReportListStrategy implements TaskDetailBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private TaskDetailBuildBizReportStrategy taskDetailBuildBizReportStrategy;

    @Autowired
    private BaseTitleBodyBuilder baseTitleBodyBuilder;

    @Autowired
    private TabsComponentBuilder tabsComponentBuilder;

    @Autowired
    private BottomButtonBizReportBuilder bottomButtonBizReportBuilder;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_TYPE_PROJECT_SCHEDULE_REPORT;
    }

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);

        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData uiBotPageData = pageSetting.getPageModel().getPageData();
        //进度回报新增两个参数标准工时和实际工时
        if (MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_LIST.toString().equals(apiRequest.getPageId())) {
            Map<String, Object> reuqestData = new HashMap<>(1);
            Object businessObject = pcUiBotModel.getExecuteContext().get("businessUnit");
            if (businessObject instanceof Map) {
                reuqestData.put("enterprise_no", ((LinkedHashMap) businessObject).get("eoc_company_id"));
                reuqestData.put("eoc_site_id", ((LinkedHashMap) businessObject).get("eoc_site_id"));
            }
            Object woOpReportDatas = pcUiBotModel.getPageData().get("wo_op_report_data");
            if (woOpReportDatas instanceof List) {
                HashMap processCategory = new HashMap();
                //进度回报默认是1
                processCategory.put("process_category", "1");
                for (Map<String, Object> woOpReport : (ArrayList<Map<String, Object>>) woOpReportDatas) {
                    woOpReport.putAll(processCategory);
                }
                reuqestData.put("wo_op_report_data", woOpReportDatas);
            }
            Map<String, Object> woOpReportWorkHoursHistoryInfoGet = digiwinEspProxyService.getWoOpReportWorkHoursHistoryInfoGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), reuqestData);
            Object woOpReportData = woOpReportWorkHoursHistoryInfoGet.get("wo_op_report_data");
            if (woOpReportData instanceof ArrayList) {
                for (Map woOpReport : (ArrayList<Map>) woOpReportData) {
                    for (Map<String, Object> woOpReportdata : (ArrayList<Map<String, Object>>) woOpReportDatas) {
                        if (woOpReportdata.get("op_seq").equals(woOpReport.get("op_seq"))) {
                            woOpReportdata.put("standard_work_hours", woOpReport.get("standard_work_hours"));
                            woOpReportdata.put("total_work_hours", woOpReport.get("total_work_hours"));
                        }
                    }
                }
            }
        }
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                //标题生成
                case TitleBody.COMPONENT_TYPE:
                    taskDetailBizReport.put(layout.getSchema(),
                            this.baseTitleBodyBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(uiBotPageData.get(layout.getSchema()), Card.class);
                    Card.handle(apiRequest, pcUiBotModel, card);
                    taskDetailBizReport.put(layout.getSchema(), card);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    taskDetailBizReport.put(layout.getSchema(),
                            JsonUtil.objectToJavaObject(uiBotPageData.get(layout.getSchema()), BlankArea.class));
                    break;
                case CustomTabs.COMPONENT_TYPE:
                    CustomTabs customTabs =
                            JsonUtil.objectToJavaObject(uiBotPageData.get(layout.getSchema()), CustomTabs.class);

                    //根据pageId获取相应默认数据
                    Map<String, Object> defaultDataMap = TaskDataExtractUtil.getDefaultData(pageSetting.getPageId());
                    String rightTitleField = String.valueOf(defaultDataMap.get("rightTitleField"));
                    String[] contentFields = (String[]) defaultDataMap.get("contentFields");
                    final int contentFieldsLimit = Integer.parseInt(defaultDataMap.get("contentFieldsLimit").toString());
                    Map<String, String> valueToTextMap = (Map<String, String>) defaultDataMap.get("valueToTextMap");
                    String bizDataSchema = StringUtils.isNotBlank(pcUiBotModel.searchBizDataSchema()) ? pcUiBotModel.searchBizDataSchema() : "wo_op_report_data";
                    List<Map<String, Object>> bizDataList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(bizDataSchema);
                    //根据与装配进度PO志基沟通，目前这个进度值都是写死的。
                    int maxNum = 100;
                    int[] progressPercentageArr = new int[maxNum + 1];
                    for (int i = 0; i <= maxNum; i++) {
                        progressPercentageArr[i] = i;
                    }
                    boolean isTeamTask = apiRequest.getRawData().getBooleanValue("isTeamTask");
                    List<Card> cardList = bizDataList.stream().map(item ->
                            TabItemCard.createApcScheduleReportCard(apiRequest, pcUiBotModel, item, !isTeamTask, rightTitleField,
                                    contentFields, contentFieldsLimit,
                                    valueToTextMap, progressPercentageArr, localeService, bizDataList.size())
                    ).collect(Collectors.toList());
                    ZtbViewList ztbViewList = new ZtbViewList();
                    ztbViewList.setData(cardList);
                    CustomTabContentContainer<ZtbViewList> container =
                            new CustomTabContentContainer<>();
                    container.setData(ztbViewList);
                    container.setContentCmptType(ZtbViewList.COMPONENT_TYPE);

                    customTabs.forEach(item -> {
                        item.setName(localeService.getLanguageValue(apiRequest.getLocale(), item.getName()));
                        item.setContent(Collections.singletonList(container));
                    });
                    taskDetailBizReport.put(layout.getSchema(), customTabs);
                default:
                    break;
            }
        }
        return taskDetailBizReport;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }
}
