package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleConditionOperatorTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRuleText;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 已废弃，不使用
 * <p>功能描述：进度回报的明细详情MKP页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildApcProjectScheduleReportMkpDetailStrategy
 * @Author: Liux
 * @Date: 2022年6月29日 11点55分
 */
@Deprecated
@Component("taskDetailBuildApcProjectScheduleReportMkpDetailStrategy")
public class TaskDetailBuildApcProjectScheduleReportMkpDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildApcProjectScheduleReportMkpDetailStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboardMkp");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Integer total = (Integer) apiRequest.getRawData().get("total");
        ApiRawData rawData = apiRequest.getRawData();
        JSONObject mainDataInfo = rawData.getJSONObject("mainDataInfo");
        UiBotModel pcUiBotModel = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("pcUiBotModel"), UiBotModel.class);
        List<Map<String, Object>> woOpReportDataList = (List<Map<String, Object>>) apiRequest.getRawData().get("wo_op_report_data");
        List<UiBotAction> pcButtonActions = pcUiBotModel.getActions();
        // 拼成最终数据
        stopWatch.start("Build ApcWorkingHourReportDetailMkp Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case SingleSelectList.COMPONENT_TYPE:
                    //进度
                    SingleSelectList selectList = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("singleSelectList"), SingleSelectList.class);
                    RelationRule relationRule = new RelationRule();
                    List<RelationRuleText> textRuleList = new ArrayList<>(1);
                    RelationRuleText relationRuleText = new RelationRuleText();
                    relationRuleText.setCondition(RuleCategoryEnum.RELATION.getCategory());
                    relationRuleText.setCondition("100");
                    relationRuleText.setConditionOperatorType(RuleConditionOperatorTypeEnum.EQUALS.getType());
                    relationRuleText.setTargetSchema("op_name");
                    relationRuleText.setTargetHidden(false);
                    relationRuleText.setTargetRequired(true);
                    RelationRuleText ruleText = new RelationRuleText();
                    ruleText.setCondition(RuleCategoryEnum.RELATION.getCategory());
                    ruleText.setCondition("100");
                    ruleText.setConditionOperatorType(RuleConditionOperatorTypeEnum.NOT_EQUALS.getType());
                    ruleText.setTargetSchema("op_name");
                    ruleText.setTargetHidden(true);
                    ruleText.setTargetRequired(false);
                    textRuleList.add(relationRuleText);
                    textRuleList.add(ruleText);
                    relationRule.setTextRuleList(textRuleList);
                    selectList.setRelationRule(relationRule);
                    selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
                    selectList.setRequired(true);
                    uiBotModel.getPageData().put(fieldSchema, selectList);
                    break;
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    //后制程
                    InputWindowSingleSelect singleSelectList =
                            InputWindowSingleSelect.create(layout, true, true,
                                    AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + layout.getSchema(),
                                    locale, uiBotModel.getExecuteContext());
                    singleSelectList.setTitle(layout.getLabel());
                    Map<String, Object> data = singleSelectList.getRawData();
                    if (CollectionUtils.isEmpty(data)) {
                        data = new HashMap<>(2);
                    }
                    data.put("isProgressReturnMkp", true);
                    data.put("pageId", apiRequest.getPageId());
                    data.put("paramList", getOpNameMaps(apiRequest));
                    int progressPercentage = Double.valueOf(String.valueOf(mainDataInfo.get("progress_percentage"))).intValue();
                    singleSelectList.setHidden(100 != progressPercentage);
                    singleSelectList.setRequired(100 == progressPercentage);
                    singleSelectList.setRawData(data);

                    //若後製程只有一個, 直接默認勾選, 不用再彈窗讓用戶選.
                    List<Map<String, Object>> opNextInfoList = digiwinEspProxyService.getOpNextInfo(
                            apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), getOpNameMaps(apiRequest));
                    defaultSingleSelect(singleSelectList, opNextInfoList);

                    uiBotModel.getPageData().put(fieldSchema, singleSelectList);
                    break;
                case Field.COMPONENT_TYPE:
                    //待出站量
                    int valueInt = Double.valueOf(String.valueOf(mainDataInfo.get("remaining_qty"))).intValue();
                    Field field = Field.create(layout.getLabel(), String.valueOf(valueInt));
                    field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_GREY.getValue());
                    uiBotModel.getPageData().put(fieldSchema, field);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
                    Map<String, Object> processReportRawData = new HashMap<>();
                    processReportRawData.put("iamUserToken", apiRequest.getIamUserToken());
                    processReportRawData.put("locale", apiRequest.getLocale());
                    processReportRawData.put("clientId", apiRequest.getClientId());

                    Map<String, Object> submitWoOpReportData = new HashMap<>();
                    submitWoOpReportData.put("wo_op_report_data", woOpReportDataList);
                    processReportRawData.put("data", submitWoOpReportData);
                    UiBotAction pcUiBotAction = pcButtonActions.stream().filter(
                                    item -> item.getType().equalsIgnoreCase("apc_ProgressToSubmit"))
                            .findFirst().orElse(null);
                    processReportRawData.put("action", pcUiBotAction);

                    Map<String, Object> extendFields = new HashMap<>();
                    Map<String, Object> processReportParameter = new HashMap<>();
                    Map<String, String> processCategory = new HashMap<>();
                    processCategory.put("process_category", "1");
                    for (Map<String, Object> woOpReportData : woOpReportDataList) {
                        woOpReportData.putAll(processCategory);
                    }
                    processReportParameter.putAll(processCategory);
                    processReportParameter.put("wo_op_report_data", woOpReportDataList);
                    extendFields.put("parameter", processReportParameter);
                    extendFields.put("actionId", "wo.op.report.progress.info.process");
                    processReportRawData.put("extendFields", extendFields);
                    processReportRawData.put("total", total);
                    processReportRawData.put("pageId", apiRequest.getPageId());
                    BottomButtonDigiwinAthena submitButton = BottomButtonDigiwinAthena.createProcessReportSubmitButton(locale, processReportRawData);
                    ModuleUtils.addRefreshPageId(submitButton, apiRequest.getRefreshPageId());
                    bottomButtonList.add(submitButton);
                    uiBotModel.getPageData().put(fieldSchema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }

        stopWatch.stop();
        return uiBotModel;
    }

    /**
     * 一条数据，默认勾选，不需要用户弹窗选择
     *
     * @param singleSelectList
     * @param opNextInfoList
     * @author yanfeng
     */
    public static void defaultSingleSelect(InputWindowSingleSelect singleSelectList, List<Map<String, Object>> opNextInfoList) {
        if (CollUtil.isNotEmpty(opNextInfoList) && opNextInfoList.size() == 1) {
            for (Map<String, Object> map : opNextInfoList) {
                String opNo = map.get("op_no").toString();
                String name = map.get("op_name").toString();
                singleSelectList.setDefaultSelectId(opNo);
                singleSelectList.setDefaultShowValue(name);
            }
        }
    }

    /**
     * 组装后制程弹窗接口请求参数
     *
     * @param apiRequest
     * @return
     */
    @NotNull
    public static List<Map<String, Object>> getOpNameMaps(ApiRequest apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        Map<String, Object> map = JsonUtil.objectToJavaObject(rawData.get("mainDataInfo"), Map.class);
        List<Map<String, Object>> mapList = new ArrayList<>();
        Map<String, Object> params = new HashMap<>(3);
        //云端营运公司编号
        params.put("eoc_company_id", String.valueOf(map.get("eoc_company_id")));
        //工单单号
        params.put("wo_no", String.valueOf(map.get("wo_no")));
        //plot_no
        params.put("plot_no", String.valueOf(map.get("plot_no")));
        //工序
        params.put("op_seq", String.valueOf(map.get("op_seq")));
        //移转数量
        params.put("op_no", String.valueOf(map.get("op_no")));
        //剩余数量
        params.put("plan_source", String.valueOf(map.get("plan_source")));
        mapList.add(params);
        return mapList;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            logger.error("Interrupted!",e);
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/mobile_athena_apc_project_schedule_report_detail.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
