package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.digiwin.mobile.mobileuibot.task.strategy.custom.TaskDetailBuildApcProjectScheduleReportMkpDetailStrategy.defaultSingleSelect;
import static com.digiwin.mobile.mobileuibot.task.strategy.custom.TaskDetailBuildApcProjectScheduleReportMkpDetailStrategy.getOpNameMaps;

/**
 * 已废弃，不使用
 * <p>功能描述：数量转移的明细详情Mkp页面生成策略</p>
 *
 * @FileName: TaskDetailBuildApcProjectScheduleTransferQuantityMkpDetailStrategy
 * @Author: yanfenga
 * @Date: 2023年6月6日
 */
@Deprecated
@Component("taskDetailBuildApcProjectScheduleTransferQuantityMkpDetailStrategy")
public class TaskDetailBuildApcProjectScheduleTransferQuantityMkpDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildApcProjectScheduleTransferQuantityMkpDetailStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("transferQuantityMkp");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        JSONObject jsonObject = rawData.getJSONObject("datas");
        // 拼成最终数据
        stopWatch.start("Build TransferQuantityMkp Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case Field.COMPONENT_TYPE:
                    //待出站量
                    int valueInt = Double.valueOf(String.valueOf(jsonObject.get("remaining_qty"))).intValue();
                    Field field = Field.create(layout.getLabel(), String.valueOf(valueInt));
                    field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_GREY.getValue());
                    uiBotModel.getPageData().put(fieldSchema, field);
                    break;
                case SingleSelectList.COMPONENT_TYPE:
                    List<Map<String, Object>> datas = digiwinEspProxyService.getTransferQuantityInfo(
                            apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), getMaps(apiRequest));
                    List<SingleSelectListOption> optionList = new ArrayList<>();
                    for (Map<String, Object> data : datas) {
                        //待出站数量字段：remaining_qty
                        int transferQty = Double.valueOf(String.valueOf(jsonObject.get("transfer_qty"))).intValue();
                        boolean selected = transferQty == Integer.parseInt(String.valueOf(data.get("transfer_qty")));
                        SingleSelectListOption singleSelectListOption = new SingleSelectListOption();
                        singleSelectListOption.setId(UUIDUtil.getUuid());
                        singleSelectListOption.setText(String.valueOf(data.get("transfer_qty")));
                        singleSelectListOption.setSelected(selected);
                        singleSelectListOption.setHasCheck(false);
                        optionList.add(singleSelectListOption);
                    }

                    SingleSelectList singleSelectList = new SingleSelectList();
                    singleSelectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
                    singleSelectList.setTitle(LocaleUtil.getMobileTextByKey(locale, "转移数量"));
                    singleSelectList.setOptionList(optionList);
                    uiBotModel.getPageData().put(fieldSchema, singleSelectList);
                    break;
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    //后制程
                    InputWindowSingleSelect windowSingleSelect =
                            InputWindowSingleSelect.create(layout, true, true,
                                    AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + layout.getSchema(),
                                    locale, uiBotModel.getExecuteContext());
                    windowSingleSelect.setTitle(layout.getLabel());

                    Map<String, Object> data = windowSingleSelect.getRawData();
                    if (CollectionUtils.isEmpty(data)) {
                        data = new HashMap<>(2);
                    }
                    data.put("isTransferQuantityMkp", true);
                    data.put("pageId", apiRequest.getPageId());
                    data.put("paramList", getOpNameMaps(apiRequest));
                    windowSingleSelect.setRawData(data);
                    windowSingleSelect.setRequired(true);
                    windowSingleSelect.setHidden(false);

                    //若後製程只有一個, 直接默認勾選, 不用再彈窗讓用戶選.
                    List<Map<String, Object>> opNextInfoList = digiwinEspProxyService.getOpNextInfo(
                            apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), getOpNameMaps(apiRequest));
                    defaultSingleSelect(windowSingleSelect, opNextInfoList);
                    uiBotModel.getPageData().put(fieldSchema, windowSingleSelect);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
                    rawData.put("pageId", apiRequest.getPageId());
                    bottomButtonList.add(BottomButtonDigiwinAthena.createTransferQuantitySubmitButton(locale, rawData));
                    uiBotModel.getPageData().put(fieldSchema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    /**
     * 组装数量转移弹窗接口请求参数
     *
     * @param apiRequest
     * @return
     */
    @NotNull
    private static List<Map<String, Object>> getMaps(ApiRequest apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        Map<String, Object> map = JsonUtil.objectToJavaObject(rawData.get("datas"), Map.class);
        List<Map<String, Object>> mapList = new ArrayList<>();
        Map<String, Object> params = new HashMap<>(3);
        params.put("wo_no", map.get("wo_no").toString());
        //工序
        params.put("op_seq", map.get("op_seq").toString());
        //移转数量
        params.put("transfer_qty", Double.parseDouble(map.get("transfer_qty").toString()));
        //剩余数量
        params.put("remaining_qty", Double.parseDouble(map.get("remaining_qty").toString()));
        mapList.add(params);
        return mapList;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            logger.error("Interrupted!",e);
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/mobile_athena_apc_project_schedule_report_detail.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
