package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：数量转移的明细详情Sft页面生成策略</p>
 *
 * @FileName: TaskDetailBuildApcProjectScheduleTransferQuantitySftDetailStrategy
 * @Author: yanfenga
 * @Date: 2023年5月29日
 */
@Component("taskDetailBuildApcProjectScheduleTransferQuantitySftDetailStrategy")
public class TaskDetailBuildApcProjectScheduleTransferQuantitySftDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildApcProjectScheduleTransferQuantitySftDetailStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("transferQuantity");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        List<Map<String, Object>> paramList = getMaps(apiRequest);
        ApiRawData rawData = apiRequest.getRawData();
        JSONObject jsonObject = rawData.getJSONObject("datas");
        int remainingQty = (int) Double.parseDouble(jsonObject.get("transfer_qty").toString());
        //调apc接口获取移转数量
        List<Map<String, Object>> qtyInfoList = digiwinEspProxyService.getTransferQuantityInfo(
                apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, paramList);
        // 拼成最终数据
        stopWatch.start("Build TransferQuantity Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case SingleSelectList.COMPONENT_TYPE:
                    if (CollUtil.isNotEmpty(qtyInfoList)) {
                        SingleSelectList singleSelectList = new SingleSelectList();
                        List<SingleSelectListOption> optionList = new ArrayList<>();
                        for (Map<String, Object> stringObjectMap : qtyInfoList) {
                            int transferQty = (int) Double.parseDouble(stringObjectMap.get("transfer_qty").toString());
                            boolean selected = transferQty == remainingQty;
                            int qty = Integer.parseInt(stringObjectMap.get("transfer_qty").toString());
                            optionList.add(SingleSelectListOption.transferQuantityCreate(qty, selected, false, 0, ""));
                        }
                        singleSelectList.setTitle(LocaleUtil.getMobileTextByKey(locale, "选择转移数量"));
                        singleSelectList.setType(1);
                        singleSelectList.setStyle(SingleSelectListTypeEnum.PROGRESS_REPORT.getValue());
                        singleSelectList.setOptionList(optionList);
                        uiBotModel.getPageData().put(fieldSchema, singleSelectList);
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
                    rawData.put("pageId", apiRequest.getPageId());
                    bottomButtonList.add(BottomButtonDigiwinAthena.createTransferQuantitySubmitButton(locale, rawData));
                    uiBotModel.getPageData().put(fieldSchema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    /**
     * 组装数量转移弹窗接口请求参数
     *
     * @param apiRequest
     * @return
     */
    @NotNull
    private static List<Map<String, Object>> getMaps(ApiRequest apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        Map<String, Object> map = JsonUtil.objectToJavaObject(rawData.get("datas"), Map.class);
        return Collections.singletonList(map);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            logger.error("Interrupted!",e);
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/mobile_athena_apc_project_schedule_report_detail.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
