package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabsComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.BaseTitleBodyBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * <p>功能描述：工时支援的列表页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildApcSupportHourReportListStrategy
 * @Author: wuyang
 * @Date: 2023年4月18日
 */
@Slf4j
@Component("taskDetailBuildApcSupportHourReportListStrategy")
public class TaskDetailBuildApcSupportHourReportListStrategy implements TaskDetailBuildStrategy {

    @Autowired
    private BaseTitleBodyBuilder baseTitleBodyBuilder;

    @Autowired
    private CustomTabsComponentBuilder tabsComponentBuilder;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_TYPE_SUPPORT_HOUR_REPORT;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);

        UiBotModel uiBotModel = pageSetting.getPageModel();

        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData uiBotPageData = pageSetting.getPageModel().getPageData();
        Boolean grayButton = true;
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                //标题生成
                case TitleBody.COMPONENT_TYPE:
                    taskDetailBizReport.put(layout.getSchema(),
                            this.baseTitleBodyBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(uiBotPageData.get(layout.getSchema()), Card.class);
                    Card.handle(apiRequest, pcUiBotModel, card);
                    taskDetailBizReport.put(layout.getSchema(), card);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    taskDetailBizReport.put(layout.getSchema(),
                            JsonUtil.objectToJavaObject(uiBotPageData.get(layout.getSchema()), BlankArea.class));
                    break;
                //tabs生成
                case CustomTabs.COMPONENT_TYPE:
                    CustomTabs tabItems = this.tabsComponentBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                            CustomTabs.class, args);
                    taskDetailBizReport.put(layout.getSchema(), tabItems);
                    grayButton = tabItems.getGrayButton();
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) uiBotModel.getPageData().get(layout.getSchema()), BottomButtonDigiwinAthena.class);
                    Optional<UiBotLayout> optional = pcUiBotModel.getLayout().stream().filter(pcLayout -> "apc_hour_support-task-detail-waitting".equals(pcLayout.getType())).findFirst();
                    List<UiBotAction> actions = Collections.emptyList();
                    if (optional.isPresent()) {
                        actions = optional.get().getActions();
                    }
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName((localeService.getLanguageValue(apiRequest.getLocale(), bottomButton.getName())));
                        if (grayButton) {
                            bottomButton.setEnable(false);
                        }
                        UiBotAction rawDataAction = null;
                        if (!CollectionUtils.isEmpty(actions)) {
                            Optional<UiBotAction> defaultOption = actions.stream().filter(action -> "submit-close-task".equals(action.getId())).findFirst();
                            if (defaultOption.isPresent()) {
                                rawDataAction = defaultOption.get();
                            }
                        }
                        Action action = bottomButton.getAction();
                        if (action == null) {
                            action = new Action();
                        }
                        Map<String, Object> rawData = new HashMap<>(3);
                        if (rawDataAction != null && rawDataAction.getSubmitType() != null) {
                            List<Map<String, Object>> woOpReportDataList = (List<Map<String, Object>>)
                                    MapUtil.getOrDefault(pcUiBotModel.getPageData(), rawDataAction.getSubmitType().getSchema(), Collections.emptyList());
                            if (!CollectionUtils.isEmpty(woOpReportDataList)) {
                                woOpReportDataList.forEach(e -> {
                                    e.put("isCloseTask", true);
                                });
                            }
                            rawData.put("data", woOpReportDataList);
                            rawDataAction.remove("checkCompleteAction");
                        }
                        rawData.put("action", rawDataAction);
                        rawData.put("isAPC", true);
                        rawData.put("pageId", apiRequest.getPageId());
                        action.setRawData(rawData);
                        bottomButton.setAction(action);
                    }
                    taskDetailBizReport.put(layout.getSchema(), JsonUtil.objectToJavaObject(buttons, BottomButtonList.class));
                    break;
                default:
                    break;
            }
        }
        return taskDetailBizReport;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }
}
