package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：工时回报的明细详情页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildApcWorkHourQuantityConfirmStrategy
 * @Author: xujin
 * @Date: 2023年5月15日 11点55分
 */
@Component("taskDetailBuildApcWorkHourQuantityConfirmStrategy")
public class TaskDetailBuildApcWorkHourQuantityConfirmStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildApcWorkHourQuantityConfirmStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        JSONArray woInfoJsonArray = apiRawData.getJSONObject("parameter").getJSONArray("wo_op_report_info");
        JSONObject woInfoJsonObject = woInfoJsonArray.getJSONObject(0);

        //调apc获取数量
        List<Map<String, Object>> qtyInfoList = digiwinEspProxyService.getWoOpReportQtyInfo(
                apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, buildApcRequest(woInfoJsonObject));

        // 拼成最终数据
        stopWatch.start("Build TaskDetailBuildApcWorkHourQuantityConfirmStrategy Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();

        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case SingleSelectList.COMPONENT_TYPE:
                    if (!CollectionUtils.isEmpty(qtyInfoList)) {
                        List<Integer> reportQtyList = qtyInfoList.stream().map(e -> (Integer) e.get("report_qty")).sorted(Collections.reverseOrder()).collect(Collectors.toList());
                        SingleSelectList singleSelectList = new SingleSelectList();
                        List<SingleSelectListOption> optionList = new ArrayList<>();
                        for (int i = 0; i < reportQtyList.size(); i++) {
                            boolean selected = (i == 0);
                            optionList.add(SingleSelectListOption.create(reportQtyList.get(i), selected, false, 0, StringUtils.EMPTY, StringUtils.EMPTY));
                        }

                        singleSelectList.setTitle(localeService.getLanguageValue(locale, "报工数量"));
                        singleSelectList.setStyle(1);
                        singleSelectList.setStyle(SingleSelectListTypeEnum.PROGRESS_REPORT.getValue());
                        singleSelectList.setOptionList(optionList);
                        uiBotModel.getPageData().put(fieldSchema, singleSelectList);
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
                    /* Map<String, Object> rawDataMap = JSONObject.toJavaObject(apiRawData, Map.class);

                   BottomButtonDigiwinAthena offlineButton = new BottomButtonDigiwinAthena();
                    offlineButton.setName(localeService.getLanguageValue(locale, "人员下线"));
                    rawDataMap.put("actionId", "wo.op.report.info.process");
                    rawDataMap.put("isProcess", apiRawData.getBoolean("isProcess"));

                    Action buttonAction = new Action();
                    buttonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
                    buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/workingHourReport/peopleOffline");
                    buttonAction.setRawData(rawDataMap);

                    offlineButton.setAction(buttonAction);
                    offlineButton.setType(BottomButtonStyleEnum.STRESS.getValue());

                    bottomButtonList.add(offlineButton);*/
                    uiBotModel.getPageData().put(fieldSchema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }

        stopWatch.stop();
        return uiBotModel;
    }

    private Map<String, Object> buildApcRequest(JSONObject woInfoJsonObject) {
        Map<String, Object> requestMap = new HashMap<>();
        JSONObject woReportData = new JSONObject();
        woReportData.put("eoc_company_id", woInfoJsonObject.getString("eoc_company_id"));
        woReportData.put("eoc_site_id", woInfoJsonObject.getString("eoc_site_id"));
        woReportData.put("wo_no", woInfoJsonObject.getString("wo_no"));
        woReportData.put("plot_no", woInfoJsonObject.getString("plot_no"));
        woReportData.put("op_seq", woInfoJsonObject.getString("op_seq"));
        woReportData.put("category", woInfoJsonObject.getString("category"));
        woReportData.put("plan_source", woInfoJsonObject.getString("plan_source"));
        woReportData.put("remaining_qty", woInfoJsonObject.getString("remaining_qty"));
        woReportData.put("report_qty", woInfoJsonObject.getDouble("report_qty"));

        JSONArray array = new JSONArray();
        array.add(woReportData);
        requestMap.put("wo_op_report_data", array);
        return requestMap;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            logger.error("Interrupted!",e);
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/mobile_athena_apc_project_schedule_report_detail.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
