package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCard;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardContent;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardTitle;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：工时回报的明细详情页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildApcWorkingHourReportDetailStrategy
 * @Author: Liux
 * @Date: 2022年6月29日 11点55分
 */
@Component("taskDetailBuildApcWorkingHourReportDetailStrategy")
public class TaskDetailBuildApcWorkingHourReportDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildApcWorkingHourReportDetailStrategy.class);

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        //不用mongodb配置的，走自定义生成
//        uiBotModel.getLayout().clear();
//        uiBotModel.getPageData().clear();
        String dataId = apiRequest.getDataId();
        // 如果是团队任务，则任务需只读，不能可给用户操作的按钮
        boolean isTeamTask = apiRequest.getRawData().getBooleanValue("isTeamTask");
        boolean hasButton = !isTeamTask;

        // 待处理组件和数据绑定的逻辑
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        JSONObject mainDataInfo = apiRequest.getRawData().getJSONObject("taskInfo");
        UiBotModel pcUiBotModel = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("pcUiBotModel"), UiBotModel.class);
        /*UiBotLayout pcUiBotLayout = pcUiBotModel.getLayout().stream().filter(
                        item -> item.getSchema().equalsIgnoreCase("customData"))
                .findFirst().orElse(null);*/
        UiBotLayout pcUiBotLayout = new UiBotLayout();
        for (UiBotLayout item : pcUiBotModel.getLayout()) {
            String pcUiBotLayoutType = item.getType() == null ? "" : item.getType();
            String pcUiBotLayoutSchema = item.getSchema() == null ? "" : item.getSchema();
            if ((pcUiBotLayoutType.equalsIgnoreCase("apc_working_hour-task-detail-waitting") && pcUiBotLayoutSchema.equalsIgnoreCase("customData"))
                    || (pcUiBotLayoutType.equalsIgnoreCase("apc_hour_support-task-detail-waitting") && pcUiBotLayoutSchema.equalsIgnoreCase("customData"))) {
                pcUiBotLayout = item;
            }
        }
        List<UiBotAction> pcButtonActions = pcUiBotLayout.getActions();

        List<Map<String, Object>> detailDataList = (List<Map<String, Object>>) apiRequest.getRawData().get("wo_op_report_data");

        //根据pageId获取相应默认数据
        Map<String, Object> defaultDataMap = TaskDataExtractUtil.getDefaultData(pageSetting.getPageId());
        String[] leftTitleFields = (String[]) defaultDataMap.get("leftTitleFields");
        String rightTitleField = String.valueOf(defaultDataMap.get("rightTitleField"));
        String[] contentFields = (String[]) defaultDataMap.get("contentFields");
        Map<String, String> valueToTextMap = (Map<String, String>) defaultDataMap.get("valueToTextMap");

        UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
        Map<String, Object> businessUnit = (Map<String, Object>) executeContext.get("businessUnit");
        Map<String, Object> commonRawDataMap = new HashMap<>();
        commonRawDataMap.put("businessUnit", businessUnit);
        commonRawDataMap.put("executeContext", executeContext);

        // 异常回报允许上传附件
        Map<String, Object> variableListSimpleMap = digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), Arrays.asList("abnormalAllowsUploadingAttachments"));
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {

                case Field.COMPONENT_TYPE:
                    Boolean hasLabel = true;
                    if ("op_name".equalsIgnoreCase(fieldSchema)) {
                        hasLabel = false;
                    }
                    String value = String.valueOf(mainDataInfo.getOrDefault(fieldSchema, ""));
                    if (value.trim().isEmpty()) {
                        // 只读的话，空值，移动不显示，故不处理
                        continue;
                    }
                    value = valueToTextMap.getOrDefault(fieldSchema + "_" + value, value);
                    String labelStr = valueToTextMap.getOrDefault(fieldSchema, fieldSchema);
                    Field itemContentField = Field.create(LocaleUtil.getMobileTextByKey(locale, labelStr),
                            "LABEL", value, FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue(), hasLabel);
                    uiBotModel.getPageData().put(fieldSchema, itemContentField);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    uiBotModel.getPageData().put(layout.getSchema(),
                            JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), BlankArea.class));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
                    //异常回报按钮生成
//                    Action buttonAction = new Action();
//                    buttonAction = Action.createAbnormalReportAction(locale, mainDataInfo, pcUiBotModel, businessUnit,
//                            executeContext, commonRawDataMap, dataId);
                    //迭代22去掉工时回报异常按钮
//                    bottomButtonList.add(BottomButtonDigiwinAthena.createAbnormalReportButton(locale, buttonAction));
                    uiBotModel.getPageData().put(fieldSchema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }

        //不管有没有子进程都设置一个空组件给前端，前端当把子进程都操作完后则显示空组件内容。
        if (CollectionUtils.isEmpty(detailDataList)) {
            String emptySchema = "empty";
            UiBotLayout emptyLayout = new UiBotLayout();
            emptyLayout.setSchema(emptySchema);
            emptyLayout.setType(Empty.COMPONENT_TYPE);
            uiBotModel.getLayout().add(emptyLayout);
            String emptyMsg = "暂无数据";
            uiBotModel.getPageData().put(emptySchema, Empty.create(LocaleUtil.getMobileTextByKey(locale, emptyMsg), true));
        } else {
            for (Map<String, Object> detailData : detailDataList) {
                String op_no = String.valueOf(detailData.get("op_no")).isEmpty() ? "" : "_" + String.valueOf(detailData.get("op_no"));
                String op_seq = String.valueOf(detailData.get("op_seq")).isEmpty() ? "" : "_" + String.valueOf(detailData.get("op_seq"));
                String sub_op_no = String.valueOf(detailData.get("sub_op_no")).isEmpty() ? "" : "_" + String.valueOf(detailData.get("sub_op_no"));
                String sub_op_seq = String.valueOf(detailData.get("sub_op_seq")).isEmpty() ? "" : "_" + String.valueOf(detailData.get("sub_op_seq"));
                String tabsItemSchema = "tabsItem" + op_no + op_seq + sub_op_no + sub_op_seq;

                String tabsItemType = TabItemCard.COMPONENT_TYPE;
                UiBotLayout tabsItemLayout = new UiBotLayout();
                tabsItemLayout.setSchema(tabsItemSchema);
                tabsItemLayout.setType(tabsItemType);
                uiBotModel.getLayout().add(tabsItemLayout);

                // 是否上线
                boolean isCheckIn = (Boolean) detailData.get("is_check_in");
                TabItemCard tabItemCard = new TabItemCard();
                List<String> leftTitle = new ArrayList<>();
                List<String> rightTitle = new ArrayList<>();
                // 标题字段
                for (String leftTitleField : leftTitleFields) {
                    String value = String.valueOf(detailData.getOrDefault(leftTitleField, ""));
                    if (value.trim().isEmpty()) {
                        // 只读的话，空值，移动不显示，故不处理
                        continue;
                    }
                    value = valueToTextMap.getOrDefault(leftTitleField + "_" + value, value);
                    leftTitle.add(LocaleUtil.getMobileTextByKey(locale, value));
                }
                if (detailData.containsKey(rightTitleField)) {
                    String value = String.valueOf(detailData.getOrDefault(rightTitleField, ""));
                    if (!value.trim().isEmpty()) {
                        value = valueToTextMap.getOrDefault(rightTitleField + "_" + value, value);
                        rightTitle.add(LocaleUtil.getMobileTextByKey(locale, value));
                    }
                }
                tabItemCard.setTitle(TabItemCardTitle.create(leftTitle, rightTitle.isEmpty() ? "" : rightTitle.get(0)));
                List<BottomButtonDigiwinAthena> tabItemButtonList = new ArrayList<>();
                if (isCheckIn) {
                    //上线需要增加一些字段显示
                    for (String contentField : contentFields) {
                        String value = String.valueOf(detailData.getOrDefault(contentField, ""));
                        if (value.trim().isEmpty()) {
                            // 只读的话，空值，移动不显示，故不处理
                            continue;
                        }
                        value = valueToTextMap.getOrDefault(contentField + "_" + value, value);
                        String labelStr = valueToTextMap.getOrDefault(contentField, contentField);

                        TabItemCardContent itemContentField = TabItemCardContent.create(LocaleUtil.getMobileTextByKey(locale, labelStr), 2, 1, value);
                        tabItemCard.getContent().add(itemContentField);
                    }
                    if (hasButton) {
                        // 取消上线按钮
                        Map<String, Object> cancelOnlineRawData = new HashMap<>();
                        Map<String, Object> cancelOnlineParameter = new HashMap<>();
                        List<Map<String, Object>> woOpReportWorkHoursList = new ArrayList<>();
                        Map<String, Object> woOpReportWorkHours = new HashMap<>();
                        woOpReportWorkHours.putAll(detailData);
                        woOpReportWorkHours.putAll(businessUnit);
                        woOpReportWorkHoursList.add(woOpReportWorkHours);
//                    cancelOnlineParameter.put("wo_op_report_work_hours", woOpReportWorkHoursList);
                        //此处修改是为了按照新的接口来
                        cancelOnlineParameter.put("wo_op_report_data", woOpReportWorkHoursList);
                        cancelOnlineRawData.put("parameter", cancelOnlineParameter);
                        cancelOnlineRawData.putAll(commonRawDataMap);

                        BottomButtonDigiwinAthena cancelOnlineButton = BottomButtonDigiwinAthena.createCancelOnlineButton(locale, cancelOnlineRawData);
                        ModuleUtils.addRefreshPageId(cancelOnlineButton, apiRequest.getRefreshPageId());
                        tabItemButtonList.add(cancelOnlineButton);

                        // 人员下线按钮
                        Map<String, Object> offlineRawData = new HashMap<>();
                        Map<String, Object> offlineParameter = new HashMap<>();
                        List<Map<String, Object>> woOpReportInfoList = new ArrayList<>();
                        Map<String, Object> woOpReportInfo = new HashMap<>();
                        List<Map<String, Object>> woOpReportWorkHoursDetailList = new ArrayList<>();
                        Map<String, Object> woOpReportWorkHoursDetail = new HashMap<>();
                        woOpReportWorkHoursDetail.putAll(detailData);
                        woOpReportWorkHoursDetail.putAll(businessUnit);
                        woOpReportWorkHoursDetailList.add(woOpReportWorkHoursDetail);
                        woOpReportInfo.putAll(woOpReportWorkHoursDetail);
                        woOpReportInfo.put("isEnter", false);
                        woOpReportInfo.put("isWorkHourOffline", true);
                        woOpReportInfo.put("isWorkHourToAbnormalTask", false);
                        //1.工单上线;2.人员下线回报;3.进度回报;4.人员上线回报;5.任务结束
                        woOpReportInfo.put("process_category", "2");
                        woOpReportInfo.put("wo_op_report_work_hours_detail", woOpReportWorkHoursDetailList);
                        woOpReportInfoList.add(woOpReportInfo);
                        offlineParameter.put("wo_op_report_info", woOpReportInfoList);
                        offlineRawData.put("parameter", offlineParameter);
                        offlineRawData.putAll(commonRawDataMap);

                        Map<String, Object> submitRequestMap = new HashMap<>();
                        Map<String, Object> submitRawData = new HashMap<>();
                        Map<String, Object> submitWoOpReportData = new HashMap<>();
                        submitWoOpReportData.put("wo_op_report_data", woOpReportInfoList);
                        submitRawData.put("data", submitWoOpReportData);
                        UiBotAction pcUiBotAction = pcButtonActions.stream().filter(
                                        item -> item.getId().equalsIgnoreCase("submit_workhour_offline"))
                                .findFirst().orElse(null);
                        submitRawData.put("action", pcUiBotAction);
                        submitRequestMap.put("iamUserToken", apiRequest.getIamUserToken());
                        submitRequestMap.put("locale", apiRequest.getLocale());
                        submitRequestMap.put("clientId", apiRequest.getClientId());
                        submitRequestMap.put("rawData", submitRawData);
                        offlineRawData.put("submitRequest", submitRequestMap);

                        // 下线按钮弹出数量确认弹框，确认后再下线
                        Action quantityConfirmAction = new Action();
                        quantityConfirmAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORKING_HOUR_QUANTITY_CONFIRM_LIST.toString());
                        quantityConfirmAction.setJumpPageTitle(localeService.getLanguageValue(locale, "报工数量确认"));
                        quantityConfirmAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                        quantityConfirmAction.setRefreshPageId(apiRequest.getPageId());
                        quantityConfirmAction.setDataId(dataId);
                        offlineRawData.put("isProcess", true);
                        quantityConfirmAction.setRawData(offlineRawData);
                        BottomButtonDigiwinAthena offlineButton = BottomButtonDigiwinAthena.createOffLineButton(locale, quantityConfirmAction, BottomButtonStyleEnum.DETAIL_NORMAL_GREEN_STROKE.getValue());
                        offlineButton.setShowDot(true);
                        offlineButton.setDotIconData(0);
                        tabItemButtonList.add(offlineButton);
                    }
                } else {
                    if (hasButton) {
                        Map<String, Object> woOpReportData = new HashMap<>();
                        woOpReportData.putAll(detailData);
                        woOpReportData.putAll(businessUnit);

                        // 附件历程和上传附件按钮,目前工时回报加，工时支援不用加
                        if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_DETAIL.name().equalsIgnoreCase(apiRequest.getPageId())) {
                            // 异常回报允许上传附件开关打开，才展示附件历程和上传附件两个按钮
                            BottomButtonDigiwinAthena attachmentButton = BottomButtonDigiwinAthena.buildAttachmentButtons(woOpReportData, variableListSimpleMap, locale);
                            if (Objects.nonNull(attachmentButton)) {
                                tabItemButtonList.add(attachmentButton);
                            }
                        }

                        Map<String, Object> onlineRawData = new HashMap<>();
                        Map<String, Object> onlineParameter = new HashMap<>();
                        List<Map<String, Object>> woOpReportDataList = new ArrayList<>();
                        woOpReportDataList.add(woOpReportData);
                        onlineParameter.put("wo_op_report_data", woOpReportDataList);
                        onlineRawData.put("parameter", onlineParameter);
                        onlineRawData.putAll(commonRawDataMap);

                        // 备注上线按钮
                        List<BottomButtonDigiwinAthena> remarkDetailBottomButtonList = new ArrayList<>();
                        remarkDetailBottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));

                        BottomButtonDigiwinAthena submitButton = new BottomButtonDigiwinAthena();
                        submitButton.setName(localeService.getLanguageValue(locale, "提交"));
                        submitButton.setType(BottomButtonStyleEnum.STRESS.getValue());

                        // 多条目时候前端根据parentSchema删除指定条目
                        submitButton.setParentSchema(tabsItemSchema);

                        Map<String, Object> submitButtonActionrawData = new HashMap<>();
                        submitButtonActionrawData.putAll(onlineRawData);
                        submitButtonActionrawData.put("actionId", "wo.op.report.check.in.info.process");
                        submitButtonActionrawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.toString());
                        submitButtonActionrawData.put("previousPageId", apiRequest.getRefreshPageId());

                        Action submitButtonAction = new Action();
                        submitButtonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
                        submitButtonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/workingHourReport/peopleOnline");
                        submitButtonAction.setRawData(submitButtonActionrawData);

                        submitButton.setAction(submitButtonAction);
                        remarkDetailBottomButtonList.add(submitButton);

                        Action remarkOnlineAction = new Action();
                        remarkOnlineAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.toString());
                        remarkOnlineAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

                        Map<String, Object> rawData = new HashMap<>();
                        rawData.put("data", mainDataInfo);
                        rawData.put("buttonList", remarkDetailBottomButtonList);
                        remarkOnlineAction.setRawData(rawData);

                        BottomButtonDigiwinAthena remarkOnlineButton = BottomButtonDigiwinAthena.createButton(localeService.getLanguageValue(locale, "备注上线"), BottomButtonStyleEnum.NORMAL.getValue(), remarkOnlineAction);
                        tabItemButtonList.add(remarkOnlineButton);

                        // 人员上线字段
                        String pageId;
                        if ("MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST".equalsIgnoreCase(apiRequest.getRefreshPageId())) {
                            pageId = apiRequest.getRefreshPageId();
                        } else {
                            pageId = apiRequest.getPageId();
                        }
                        BottomButtonDigiwinAthena onlineButton = BottomButtonDigiwinAthena.createOnlineButton(pageId, locale, onlineRawData, ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
                        ModuleUtils.addRefreshPageId(onlineButton, apiRequest.getRefreshPageId());
                        tabItemButtonList.add(onlineButton);
                    }
                }
                String subOpRemark = StringUtil.valueOf(detailData.get("sub_op_remark"));
                if (StringUtils.isNotBlank(subOpRemark)) {
                    // 子工艺备注
                    TabItemCardContent content = new TabItemCardContent();
                    content.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
                    content.setLabel(localeService.getLanguageValue("备注"));
                    content.setValue(subOpRemark);
                    content.setLabelStyleType(2);
                    content.setValueStyleType(1);
                    tabItemCard.getContent().add(content);
                }
                tabItemCard.setButtonLayout(UiBotModel.createSingleButton(tabItemButtonList));
                uiBotModel.getPageData().put(tabsItemSchema, tabItemCard);
            }
        }

        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/mobile_athena_apc_working_hour_report_detail.json");

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
