package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabsComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.BaseTitleBodyBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildBizReportStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>功能描述：工时回报的条目详情列表页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildApcWorkingHourReportListStrategy
 * @Author: Liux
 * @Date: 2022年6月29日 11点55分
 */
@Slf4j
@Component("taskDetailBuildApcWorkingHourReportListStrategy")
public class TaskDetailBuildApcWorkingHourReportListStrategy implements TaskDetailBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private TaskDetailBuildBizReportStrategy taskDetailBuildBizReportStrategy;

    @Autowired
    private BaseTitleBodyBuilder baseTitleBodyBuilder;

    @Autowired
    private CustomTabsComponentBuilder tabsComponentBuilder;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_TYPE_WORKING_HOUR_REPORT;
    }

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private DigiwinMdcProxyService digiwinMdcProxyService;

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);

        UiBotModel uiBotModel = pageSetting.getPageModel();

        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData uiBotPageData = pageSetting.getPageModel().getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                //标题生成
                case TitleBody.COMPONENT_TYPE:
                    taskDetailBizReport.put(layout.getSchema(),
                            this.baseTitleBodyBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(uiBotPageData.get(layout.getSchema()), Card.class);
                    Card.handle(apiRequest, pcUiBotModel, card);
                    taskDetailBizReport.put(layout.getSchema(), card);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    taskDetailBizReport.put(layout.getSchema(),
                            JsonUtil.objectToJavaObject(uiBotPageData.get(layout.getSchema()), BlankArea.class));
                    break;
                //tabs生成
                case CustomTabs.COMPONENT_TYPE:
                    taskDetailBizReport.put(layout.getSchema(),
                            this.tabsComponentBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                                    CustomTabs.class, args));
                    break;
                default:
                    break;
            }
        }
        return taskDetailBizReport;
    }
}
