package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgressList;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcReassignUser;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 * @desc APC-异常结案任务卡
 */
@Component("uiBotModelBuildApcAbnormalClosureStrategy")
public class UiBotModelBuildApcAbnormalClosureStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildApcAbnormalClosureStrategy.class);

    private static final String PROGRESS_LIST_SCHEMA = "wo_op_report_abnormal";

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc Abnormal Closeure Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.
                getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();

        //是否是团队任务，团队任务不可编辑和提交
        boolean isTeamTask = BooleanUtils.isTrue(apiRawData.getBoolean("isTeamTask"));

        if (StringUtils.hasLength(digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
        }
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(locale);
        }

        if (pcUiBotModel.getPageData().get("uiBot__APPROVAL_DESCRIPTION") == null) {
            return UiBotModel.emptyUibotModel(locale);
        }
        UiBotLayout uiBotLayout = UiBotModel.getCustomUibotLayout(pcUiBotModel.getLayout(), "apc_abnormal_closecase-task-detail-waitting");
        List<UiBotAction> actions = uiBotLayout.getActions();
        List<Map<String, Object>> datas = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("wo_op_report_abnormal");
        Map<String, Object> data = new HashMap<>(16);
        Map<String, Object> oneceData = new HashMap<>(16);
        if (!CollectionUtils.isEmpty(datas)) {
            data = datas.get(datas.size() - 1);
            oneceData = datas.get(0);
            EocPersonInfo onecePersonInfo = digiwinEocProxyService.getEocPersonInfo((String) oneceData.get("reporter_no"), iamUserToken, 2);
            oneceData.put("reporter_no", onecePersonInfo.getEocId());
            oneceData.put("reporter_name", onecePersonInfo.getName());
        }
        EocPersonInfo eocPersonInfo = digiwinEocProxyService.getEocPersonInfo(apiRequest.getUserId(), iamUserToken, 2);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.createApc(digiwinAtmcBacklogDetail, pcUiBotModel, locale);
                    pageData.put(schema, titleBody);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                    pageData.put(schema, CustomGroup.createDetail(localeService, apiRequest, data, customGroup));
                    break;
                case TaskProgressList.COMPONENT_TYPE:
                    //APC客制的处理历程
                    TaskProgressList progressList = JsonUtil.objectToJavaObject(pageData.get(schema), TaskProgressList.class);
                    String title = localeService.getLanguageValue(locale, progressList.getTitle());
                    progressList.setTitle(title);
                    List<TaskProgress> taskProgressList = progressList.getTaskProgressList();
                    List<Map<String, Object>> reportAbnormalList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(PROGRESS_LIST_SCHEMA);
                    if (CollectionUtils.isEmpty(reportAbnormalList)) {
                        layout.setType(CustomGroup.COMPONENT_TYPE);
                        pageData.put(schema, CustomGroup.createEmptyGroup(locale, title));
                    } else {
                        int i = 0;
                        for (Map<String, Object> reportAbnormal : reportAbnormalList) {
                            taskProgressList.add(TaskProgress.createApcProgress(i, reportAbnormal,
                                    locale, localeService, iamUserToken, digiwinEocProxyService));
                            i++;
                        }
                        pageData.put(schema, progressList);
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = null;

                    // 团队任务按钮不展示
                    if (BooleanUtils.isFalse(isTeamTask)) {
                        bottomButtonList = JsonUtil.objectToJavaObject(
                                pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                                BottomButtonList.class);
                        Map<String, Object> rawData = buildData(oneceData, eocPersonInfo);
                        rawData.put("process_person_no", apiRequest.getUserId());
                        String dataKey = (String) data.get("__DATA_KEY");
//                    String abnormalReasonNo = (String) oneceData.get("abnormal_reason_no");
//                    String abnormalReasonName = (String) oneceData.get("abnormal_reason_name");
//                    String abnormalReasonDescription = (String) oneceData.get("abnormal_reason_description");

                        Map<String, Object> finalOneceData = oneceData;
                        bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                            Map<String, Object> buttonRawData = new HashMap<>(6);
                            String buttonName = bottomButtonDigiwinAthena.getName();
                            if (StringUtils.hasLength(buttonName)) {
                                bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                            }
                            Action action = bottomButtonDigiwinAthena.getAction();
                            String jumpPageTitle = action.getJumpPageTitle();
                            if (StringUtils.hasLength(jumpPageTitle)) {
                                action.setJumpPageTitle(localeService.getLanguageValue(locale, jumpPageTitle));
                            }
                            if (bottomButtonDigiwinAthena.getType().intValue() == 2) {
                                buttonRawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_RETURN_BOTTOM.toString());
                                if (!CollectionUtils.isEmpty(actions)) {
                                    buttonRawData.put("action", actions.stream().filter(action1 -> action1.getDefaultAction()).findFirst().get());
                                    Map<String, Object> returnData = new HashMap<>(16);
                                    returnData.putAll(rawData);
                                    buttonRawData.put("oneData", finalOneceData);
//                                returnData.put("abnormal_reason_no", abnormalReasonNo);
//                                returnData.put("abnormal_reason_name", abnormalReasonName);
//                                returnData.put("abnormal_reason_description", abnormalReasonDescription);
                                    buttonRawData.put("data", returnData);
                                } else {
                                    buttonRawData.put("data", rawData);
                                }
                            } else {
                                buttonRawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_PROGRESS_BOTTOM.toString());
                                if (!CollectionUtils.isEmpty(actions)) {
                                    buttonRawData.put("action", actions.stream().filter(action1 -> !action1.getDefaultAction()).findFirst().get());
                                }
                                buttonRawData.put("data", rawData);
                            }
                            buttonRawData.put("dataKey", dataKey);
                            buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                            action.setRawData(buttonRawData);
                            ModuleUtils.addRefreshPageId(bottomButtonDigiwinAthena, "");
                        });
                    }
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private Map<String, Object> buildData(Map<String, Object> data, EocPersonInfo eocPersonInfo) {
        Map<String, Object> returnData = new HashMap<>(13);
        returnData.put("eoc_company_id", data.get("eoc_company_id"));
        returnData.put("eoc_site_id", data.get("eoc_site_id"));
        returnData.put("op_no", data.get("op_no"));
        returnData.put("wo_op_abnormal_report_id", data.get("wo_op_abnormal_report_id"));
        returnData.put("wo_no", data.get("wo_no"));
        returnData.put("plot_no", data.get("plot_no"));
        returnData.put("op_seq", data.get("op_seq"));
        returnData.put("op_name", data.get("op_name"));
        returnData.put("abnormal_doc_no", data.get("abnormal_doc_no"));
        returnData.put("reporter_no", eocPersonInfo.getEocId());
        returnData.put("reporter_name", eocPersonInfo.getName());
        return returnData;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
