package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 * @desc APC-异常回报任务卡
 */
@Component("uiBotModelBuildApcAbnormalReportListStrategy")
public class UiBotModelBuildApcAbnormalReportListStrategy implements TaskDetailBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildApcAbnormalReportListStrategy.class);

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_TYPE_ABNORMAL_REPORT;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        StopWatch stopWatch = new StopWatch("Build Apc abnormal report list");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.
                getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();

        //是否是团队任务，团队任务不可编辑和提交
        boolean isTeamTask = BooleanUtils.isTrue(apiRawData.getBoolean("isTeamTask"));
        if (StringUtils.hasLength(digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
        }
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(locale);
        }
        String path = "wo_op_report_data";
//        UiBotLayout uiBotLayout = UiBotModel.getContentQueryButtonLayout(pcUiBotModel.getLayout());
//        Map<String, Object> bodyMap = JsonUtil.objectToJavaObject(uiBotLayout.getQueryButtons().get(1), Map.class);
//        bodyMap.put("executeContext", pcUiBotModel.getExecuteContext());
//        UiBotModel completeUibotModle = digiwinPcUiBotProxyService.actionShow(locale, iamUserToken, JsonUtil.javaObjectToJsonString(bodyMap));

        // 异常回报数据有且只有一条
        // 非团队任务下 已完成Action无值，待处理Action有值，已完成内容在task/show接口里
        // 团队任务 已完成在show接口，待处理在task/show接口
//        if (!isTeamTask) {
//            if (CollectionUtils.isEmpty(pcUiBotModel.getActions())) {
//                completeUibotModle = pcUiBotModel;
//            }
//        }
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.createApc(digiwinAtmcBacklogDetail, pcUiBotModel, locale);
                    pageData.put(schema, titleBody);
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), Card.class);
                    Card.handle(apiRequest, pcUiBotModel, card);
                    pageData.put(layout.getSchema(), card);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    BlankArea area = JsonUtil.objectToJavaObject(pageData.get(schema), BlankArea.class);
                    pageData.put(schema, area);
                    break;
                case CustomTabs.COMPONENT_TYPE:
                    CustomTabs customTabs = JsonUtil.objectToJavaObject(pageData.get(schema), CustomTabs.class);
                    pageData.put(layout.getSchema(), customTabs.detailMessage(customTabs, pcUiBotModel, null,
                            path, locale, localeService, isTeamTask));
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        return null;
    }

}
