package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：转派异常回报的底部详情页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildApcApprovalReassignBottomStrategy
 * @Author: 吴阳
 * @Date: 20230419
 */
@Component("uiBotModelBuildApcApprovalReassignBottomStrategy")
public class UiBotModelBuildApcApprovalReassignBottomStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildApcApprovalReassignBottomStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc ApporovalReassign Bottom");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();
        // 拼成最终数据
        stopWatch.start("Build ApcAbnormalReport Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();

        // 设计器「異常回報允許上傳附件」=tue,显示附件组件，否则隐藏
        Boolean abnormalReturns = digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), KnowledgeMapsConstant.APC_ABNORMAL_RETURNS);

        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect inputWindowSingleSelect = InputWindowSingleSelect.create(
                            layout,
                            AppContext.getBaseUrl() + "/mobile/v1/proxy/abnormalReport/abnormalReasonlist",
                            locale,
                            rawData, localeService);
                    uiBotModel.getPageData().put(fieldSchema, inputWindowSingleSelect);
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    InputMultiText inputMultiText = new InputMultiText();
                    inputMultiText.setPlaceholder(localeService.getLanguageValue(locale, "请输入..."));
                    inputMultiText.setRequired(false);
                    inputMultiText.setText("");
                    inputMultiText.setTitle(localeService.getLanguageValue(locale, layout.getLabel()));
                    uiBotModel.getPageData().put(fieldSchema, inputMultiText);
                    break;
                case Attachment.COMPONENT_TYPE:
                    uiBotModel.getPageData().put(fieldSchema, Attachment.create(
                            localeService.getLanguageValue(locale, layout.getLabel()),
                            AttachmentStyleTypeEnum.TITLE_NORMAL.getValue(),
                            SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_TWO.getValue(),
                            AttachmentTypeEnum.READ_AND_WRITE.getValue(), abnormalReturns));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) uiBotModel.getPageData().get(fieldSchema), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                        if (bottomButton.getIsCheckButton()) {
                            Action action = bottomButton.getAction();
                            action.setRawData(rawData);
                            ModuleUtils.addRefreshPageId(bottomButton, apiRequest.getRefreshPageId());
                        }
                    }
                    uiBotModel.getPageData().put(fieldSchema, buttons);
                    break;
                default:
                    break;
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
