package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelOnlineManage;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;

/**
 * 功能: APC 进度回报异常的待处理异常清单展示
 *
 * @author: 吴阳
 * @date: created at 2023/03/30
 */
@Component("uiBotModelBuildApcProjectScheduleReportWaitDealListStrategy")
public class UiBotModelBuildApcProjectScheduleReportWaitDealListStrategy
        implements UiBotModelBuildStrategy {

    @Autowired
    private PersonnelOnlineManage personnelOnlineManage;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        Map<String, Object> rawData = apiRequest.getRawData();
        List<Map<String, Object>> reportData = digiwinEspProxyService.getWoOpReportWaitProcessAbnormalInfo(
                iamUserToken, tenantId, locale, rawData);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> newLayouts = new ArrayList<>();
        UiBotLayout buttonLayout = uiBotModel.getLayout().get(0);
        int i = 0;
        if (CollectionUtils.isEmpty(reportData) || CollectionUtils.isEmpty(Collections.singleton(reportData.get(0).get("wait_process_abnormal_detail")))) {
            return UiBotModel.emptyUibotModel(locale);
        }
        Map<String, Object> waitProcessAbnormalDetail = (Map<String, Object>) ((List) reportData.get(0).get("wait_process_abnormal_detail")).get(0);
        List<Map<String, Object>> abnormalDetails = (List<Map<String, Object>>) waitProcessAbnormalDetail.get("abnormal_detail");
        if (CollectionUtils.isEmpty(abnormalDetails)) {
            return UiBotModel.emptyUibotModel(locale);
        }

        for (Map<String, Object> abnormalDetail : abnormalDetails) {
            String schema = UUIDUtil.getUuid();
            String dividerSchema = UUIDUtil.getUuid();

            newLayouts.add(new UiBotLayout(schema, Field.COMPONENT_TYPE));
            newLayouts.add(new UiBotLayout("abnormal_reason_description" + dividerSchema, Field.COMPONENT_TYPE));
            newLayouts.add(new UiBotLayout("process_person_name" + dividerSchema, Field.COMPONENT_TYPE));
            newLayouts.add(new UiBotLayout("abnormal_reason_attachment" + dividerSchema, Attachment.COMPONENT_TYPE));
            if (i < abnormalDetails.size() - 1) {
                newLayouts.add(new UiBotLayout(dividerSchema, Divider.COMPONENT_TYPE));
            }

            if (CollectionUtils.isEmpty(abnormalDetail)) {
                pageData.put(schema, buildFieldPageData((String) abnormalDetail.get("abnormal_reason_name"),
                        "", FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue(),
                        FieldLabelStyleTypeEnum.LABEL_BLACK.getValue(),
                        FieldLabelStyleTypeEnum.LABEL_BLACK.getValue()));
                pageData.put("abnormal_reason_description" + dividerSchema, buildFieldPageData(
                        localeService.getLanguageValue(locale, "异常描述"),
                        "-",
                        FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue(),
                        FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                        FieldLabelStyleTypeEnum.LABEL_BLACK.getValue()));
                pageData.put("process_person_name" + dividerSchema, buildFieldPageData(
                        localeService.getLanguageValue(locale, "处理人"), "-",
                        FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue(),
                        FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                        FieldLabelStyleTypeEnum.LABEL_BLACK.getValue()));
            } else {
                pageData.put(schema, buildFieldPageData((String) abnormalDetail.get("abnormal_reason_name"),
                        (String) abnormalDetail.get("abnormal_doc_no"),
                        FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue(),
                        FieldLabelStyleTypeEnum.LABEL_BLACK.getValue(),
                        FieldLabelStyleTypeEnum.LABEL_BLACK.getValue()));
                pageData.put("abnormal_reason_description" + dividerSchema, buildFieldPageData(
                        localeService.getLanguageValue(locale, "异常描述"),
                        (String) abnormalDetail.get("abnormal_reason_description"),
                        FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue(),
                        FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                        FieldLabelStyleTypeEnum.LABEL_BLACK.getValue()));
                List<Map<String, Object>> personDetails = (List<Map<String, Object>>) abnormalDetail.get("process_person_detail");
                if (CollectionUtils.isEmpty(personDetails)) {
                    pageData.put("process_person_name" + dividerSchema, buildFieldPageData(
                            localeService.getLanguageValue(locale, "处理人"), "-",
                            FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue(),
                            FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                            FieldLabelStyleTypeEnum.LABEL_BLACK.getValue()));
                } else {
                    StringBuilder personName = new StringBuilder();
                    for (int j = 0; j < personDetails.size(); j++) {
                        personName.append(personDetails.get(j).get("process_person_name"));
                        if (j < personDetails.size() - 1) {
                            personName.append("、");
                        }
                    }
                    pageData.put("process_person_name" + dividerSchema, buildFieldPageData(
                            localeService.getLanguageValue(locale, "处理人"),
                            personName.toString(),
                            FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue(),
                            FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                            FieldLabelStyleTypeEnum.LABEL_BLACK.getValue()));
                }
                Map<String, Object> attachments = (Map<String, Object>) abnormalDetail.get("abnormal_reason_attachment");
                if (!CollectionUtils.isEmpty(attachments) && !CollectionUtils.isEmpty((Collection<?>) attachments.get("data"))) {
                    Attachment attachment = Attachment.createAbnormalReasonAttachment(attachments, localeService.getLanguageValue(locale, "异常附件"));
                    pageData.put("abnormal_reason_attachment" + dividerSchema, attachment);
                }
            }
            pageData.put(dividerSchema, new Divider(DividerTypeEnum.ELEMENT_DIVIDER.getValue()));
            i++;
        }
        newLayouts.add(buttonLayout);
        List<BottomButtonDigiwinAthena> buttonList = ModuleUtils.listMapToListObject((List<?>) pageData.get(buttonLayout.getSchema()), BottomButtonDigiwinAthena.class);
        buttonList.forEach(button -> {
            button.setName(localeService.getLanguageValue(locale, button.getName()));
        });
        pageData.put(buttonLayout.getSchema(), buttonList);
        uiBotModel.setLayout(newLayouts);
        return uiBotModel;
    }

    private Field buildFieldPageData(String label, String value, Integer alimentType,
                                     Integer labelType, Integer valueType) {
        return Field.createZtbField(label, labelType, valueType, value, alimentType);
    }


    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}
