package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 * @desc APC-请求支援底部弹出
 */
@Component("uiBotModelBuildApcSupportBottomStrategy")
public class UiBotModelBuildApcSupportBottomStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildApcSupportBottomStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc support bottom");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    rawData.put("isAPC", true);
                    rawData.put("type", layout.getSchema());
                    pageData.put(layout.getSchema(), InputWindowSingleSelect.create(
                            localeService.getLanguageValue(locale, layout.getLabel()), layout.getSchema(),
                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                            locale, rawData, "", "", new RelationRule(), Collections.emptyMap()));
                    break;
                case InputNumeric.COMPONENT_TYPE:
                    pageData.put(layout.getSchema(), InputNumeric.create(999, 0, "0",
                            localeService.getLanguageValue(locale, layout.getLabel()),
                            InputNumericTypeEnum.INTEGER.getValue()));
                    break;
                case InputCalendar.COMPONENT_TYPE:
                    pageData.put(layout.getSchema(), InputCalendar.create(
                            localeService.getLanguageValue(locale, layout.getLabel()),
                            InputCalendarTypeEnum.SELECT_DATE_RANGE.getValue(),
                            InputCalendarDate.createToday(),
                            InputCalendarDate.create("9999", "12", "31"),
                            true, false, true, localeService.getLanguageValue(locale, "请选择日期区间")));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    Map<String, Object> buttonRawData = new HashMap<>(6);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength(buttonName)) {
                            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        Action action = bottomButtonDigiwinAthena.getAction();
                        String jumpPageTitle = action.getJumpPageTitle();
                        if (StringUtils.hasLength(jumpPageTitle)) {
                            action.setJumpPageTitle(localeService.getLanguageValue(locale, jumpPageTitle));
                        }
                        buttonRawData.put("data", rawData.get("datas"));
                        buttonRawData.put("action", rawData.get("action"));
                        buttonRawData.put("pageId", apiRequest.getPageId());
                        action.setRawData(buttonRawData);
                        ModuleUtils.addRefreshPageId(bottomButtonDigiwinAthena, apiRequest.getRefreshPageId());
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
