package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcReassignUser;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 * @desc APC-请求支援的渲染页面
 */
@Component("uiBotModelBuildApcSupportNeedsStrategy")
public class UiBotModelBuildApcSupportNeedsStrategy implements TaskDetailBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildApcSupportNeedsStrategy.class);

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_TYPE_SUPPORT_NEEDS;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        StopWatch stopWatch = new StopWatch("Build Apc support needs");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.
                getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        if (StringUtils.hasLength(digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        }

        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
        }
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        List<Map<String, Object>> datas = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("wo_op_request_support_demand_info");

        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(locale);
        }

        if (datas == null) {
            return UiBotModel.emptyUibotModel(locale);
        }
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.createApc(digiwinAtmcBacklogDetail, pcUiBotModel, locale);
                    pageData.put(schema, titleBody);
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), Card.class);
                    Card.handle(apiRequest, pcUiBotModel, card);
                    pageData.put(layout.getSchema(), card);
                    break;
                case Field.COMPONENT_TYPE:
                    Field field = JsonUtil.objectToJavaObject(pageData.get(schema), Field.class);
                    field.setValue(localeService.getLanguageValue(locale, field.getValue()) + " " + datas.size());
                    pageData.put(layout.getSchema(), field);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup parentCustomGroup = new CustomGroup();
                    parentCustomGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING.getValue());
                    CustomGroupContent parentContent = new CustomGroupContent();
                    List<UiBotLayout> parentLayous = parentContent.getLayout();
                    UiBotPageData parentPageDte = parentContent.getPageData();
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                    parentCustomGroup.setName(localeService.getLanguageValue(locale, customGroup.getName()) + " " + datas.size());
                    List<UiBotLayout> newUiBotLayoutList = new ArrayList<>();
                    List<UiBotLayout> uiBotLayoutList = customGroup.getContent().getLayout();
                    for (Map<String, Object> data : datas) {
                        CustomGroup dataGroup = new CustomGroup();
                        dataGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_INPUT_FORM.getValue());
                        CustomGroupContent content = new CustomGroupContent();
                        String dataSchema = UUIDUtil.getUuid();
                        parentLayous.add(new UiBotLayout(dataSchema, CustomGroup.COMPONENT_TYPE));
                        content.setLayout(newUiBotLayoutList);
                        UiBotPageData dataPageData = new UiBotPageData();
                        for (UiBotLayout uiBotLayout : uiBotLayoutList) {
                            UiBotLayout newLayout = new UiBotLayout();
                            newLayout.setType(uiBotLayout.getType());
                            String layoutSchema = uiBotLayout.getSchema();
                            String newSchema = layoutSchema + "_mobile_" + dataSchema;
                            newLayout.setSchema(newSchema);
                            if (Field.COMPONENT_TYPE.equals(uiBotLayout.getType())) {
                                if (StringUtils.hasLength(uiBotLayout.getLabel())) {
                                    String value;
                                    if (data.get(layoutSchema) instanceof Double) {
                                        value = Double.toString((Double) data.get(layoutSchema));
                                    } else if (data.get(layoutSchema) instanceof String) {
                                        value = (String) data.get(layoutSchema);
                                    } else {
                                        value = String.valueOf(data.get(layoutSchema));
                                    }
                                    dataPageData.put(newSchema,
                                            Field.createLabelLeftValueRightFieldBy18PX(
                                                    uiBotLayout.getLabel(), value,
                                                    2, 1));
                                } else {
                                    dataPageData.put(newSchema, Field.createLabelValueLeftField(
                                            "", (String) data.get(layoutSchema), 1, 3, (String) data.get("op_no")));
                                }
                            } else if (InputWindowMultiSelect.COMPONENT_TYPE.equals(uiBotLayout.getType())) {
                                uiBotLayout.setLabel(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
                                Map<String, Object> rawData = new HashMap<>(3);
                                if ("supporter_info".equals(layoutSchema)) {
                                    rawData.put("isAPC", true);
                                    rawData.put("team_no", data.get("team_no"));
                                    rawData.put("team_name", data.get("team_name"));
                                    data.put("dataSchema", dataSchema);
                                    rawData.put("webData", data);
                                    dataPageData.put(newSchema, InputWindowMultiSelect.create(uiBotLayout,
                                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                            rawData, locale, 1, InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue(),
                                            false, false, localeService
                                    ));
                                } else {
                                    dataPageData.put(newSchema, InputWindowMultiSelect.create(uiBotLayout,
                                            new UiBotRule(),
                                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                            locale, pcUiBotModel.getExecuteContext()));
                                }

                            }
                            newUiBotLayoutList.add(newLayout);
                        }
                        content.setPageData(dataPageData);
                        dataGroup.setContent(content);
                        parentPageDte.put(dataSchema, dataGroup);
                    }
                    parentCustomGroup.setContent(parentContent);
                    pageData.put(schema, parentCustomGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    Map<String, Object> buttonRawData = new HashMap<>(6);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength(buttonName)) {
                            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        Action action = bottomButtonDigiwinAthena.getAction();
                        String jumpPageTitle = action.getJumpPageTitle();
                        if (StringUtils.hasLength(jumpPageTitle)) {
                            action.setJumpPageTitle(localeService.getLanguageValue(locale, jumpPageTitle));
                        }
                        ModuleUtils.addRefreshPageId(bottomButtonDigiwinAthena, "");
                        buttonRawData.put("data", datas);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        buttonRawData.put("action", pcUiBotModel.getLayout().stream()
                                .filter(action1 -> "apc_support_needs-task-detail-waitting".equalsIgnoreCase(action1.getType()))
                                .findFirst().map(UiBotLayout::getActions)
                                .map(e->e.get(0)).orElse(new UiBotAction()));
                        buttonRawData.put("pageId", apiRequest.getPageId());
                        action.setRawData(buttonRawData);
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        return null;
    }
}
