package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 功能: APC 班组派工异常的待处理异常清单展示
 *
 * @author: xujicn
 * @date: created at 2023/09/15
 */
@Component("uiBotModelBuildApcTeamDispatchAbnormalReportDetailStrategy")
public class UiBotModelBuildApcTeamDispatchAbnormalReportDetailStrategy
        implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        Map<String, Object> rawData = apiRequest.getRawData();

        boolean isGetDataByApi = (Boolean) MapUtil.getOrDefault(rawData, "isGetDataByApi", true);
        List<Map<String, Object>> reportData;
        if (isGetDataByApi) {
            reportData = digiwinEspProxyService.getWoOpReportWaitProcessAbnormalInfo(
                    iamUserToken, tenantId, locale, rawData);
        } else {
            reportData = (List<Map<String, Object>>) MapUtil.getOrDefault(rawData, "wo_op_report_abnormal", Collections.emptyList());
        }

        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();

        List<UiBotLayout> newLayouts = new ArrayList<>();
        if (CollectionUtils.isEmpty(reportData) || CollectionUtils.isEmpty(Collections.singleton(reportData.get(0).get("wait_process_abnormal_detail")))) {
            return UiBotModel.emptyUibotModel(locale);
        }

        // 设计器「異常回報允許上傳附件」=tue,显示附件组件，否则隐藏
        Boolean abnormalReturns = digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), KnowledgeMapsConstant.APC_ABNORMAL_RETURNS);

        List<Map<String, Object>> waitProcessAbnormalDetailList = (List<Map<String, Object>>) reportData.get(0).get("wait_process_abnormal_detail");
        if (CollectionUtils.isEmpty(waitProcessAbnormalDetailList)) {
            return UiBotModel.emptyUibotModel(locale);
        }
        for (Map<String, Object> waitProcessAbnormalDetail : waitProcessAbnormalDetailList) {
            List<Map<String, Object>> abnormalDetails = (List<Map<String, Object>>) waitProcessAbnormalDetail.get("abnormal_detail");
            if (CollectionUtils.isEmpty(abnormalDetails)) {
                continue;
            }
            for (Map<String, Object> abnormalDetail : abnormalDetails) {
                String schema = UUIDUtil.getUuid();
                newLayouts.add(new UiBotLayout(schema, Card.COMPONENT_TYPE));
                if (!CollectionUtils.isEmpty(abnormalDetail)) {
                    Card card = new Card();
                    card.setTitle((String) MapUtil.getOrDefault(abnormalDetail, "abnormal_reason_name", StringUtils.EMPTY));
                    List<CardContent> contentList = new LinkedList<>();
                    contentList.add(buildCardContent(localeService.getLanguageValue(locale, "异常单号"), abnormalDetail.get("abnormal_doc_no")));
                    contentList.add(buildCardContent(localeService.getLanguageValue(locale, "异常描述"), abnormalDetail.get("abnormal_reason_description")));

                    String processPersonNameListStr = StringUtils.EMPTY;
                    List<Map<String, Object>> personDetails = (List<Map<String, Object>>) abnormalDetail.get("process_person_detail");
                    if (!CollectionUtils.isEmpty(personDetails)) {
                        List<String> processPersonNameList = personDetails.stream().map(e -> (String) e.get("process_person_name")).collect(Collectors.toList());
                        processPersonNameListStr = StringUtils.join(processPersonNameList, "、");
                    }
                    contentList.add(buildCardContent(localeService.getLanguageValue(locale, "处理人"), processPersonNameListStr));

                    if (BooleanUtils.isTrue(abnormalReturns)) {
                        CardContent attachmentCardContent = new CardContent();
                        Map<String, Object> attachments = (Map<String, Object>) abnormalDetail.get("abnormal_reason_attachment");
                        if (!CollectionUtils.isEmpty(attachments) && !CollectionUtils.isEmpty((Collection<?>) attachments.get("data"))) {
                            Attachment attachment = Attachment.createAbnormalReasonAttachment(attachments, localeService.getLanguageValue(locale, "异常附件"));
                            attachmentCardContent.setFile(attachment);
                        } else {
                            attachmentCardContent = buildCardContent(localeService.getLanguageValue(locale, "异常附件"), "-");
                        }
                        contentList.add(attachmentCardContent);
                    }
                    card.setContent(contentList);
                    pageData.put(schema, card);
                }
            }
        }

        newLayouts.add(new UiBotLayout("bottomButtons", BottomButtonDigiwinAthena.COMPONENT_TYPE));
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton(locale);
        pageData.put("bottomButtons", Collections.singletonList(cancelButton));
        uiBotModel.setLayout(newLayouts);
        return uiBotModel;
    }

    private CardContent buildCardContent(String name, Object value) {
        return new CardContent(name, Objects.isNull(value) ? "-" : String.valueOf(value), false, 1);
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}
