package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldValueStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButtonLabelStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.model.ApcDisassemblemergeEnum;
import com.digiwin.mobile.mobileuibot.task.model.ApcWorkTypeEnum;
import com.digiwin.mobile.mobileuibot.task.model.TaskChangeFlagEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * <p>功能描述：班组派工的去处理详情页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildApcTeamDispatchDetailStrategy
 * @Author: 吴阳
 * @Date: 20230509
 */
@Component("uiBotModelBuildApcTeamDispatchDetailStrategy")
public class UiBotModelBuildApcTeamDispatchDetailStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildApcTeamDispatchDetailStrategy.class);
    List<String> apcLabelList =
            new ArrayList<>(Arrays.asList(
                    "is_main_op", "plan_qty", "disassemble_merge",
                    "position_flag", "next_op_seq", "plan_status"));

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc Team Dispatch Detail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();

        //获取交付设计器参数
        Boolean adjustTeam = false;
        Map<String, Object> adjustTeamMap = digiwinKnowledgeMapsProxyService.getMechanismParamValue(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), KnowledgeMapsConstant.APC_ADJUST_TEAM);
        if (adjustTeamMap != null) {
            if (adjustTeamMap.get(KnowledgeMapsConstant.APC_ADJUST_TEAM) != null) {
                adjustTeam = (Boolean) adjustTeamMap.get(KnowledgeMapsConstant.APC_ADJUST_TEAM);
            }
        }

        Map<String, Object> data = (Map<String, Object>) rawData.get("data");
        String changeFlag = (String) MapUtil.getOrDefault(data, "change_flag", StringUtils.EMPTY);
        // 保存按钮不调接口，前端保存，如果重新编辑，需要将上一次编辑数据加载到
        if (TaskChangeFlagEnum.NEW.getType().equals(changeFlag)
                || TaskChangeFlagEnum.MODIFY.getType().equals(changeFlag)) {
            initDataHandle(apiRequest, true);
        } else {
            initDataHandle(apiRequest, false);
        }
        //保存后重新赋值
        data = (Map<String, Object>) rawData.get("data");

        // 拼成最终数据
        stopWatch.start("Build Team Dispatch Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        String dataId = MapUtils.getString(rawData, "dataId");
        Boolean canEdit = MapUtils.getBooleanValue(rawData, "canEdit", false);

        List<Map<String, Object>> dataList = (List<Map<String, Object>>) MapUtil.getOrDefault(rawData, "woOpDispatchData", Collections.emptyMap());

        // 获取主从制程对应关系
        List<Map<String, Object>> workingDayPlanDispatchInfoList = handleWorkingDayPlanDispatchInfoList(apiRequest);
        handleProcessRelationShip(apiRequest, dataList, data, workingDayPlanDispatchInfoList, false);

        boolean isSubProcess = MapUtils.getBooleanValue(data, "isSubProcess", false);

        String woPropertySchema = "wo_property";
        String woPropertyVal = MapUtils.getString(data, "new_" + woPropertySchema);
        woPropertyVal = StringUtils.isNotEmpty(woPropertyVal) ? woPropertyVal : MapUtils.getString(data, woPropertySchema);

        List<Map<String, Object>> params = new ArrayList<>(1);
        String eocCompanyId = (String) data.get("eoc_company_id");
        String eocSiteId = (String) data.get("eoc_site_id");
        Map<String, Object> maps = new HashMap<>(4);
        maps.put("plan_source", data.get("plan_source"));
        maps.put("area_no", "");
        maps.put("layout_no", "");
        maps.put("eoc_company_id", eocCompanyId);
        maps.put("eoc_site_id", eocSiteId);
        if (StringUtils.isEmpty(eocCompanyId) && StringUtils.isEmpty(eocSiteId) && data.get("businessUnit") != null) {
            maps.putAll((Map<? extends String, ?>) data.get("businessUnit"));
            eocCompanyId = (String) ((Map<? extends String, ?>) data.get("businessUnit")).get("eoc_company_id");
            eocSiteId = (String) ((Map<? extends String, ?>) data.get("businessUnit")).get("eoc_site_id");
        }

        // 变更标识为新或改，场域，区域才可编辑
        changeFlag = (String) MapUtil.getOrDefault(data, "change_flag", StringUtils.EMPTY);

        //获取机制能力code list
        List<Map<String, Object>> mapList = getMechanismCapabilityCode(apiRequest);
        //現場資源規劃機制code
        String onSiteResourcePlanningMechanism = null;
        if (CollUtil.isNotEmpty(mapList)) {
            for (Map<String, Object> stringObjectMap : mapList) {
                Object mechanismAbilityCode = stringObjectMap.get("mechanismAbilityCode");
                if (ObjectUtil.isNotEmpty(mechanismAbilityCode)) {
                    if (KnowledgeMapsConstant.APC_ON_SITE_RESOURCE_PLANNING_MECHANISM.equalsIgnoreCase(stringObjectMap.get("mechanismAbilityCode").toString()))
                        onSiteResourcePlanningMechanism = mechanismAbilityCode.toString();
                }
            }
        }
        params.add(maps);
        List<Map<String, Object>> areaWoOpDataList = digiwinEspProxyService.getLayoutAreaWoOpInfo(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), params);

        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    String newFieldSchema = fieldSchema;
                    String teamnNo = "team_no";
                    String teamName = "team_name";
                    String teamInfo = "team_info";
                    if (TaskChangeFlagEnum.NEW.getType().equals(changeFlag)
                            || TaskChangeFlagEnum.MODIFY.getType().equals(changeFlag)) {
                        newFieldSchema = "new_" + fieldSchema;
                        teamnNo = "new_team_no";
                        teamName = "new_team_name";
                        teamInfo = "new_teamInfo";
                    }
                    if (BooleanUtils.isFalse(adjustTeam) || BooleanUtils.isNotTrue(canEdit)) {
                        layout.setType(Field.COMPONENT_TYPE);
                        Field field = Field.createLabelLeftValueRightField(localeService.getLanguageValue(locale, layout.getLabel()),
                                (String) MapUtil.getOrDefault(data, newFieldSchema, StringUtils.EMPTY));
                        uiBotModel.getPageData().put(fieldSchema, field);
                    } else {
                        Map<String, Object> rawdata = new HashMap<>(4);
                        rawdata.put("type", fieldSchema);
                        rawdata.put("isAPC", true);

                        String workstationNo = (String) MapUtil.getOrDefault(data, "new_workstation_no", "");
                        if (StringUtils.isEmpty(workstationNo)) {
                            workstationNo = (String) MapUtil.getOrDefault(data, "workstation_no", "");
                        }
                        rawdata.put("workstation_no", workstationNo);
                        InputWindowSingleSelect inputWindowSingleSelect = InputWindowSingleSelect.create(
                                layout,
                                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                locale,
                                rawdata, localeService, (String) MapUtil.getOrDefault(data, newFieldSchema, StringUtils.EMPTY), false, true);
                        inputWindowSingleSelect.setDefaultSelectId(MapUtils.getString(data, teamnNo));
                        inputWindowSingleSelect.setDefaultShowValue(MapUtils.getString(data, teamName));
                        inputWindowSingleSelect.setDetail((Map<String, Object>) MapUtil.getOrDefault(data, teamInfo, Collections.emptyMap()));
                        uiBotModel.getPageData().put(fieldSchema, inputWindowSingleSelect);
                    }
                    break;
                case SingleSelectList.COMPONENT_TYPE:
                    //从制程：场域处理
                    // 性质wo_property为委外只读且非必填
                    if (isSubProcess || BooleanUtils.isNotTrue(canEdit)) {
                        layout.setType(Field.COMPONENT_TYPE);
                        Field field = Field.createLabelLeftValueRightField(localeService.getLanguageValue(locale, layout.getLabel()),
                                (String) MapUtil.getOrDefault(data, "layout_name", StringUtils.EMPTY));
                        uiBotModel.getPageData().put(fieldSchema, field);
                    } else {
                        SingleSelectList singleSelectList = SingleSelectList.createByAPC(areaWoOpDataList,
                                localeService.getLanguageValue(locale, layout.getLabel()), MapUtils.getString(data, fieldSchema),
                                MapUtils.getString(data, "layout_name"), locale, false, true);

                        // 场域有值，联动区域必填
                        CommonRule commonRule = new CommonRule();
                        commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                        commonRule.setTargetSchema("area_name");
                        commonRule.setTargetRequired(true);
                        RelationRule relationRule = singleSelectList.getRelationRule();
                        relationRule.addCommonRule(commonRule);
                        uiBotModel.getPageData().put(fieldSchema, singleSelectList);
                    }
                    break;
                case InputWindowMultiSelect.COMPONENT_TYPE:
                    //从制程：区域处理，
                    //性质wo_property为委外只读且非必填
                    if (isSubProcess || BooleanUtils.isNotTrue(canEdit)) {
                        layout.setType(Field.COMPONENT_TYPE);
                        Field field = Field.createLabelLeftValueRightField(localeService.getLanguageValue(locale, layout.getLabel()),
                                MapUtils.getString(data, fieldSchema));
                        uiBotModel.getPageData().put(fieldSchema, field);
                    } else {
                        Map<String, Object> selectMaps = new HashMap<>(4);
                        selectMaps.put("type", fieldSchema);
                        selectMaps.put("isAPC", true);
                        if ("area_name".equalsIgnoreCase(fieldSchema)) {
                            selectMaps.put("plan_source", data.get("plan_source"));
                            selectMaps.put("eoc_company_id", eocCompanyId);
                            selectMaps.put("eoc_site_id", eocSiteId);
                            selectMaps.put("onSiteResourcePlanningMechanism", onSiteResourcePlanningMechanism);

                            selectMaps.put("doc_type_no", data.get("doc_type_no"));
                            selectMaps.put("op_seq", data.get("op_seq"));
                            selectMaps.put("item_name", data.get("item_name"));
                            selectMaps.put("item_no", data.get("item_no"));
                            selectMaps.put("item_spec", data.get("item_spec"));
                            selectMaps.put("plan_start_date", data.get("plan_start_date"));
                            selectMaps.put("area_no", data.get("area_no"));
                            selectMaps.put("wo_no", data.get("wo_no"));
                            selectMaps.put("op_no", data.get("op_no"));
                            selectMaps.put("op_name", data.get("op_name"));
                            selectMaps.put("plan_complete_date", data.get("plan_complete_date"));
                            selectMaps.put("plot_no", data.get("plot_no"));
                        }
                        InputWindowMultiSelect inputWindowMultiSelect = InputWindowMultiSelect.create(layout,
                                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                selectMaps, locale, 0, InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue(),
                                false, StringUtils.isNotEmpty(MapUtils.getString(data, "layout_name")), localeService, true);
                        String areaNo = (String) MapUtil.getOrDefault(data, "area_no", StringUtils.EMPTY);
                        if (StringUtils.isNotEmpty(areaNo)) {
                            inputWindowMultiSelect.setSelectIdList(Arrays.asList(StringUtils.split(areaNo, ";")));
                        }
                        String areaName = (String) MapUtil.getOrDefault(data, "area_name", StringUtils.EMPTY);
                        if (StringUtils.isNotEmpty(areaNo)) {
                            inputWindowMultiSelect.setTextList(Arrays.asList(StringUtils.split(areaName, ";")));
                        }
                        List<Object> areaInfo = (List<Object>) MapUtil.getOrDefault(data, "area_info", Collections.emptyList());
                        inputWindowMultiSelect.setSelectDetailList(areaInfo);
                        uiBotModel.getPageData().put(fieldSchema, inputWindowMultiSelect);
                    }
                    break;
                case Field.COMPONENT_TYPE:
                    String value = "";
                    String newSchema = "new_" + fieldSchema;
                    boolean isShowChangeTag = false;

                    if (apcLabelList.contains(fieldSchema)) {
                        value = convertApcValue(changeFlag, newSchema, fieldSchema, data, locale);
                        if (TaskChangeFlagEnum.MODIFY.getType().equals(changeFlag)
                                && !StringUtils.equals(String.valueOf(data.get(fieldSchema)), String.valueOf(data.get(newSchema)))) {
                            isShowChangeTag = true;
                        }
                        if ("-".equals(value) || StringUtils.isBlank(value)) {
                            isShowChangeTag = false;
                        }
                    } else {
                        if ("progress_percentage".equalsIgnoreCase(fieldSchema)) {
                            value = String.format("%.0f", Double.valueOf(String.valueOf(MapUtil.getOrDefault(data, fieldSchema, 0)))) + "%";
                        } else {
                            value = (String) data.get(newSchema);
                            if (StringUtils.isEmpty(value)) {
                                value = (String) data.get(fieldSchema);
                            }
                            if ("plan_start_date".equals(fieldSchema) || "plan_complete_date".equals(fieldSchema)) {
                                if (value.contains("1900") || value.contains("9998")) {
                                    value = "-";
                                }
                            }
                            //性质：1:厂内、2:委外, 可能 new_wo_property 或者 wo_property字段有值
                            if ("wo_property".equalsIgnoreCase(fieldSchema)) {
                                if ("1".equalsIgnoreCase(value)) {
                                    value = localeService.getLanguageValue(locale, "厂内");
                                }
                                if ("2".equalsIgnoreCase(value)) {
                                    value = localeService.getLanguageValue(locale, "委外");
                                }
                            }

                            // 状态为修改的情况下， 字段名和字段名加前缀new_ 两者对应的值比较，不一致该字段右侧展示改字tag
                            if (TaskChangeFlagEnum.MODIFY.getType().equals(changeFlag)
                                    && !StringUtils.equals(String.valueOf(data.get(fieldSchema)), String.valueOf(data.get(newSchema))) && !"-".equals(value)) {
                                isShowChangeTag = true;
                            }
                        }
                    }
                    uiBotModel.getPageData().put(fieldSchema, Field.createApcField(
                            localeService.getLanguageValue(locale, layout.getLabel()),
                            FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                            FieldValueStyleTypeEnum.VALUE_BLACK.getValue(),
                            ModuleUtils.emptyValueToHyphen(value),
                            FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT.getValue(), isShowChangeTag));
                    break;
                case PageButton.COMPONENT_TYPE:
                    String text;
                    PageButton pageButton = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(fieldSchema), PageButton.class);
                    pageButton.setName(localeService.getLanguageValue(locale, layout.getLabel()));
                    pageButton.setLabelStyle(BooleanUtils.isNotTrue(canEdit) ? PageButtonLabelStyleEnum.ONLY_READ.getType() : PageButtonLabelStyleEnum.EDIT.getType());

                    if ("production_status".equalsIgnoreCase(fieldSchema)) {
                        text = (String) data.get(fieldSchema);
                        if ("4".equalsIgnoreCase(text)) {
                            text = localeService.getLanguageValue(locale, "异常");
                        } else if ("3".equalsIgnoreCase(text)) {
                            text = localeService.getLanguageValue(locale, "已完成");
                        } else if ("2".equalsIgnoreCase(text)) {
                            text = localeService.getLanguageValue(locale, "进行中");
                        } else if ("1".equalsIgnoreCase(text)) {
                            text = localeService.getLanguageValue(locale, "未开始");
                        }
                        // 异常用PageButton，其余状态用field
                        if ("4".equalsIgnoreCase((String) data.get(fieldSchema))) {
                            pageButton.setAction(buildPageButtonAction(pageButton, data, eocCompanyId,
                                    eocSiteId, locale));
                            pageButton.setText(text);
                            uiBotModel.getPageData().put(fieldSchema, pageButton);
                        } else {
                            layout.setType(Field.COMPONENT_TYPE);
                            Field field = Field.createLabelLeftValueRightField(pageButton.getName(), text);
                            uiBotModel.getPageData().put(fieldSchema, field);
                        }
                    } else {
                        text = String.format("%.0f", Double.valueOf(String.valueOf(MapUtil.getOrDefault(data, fieldSchema, 0.0))));
                        pageButton.setAction(buildPageButtonAction(pageButton, data, eocCompanyId,
                                eocSiteId, locale));
                        pageButton.setText(text);
                        uiBotModel.getPageData().put(fieldSchema, pageButton);
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) uiBotModel.getPageData().get(fieldSchema), BottomButtonDigiwinAthena.class);
                    Iterator<BottomButtonDigiwinAthena> buttonsIterator = buttons.iterator();
                    while (buttonsIterator.hasNext()) {
                        BottomButtonDigiwinAthena bottomButton = buttonsIterator.next();
                        if (bottomButton.getIsCheckButton() && BooleanUtils.isNotTrue(canEdit)) {
                            buttonsIterator.remove();
                        } else {
                            Map<String, Object> actionRawData = new HashMap<>(8);
                            bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                            if (bottomButton.getIsCheckButton()) {
                                Action action = bottomButton.getAction();
                                action.setRefreshPageId(apiRequest.getRefreshPageId());
                                actionRawData.put("dataId", dataId);
//                                actionRawData.put("isMainProcess", isMainProcess);
                                actionRawData.put("data", data);
                                actionRawData.put("dataList", dataList);
                                actionRawData.put("workingDayPlanDispatchInfoList", workingDayPlanDispatchInfoList);
                                action.setRawData(actionRawData);
                                action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/apcTeamDispatcher/save");
                                action.setDataId(dataId);
//                                action.setType(isMainProcess ? ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue() : ActionTypeEnum.BACK_AND_TRANSFER_DATA_TO_PREFIX.getValue());
                                action.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());

                            }
                        }
                    }
                    uiBotModel.getPageData().put(fieldSchema, buttons);
                    break;
                default:
                    break;
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private String convertApcValue(String changeFlag, String newfieldSchema, String fieldSchema, Map<String, Object> data, String locale) {
        String value = "-";
        Boolean flag = false;
        if (TaskChangeFlagEnum.NEW.getType().equals(changeFlag) ||
                TaskChangeFlagEnum.MODIFY.getType().equals(changeFlag)) {
            //1和3的状态要加new
            flag = true;
        }
        if ("is_main_op".equals(fieldSchema)) {
            if (flag) {
                if (data.get(newfieldSchema) != null) {
                    if ((Boolean) data.get(newfieldSchema)) {
                        value = localeService.getLanguageValue(locale, "是");
                    } else {
                        value = localeService.getLanguageValue(locale, "否");
                    }
                }
            } else {
                if (data.get(fieldSchema) != null) {
                    if ((Boolean) data.get(fieldSchema)) {
                        value = localeService.getLanguageValue(locale, "是");
                    } else {
                        value = localeService.getLanguageValue(locale, "否");
                    }
                }
            }
        } else if ("disassemble_merge".equals(fieldSchema)) {
            if (flag) {
                if (data.get(newfieldSchema) != null) {
                    if (ApcDisassemblemergeEnum.DISMANTLE.getType().equals(data.get(newfieldSchema))) {
                        value = ApcDisassemblemergeEnum.DISMANTLE.getName();
                    } else if (ApcDisassemblemergeEnum.LINEAR.getType().equals(data.get(newfieldSchema))) {
                        value = ApcDisassemblemergeEnum.LINEAR.getName();
                    } else if (ApcDisassemblemergeEnum.MERGE.getType().equals(data.get(newfieldSchema))) {
                        value = ApcDisassemblemergeEnum.MERGE.getName();
                    } else if (ApcDisassemblemergeEnum.SPLIT.getType().equals(data.get(newfieldSchema))) {
                        value = ApcDisassemblemergeEnum.SPLIT.getName();
                    } else {
                        value = "";
                    }
                    value = localeService.getLanguageValue(locale, value);
                }
            } else {
                if (data.get(fieldSchema) != null) {
                    if (ApcDisassemblemergeEnum.DISMANTLE.getType().equals(data.get(fieldSchema))) {
                        value = ApcDisassemblemergeEnum.DISMANTLE.getName();
                    } else if (ApcDisassemblemergeEnum.LINEAR.getType().equals(data.get(fieldSchema))) {
                        value = ApcDisassemblemergeEnum.LINEAR.getName();
                    } else if (ApcDisassemblemergeEnum.MERGE.getType().equals(data.get(fieldSchema))) {
                        value = ApcDisassemblemergeEnum.MERGE.getName();
                    } else if (ApcDisassemblemergeEnum.SPLIT.getType().equals(data.get(fieldSchema))) {
                        value = ApcDisassemblemergeEnum.SPLIT.getName();
                    } else {
                        value = "";
                    }
                    value = localeService.getLanguageValue(locale, value);
                }
            }
        } else if ("position_flag".equals(fieldSchema)) {
            if (flag) {
                if (data.get(newfieldSchema) != null) {
                    if (ApcWorkTypeEnum.START_PROCESS.getType().equals(data.get(newfieldSchema))) {
                        value = ApcWorkTypeEnum.START_PROCESS.getName();
                    } else if (ApcWorkTypeEnum.END_PROCESS.getType().equals(data.get(newfieldSchema))) {
                        value = ApcWorkTypeEnum.END_PROCESS.getName();
                    } else if (ApcWorkTypeEnum.MIDDLE_PROCESS.getType().equals(data.get(newfieldSchema))) {
                        value = ApcWorkTypeEnum.MIDDLE_PROCESS.getName();
                    } else if (ApcWorkTypeEnum.START_END_PROCESS.getType().equals(data.get(newfieldSchema))) {
                        value = ApcWorkTypeEnum.START_END_PROCESS.getName();
                    } else {
                        value = "";
                    }
                    value = localeService.getLanguageValue(locale, value);
                }
            } else {
                if (data.get(fieldSchema) != null) {
                    if (ApcWorkTypeEnum.START_PROCESS.getType().equals(data.get(fieldSchema))) {
                        value = ApcWorkTypeEnum.START_PROCESS.getName();
                    } else if (ApcWorkTypeEnum.END_PROCESS.getType().equals(data.get(fieldSchema))) {
                        value = ApcWorkTypeEnum.END_PROCESS.getName();
                    } else if (ApcWorkTypeEnum.MIDDLE_PROCESS.getType().equals(data.get(fieldSchema))) {
                        value = ApcWorkTypeEnum.MIDDLE_PROCESS.getName();
                    } else if (ApcWorkTypeEnum.START_END_PROCESS.getType().equals(data.get(fieldSchema))) {
                        value = ApcWorkTypeEnum.START_END_PROCESS.getName();
                    } else {
                        value = "";
                    }
                    value = localeService.getLanguageValue(locale, value);
                }
            }
        } else if ("plan_qty".equals(fieldSchema)) {
            Double planQty = 0.0;
            DecimalFormat df = new DecimalFormat("0.######");
            if (flag) {
                if (data.get(newfieldSchema) != null) {
                    if (data.get(newfieldSchema) instanceof Double) {
                        planQty = (Double) data.get(newfieldSchema);
                    } else {
                        planQty = ((Integer) data.get(newfieldSchema)).doubleValue();
                    }
                    value = df.format(planQty);
                } else {
                    value = "-";
                }
            } else {
                if (data.get(fieldSchema) != null) {
                    if (data.get(fieldSchema) instanceof Double) {
                        planQty = (Double) data.get(fieldSchema);
                    } else {
                        planQty = ((Integer) data.get(fieldSchema)).doubleValue();
                    }
                    value = df.format(planQty);
                } else {
                    value = "-";
                }
            }
        } else if ("plan_status".equals(fieldSchema)) {
            if (flag) {
                if (data.get(newfieldSchema) != null) {
                    if ("1".equals(data.get(newfieldSchema))) {
                        value = localeService.getLanguageValue(locale, "计划暂停");
                    } else if ("2".equals(data.get(newfieldSchema))) {
                        value = localeService.getLanguageValue(locale, "计划删除");
                    }
                }
            } else {
                if (data.get(fieldSchema) != null) {
                    if ("1".equals(data.get(fieldSchema))) {
                        value = localeService.getLanguageValue(locale, "计划暂停");
                    } else if ("2".equals(data.get(fieldSchema))) {
                        value = localeService.getLanguageValue(locale, "计划删除");
                    }
                }
            }
        } else {
            if (flag) {
                if (data.get(newfieldSchema) != null) {
                    value = String.valueOf(data.get(newfieldSchema));
                }
            } else {
                if (data.get(fieldSchema) != null) {
                    value = String.valueOf(data.get(fieldSchema));
                }
            }
        }
        return value;
    }

    private Action buildPageButtonAction(PageButton pageButton, Map<String, Object> data,
                                         String eocCompanyId, String eocSiteId, String locale) {
        Action pageButtonAction = pageButton.getAction();
        Map<String, Object> requestMap = new HashMap<>(1);
        List<Map<String, Object>> rawDatas = new ArrayList<>(1);
        Map<String, Object> rawDatamap = new HashMap<>(8);
        String newOpSeq = (String) data.get("new_op_seq");
        String newPlotNo = (String) data.get("new_plot_no");
        String newWoNo = (String) data.get("new_wo_no");
        rawDatamap.put("op_seq", StringUtils.isNotEmpty(newOpSeq) ? newOpSeq : data.get("op_seq"));
        rawDatamap.put("plot_no", StringUtils.isNotEmpty(newPlotNo) ? newPlotNo : data.get("plot_no"));
        rawDatamap.put("wo_no", StringUtils.isNotEmpty(newWoNo) ? newWoNo : data.get("wo_no"));
        rawDatamap.put("eoc_region_id", data.get("eoc_region_id"));
        rawDatamap.put("eoc_company_id", eocCompanyId);
        rawDatamap.put("eoc_site_id", eocSiteId);
        rawDatas.add(rawDatamap);
        requestMap.put("wo_op_report_data", rawDatas);

        requestMap.put("isShowOpName", true);
        pageButtonAction.setRawData(requestMap);
        pageButtonAction.setJumpPageTitle(localeService.getLanguageValue(locale,
                pageButtonAction.getJumpPageTitle()));
        return pageButtonAction;
    }

    private List<Map<String, Object>> getMechanismCapabilityCode(ApiRequest apiRequest) {
        List<String> stringList = new ArrayList<>();
        stringList.add(KnowledgeMapsConstant.APC_ON_SITE_RESOURCE_PLANNING_MECHANISM);
        List<Map<String, Object>> mapList = digiwinKnowledgeMapsProxyService.getMechanismCapabilityCode(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), stringList);
        return mapList;
    }

    /**
     * 保存按钮不调接口，前端保存，如果重新编辑，需要将上一次编辑数据加载到
     *
     * @param apiRequest
     * @return
     */
    public void initDataHandle(ApiRequest apiRequest, Boolean changeFlag) {
        if (CollectionUtils.isEmpty(apiRequest.getSubmitParam())) {
            return;
        }

        Map<String, Object> rawData = apiRequest.getRawData();
        Map<String, Object> woOpDispatchDetailItem = (Map<String, Object>) rawData.get("data");
        for (ActionSubmitParam actionSubmitParam : apiRequest.getSubmitParam()) {
            switch (actionSubmitParam.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    // 班组
                    InputWindowSingleSelect inputWindowSingleSelect = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputWindowSingleSelect.class);
                    if (changeFlag) {
                        woOpDispatchDetailItem.put("new_team_no", inputWindowSingleSelect.getSelectId());
                        woOpDispatchDetailItem.put("new_team_name", inputWindowSingleSelect.getTitle());
                        woOpDispatchDetailItem.put("new_team_info", inputWindowSingleSelect.getDetail());
                    } else {
                        woOpDispatchDetailItem.put("team_no", inputWindowSingleSelect.getSelectId());
                        woOpDispatchDetailItem.put("team_name", inputWindowSingleSelect.getTitle());
                        woOpDispatchDetailItem.put("team_info", inputWindowSingleSelect.getDetail());
                    }
                    break;
                case InputWindowMultiSelect.COMPONENT_TYPE:
                    // 区域
                    InputWindowMultiSelect inputWindowMultiSelect = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputWindowMultiSelect.class);
                    List<String> areaNoList = new ArrayList<>();
                    List<String> areaNameList = new ArrayList<>();
                    if (ObjectUtils.isNotEmpty(inputWindowMultiSelect)) {
                        woOpDispatchDetailItem.put("area_info", inputWindowMultiSelect.getSelectDetailList());
                        inputWindowMultiSelect.getSelectDetailList().forEach(e -> {
                            Map<String, Object> selectDetailItem = (Map<String, Object>) e;
                            String areaNo = (String) MapUtil.getOrDefault(selectDetailItem, "area_no", StringUtils.EMPTY);
                            String areaName = (String) MapUtil.getOrDefault(selectDetailItem, "area_name", StringUtils.EMPTY);
                            areaNoList.add(areaNo);
                            areaNameList.add(areaName);
                        });
                    }
                    if (!CollectionUtils.isEmpty(areaNoList)) {
                        woOpDispatchDetailItem.put("area_no", StringUtils.join(areaNoList, ";"));
                    }
                    if (!CollectionUtils.isEmpty(areaNameList)) {
                        woOpDispatchDetailItem.put("area_name", StringUtils.join(areaNameList, ";"));
                    }
                    break;
                case SingleSelectList.COMPONENT_TYPE:
                    // 场域
                    SingleSelectList singleSelectList = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), SingleSelectList.class);
                    woOpDispatchDetailItem.put("layout_no", singleSelectList.getSelectId());
                    woOpDispatchDetailItem.put("layout_name", singleSelectList.getText());
                    break;
                default:
                    break;
            }
        }
    }

    private List<Map<String, Object>> handleWorkingDayPlanDispatchInfoList(ApiRequest apiRequest) {
        // 获取工单下的所有制程（没有区域）
        List<Map<String, Object>> workingDayPlanDispatchInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(apiRequest.getRawData(), "workingDayPlanDispatchInfoList", Collections.emptyList());

        // 获取工单下的所有制程(取区域)
        List<Map<String, Object>> dispatchOpWoDscBmInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(apiRequest.getRawData(), "dispatchOpWoDscBmInfoList", Collections.emptyList());

        Map<String, String> areaNoByWoNo = dispatchOpWoDscBmInfoList.stream().collect(Collectors.toMap(e ->
                        MapUtils.getString(e, "op_no") + "_" + MapUtils.getString(e, "op_seq"),
                e -> MapUtils.getString(e, "area_no"), (c1, c2) -> c1));

        // 获取页面前端保存过后的区域信息
        Map<String, String> pageAreaNoMapByOpNoAndOpSeq = getPageAreaNoMapByOpNoAndOpSeq(apiRequest.getMultiLayoutSubmitParamList());

        workingDayPlanDispatchInfoList.forEach(e -> {
            String opNoAndOpSeq = MapUtils.getString(e, "op_no") + "_" + MapUtils.getString(e, "op_seq");
            String areaNo = pageAreaNoMapByOpNoAndOpSeq.containsKey(opNoAndOpSeq) ? pageAreaNoMapByOpNoAndOpSeq.get(opNoAndOpSeq) : areaNoByWoNo.get(opNoAndOpSeq);
            e.put("area_no", areaNo);
        });
        return workingDayPlanDispatchInfoList;
    }

    /**
     * 根据配置的主从制程对应关系，获取该工单下的制程的卡片id对应关系
     *
     * @param apiRequest
     * @param datas
     * @param currentData
     * @param workingDayPlanDispatchInfoList
     * @param isNeedSubProcessIds
     * @return
     */
    public void handleProcessRelationShip(ApiRequest apiRequest, List<Map<String, Object>> datas, Map<String, Object> currentData,
                                          List<Map<String, Object>> workingDayPlanDispatchInfoList, boolean isNeedSubProcessIds) {
        Map<String, List<Map<String, Object>>> workingDayPlanDispatchInfoMapByOpNo = workingDayPlanDispatchInfoList.stream()
                .collect(Collectors.groupingBy(e -> MapUtils.getString(e, "op_no")));

        // 获取配置的主从关系，用于主制程修改区域后，同步更新子制程区域
        Map<String, Object> variableListSimpleMap = digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), Collections.singletonList("masterSlaveProcessRelationship"));
        if (CollectionUtils.isEmpty(variableListSimpleMap)) {
            return;
        }

        // map 结构包含key（主制程信息），value（从制程信息）字段，key和value又都是对象结构，包含name（制程名称）和key（制程op_no）字段
        List<Map<String, Object>> variableListSimpleList = (List<Map<String, Object>>) variableListSimpleMap.get("masterSlaveProcessRelationship");
        if (CollectionUtils.isEmpty(variableListSimpleList)) {
            return;
        }

        String opNoSchema = "op_no";

        // 按照从制程维度 平铺数据，方便处理
        List<Map<String, Object>> variableList = variableListSimpleList.stream().map(e -> {
            List<Map<String, Object>> values = (List<Map<String, Object>>) e.get("value");
            values.stream().forEach(v -> {
                v.put("sub_key", v.get("key"));
                v.put("index", new BigDecimal(String.valueOf(e.get("index"))).stripTrailingZeros().toPlainString());
                Map<String, Object> key = (Map<String, Object>) e.get("key");
                v.put("main_key", key.get("key"));
            });
            return values;
        }).flatMap(List::stream).collect(Collectors.toList());

        // 从制程-主制程的对应关系。按照从制程sub_key分组，获取主制程key集合，并将集合按照优先级排序
        Map<String, String> variableListSimpleMapBySubProcessId = variableList.stream().collect(Collectors.groupingBy(e -> (String) e.get("sub_key"),
                Collectors.collectingAndThen(Collectors.toList(), list -> {
                    //从制程对应的主制程集合按照优先级排序
                    list.sort(Comparator.comparingInt(e -> Integer.parseInt(MapUtils.getString(e, "index"))));

                    // 在保证从制程对应的主制程优先级顺序的情况下，获取最先满足已开工状态的主制程，如果没有，再获取满足区域有值的主制程
                    return getMainKey(list, workingDayPlanDispatchInfoMapByOpNo);
                }))).entrySet().stream().filter(e -> StringUtils.isNotBlank(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

        // 主制程-从制程的对应关系
        Map<String, List<String>> variableListSimpleMapByMainProcessId = variableListSimpleMapBySubProcessId.entrySet().stream()
                .collect(Collectors.groupingBy(e -> e.getValue(), Collectors.mapping(Map.Entry::getKey, Collectors.toList())));

        String opNoData = MapUtils.getString(currentData, "new_" + opNoSchema);
        if (StringUtils.isEmpty(opNoData)) {
            opNoData = MapUtils.getString(currentData, opNoSchema);
        }

        // 当前制程为配置的从制程
        if (variableListSimpleMapBySubProcessId.containsKey(opNoData)) {

            // 判断当前从制程对应的主制程在同一工单下是否存在（主制程可能在同一工单下的另外一张任务卡），如果不存在的话，主从关系其实就不存在，场域区域还是需要可编辑的
            String variableListSimpleMainProcessId = variableListSimpleMapBySubProcessId.get(opNoData);
            if (workingDayPlanDispatchInfoMapByOpNo.containsKey(variableListSimpleMainProcessId)) {
                currentData.put("isSubProcess", true);
                return;
            }
        }

        // 获取主制程opNo的对应的从制程的opNo集合
        List<String> variableListSimpleSubPorcessOpNoList = variableListSimpleMapByMainProcessId.get(opNoData);
        if (CollectionUtils.isEmpty(variableListSimpleSubPorcessOpNoList)) {
            return;
        }
        currentData.put("isMainProcess", true);

        //wo_property  1:厂内、2:委外
        String woPropertySchema = "wo_property";
        String woPropertyVal = MapUtils.getString(currentData, "new_" + woPropertySchema);
        woPropertyVal = StringUtils.isNotEmpty(woPropertyVal) ? woPropertyVal : MapUtils.getString(currentData, woPropertySchema);

        // isNeedSubProcessIds  是否需要联动从制程更新。
        // true: 返回需要更新的从制程，/apcTeamDispatcher/save 保存接口使用，false:详情页是不需要更新的从制程
        // 性质为委外的主制程，不需要更新从制程
        if (isNeedSubProcessIds && !Objects.equals("2", woPropertyVal)) {

            // 获取制程和卡片id的对应关系,需要过滤掉性质为委外的制程，因为主制程不联动更新委外的从制程
            Map<String, List<String>> woOpDispatchDetailMapByOpNo = datas.stream().filter(e -> {
                String value = MapUtils.getString(e, "new_" + woPropertySchema);
                value = StringUtils.isNotEmpty(value) ? value : MapUtils.getString(e, woPropertySchema);
                return !Objects.equals("2", value);
            }).collect(Collectors.groupingBy(e -> {
                String value = MapUtils.getString(e, "new_" + opNoSchema);
                return StringUtils.isNotEmpty(value) ? value : MapUtils.getString(e, opNoSchema);
            }, Collectors.mapping(e -> (String) e.get("mobile_card_dataId"), Collectors.toList())));

            List<String> subProcessDataIds = new ArrayList<>();
            for (String variableListSimpleSubPorcessOpNo : variableListSimpleSubPorcessOpNoList) {

                // 判断配置的从制程的opNo是否是在当前工单数据下
                if (!woOpDispatchDetailMapByOpNo.containsKey(variableListSimpleSubPorcessOpNo)) {
                    continue;
                }
                if (ObjectUtils.isNotEmpty(woOpDispatchDetailMapByOpNo.get(variableListSimpleSubPorcessOpNo))) {
                    subProcessDataIds.addAll(woOpDispatchDetailMapByOpNo.get(variableListSimpleSubPorcessOpNo));
                }
            }
            currentData.put("subProcessDataIds", subProcessDataIds);
        }
    }

    /**
     * 获取当前页面的前端保存过的卡片对应区域
     *
     * @param multiLayoutSubmitParamList
     * @return
     */
    private Map<String, String> getPageAreaNoMapByOpNoAndOpSeq(List<Map<String, Object>> multiLayoutSubmitParamList) {
        Map<String, String> areaNoMapByOpNoAndOpSeq = new HashMap<>(1);
        if (CollectionUtils.isEmpty(multiLayoutSubmitParamList)) {
            return areaNoMapByOpNoAndOpSeq;
        }
        multiLayoutSubmitParamList.forEach(multiLayoutSubmitParam -> {
            List<ActionSubmitParam> actionSubmitParamList = JsonUtil.objectToJavaObject(multiLayoutSubmitParam.get("data"), new TypeReference<List<ActionSubmitParam>>() {
            });

            String opNoAndOpSeq = "op_no_op_seq";
            String areaNoList = "";
            for (ActionSubmitParam actionSubmitParamItem : actionSubmitParamList) {
                switch (actionSubmitParamItem.getType()) {
                    case Field.COMPONENT_TYPE:
                        if ("op_no".equalsIgnoreCase(actionSubmitParamItem.getSchema()) || "op_seq".equalsIgnoreCase(actionSubmitParamItem.getSchema())) {
                            Field field = JsonUtil.objectToJavaObject(actionSubmitParamItem.getParams(), Field.class);
                            opNoAndOpSeq = opNoAndOpSeq.replace(actionSubmitParamItem.getSchema(), field.getText());
                        }
                        break;
                    case InputWindowMultiSelect.COMPONENT_TYPE:
                        // 区域
                        InputWindowMultiSelect inputWindowMultiSelect = JsonUtil.objectToJavaObject(actionSubmitParamItem.getParams(), InputWindowMultiSelect.class);
                        if (ObjectUtils.isNotEmpty(inputWindowMultiSelect)) {
                            areaNoList = inputWindowMultiSelect.getSelectDetailList().stream().map(e -> {
                                Map<String, Object> selectDetailItem = (Map<String, Object>) e;
                                return MapUtils.getString(selectDetailItem, "area_no");
                            }).collect(Collectors.joining(";"));
                        }
                        break;
                }
            }
            areaNoMapByOpNoAndOpSeq.put(opNoAndOpSeq, areaNoList);
        });
        return areaNoMapByOpNoAndOpSeq;
    }

    private String getMainKey(List<Map<String, Object>> variableListBySubKeyAndSortByIndex,
                              Map<String, List<Map<String, Object>>> workingDayPlanDispatchInfoMapByOpNo) {
        AtomicReference<String> mainKey = new AtomicReference<>("");
        variableListBySubKeyAndSortByIndex.stream().filter(e -> {
            List<Map<String, Object>> dataByMainKey = workingDayPlanDispatchInfoMapByOpNo.get(MapUtils.getString(e, "main_key"));
            if (CollectionUtils.isEmpty(dataByMainKey)) {
                return false;
            }
            return dataByMainKey.stream().anyMatch(v -> StringUtils.isNotBlank(MapUtils.getString(v, "actual_start_date")));
        }).findFirst().ifPresent(e -> mainKey.set(MapUtils.getString(e, "main_key")));
        if (StringUtils.isNotBlank(mainKey.get())) {
            return mainKey.get();
        }

        variableListBySubKeyAndSortByIndex.stream().filter(e -> {
            List<Map<String, Object>> dataByMainKey = workingDayPlanDispatchInfoMapByOpNo.get(MapUtils.getString(e, "main_key"));
            if (CollectionUtils.isEmpty(dataByMainKey)) {
                return false;
            }
            return dataByMainKey.stream().anyMatch(v -> StringUtils.isNotBlank(MapUtils.getString(v, "area_no")));
        }).findFirst().ifPresent(e -> mainKey.set(MapUtils.getString(e, "main_key")));
        if (StringUtils.isNotBlank(mainKey.get())) {
            return mainKey.get();
        }

        variableListBySubKeyAndSortByIndex.stream().filter(e -> {
            List<Map<String, Object>> dataByMainKey = workingDayPlanDispatchInfoMapByOpNo.get(MapUtils.getString(e, "main_key"));
            return !CollectionUtils.isEmpty(dataByMainKey);
        }).findFirst().ifPresent(e -> mainKey.set(MapUtils.getString(e, "main_key")));
        if (org.springframework.util.StringUtils.hasLength(mainKey.get())) {
            return mainKey.get();
        }
        return null;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
