package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionPreHandleResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardOpenDetailTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleItemLabel;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.model.TaskChangeFlagEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


/**
 * @author wuyang
 * @desc APC-班组派工任务卡
 */
@Component("uiBotModelBuildApcTeamDispatchStrategy")
public class UiBotModelBuildApcTeamDispatchStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildApcTeamDispatchStrategy.class);

    private static final String PATH = "wo_op_dispatch_data";

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinMdcProxyService digiwinMdcProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc Team Dispatch");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.
                getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();

        ApiRawData apiRawData = ObjectUtils.isNotEmpty(apiRequest.getRawData()) ? apiRequest.getRawData() : new ApiRawData();

        //是否是团队任务，团队任务不可编辑和提交
        boolean isTeamTask = BooleanUtils.isTrue(apiRawData.getBoolean("isTeamTask"));
        if (StringUtils.isNotEmpty(digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
        }
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(locale);
        }
        List<Map<String, Object>> woOpDispatchData = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(PATH);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.createApc(digiwinAtmcBacklogDetail, pcUiBotModel, locale);
                    pageData.put(schema, titleBody);
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    Map<String, Object> data = CollectionUtils.isEmpty(woOpDispatchData) ? Collections.emptyMap() : woOpDispatchData.get(0);
                    boolean isProductGatewayE10orT100 = digiwinMdcProxyService.isProductGatewayE10orT100(apiRequest.getIamUserToken(), apiRequest.getTenantId());
                    List<CardContent> contents = card.getContent();
                    Iterator<CardContent> iterator = contents.iterator();
                    while (iterator.hasNext()) {
                        CardContent content = iterator.next();
                        content.setLabel(localeService.getLanguageValue(locale, content.getLabel()));
                        if (data.get(content.getSchema()) instanceof Boolean) {
                            if ((Boolean) data.get(content.getSchema())) {
                                content.setValue(localeService.getLanguageValue(locale, "是"));
                            } else {
                                content.setValue(localeService.getLanguageValue(locale, "否"));
                            }
                        } else {
                            // 产品线为E10或T100才展示特征码
                            if ("item_feature_no".equalsIgnoreCase(content.getSchema()) || "item_feature_spec".equalsIgnoreCase(content.getSchema())) {
                                if (!isProductGatewayE10orT100) {
                                    iterator.remove();
                                    continue;
                                }
                            }
                            content.setValue((String) data.get(content.getSchema()));
                        }
                    }
                    pageData.put(schema, card);
                    break;
                case ZtbViewList.COMPONENT_TYPE:
                    ZtbViewList ztbViewList = JsonUtil.objectToJavaObject(pageData.get(schema), ZtbViewList.class);
                    ztbViewList = buildZtbViewList(ztbViewList, apiRequest, pcUiBotModel, locale, apiRequest.getPageId(), isTeamTask);
                    pageData.put(layout.getSchema(), ztbViewList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttonList = null;
                    if (BooleanUtils.isFalse(isTeamTask)) {
                        buttonList = JsonUtil.objectToJavaObject(pageData.get(schema), new TypeReference<List<BottomButtonDigiwinAthena>>() {
                        });
                        for (BottomButtonDigiwinAthena bottomButton : buttonList) {
                            bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                            if (bottomButton.getIsCheckButton()) {
                                Action action = bottomButton.getAction();
                                action.setRefreshPageId(apiRequest.getRefreshPageId());
                                Map<String, Object> rawData = new HashMap<>(4);

                                List<UiBotAction> actions = pcUiBotModel.getActions();
                                if (CollectionUtils.isEmpty(actions)) {
                                    UiBotLayout layoutInfo = UiBotModel.getCustomUibotLayout(pcUiBotModel.getLayout(), "apc_team_dispatch-task-detail-waitting");
                                    if (layoutInfo != null) {
                                        actions = layoutInfo.getActions();
                                    }
                                }
                                rawData.put("action", actions.get(0));
                                rawData.put("pageId", apiRequest.getPageId());
                                rawData.put("baseData", woOpDispatchData);
                                action.setRawData(rawData);
                            }
                        }
                    }
                    pageData.put(schema, buttonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    public ZtbViewList buildZtbViewList(ZtbViewList ztbViewList, ApiRequest apiRequest,
                                        UiBotModel pcUiBotModel, String locale, String pageId, Boolean isTeamTask) {
        List<Map<String, Object>> datas;
        String eocCompanyId = "";
        String eocSiteId = "";
        if (CollectionUtils.isEmpty((Collection<?>) pcUiBotModel.getPageData().get(PATH))) {
            return null;
        }
        datas = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(PATH);
        List<UiBotAction> actions = pcUiBotModel.getActions();
        if (CollectionUtils.isEmpty(actions)) {
            UiBotLayout layout = UiBotModel.getCustomUibotLayout(pcUiBotModel.getLayout(), "apc_team_dispatch-task-detail-waitting");
            if (layout != null) {
                actions = layout.getActions();
            }
        }

        ztbViewList.setTitle(localeService.getLanguageValue(locale, ztbViewList.getTitle()));
        ztbViewList.setIsCheckList(false);
        ztbViewList.setIsNeedSubmit(true);

        if (CollectionUtils.isEmpty(datas)) {
            return ztbViewList;
        }

        List<Map<String, Object>> workingDayPlanDispatchInfoList = null;
        List<Map<String, Object>> dispatchOpWoDscBmInfoList = null;

        //获取主从关联机制机制能力是否生效
        if (StringUtils.isNotEmpty(getApcTeamDispatcherMainAndSubProcessRelationCode(apiRequest))) {
            // 获取工单下的所有制程（没有区域）
            Map<String, Object> queryWorkingDayPlanDispatchInfoMap = new HashMap<>();
            queryWorkingDayPlanDispatchInfoMap.put("wo_no", datas.get(0).get("wo_no"));
            queryWorkingDayPlanDispatchInfoMap.put("plot_no", datas.get(0).get("plot_no"));
            workingDayPlanDispatchInfoList = digiwinEspProxyService.getApcWorkingDayPlanDispatchInfo(apiRequest.getIamUserToken(),
                    apiRequest.getTenantId(), apiRequest.getLocale(), queryWorkingDayPlanDispatchInfoMap);

            // 获取工单下的所有制程(取区域)
            Map<String, Object> queryDispatchOpWoDscBmInfoMap = new HashMap<>();
            queryDispatchOpWoDscBmInfoMap.put("wo_no", datas.get(0).get("wo_no"));
            queryDispatchOpWoDscBmInfoMap.put("plot_no", datas.get(0).get("plot_no"));
            dispatchOpWoDscBmInfoList = digiwinEspProxyService.getDispatchOpWoDscBmInfo(apiRequest.getIamUserToken(),
                    apiRequest.getTenantId(), apiRequest.getLocale(), queryDispatchOpWoDscBmInfoMap);

        }

//        // 根据配置的主从制程对应关系，获取该工单下的制程的卡片id对应关系
//        handleProcessRelationShip(apiRequest, datas, woOpDispatchDataItem);

        List<Card> cardList = new ArrayList<>();
        for (Map<String, Object> data : datas) {
            data.put("eoc_company_id", eocCompanyId);
            data.put("eoc_site_id", eocSiteId);

            String dataId = (String) MapUtil.getOrDefault(data, "mobile_card_dataId", StringUtils.EMPTY);
            if (StringUtils.isEmpty(dataId)) {
                dataId = UUIDUtil.getUuid();
                // 用于提交参数替换，识别是哪个条目的id
                data.put("mobile_card_dataId", dataId);
            }

            //班组派工特有的，如果变更标识为删除，则没有按钮
            String changeFlag = (String) MapUtil.getOrDefault(data, "change_flag", StringUtils.EMPTY);

            // 卡片标题右边展示的tag,changeFlag为4代表原 不展示tag
            InputWindowSingleItemLabel label = new InputWindowSingleItemLabel();
            if (!TaskChangeFlagEnum.OROGIN.getType().equals(changeFlag)) {
                label.setColor("#4670F7");
                label.setBackgroudColor("#ffffff");
                label.setText(localeService.getLanguageValue(locale, TaskChangeFlagEnum.getNameByType(changeFlag)));
            }

            String subTitle = null;
            Action subTitleAction = new Action();
            String subtitleType = (String) data.get("production_status");
            if (StringUtils.isNotEmpty(subtitleType)) {
                if ("1".equals(subtitleType)) {
                    subTitle = localeService.getLanguageValue(locale, "未开始");
                } else if ("2".equals(subtitleType)) {
                    subTitle = localeService.getLanguageValue(locale, "进行中");
                } else if ("3".equals(subtitleType)) {
                    subTitle = localeService.getLanguageValue(locale, "已完成");
                } else if ("4".equals(subtitleType)) {
                    subTitle = localeService.getLanguageValue(locale, "异常 >");
                    subTitleAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_TEAM_DISPATCH_ABNORMAL_REPORT_DETAIL.toString());
                    subTitleAction.setJumpPageTitle(localeService.getLanguageValue(locale, "待处理异常清单"));
                    subTitleAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

                    Map<String, Object> woOpReportData = new HashMap<>(1);
                    woOpReportData.put("wo_no", ModuleUtils.emptyString(data.get("wo_no")));
                    woOpReportData.put("plot_no", ModuleUtils.emptyString(data.get("plot_no")));
                    woOpReportData.put("op_seq", ModuleUtils.emptyString(data.get("op_seq")));
                    woOpReportData.put("eoc_company_id", ModuleUtils.emptyString(data.get("eoc_company_id")));
                    woOpReportData.put("eoc_site_id", ModuleUtils.emptyString(data.get("eoc_site_id")));
                    woOpReportData.put("eoc_region_id", ModuleUtils.emptyString(data.get("eoc_region_id")));

                    Map<String, Object> rawData = new HashMap<>(1);
                    rawData.put("wo_op_report_data", Collections.singletonList(woOpReportData));
                    subTitleAction.setRawData(rawData);
                }
            }

            List<CardContent> contentList = new LinkedList<>();
            List<Card> ztbViewCardList = ztbViewList.getData();
            Card cardTemplate = ztbViewCardList.get(0);
            for (CardContent cardContentTemplate : cardTemplate.getContent()) {
                String value = String.valueOf(MapUtil.getOrDefault(data, "new_" + cardContentTemplate.getSchema(), StringUtils.EMPTY));
                if (StringUtils.isEmpty(value)) {
                    value = String.valueOf(MapUtil.getOrDefault(data, cardContentTemplate.getSchema(), StringUtils.EMPTY));
                }
                if ("plan_start_date".equals(cardContentTemplate.getSchema()) || "plan_complete_date".equals(cardContentTemplate.getSchema())) {
                    if (value.contains("1900") || value.contains("9998")) {
                        value = "-";
                    }
                }
                if ("team_name".equals(cardContentTemplate.getSchema())) {
                    if (TaskChangeFlagEnum.NEW.getType().equals(changeFlag)
                            || TaskChangeFlagEnum.MODIFY.getType().equals(changeFlag)) {
                        value = String.valueOf(MapUtil.getOrDefault(data, "new_" + cardContentTemplate.getSchema(), StringUtils.EMPTY));
                    } else {
                        value = String.valueOf(MapUtil.getOrDefault(data, cardContentTemplate.getSchema(), StringUtils.EMPTY));
                    }
                }
                contentList.add(new CardContent(localeService.getLanguageValue(locale, cardContentTemplate.getLabel()), value, cardContentTemplate.getSchema(), 1));
            }

            String title = (String) MapUtil.getOrDefault(data, "new_" + cardTemplate.getTitle(), StringUtils.EMPTY);
            if (StringUtils.isEmpty(title)) {
                title = (String) MapUtil.getOrDefault(data, cardTemplate.getTitle(), StringUtils.EMPTY);
            }


            Button button = Button.createApcTeamDispatch(locale, localeService, dataId);

            TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
            detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_TEAM_DISPATCH_DEAL_DETAIL.toString());
            detailPage.setRefreshPageId(pageId);
            detailPage.setDataId(dataId);

            Map<String, Object> buttonRawData = new HashMap<>(4);
            buttonRawData.put("data", data);
            buttonRawData.put("action", !CollectionUtils.isEmpty(actions) ? actions.get(0) : Collections.emptyList());
            buttonRawData.put("dataId", dataId);
            // 是否是主制程，用于卡片详情页保存主制程返回action为32的场景
            buttonRawData.put("isMainProcess", data.get("isMainProcess"));

            // 是否是子制程,用于卡片详情页子制程场域区域不可编辑的场景
            buttonRawData.put("isSubProcess", data.get("isSubProcess"));

            // 子制程dataId集合，用于主制程修改区域后，同步更新子制程区域；
            buttonRawData.put("subProcessDataIds", data.get("subProcessDataIds"));

            buttonRawData.put("woOpDispatchData", datas);
            buttonRawData.put("workingDayPlanDispatchInfoList", workingDayPlanDispatchInfoList);
            buttonRawData.put("dispatchOpWoDscBmInfoList", dispatchOpWoDscBmInfoList);

            detailPage.setRawData(buttonRawData);

            Integer style = 1;
            List<Button> cardButtonList;
            Integer openDetailType;

            // 是否是指定完工，是的话，班组，场域区域都不能编辑
            boolean isNotDesignationClose = BooleanUtils.isFalse((Boolean) MapUtil.getOrDefault(data, "is_designation_close", false));

            // 是否是厂内，厂内的场域，区域才可更新, 可能 new_wo_property 或者 wo_property字段有值
            String woProperty = String.valueOf(MapUtil.getOrDefault(data, "new_wo_property", StringUtils.EMPTY));
            if (StringUtils.isEmpty(woProperty)) {
                woProperty = String.valueOf(MapUtil.getOrDefault(data, "wo_property", StringUtils.EMPTY));
            }
            boolean isEligibleWoProperty = "1".equals(woProperty);

            // 进度小于100，场域，区域才可编辑
            BigDecimal progressPercentage = new BigDecimal(String.valueOf(MapUtil.getOrDefault(data, "progress_percentage", "0")));
            boolean isEligibleProgressPercentage = progressPercentage.compareTo(new BigDecimal(100)) < 0;

            //1.當性質=廠內 且 目前進度=0~99%
            //可維護的欄位:
            //=>新、改 的工序,可維護班組、區域
            //=>不可維護 工序、製程、預計開工日、預計完工日、線別(工作中心)
            //=>原，刪的工序,不可維護 工序、製程、預計開工日、預計完工日、線別(工作中心)、班組、區域
            //2.當是否指定完工=是 或 性質=委外 或 目前進度=100%
            //=>新、刪、改、原 全部欄位都不可維護
            //
            // 去处理展示条件只会 在指定完工为否，厂内，且进度小于100%，且标签是新或改， 子制程不可编辑在详情里面控制，因为班组不受子制程控制
            if (isNotDesignationClose && isEligibleWoProperty && isEligibleProgressPercentage
                    && BooleanUtils.isFalse(isTeamTask)
                    && (TaskChangeFlagEnum.NEW.getType().equals(changeFlag)
                    || TaskChangeFlagEnum.MODIFY.getType().equals(changeFlag))) {
                cardButtonList = Collections.singletonList(button);
                openDetailType = CardOpenDetailTypeEnum.BY_BUTTON.getValue();
                buttonRawData.put("canEdit", true);
            } else {
                cardButtonList = Collections.emptyList();
                openDetailType = CardOpenDetailTypeEnum.BY_CARD.getValue();

                // 删除状态卡片置灰
                if (TaskChangeFlagEnum.DELETE.getType().equals(changeFlag)) {
                    style = 2;
                }
            }

            Card card = Card.create(title, subTitle, contentList, cardButtonList, subTitleAction,
                    label, detailPage, style, openDetailType);
            card.setDataId(dataId);
            cardList.add(card);
        }
        ztbViewList.setData(cardList);
        return ztbViewList;
    }

    private String getApcTeamDispatcherMainAndSubProcessRelationCode(ApiRequest apiRequest) {
        List<String> paramList = new ArrayList<>();
        paramList.add(KnowledgeMapsConstant.APC_SEATS_AND_TEAM_DISPATCHER + apiRequest.getTenantId());
        List<Map<String, Object>> mapList = digiwinKnowledgeMapsProxyService.getMechanismCapabilityCode(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), paramList);
        if (CollectionUtils.isEmpty(mapList)) {
            return StringUtils.EMPTY;
        }
        return (String) MapUtil.getOrDefault(mapList.get(0), "mechanismAbilityCode", StringUtils.EMPTY);
    }

    public ActionPreHandleResult actionBeforeSubmit(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();
        ApiRawData rawData = apiRequestSubmit.getRawData();

        Map<String, Map<String, Object>> paramValueMapByCardDataId = new HashMap<>();
        for (Map<String, Object> multiLayoutSubmitParam : apiRequestSubmit.getMultiLayoutSubmitParamList()) {
            List<ActionSubmitParam> actionSubmitParamList = JsonUtil.objectToJavaObject(multiLayoutSubmitParam.get("data"), new TypeReference<List<ActionSubmitParam>>() {
            });

            Map<String, Object> paramValueMap = new HashMap<>();
            for (ActionSubmitParam actionSubmitParamItem : actionSubmitParamList) {
                switch (actionSubmitParamItem.getType()) {
                    case InputWindowSingleSelect.COMPONENT_TYPE:
                        // 班组
                        InputWindowSingleSelect inputWindowSingleSelect = JsonUtil.objectToJavaObject(actionSubmitParamItem.getParams(), InputWindowSingleSelect.class);
                        paramValueMap.put("team_no", inputWindowSingleSelect.getSelectId());
                        paramValueMap.put("team_name", inputWindowSingleSelect.getTitle());
                        break;
                    case InputWindowMultiSelect.COMPONENT_TYPE:
                        // 区域
                        InputWindowMultiSelect inputWindowMultiSelect = JsonUtil.objectToJavaObject(actionSubmitParamItem.getParams(), InputWindowMultiSelect.class);
                        List<String> areaNoList = new ArrayList<>();
                        List<String> areaNameList = new ArrayList<>();
                        if (ObjectUtils.isNotEmpty(inputWindowMultiSelect)) {
                            inputWindowMultiSelect.getSelectDetailList().forEach(e -> {
                                Map<String, Object> selectDetailItem = (Map<String, Object>) e;
                                String areaNo = (String) MapUtil.getOrDefault(selectDetailItem, "area_no", StringUtils.EMPTY);
                                String areaName = (String) MapUtil.getOrDefault(selectDetailItem, "area_name", StringUtils.EMPTY);
                                areaNoList.add(areaNo);
                                areaNameList.add(areaName);
                            });
                        }
                        paramValueMap.put("area_no", StringUtils.join(areaNoList, ";"));
                        paramValueMap.put("area_name", StringUtils.join(areaNameList, ";"));
                        break;
                    case SingleSelectList.COMPONENT_TYPE:
                        // 场域
                        SingleSelectList singleSelectList = JsonUtil.objectToJavaObject(actionSubmitParamItem.getParams(), SingleSelectList.class);
                        paramValueMap.put("layout_no", singleSelectList.getSelectId());
                        paramValueMap.put("layout_name", singleSelectList.getText());
                        break;
                    default:
                        break;
                }
            }
            paramValueMapByCardDataId.put((String) multiLayoutSubmitParam.get("dataId"), paramValueMap);
        }


        // 根据mobile_card_dataId识别是哪个条目的id，用来替换条目里的班组，场域，区域信息
        List<Map<String, Object>> woOpDispatchDataList = (List<Map<String, Object>>) rawData.get("baseData");
        for (Map<String, Object> woOpDispatchData : woOpDispatchDataList) {

            String mobileCardDataId = MapUtils.getString(woOpDispatchData, "mobile_card_dataId");
            Map<String, Object> paramValueMapInfo = paramValueMapByCardDataId.get(mobileCardDataId);
            if (!CollectionUtils.isEmpty(paramValueMapInfo)) {

                //班组是新，改才传new前缀的，区域不需要带new前缀
                String changeFlag = MapUtils.getString(woOpDispatchData, "change_flag");
                if(TaskChangeFlagEnum.NEW.getType().equals(changeFlag)
                        || TaskChangeFlagEnum.MODIFY.getType().equals(changeFlag)){
                    paramValueMapInfo.put("new_team_no",  MapUtils.getString(paramValueMapInfo, "team_no"));
                    paramValueMapInfo.put("new_team_name", MapUtils.getString(paramValueMapInfo, "team_name"));
                    paramValueMapInfo.remove("team_no");
                    paramValueMapInfo.remove("team_name");
                }
                woOpDispatchData.putAll(paramValueMapInfo);
            }
        }

        Map<String, Object> activityBackLogDataByKey = woOpDispatchDataList.stream().collect(Collectors.toMap(e -> MapUtils.getString(e, "wo_no")
                + "_" + MapUtils.getString(e, "op_seq")
                + "_" + MapUtils.getString(e, "plot_no"), e -> e.get("activity__backLog__data")));

        Map<String, Object> changeInfoProcessDataMap = new HashMap<>(1);
        Map<String, Object> changeInfoProcessParameterMap = new HashMap<>(1);
        changeInfoProcessParameterMap.put(PATH, woOpDispatchDataList);
        changeInfoProcessDataMap.put("parameter", changeInfoProcessParameterMap);
        changeInfoProcessDataMap.put("actionId", "op.change.info.process");
        changeInfoProcessDataMap.put("businessUnit", woOpDispatchDataList.get(0).get("businessUnit"));

        DigiwinAthenaApiResponse<JSONObject> verCheckDataParamsRes = digiwinAtdmProxyService
                .handleByActionId(locale, iamUserToken, tenantId, "", changeInfoProcessDataMap);

        ActionPreHandleResult preHandleResult = new ActionPreHandleResult();
        if (verCheckDataParamsRes.getStatus() != 200) {
            preHandleResult.setActionFound(false);
            return preHandleResult;
        }

        Map<String, Object> resultMap = verCheckDataParamsRes.getResponse().getInnerMap();
        List<Map<String, Object>> respWoOpDispatchDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(resultMap, "wo_op_dispatch_data", Collections.emptyList());
        if (CollectionUtils.isEmpty(respWoOpDispatchDataList)) {
            preHandleResult.setActionFound(false);
            return preHandleResult;
        }

        List<Map<String, Object>> onlineReporterDetail = (List<Map<String, Object>>) MapUtil.getOrDefault(respWoOpDispatchDataList.get(0), "online_reporter_detail", Collections.emptyList());
        List<Map<String, Object>> waitProcessAbnormalDetail = (List<Map<String, Object>>) MapUtil.getOrDefault(respWoOpDispatchDataList.get(0), "wait_process_abnormal_detail", Collections.emptyList());
        if (!(CollectionUtils.isEmpty(onlineReporterDetail) && CollectionUtils.isEmpty(waitProcessAbnormalDetail))) {
            throw new ServiceException(localeService.getLanguageValue(locale, "报工在线人数大于0或制程状态为异常，不可提交"));
        }

        respWoOpDispatchDataList.forEach(e -> {
            String key = MapUtils.getString(e, "wo_no")
                    + "_" + MapUtils.getString(e, "op_seq")
                    + "_" + MapUtils.getString(e, "plot_no");
            e.put("activity__backLog__data", activityBackLogDataByKey.get(key));
        });
        rawData.put("data", resultMap);
        preHandleResult.setActionFound(true);
        return preHandleResult;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
