package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldValueStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.TargetDatetime;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：制令上线的撤回详情页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildApcWorkShopOnlineCancelDetailStrategy
 * @Author: 吴阳
 * @Date: 20230425
 */
@Component("uiBotModelBuildApcWorkShopOnlineCancelDetailStrategy")
public class UiBotModelBuildApcWorkShopOnlineCancelDetailStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildApcWorkShopOnlineCancelDetailStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc WorkShopOnline Cancel Detail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();
        Map<String, Object> data = (Map<String, Object>) rawData.get("data");
//        List<UiBotAction> actions = ModuleUtils.listMapToListObject((List<?>) rawData.get("actions"), UiBotAction.class);
        // 拼成最终数据
        stopWatch.start("Build ApcWorkShopOnline Cancel Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case Field.COMPONENT_TYPE:
                    if ("plan_qty".equals(fieldSchema)) {
                        String value = "-";
                        Double planQty = 0.0;
                        if (data.get(fieldSchema) != null) {
                            if (data.get(fieldSchema) instanceof Integer) {
                                planQty = ((Integer) data.get(fieldSchema)).doubleValue();
                            } else {
                                planQty = (Double) data.get(fieldSchema);
                            }
                            DecimalFormat df = new DecimalFormat("0.######");
                            value = df.format(planQty);
                        }
                        uiBotModel.getPageData().put(fieldSchema, Field.createZtbField(
                                localeService.getLanguageValue(locale, layout.getLabel()),
                                FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                                FieldValueStyleTypeEnum.VALUE_BLACK.getValue(),
                                value,
                                FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX.getValue()));
                    }else{
                        uiBotModel.getPageData().put(fieldSchema, Field.createZtbField(
                                localeService.getLanguageValue(locale, layout.getLabel()),
                                FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                                FieldValueStyleTypeEnum.VALUE_BLACK.getValue(),
                                ModuleUtils.emptyValueToHyphen(data.get(fieldSchema)),
                                FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX.getValue()));
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) uiBotModel.getPageData().get(fieldSchema), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                        if (bottomButton.getIsCheckButton()) {
                            Action action = bottomButton.getAction();
                            //TODO 先注释掉S7在打开
//                            rawData.put("action", actions.get(0));
                            rawData.put("isAPC", true);
                            rawData.put("pageId", apiRequest.getPageId());
                            action.setRawData(rawData);
                        }
                    }
                    uiBotModel.getPageData().put(fieldSchema, buttons);
                    break;
                default:
                    break;
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    /**
     * APC工艺天数定制规则
     *
     * @return
     */
    private RelationRule buildRelationRule() {
        RelationRule relationRule = new RelationRule();
        List<CommonRule> ruleList = new ArrayList<>(1);
        CommonRule commonRule = new CommonRule();
        commonRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRule.setTargetSchema("plan_complete_date");
        List<TargetDatetime> targetDatetime = new ArrayList<>(1);
        TargetDatetime datetime = new TargetDatetime();
        datetime.setLinkageSchema("plan_start_date");
        datetime.setDatetimeType(5);
        targetDatetime.add(datetime);
        commonRule.setTargetDatetime(targetDatetime);
        ruleList.add(commonRule);
        relationRule.setRuleList(ruleList);
        return relationRule;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
