package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldValueStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.hooks.MobileUiBotHooks;
import com.digiwin.mobile.mobileuibot.core.hooks.MobileUiBotHooksService;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.TargetDatetime;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * <p>功能描述：制令上线的去处理详情页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildApcWorkShopOnlineDealDetailStrategy
 * @Author: 吴阳
 * @Date: 20230425
 */
@Component("uiBotModelBuildApcWorkShopOnlineDealDetailStrategy")
public class UiBotModelBuildApcWorkShopOnlineDealDetailStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildApcWorkShopOnlineDealDetailStrategy.class);

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private MobileUiBotHooksService mobileUiBotHooksService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc WorkShopOnline Deal Detail");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();
        Map<String, Object> data = (Map<String, Object>) rawData.get("data");

        // 是否是团队任务
        Boolean isTeamTask = (Boolean) MapUtil.getOrDefault(rawData, "isTeamTask", false);

        //TODO 保存和提交按钮，暂时没用到 移到S6
        List<UiBotAction> actions = ModuleUtils.listMapToListT((List<Map<String, Object>>) rawData.get("actions"), UiBotAction.class);
        // 拼成最终数据
        stopWatch.start("Build ApcWorkShopOnline Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        Boolean adjustStartAndEndDate = false;
        Boolean adjustTeam = false;
        //预计开工日的交付设计器参数
        Map<String, Object> adjustStartAndEndDateMap = digiwinKnowledgeMapsProxyService.getMechanismParamValue(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), KnowledgeMapsConstant.APC_ADJUST_START_AND_DATE);
        if (adjustStartAndEndDateMap != null) {
            if (adjustStartAndEndDateMap.get(KnowledgeMapsConstant.APC_ADJUST_START_AND_DATE) != null) {
                adjustStartAndEndDate = (Boolean) adjustStartAndEndDateMap.get(KnowledgeMapsConstant.APC_ADJUST_START_AND_DATE);
            }
        }
        //调整班组交付设计器参数
        Map<String, Object> adjustTeamMap = digiwinKnowledgeMapsProxyService.getMechanismParamValue(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), KnowledgeMapsConstant.APC_ADJUST_TEAM);
        if (adjustTeamMap != null) {
            if (adjustTeamMap.get(KnowledgeMapsConstant.APC_ADJUST_TEAM) != null) {
                adjustTeam = (Boolean) adjustTeamMap.get(KnowledgeMapsConstant.APC_ADJUST_TEAM);
            }
        }

        Boolean required = false;
        if (data != null && data.get("plan_source") != null && adjustStartAndEndDate != null) {
            Object planSource = data.get("plan_source");
            if (planSource instanceof String) {
                required = adjustStartAndEndDate && "1".equalsIgnoreCase((String) planSource);
            }
        }
        List<Map<String, Object>> params = new ArrayList<>(1);
        String eocCompanyId = (String) data.get("eoc_company_id");
        String eocSiteId = (String) data.get("eoc_site_id");
        Map<String, Object> maps = new HashMap<>(4);
        maps.put("plan_source", data.get("plan_source"));
        maps.put("area_no", "");
        maps.put("layout_no", "");
        maps.put("eoc_company_id", eocCompanyId);
        maps.put("eoc_site_id", eocSiteId);
        if (!StringUtils.hasLength(eocCompanyId) &&
                !StringUtils.hasLength(eocSiteId) &&
                data.get("businessUnit") != null) {
            maps.putAll((Map<? extends String, ?>) data.get("businessUnit"));
            eocCompanyId = (String) ((Map<? extends String, ?>) data.get("businessUnit")).get("eoc_company_id");
            eocSiteId = (String) ((Map<? extends String, ?>) data.get("businessUnit")).get("eoc_site_id");
        }
        params.add(maps);

        //获取机制能力code list
        List<Map<String, Object>> mapList = getMechanismCapabilityCode(apiRequest);
        //現場資源規劃機制code
        String onSiteResourcePlanningMechanism = null;
        //席位與班組派工機制 能力code 值为空==未生效 是否生效呈现不同资料
        String seatsAndTeamDispatch = null;
        String s = KnowledgeMapsConstant.APC_SEATS_AND_WORK_SHOP + apiRequest.getTenantId();
        if (CollUtil.isNotEmpty(mapList)) {
            for (Map<String, Object> stringObjectMap : mapList) {
                Object mechanismAbilityCode = stringObjectMap.get("mechanismAbilityCode");
                if (ObjectUtil.isNotEmpty(mechanismAbilityCode)) {
                    if (KnowledgeMapsConstant.APC_ON_SITE_RESOURCE_PLANNING_MECHANISM.equalsIgnoreCase(stringObjectMap.get("mechanismAbilityCode").toString()))
                        onSiteResourcePlanningMechanism = mechanismAbilityCode.toString();
                    if (s.equalsIgnoreCase(stringObjectMap.get("mechanismAbilityCode").toString()))
                        seatsAndTeamDispatch = stringObjectMap.get("mechanismAbilityCode").toString();
                }
            }
        }
        List<Map<String, Object>> datas = digiwinEspProxyService.getLayoutAreaWoOpInfo(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), params);
        Map<String, Object> variableListSimple = null;
        if (StrUtil.isNotEmpty(seatsAndTeamDispatch)) {
            //获取是否是主从制程
            variableListSimple = getVariableListSimple(apiRequest, data, datas);
        }

        List<MobileUiBotHooks> mobileUiBotHooksList = mobileUiBotHooksService.findByPageId(pageSetting.getPageId());
        Map<String, Map<String, Object>> hooksBySchema = mobileUiBotHooksList.stream().collect(Collectors.toMap(MobileUiBotHooks::getSchema, e -> e.getData().getInnerMap(), (a, b) -> a));

        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    if (BooleanUtils.isTrue(isTeamTask)) {
                        layout.setType(Field.COMPONENT_TYPE);
                        uiBotModel.getPageData().put(fieldSchema, Field.createProcess(
                                localeService.getLanguageValue(locale, layout.getLabel()),
                                buildFieldValue(data, fieldSchema)));
                    } else {
                        Map<String, Object> rawdata = new HashMap<>(4);
                        rawdata.put("type", fieldSchema);
                        rawdata.put("isAPC", true);
                        String defaultId = "";
                        rawdata.put("eoc_company_id", eocCompanyId);
                        rawdata.put("eoc_site_id", eocSiteId);
                        if ("team_name".equalsIgnoreCase(fieldSchema)) {
                            rawdata.put("workstation_no", data.get("workstation_no"));
                            rawdata.put("workstation_name", data.get("workstation_name"));
                            rawdata.put("wo_no", data.get("wo_no"));
                            rawdata.put("plot_no", data.get("plot_no"));
                            rawdata.put("op_seq", data.get("op_seq"));
                            rawdata.put("op_no", data.get("op_no"));
                            rawdata.put("plan_start_date", data.get("plan_start_date"));
                            rawdata.put("plan_complete_date", data.get("plan_complete_date"));
                            defaultId = (String) data.get("team_no");
                        }
                        InputWindowSingleSelect inputWindowSingleSelect = InputWindowSingleSelect.create(
                                layout,
                                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                locale,
                                rawdata, localeService, (String) data.get(fieldSchema), defaultId, adjustTeam);
                        uiBotModel.getPageData().put(fieldSchema, inputWindowSingleSelect);
                    }
                    break;
                case SingleSelectList.COMPONENT_TYPE:
                    //从制程：场域处理  isMainProcess true主制程 false从制程
                    if (BooleanUtils.isTrue(isTeamTask)
                            || (ObjectUtil.isNotEmpty(variableListSimple) && !(Boolean) variableListSimple.get("isMainProcess"))) {
                        layout.setType(Field.COMPONENT_TYPE);
                        uiBotModel.getPageData().put(fieldSchema, Field.createProcess(
                                localeService.getLanguageValue(locale, layout.getLabel()),
                                buildFieldValue(data, "layout_name")));
                    } else {
                        uiBotModel.getPageData().put(fieldSchema, SingleSelectList.createByAPC(datas,
                                localeService.getLanguageValue(locale, layout.getLabel()), (String) data.get(fieldSchema),
                                (String) data.get("layout_name"), locale,true, true));
                    }

                    break;
                case InputWindowMultiSelect.COMPONENT_TYPE:
                    //从制程：区域处理
                    if (BooleanUtils.isTrue(isTeamTask)
                            || (ObjectUtil.isNotEmpty(variableListSimple) && !(Boolean) variableListSimple.get("isMainProcess"))) {
                        layout.setType(Field.COMPONENT_TYPE);
                        uiBotModel.getPageData().put(fieldSchema, Field.createProcess(
                                localeService.getLanguageValue(locale, layout.getLabel()),
                                buildFieldValue(data, fieldSchema)));
                    } else {
                        Map<String, Object> selectMaps = new HashMap<>(4);
                        selectMaps.put("type", fieldSchema);
                        selectMaps.put("isAPC", true);
                        selectMaps.put("plan_source", data.get("plan_source"));
                        selectMaps.put("eoc_company_id", eocCompanyId);
                        selectMaps.put("eoc_site_id", eocSiteId);
                        selectMaps.put("doc_type_no", data.get("doc_type_no"));
                        selectMaps.put("op_seq", data.get("op_seq"));
                        selectMaps.put("item_no", data.get("item_no"));
                        selectMaps.put("plan_start_date", data.get("plan_start_date"));
                        selectMaps.put("area_no", data.get("area_no"));
                        selectMaps.put("wo_no", data.get("wo_no"));
                        selectMaps.put("op_no", data.get("op_no"));
                        selectMaps.put("plan_complete_date", data.get("plan_complete_date"));
                        selectMaps.put("onSiteResourcePlanningMechanism", onSiteResourcePlanningMechanism);

                        String selectId = (String) data.get("area_no");
                        uiBotModel.getPageData().put(fieldSchema, InputWindowMultiSelect.create(layout,
                                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                selectMaps, locale, 0, InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue(),
                                false, true, localeService, 10, selectId
                        ));
                    }
                    break;
                case InputCalendar.COMPONENT_TYPE:
                    if ("plan_start_date".equalsIgnoreCase(fieldSchema)) {
                        String value = null;
                        if (!((String) data.get(fieldSchema)).contains("1900")) {
                            value = (String) data.get(fieldSchema);
                        }
                        InputCalendar calendar = InputCalendar.create(
                                localeService.getLanguageValue(locale, layout.getLabel()),
                                InputCalendarTypeEnum.SELECT_SINGLE_DATE.getValue(), value,
                                required, false, required,
                                localeService.getLanguageValue(locale, "请输入日期"));
//                        calendar.setRelationRule(RelationRule.createApcWorkShopOnlinePlanStartDate(
//                                fieldSchema, "op_days", 1,
//                                "plan_complete_date"));
                        calendar.setHooks(hooksBySchema.get(fieldSchema));
                        uiBotModel.getPageData().put(fieldSchema, calendar);
                    } else if ("plan_complete_date".equalsIgnoreCase(fieldSchema)) {
                        String value = null;
                        if (!((String) data.get(fieldSchema)).contains("9998")) {
                            value = (String) data.get(fieldSchema);
                        }
                        uiBotModel.getPageData().put(fieldSchema, InputCalendar.create(
                                localeService.getLanguageValue(locale, layout.getLabel()),
                                InputCalendarTypeEnum.SELECT_SINGLE_DATE.getValue(), value,
                                false, false, false,
                                localeService.getLanguageValue(locale, "请输入工艺天数")));
                    }
                    break;
                case InputNumeric.COMPONENT_TYPE:
                    String value;
                    if (data.get(fieldSchema) instanceof Double ||
                            data.get(fieldSchema) instanceof Integer
                    ) {
                        value = String.valueOf(data.get(fieldSchema));
                    } else {
                        value = (String) data.get(fieldSchema);
                    }
                    InputNumeric inputNumeric = InputNumeric.create(99999, 0, value,
                            localeService.getLanguageValue(locale, layout.getLabel()),
                            InputNumericTypeEnum.INTEGER.getValue(), buildRelationRule(), required);
//                    inputNumeric.setRelationRule(RelationRule.createApcWorkShopOnlinePlanStartDate(
//                            "plan_start_date", fieldSchema, 1,
//                            "plan_complete_date"));
                    inputNumeric.setHooks(hooksBySchema.get(fieldSchema));
                    uiBotModel.getPageData().put(fieldSchema, inputNumeric);
                    break;
                case Field.COMPONENT_TYPE:
                    if ("plan_qty".equals(fieldSchema)) {
                        Double planQty = 0.0;
                        if (data.get(fieldSchema) != null) {
                            if (data.get(fieldSchema) instanceof Integer) {
                                planQty = ((Integer) data.get(fieldSchema)).doubleValue();
                            } else {
                                planQty = (Double) data.get(fieldSchema);
                            }
                            DecimalFormat df = new DecimalFormat("0.######");
                            value = df.format(planQty);
                        } else {
                            value = "-";
                        }
                        uiBotModel.getPageData().put(fieldSchema, Field.createZtbField(
                                localeService.getLanguageValue(locale, layout.getLabel()),
                                FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                                FieldValueStyleTypeEnum.VALUE_BLACK.getValue(),
                                value,
                                FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT.getValue()));
                    } else {
                        uiBotModel.getPageData().put(fieldSchema, Field.createZtbField(
                                localeService.getLanguageValue(locale, layout.getLabel()),
                                FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                                FieldValueStyleTypeEnum.VALUE_BLACK.getValue(),
                                ModuleUtils.emptyValueToHyphen(data.get(fieldSchema)),
                                FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT.getValue()));
                    }
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    // 备注
                    String text = String.valueOf(MapUtil.getOrDefault(data, fieldSchema, org.apache.commons.lang3.StringUtils.EMPTY));
                    uiBotModel.getPageData().put(fieldSchema, InputMultiText.create(fieldSchema, localeService.getLanguageValue(locale,
                                    layout.getLabel()), text, true, false, true, locale,
                            255));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) uiBotModel.getPageData().get(fieldSchema), BottomButtonDigiwinAthena.class);
                    Iterator<BottomButtonDigiwinAthena> buttonsIterator = buttons.iterator();
                    while (buttonsIterator.hasNext()) {
                        BottomButtonDigiwinAthena bottomButton = buttonsIterator.next();
                        if (bottomButton.getIsCheckButton() && BooleanUtils.isTrue(isTeamTask)) {
                            buttonsIterator.remove();
                        } else {
                            Map<String, Object> actionRawData = new HashMap<>(8);
                            bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                            if (bottomButton.getIsCheckButton()) {
                                Action action = bottomButton.getAction();
                                if (BottomButtonStyleEnum.NORMAL.getValue().intValue() == bottomButton.getType()) {
                                    Optional<UiBotAction> defaultOption = actions.stream().filter(saveAction -> !saveAction.getDefaultAction()).findFirst();
                                    if (defaultOption.isPresent()) {
                                        actionRawData.put("action", defaultOption.get());
                                    } else {
                                        actionRawData.put("action", null);
                                    }
                                    actionRawData.put("type", "isSave");
                                } else {
                                    Optional<UiBotAction> defaultOption = actions.stream().filter(submitAction -> submitAction.getDefaultAction()).findFirst();
                                    if (defaultOption.isPresent()) {
                                        actionRawData.put("action", defaultOption.get());
                                    } else {
                                        actionRawData.put("action", null);
                                    }
                                    actionRawData.put("type", "isCommit");
                                }
                                action.setRefreshPageId(apiRequest.getRefreshPageId());
                                rawData.put("pageId", apiRequest.getPageId());
                                actionRawData.putAll(rawData);
                                actionRawData.put("variableListSimple", variableListSimple);
                                action.setRawData(actionRawData);
                            }
                        }
                    }
                    uiBotModel.getPageData().put(fieldSchema, buttons);
                    break;
                default:
                    break;
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private List<Map<String, Object>> getMechanismCapabilityCode(ApiRequest apiRequest) {
        List<String> stringList = new ArrayList<>();
        stringList.add(KnowledgeMapsConstant.APC_SEATS_AND_WORK_SHOP + apiRequest.getTenantId());
        stringList.add(KnowledgeMapsConstant.APC_ON_SITE_RESOURCE_PLANNING_MECHANISM);
        List<Map<String, Object>> mapList = digiwinKnowledgeMapsProxyService.getMechanismCapabilityCode(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), stringList);
        return mapList;
    }

    /**
     * 是否主从制程处理
     *
     * @param apiRequest
     * @param data
     * @param datas
     * @return Map<Object>
     * @author yanfeng
     */
    private Map<String, Object> getVariableListSimple(ApiRequest apiRequest, Map<String, Object> data, List<Map<String, Object>> datas) {
        Map<String, Object> returnMap = new HashMap<>(1);
        Map<String, Object> list = digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), Collections.singletonList("masterSlaveProcessRelationship"));
        if (CollUtil.isNotEmpty(list)) {
            List<Map<String, Object>> variableListSimple = (List<Map<String, Object>>) list.get("masterSlaveProcessRelationship");
            if (CollUtil.isNotEmpty(variableListSimple)) {

                Map<String, Object> requestMap = new HashMap<>();
                requestMap.put("wo_no", data.get("wo_no"));
                requestMap.put("plot_no", data.get("plot_no"));
                List<Map<String, Object>> dispatchOpWoDscBmInfo = digiwinEspProxyService.getDispatchOpWoDscBmInfo(apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), apiRequest.getLocale(), requestMap);

                // 获取主从制程关系
                Map<String, List<String>> variableListSimpleMapByMainProcessId = getVariableListSimpleMapByMainProcessId(variableListSimple, dispatchOpWoDscBmInfo);

                for (Map.Entry<String, List<String>> stringObjectMap : variableListSimpleMapByMainProcessId.entrySet()) {
                    //获取主制程
                    if (data.get("op_no").toString().equalsIgnoreCase(stringObjectMap.getKey())) {
                        //是主制程
                        returnMap.put("isMainProcess", true);
                        break;
                    }
                    //获取从制程
                    for (String subProcessId : stringObjectMap.getValue()) {
                        if (data.get("op_no").toString().equalsIgnoreCase(subProcessId)) {
                            //是从制程
                            returnMap.put("isMainProcess", false);
                            //获取工单的所有制程
                            Map<String, Object> fromProcessReturnMap = getDispatchOpWoDscBmInfo(dispatchOpWoDscBmInfo, stringObjectMap.getKey());
                            if (ObjectUtil.isNotEmpty(fromProcessReturnMap)) {
                                if (ObjectUtils.isNotEmpty(fromProcessReturnMap.get("slaveProcess"))) {
                                    returnMap.put("isMainProcess", fromProcessReturnMap.get("slaveProcess"));
                                }
                                if (ObjectUtils.isNotEmpty(fromProcessReturnMap.get("is_in_production"))
                                        && "true".equalsIgnoreCase(String.valueOf(fromProcessReturnMap.get("is_in_production")))) {
                                    data.put("area_name", fromProcessReturnMap.get("area_name"));
                                    data.put("area_no", fromProcessReturnMap.get("area_no"));
                                    for (Map<String, Object> objectMap : datas) {
                                        List<Map<String, Object>> mapList = JsonUtil.objectToJavaObject(objectMap.get("machine_position_map_detail"), new TypeReference<List<Map<String, Object>>>() {
                                        });
                                        for (Map<String, Object> stringObjectMap1 : mapList) {
                                            if (fromProcessReturnMap.get("area_no").toString().contains(";")) {
                                                String[] areaNos = StrUtil.splitToArray(fromProcessReturnMap.get("area_no").toString(), ';');
                                                for (String areaNo : areaNos) {
                                                    if (areaNo.equalsIgnoreCase(stringObjectMap1.get("area_no").toString())) {
                                                        data.put("layout_no", stringObjectMap1.get("layout_no"));
                                                        data.put("layout_name", stringObjectMap1.get("layout_name"));
                                                        break;
                                                    }
                                                }
                                            } else {
                                                if (fromProcessReturnMap.get("area_no").toString()
                                                        .equalsIgnoreCase(stringObjectMap1.get("area_no").toString())) {
                                                    data.put("layout_no", stringObjectMap1.get("layout_no"));
                                                    data.put("layout_name", stringObjectMap1.get("layout_name"));
                                                }
                                            }

                                        }
                                    }
                                } else {
                                    //主制程未提交：场域和区域没有值，显示 -
                                    if (ObjectUtil.isEmpty(data.get("area_no"))) {
                                        data.put("area_name", "-");
                                        data.put("area_no", "-");
                                    }
                                    if (ObjectUtil.isEmpty(data.get("layout_no"))) {
                                        data.put("layout_no", "-");
                                        data.put("layout_name", "-");
                                    }
                                }
                            } else {
                                //场域和区域保存的状态下有值，显示出来
                                if (ObjectUtil.isEmpty(data.get("area_no")) && ObjectUtil.isEmpty(data.get("layout_no"))) {
                                    data.put("area_name", "-");
                                    data.put("area_no", "-");
                                    data.put("layout_no", "-");
                                    data.put("layout_name", "-");
                                }
                            }
                            break;
                        }
                    }
                }
            }
        }
        return returnMap;
    }

    /**
     * 获取同工单下所有制程
     *
     * @param opNo 主制程的op_no
     * @return Map<Object>
     * @author yanfeng
     */
    private Map<String, Object> getDispatchOpWoDscBmInfo(List<Map<String, Object>> dispatchOpWoDscBmInfo, String opNo) {
        Map<String, Object> returnMap = new HashMap<>(4);
        //查询从制程的主制程是否提交，
        if (CollUtil.isNotEmpty(dispatchOpWoDscBmInfo)) {
            returnMap.put("dispatchOpWoDscBmInfo", dispatchOpWoDscBmInfo);
            for (Map<String, Object> stringObjectMap : dispatchOpWoDscBmInfo) {
                //判断主制程：
                if (opNo.equalsIgnoreCase(stringObjectMap.get("op_no").toString())) {
                    if ((Boolean) stringObjectMap.get("is_in_production")) {
                        //提交取场域区域的值赋给从制程的场域区域
                        returnMap.put("area_name", stringObjectMap.get("area_name").toString());
                        returnMap.put("area_no", stringObjectMap.get("area_no").toString());
                        returnMap.put("is_in_production", "true");
                        break;
                    } else {
                        returnMap.put("is_in_production", "false");
                    }
                }
            }
            boolean b = dispatchOpWoDscBmInfo.stream()
                    .anyMatch(a -> opNo.equalsIgnoreCase(a.get("op_no").toString()));
            if (!b) {
                //此从制程的主制程不在同一工单下，所以此从制程场域和区域可以编辑
                returnMap.put("slaveProcess", true);
            }
        }
        return returnMap;
    }

    private Map<String, List<String>> getVariableListSimpleMapByMainProcessId(List<Map<String, Object>> variableListSimpleList,
                                                                              List<Map<String, Object>> dispatchOpWoDscBmInfo) {
        Map<String, List<Map<String, Object>>> dataMapByOpNo;
        if (!CollectionUtils.isEmpty(dispatchOpWoDscBmInfo)) {
            dataMapByOpNo = dispatchOpWoDscBmInfo.stream()
                    .collect(Collectors.groupingBy(e -> MapUtils.getString(e, "op_no")));
        } else {
            dataMapByOpNo = new HashMap<>();
        }

        // 按照从制程维度 平铺数据，方便处理
        List<Map<String, Object>> variableList = variableListSimpleList.stream().map(e -> {
            List<Map<String, Object>> values = (List<Map<String, Object>>) e.get("value");
            values.stream().forEach(v -> {
                v.put("sub_key", v.get("key"));
                v.put("index", new BigDecimal(String.valueOf(e.get("index"))).stripTrailingZeros().toPlainString());
                Map<String, Object> key = (Map<String, Object>) e.get("key");
                v.put("main_key", key.get("key"));
            });
            return values;
        }).flatMap(List::stream).collect(Collectors.toList());

        // 从制程-主制程的对应关系。按照从制程sub_key分组，获取主制程key集合，并将集合按照优先级排序
        Map<String, String> variableListSimpleMapBySubProcessId = variableList.stream().collect(Collectors.groupingBy(e -> (String) e.get("sub_key"),
                Collectors.collectingAndThen(Collectors.toList(), list -> {
                    //从制程对应的主制程集合按照优先级排序
                    list.sort(Comparator.comparingInt(e -> Integer.parseInt(MapUtils.getString(e, "index"))));

                    // 在保证从制程对应的主制程优先级顺序的情况下，获取最先满足已开工状态的主制程，如果没有，再获取满足区域有值的主制程
                    return getMainKey(list, dataMapByOpNo);
                }))).entrySet().stream().filter(e -> StringUtils.hasLength(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

        // 主制程-从制程的对应关系
        Map<String, List<String>> variableListSimpleMapByMainProcessId = variableListSimpleMapBySubProcessId.entrySet().stream()
                .collect(Collectors.groupingBy(e -> e.getValue(), Collectors.mapping(Map.Entry::getKey, Collectors.toList())));

        return variableListSimpleMapByMainProcessId;
    }

    private String getMainKey(List<Map<String, Object>> variableListBySubKeyAndSortByIndex, Map<String, List<Map<String, Object>>> dataMapByOpNo) {
        AtomicReference<String> mainKey = new AtomicReference<>("");
        variableListBySubKeyAndSortByIndex.stream().filter(e -> {
            List<Map<String, Object>> dataByMainKey = dataMapByOpNo.get(MapUtils.getString(e, "main_key"));
            if (CollectionUtils.isEmpty(dataByMainKey)) {
                return false;
            }
            return dataByMainKey.stream().anyMatch(v -> StringUtils.hasLength(MapUtils.getString(v, "actual_start_date")));
        }).findFirst().ifPresent(e -> mainKey.set(MapUtils.getString(e, "main_key")));
        if (StringUtils.hasLength(mainKey.get())) {
            return mainKey.get();
        }

        variableListBySubKeyAndSortByIndex.stream().filter(e -> {
            List<Map<String, Object>> dataByMainKey = dataMapByOpNo.get(MapUtils.getString(e, "main_key"));
            if (CollectionUtils.isEmpty(dataByMainKey)) {
                return false;
            }
            return dataByMainKey.stream().anyMatch(v -> StringUtils.hasLength(MapUtils.getString(v, "area_no")));
        }).findFirst().ifPresent(e -> mainKey.set(MapUtils.getString(e, "main_key")));
        if (StringUtils.hasLength(mainKey.get())) {
            return mainKey.get();
        }

        variableListBySubKeyAndSortByIndex.stream().filter(e -> {
            List<Map<String, Object>> dataByMainKey = dataMapByOpNo.get(MapUtils.getString(e, "main_key"));
            return !CollectionUtils.isEmpty(dataByMainKey);
        }).findFirst().ifPresent(e -> mainKey.set(MapUtils.getString(e, "main_key")));
        if (StringUtils.hasLength(mainKey.get())) {
            return mainKey.get();
        }
        return null;
    }

    /**
     * APC工艺天数定制规则
     *
     * @return
     */
    private RelationRule buildRelationRule() {
        RelationRule relationRule = new RelationRule();
        List<CommonRule> ruleList = new ArrayList<>(1);
        CommonRule commonRule = new CommonRule();
        commonRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRule.setTargetSchema("plan_complete_date");
        List<TargetDatetime> targetDatetime = new ArrayList<>(1);
        TargetDatetime datetime = new TargetDatetime();
        datetime.setLinkageSchema("plan_start_date");
        datetime.setDatetimeType(5);
        targetDatetime.add(datetime);
        commonRule.setTargetDatetime(targetDatetime);
        ruleList.add(commonRule);
        relationRule.setRuleList(ruleList);
        return relationRule;
    }

    private String buildFieldValue(Map<String, Object> data, String schema) {
        String fieldValue = String.valueOf(MapUtil.getOrDefault(data, schema, ""));
        return StringUtils.hasLength(fieldValue) ? fieldValue : "-";
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
