package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcLayoutEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcReassignUser;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 * @desc APC-工单上线（制令上线）
 */
@Component("uiBotModelBuildApcWorkShopOnlineStrategy")
public class UiBotModelBuildApcWorkShopOnlineStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildApcWorkShopOnlineStrategy.class);

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private DigiwinMdcProxyService digiwinMdcProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc work shop online");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.
                getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();

        //是否是团队任务，团队任务不可编辑和提交
        boolean isTeamTask = BooleanUtils.isTrue(apiRawData.getBoolean("isTeamTask"));

        if (StringUtils.hasLength(digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
        }
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(locale);
        }
        String path = UiBotModel.getAthenaTableSchema(pcUiBotModel.getLayout());

        UiBotLayout uiBotLayout = UiBotModel.getContentQueryButtonLayout(pcUiBotModel.getLayout());
        Map<String, Object> bodyMap = JsonUtil.objectToJavaObject(uiBotLayout.getQueryButtons().get(1), Map.class);
        bodyMap.put("executeContext", pcUiBotModel.getExecuteContext());
        UiBotModel completeUibotModle = digiwinPcUiBotProxyService.actionShow(locale, iamUserToken, JsonUtil.javaObjectToJsonString(bodyMap));
        List<Map<String, Object>> datas = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(path);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    UiBotLayout findLayout = UiBotModel.getApprovalDesriptionLayout(pcUiBotModel.getLayout());
                    Map<String, Object> data = Collections.emptyMap();
                    if (!CollectionUtils.isEmpty(datas)) {
                        data = datas.get(0);
                    } else if (ObjectUtil.isNotEmpty(pcUiBotModel.getPageData().get(PcLayoutEnum.APPROVAL_DESCRIPTION.getValue()))) {
                        data = (Map<String, Object>) pcUiBotModel.getPageData().get(PcLayoutEnum.APPROVAL_DESCRIPTION.getValue());
                    }
                    TitleBody titleBody = TitleBody.createApc(locale, digiwinAtmcBacklogDetail, findLayout, data);
                    pageData.put(schema, titleBody);
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    boolean isProductGatewayE10orT100 = digiwinMdcProxyService.isProductGatewayE10orT100(apiRequest.getIamUserToken(), apiRequest.getTenantId());

                    Map<String, Object> dataInfo = new HashMap<>();
                    if (!CollectionUtils.isEmpty(datas)) {
                        dataInfo = datas.get(0);
                    } else {
                        List<Map<String, Object>> complateDatas = (List<Map<String, Object>>) completeUibotModle.getPageData().get(path);
                        if (!CollectionUtils.isEmpty(complateDatas)) {
                            dataInfo = complateDatas.get(0);
                        }
                    }
                    List<CardContent> contents = card.getContent();
                    Iterator<CardContent> iterator = contents.iterator();
                    while (iterator.hasNext()) {
                        CardContent content = iterator.next();
                        content.setLabel(localeService.getLanguageValue(locale, content.getLabel()));

                        // 产品线为E10或T100才展示特征码
                        if ("item_feature_no".equalsIgnoreCase(content.getSchema()) || "item_feature_spec".equalsIgnoreCase(content.getSchema())) {
                            if (!isProductGatewayE10orT100) {
                                iterator.remove();
                                continue;
                            }
                        }
                        content.setValue((String) dataInfo.get(content.getSchema()));
                    }
                    pageData.put(schema, card);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    BlankArea area = JsonUtil.objectToJavaObject(pageData.get(schema), BlankArea.class);
                    pageData.put(schema, area);
                    break;
                case CustomTabs.COMPONENT_TYPE:
                    CustomTabs customTabs = JsonUtil.objectToJavaObject(pageData.get(schema), CustomTabs.class);
                    pageData.put(layout.getSchema(), customTabs.detailApcMessage(customTabs, pcUiBotModel, completeUibotModle,
                            path, locale, localeService, apiRequest.getPageId(), isTeamTask));
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
