package com.digiwin.mobile.mobileuibot.task.strategy.custom.account;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author yanfenga
 * @desc 账务小管家：通知请款页面
 */
@Component("taskDetailBuildReconciliationProgressCallPaymentStrategy")
public class TaskDetailBuildReconciliationProgressCallPaymentStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReconciliationProgressCallPaymentStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Reconciliation Progress CallPayment Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        Map<String, Object> data = JsonUtil.objectToJavaObject(apiRawData.get("ar_data"), new TypeReference<Map<String, Object>>() {
        });
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case InputSingleText.COMPONENT_TYPE:
                    pageData.put(schema, createInputSingleText(schema, locale, data));
                    break;
                case InputNumeric.COMPONENT_TYPE:
                    pageData.put(schema, createInputNumeric(schema, locale, data));
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    InputMultiText inputMultiText = buildInputMultiText(schema, locale);
                    pageData.put(schema, inputMultiText);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttonList = buildButton(apiRawData, locale, pageData, schema);
                    pageData.put(schema, buttonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private InputNumeric createInputNumeric(String schema, String locale, Map<String, Object> data) {
        InputNumeric input = new InputNumeric();
        if ("process_hours".equalsIgnoreCase(schema)) {
            input.setTitle(localeService.getLanguageValue(locale, "时数"));
            BigDecimal processWorkHours = new BigDecimal(String.valueOf(data.get("process_work_hours"))).stripTrailingZeros();
            BigDecimal processHours = new BigDecimal(String.valueOf(data.get("process_hours"))).stripTrailingZeros();
            BigDecimal bigDecimal = processWorkHours.subtract(processHours);
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                input.setText("0");
            } else {
                input.setText(String.valueOf(bigDecimal));
            }
        } else if ("local_curr_price".equalsIgnoreCase(schema)) {
            input.setTitle(localeService.getLanguageValue(locale, "单价"));
            input.setText(String.valueOf(data.get(schema)));
        }
        input.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
        input.setRequired(true);
        input.setSchema(schema);
        input.setPrecision(3);
        return input;
    }

    private InputSingleText createInputSingleText(String schema, String locale, Map<String, Object> data) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setTitle(localeService.getLanguageValue(locale, "发票客户"));
        inputSingleText.setText(String.valueOf(data.get(schema)));
        inputSingleText.setSchema(schema);
        inputSingleText.setRequired(true);
        inputSingleText.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
        return inputSingleText;
    }

    /**
     * 构建多行文本组件
     *
     * @param schema
     * @param locale
     * @return
     */
    private InputMultiText buildInputMultiText(String schema, String locale) {
        return InputMultiText.create(schema,
                localeService.getLanguageValue(locale, "开票备注"),
                "", true,
                false, true, locale);
    }

    /**
     * 构建按钮组件
     *
     * @param apiRawData
     * @param locale
     * @return
     */
    private List<BottomButtonDigiwinAthena> buildButton(ApiRawData apiRawData, String locale, UiBotPageData pageData, String schema) {
        List<BottomButtonDigiwinAthena> buttonList = JsonUtil.objectToJavaObject(pageData.get(schema), new TypeReference<List<BottomButtonDigiwinAthena>>() {
        });
        for (BottomButtonDigiwinAthena bottomButton : buttonList) {
            bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
            Action buttonAction = bottomButton.getAction();
            if (ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue().equals(buttonAction.getType())) {
                buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/reconciliationProgress/submit");
                apiRawData.put("buttonType", "noticePay");
                buttonAction.setRawData(apiRawData);
            }
        }


        return buttonList;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
