package com.digiwin.mobile.mobileuibot.task.strategy.custom.account;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author xujin
 * @desc 对账进度通知详情页
 */
@Component("taskDetailBuildReconciliationProgressNoticeDetailStrategy")
public class TaskDetailBuildReconciliationProgressNoticeDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReconciliationProgressNoticeDetailStrategy.class);

    private static final String ALREADY_NOTICE = "1";

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Reconciliation Progress Notice Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();

        ApiRawData apiRawData = apiRequest.getRawData();
        Map<String, Object> arDataDetail = (Map<String, Object>) apiRawData.get("ar_data_detail");
        List<Map<String, Object>> arDataList = digiwinEspProxyService.getAacrArdateInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, buildgetAacrArdateReq(arDataDetail));
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case CustomTabs.COMPONENT_TYPE:
                    CustomTabs customTabs = new CustomTabs();
                    Map<String, String> nameMap = buildNameMap(locale);
                    Map<String, List<Map<String, Object>>> arDataMapByDocType = arDataList.stream().collect(Collectors.groupingBy(e -> (String) e.get("doc_type")));

                    //辅导
                    List<Map<String, Object>> notBillingQtyList = arDataMapByDocType.get("cs");
                    customTabs.add(buildCustomTab(notBillingQtyList, nameMap, apiRawData,
                            localeService.getLanguageValue(locale, "辅导"), arDataDetail.get("not_billing_qty"), locale));

                    //客制
                    List<Map<String, Object>> notSettlementQtyList = arDataMapByDocType.get("aacr");
                    customTabs.add(buildCustomTab(notSettlementQtyList, nameMap, apiRawData,
                            localeService.getLanguageValue(locale, "客制"), arDataDetail.get("not_settlement_qty"), locale));

                    //工程
                    List<Map<String, Object>> notApplicationBusinessQtyList = arDataMapByDocType.get("ps");
                    customTabs.add(buildCustomTab(notApplicationBusinessQtyList, nameMap, apiRawData,
                            localeService.getLanguageValue(locale, "工程"), arDataDetail.get("not_application_business_qty"), locale));
                    pageData.put(schema, customTabs);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    /**
     * 构建CustomTab
     *
     * @param dataList
     * @param nameMap
     * @param apiRawData
     * @param tabName
     * @param hour
     * @param locale
     * @return
     */
    private CustomTab buildCustomTab(List<Map<String, Object>> dataList, Map<String, String> nameMap, ApiRawData apiRawData, String tabName, Object hour, String locale) {
        if (CollectionUtils.isEmpty(dataList)) {
            return buidlEmptyTab(tabName, nameMap, locale);
        }

        List<CustomTabContentContainer> customTabContentContainerList = new ArrayList<>();
        for (Map<String, Object> data : dataList) {
            List<CardContent> contentList = new LinkedList<>();

            contentList.add(buildCardContent(nameMap.get("laborHours"), buildHour(data, nameMap, "labor_hours")));
            contentList.add(buildCardContent(nameMap.get("processWorkHours"), buildHour(data, nameMap, "process_work_hours")));

            //已验时数(process_work_hours)
            Double processWorkHours = (Double) MapUtil.getOrDefault(data, "process_work_hours", 0.0);

            //已请时数(process_hours)
            Double processHours = (Double) MapUtil.getOrDefault(data, "process_hours", 0.0);

            //待请时数 = 已验时数-已请时数
            BigDecimal bigDecimal = BigDecimal.valueOf(processWorkHours).subtract(BigDecimal.valueOf(processHours));
            String waitHour;
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                waitHour = "0";
            } else {
                waitHour = bigDecimal.toString();
            }
            contentList.add(buildCardContent(nameMap.get("waitHour"), handleHour(waitHour) + nameMap.get("hour")));

            // 验收日 accepted_date为空传plan_complete_set_date，否则传accepted_date
            String acceptedDate = null;
            if (Objects.isNull(data.get("accepted_date")) || StringUtils.isEmpty((String) data.get("accepted_date"))) {
                acceptedDate = handleAcceptedDate(data.get("plan_complete_set_date"));
            } else {
                acceptedDate = handleAcceptedDate(data.get("accepted_date"));
            }
            contentList.add(buildCardContent(nameMap.get("acceptedDate"), acceptedDate));

            contentList.add(buildCardContent(nameMap.get("localCurrPrice"), data.get("local_curr_price")));
            contentList.add(buildCardContent(nameMap.get("reasonCodeName"), data.get("reason_code_name")));

            //附件
            Picture picture = buildPicture(data, nameMap);
            if (!Objects.isNull(picture)) {
                contentList.add(new CardContent(StringUtils.EMPTY, picture));
            }

            String arNo = (String) MapUtil.getOrDefault(data, "ar_no", StringUtils.EMPTY);
            String subTitle = !ALREADY_NOTICE.equals(String.valueOf(data.get("billing_code"))) ? nameMap.get("waitNotice") : nameMap.get("alreadyNotice");

            //按钮
            List<Button> buttonList = buildButtonList(data, nameMap, apiRawData, locale);

            Card arDataDetailCard = Card.create(arNo, subTitle, contentList, buttonList, "#F8F8FC");

            CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
            customTabContentContainer.setContentCmptType(Card.COMPONENT_TYPE);
            customTabContentContainer.setData(arDataDetailCard);
            customTabContentContainerList.add(customTabContentContainer);
        }

        // 根据验收日从小到大排序
        customTabContentContainerList = sortCustomTabContentContainerListByDate(customTabContentContainerList, nameMap);

        CustomTab customTab = new CustomTab();
        customTab.setName(tabName + "(" + handleHour(String.valueOf(hour)) + nameMap.get("hour") + ")");
        customTab.setStyle(2);
        customTab.setAlignmentType(1);
        customTab.setContent(customTabContentContainerList);
        customTab.setIsSelected(true);
        return customTab;
    }

    /**
     * 构建Picture
     *
     * @param data
     * @param nameMap
     * @return
     */
    private Picture buildPicture(Map<String, Object> data, Map<String, String> nameMap) {

        //附件
        List<AttachmentFile> fileList = new ArrayList<>(3);
        if (!Objects.isNull(data.get("contract_attachment")) && StringUtils.isNotEmpty((String) data.get("contract_attachment"))) {
            AttachmentFile contractAttachment = new AttachmentFile();
            contractAttachment.setPreviewUrl((String) data.get("contract_attachment"));
            fileList.add(contractAttachment);
        }
        if (!Objects.isNull(data.get("delivery_attachment")) && StringUtils.isNotEmpty((String) data.get("delivery_attachment"))) {
            AttachmentFile deliveryAttachment = new AttachmentFile();
            deliveryAttachment.setPreviewUrl((String) data.get("delivery_attachment"));
            fileList.add(deliveryAttachment);
        }
        if (!Objects.isNull(data.get("project_attachment")) && StringUtils.isNotEmpty((String) data.get("project_attachment"))) {
            AttachmentFile projectAttachment = new AttachmentFile();
            projectAttachment.setPreviewUrl((String) data.get("project_attachment"));
            fileList.add(projectAttachment);
        }
        if (CollectionUtils.isEmpty(fileList)) {
            return null;
        }

        Picture picture = new Picture();
        picture.setTitle(nameMap.get("attachemnt"));
        picture.setFileList(fileList);
        picture.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        picture.setUsePreviewUrl(true);
        picture.setRows(1);
        return picture;
    }

    /**
     * 构建ButtonList
     *
     * @param data
     * @param nameMap
     * @return
     */
    private List<Button> buildButtonList(Map<String, Object> data, Map<String, String> nameMap, ApiRawData apiRawData, String locale) {
        List<Button> buttonList = new ArrayList<>();

        // 不是已通知状态就需要展示通知请款按钮
        if (!ALREADY_NOTICE.equals(String.valueOf(data.get("billing_code")))) {
            // 通知请款按钮
            Action noticePayAction = new Action();
            noticePayAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_CALL_PAYMENT.toString());
            noticePayAction.setJumpPageTitle(localeService.getLanguageValue(locale, "通知请款"));
            noticePayAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            noticePayAction.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_DETAIL.toString());

            /*noticePayAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
            noticePayAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/reconciliationProgress/submit");*/
            Map<String, Object> rawData = new HashMap<>();
            rawData.put("ar_data", data);
            rawData.put("buttonType", "noticePay");
            rawData.put("refreshDataId", apiRawData.get("refreshDataId"));
            noticePayAction.setRawData(rawData);
            buttonList.add(Button.createButton(nameMap.get("noticeAccount"), UUIDUtil.getUuid(), BottomButtonStyleEnum.DETAIL_NORMAL.getValue(), noticePayAction));
        }

        // 进度回报按钮
        Action progressReportAction = new Action();
        progressReportAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_REPORT.toString());
        progressReportAction.setJumpPageTitle(nameMap.get("progressReport"));
        progressReportAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        progressReportAction.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_DETAIL.toString());
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("ar_data", data);
        rawData.put("refreshDataId", apiRawData.get("refreshDataId"));
        progressReportAction.setRawData(rawData);
        buttonList.add(Button.createButton(nameMap.get("progressReport"), UUIDUtil.getUuid(), BottomButtonStyleEnum.DETAIL_STRESS.getValue(), progressReportAction));
        return buttonList;
    }

    private Map<String, Object> buildgetAacrArdateReq(Map<String, Object> arDataDetail) {
        Map<String, Object> requestMap = new HashMap<>();
        JSONObject woReportData = new JSONObject();
        woReportData.put("customer_no", arDataDetail.get("customer_no"));
        woReportData.put("status", "0");
        JSONArray array = new JSONArray();
        array.add(woReportData);
        requestMap.put("query_condition", array);
        return requestMap;
    }

    /**
     * 针对验收日有数据得条目排序，没有数据的放在后面
     *
     * @param customTabContentContainerList
     * @param nameMap
     * @return
     */
    private List<CustomTabContentContainer> sortCustomTabContentContainerListByDate(List<CustomTabContentContainer> customTabContentContainerList, Map<String, String> nameMap) {

        List<CustomTabContentContainer> customTabContentContainerDateNotExistList = customTabContentContainerList.stream().filter(e -> {
                    Card card = (Card) e.getData();
                    CardContent cardContent01 = card.getContent().stream().filter(item -> nameMap.get("acceptedDate").equals(item.getLabel())).findFirst().get();
                    return StringUtils.isEmpty(cardContent01.getValue());
                }
        ).collect(Collectors.toList());

        List<CustomTabContentContainer> customTabContentContainerDateExistList = customTabContentContainerList.stream().filter(e -> {
                    Card card = (Card) e.getData();
                    CardContent cardContent01 = card.getContent().stream().filter(item -> nameMap.get("acceptedDate").equals(item.getLabel())).findFirst().get();
                    return StringUtils.isNotEmpty(cardContent01.getValue());
                }
        ).collect(Collectors.toList());

        customTabContentContainerDateExistList = customTabContentContainerDateExistList.stream().sorted((o1, o2) -> {
            Card card01 = (Card) o1.getData();
            String date01 = card01.getContent().stream().filter(e -> nameMap.get("acceptedDate").equals(e.getLabel())).findFirst().get().getValue();
            Card card02 = (Card) o2.getData();
            String date02 = card02.getContent().stream().filter(e -> nameMap.get("acceptedDate").equals(e.getLabel())).findFirst().get().getValue();

            LocalDate o1SDate = DateTimeUtil.parseLocalDateUseDefaultPattern(date01);
            LocalDate o2SDate = DateTimeUtil.parseLocalDateUseDefaultPattern(date02);
            return o1SDate.compareTo(o2SDate);
        }).collect(Collectors.toList());

        customTabContentContainerDateExistList.addAll(customTabContentContainerDateNotExistList);
        return customTabContentContainerDateExistList;
    }

    private String handleAcceptedDate(Object acceptedDate) {
        if (Objects.isNull(acceptedDate) || StringUtils.isEmpty((String) acceptedDate)) {
            return StringUtils.EMPTY;
        }
        String acceptedDateStr = String.valueOf(acceptedDate);
        acceptedDateStr = acceptedDateStr.substring(0, 10).replaceAll("/", "-");
        return acceptedDateStr;
    }

    private Map<String, String> buildNameMap(String locale) {
        Map<String, String> nameMap = new HashMap<>();
        String laborHours = localeService.getLanguageValue(locale, "计价");
        nameMap.put("laborHours", laborHours);
        String processWorkHours = localeService.getLanguageValue(locale, "已验");
        nameMap.put("processWorkHours", processWorkHours);
        String waitHour = localeService.getLanguageValue(locale, "待请");
        nameMap.put("waitHour", waitHour);
        String acceptedDate = localeService.getLanguageValue(locale, "验收日");
        nameMap.put("acceptedDate", acceptedDate);
        String localCurrPrice = localeService.getLanguageValue(locale, "最近单价");
        nameMap.put("localCurrPrice", localCurrPrice);
        String reasonCodeName = localeService.getLanguageValue(locale, "状况");
        nameMap.put("reasonCodeName", reasonCodeName);
        String attachemnt = localeService.getLanguageValue(locale, "附件");
        nameMap.put("attachemnt", attachemnt);
        String noticeAccount = localeService.getLanguageValue(locale, "通知请款");
        nameMap.put("noticeAccount", noticeAccount);
        String progressReport = localeService.getLanguageValue(locale, "进度回报");
        nameMap.put("progressReport", progressReport);
        String alreadyNotice = localeService.getLanguageValue(locale, "已通知");
        nameMap.put("alreadyNotice", alreadyNotice);
        String waitNotice = localeService.getLanguageValue(locale, "待通知");
        nameMap.put("waitNotice", waitNotice);
        String hour = localeService.getLanguageValue(locale, "小时");
        nameMap.put("hour", hour);
        return nameMap;
    }

    private CustomTab buidlEmptyTab(String name, Map<String, String> nameMap, String locale) {
        String tabName = name + "(0" + nameMap.get("hour") + ")";
        CustomTab customTab = new CustomTab();
        customTab.setName(tabName);
        customTab.setStyle(2);
        customTab.setAlignmentType(1);
        CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
        customTabContentContainer.setData(Empty.create(localeService.getLanguageValue(locale, "暂无数据")));
        customTabContentContainer.setContentCmptType(Empty.COMPONENT_TYPE);
        customTab.setContent(Collections.singletonList(customTabContentContainer));
        return customTab;
    }

    private String buildHour(Map<String, Object> arData, Map<String, String> nameMap, String labelName) {
        String value = handleHour(String.valueOf(MapUtil.getOrDefault(arData, labelName, "0")));
        String hour = value + nameMap.get("hour");
        return hour;
    }

    /**
     * 处理小数点后无用0
     *
     * @param hour
     * @return
     */
    private String handleHour(String hour) {
        if (StringUtils.isEmpty(hour)) {
            return "0";
        }
        return new BigDecimal(hour).stripTrailingZeros().toPlainString();
    }

    private CardContent buildCardContent(String name, Object value) {
        return new CardContent(name, Objects.isNull(value) ? "-" : String.valueOf(value), false, 1);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
