package com.digiwin.mobile.mobileuibot.task.strategy.custom.account;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author xujin
 * @desc 对账进度通知列表任务卡
 */
@Component("taskDetailBuildReconciliationProgressNoticeListStrategy")
public class TaskDetailBuildReconciliationProgressNoticeListStrategy implements TaskDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReconciliationProgressNoticeListStrategy.class);

    @Autowired
    private LocaleService localeService;

    private static final String HIGH_CREDITLEVEL = "ABC";

    private static final String MEDIUM_CREDITLEVEL = "DEF";

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_TYPE_RECONCILIATION_PROGRESS_NOTICE;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        StopWatch stopWatch = new StopWatch("Build Reconciliation Progress Notice List Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = JsonUtil.objectToJavaObject(args[0], DigiwinAtmcBacklogDetail.class);
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch, pcUiBotModel, digiwinAtmcBacklogDetail);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch, UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    // 单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    pageData.put(schema, titleBody);
                    break;
                case ZtbViewList.COMPONENT_TYPE:
                    ZtbViewList ztbViewList = JsonUtil.objectToJavaObject(pageData.get(schema), ZtbViewList.class);
                    ztbViewList = buildZtbViewList(pcUiBotModel, ztbViewList, locale);
                    pageData.put(schema, ztbViewList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    /**
     * 构建ZtbViewList
     *
     * @param pcUiBotModel
     * @param locale
     * @return
     */
    private ZtbViewList buildZtbViewList(UiBotModel pcUiBotModel, ZtbViewList ztbViewList, String locale) {
        ztbViewList.setTitle(localeService.getLanguageValue(locale, ztbViewList.getTitle()));
        List<Card> ztbViewCardList = ztbViewList.getData();
        Card cardTemplate = ztbViewCardList.get(0);

        Map<String, String> nameMap = buildNameMap(locale);
        List<Map<String, Object>> arDataList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("ar_data");
        List<Card> cardList = new ArrayList<>();
        for (Map<String, Object> arData : arDataList) {
            List<Tag> tagList = new LinkedList<>();
            if (!StringUtils.isEmpty((String) MapUtil.getOrDefault(arData, "credit_level_no", StringUtils.EMPTY))) {
                Tag creditLevelTag = buildCreditLevelTag((String) arData.get("credit_level_no"), nameMap);
                if (!Objects.isNull(creditLevelTag)) {
                    tagList.add(creditLevelTag);
                }
            }
            if (!StringUtils.isEmpty((String) MapUtil.getOrDefault(arData, "risk_level_id", StringUtils.EMPTY))) {
                Tag riskLevelTag = buildRiskLevelTag((String) arData.get("risk_level_id"));
                if (!Objects.isNull(riskLevelTag)) {
                    tagList.add(riskLevelTag);
                }
            }

            List<CardContent> contentList = new LinkedList<>();
            for (CardContent cardContentTemplate : cardTemplate.getContent()) {
                if (cardContentTemplate.getHiddenLabel()) {
                    contentList.add(buildCardContent(StringUtils.EMPTY, arData.get(cardContentTemplate.getSchema()), true));
                } else {
                    contentList.add(buildCardContent(localeService.getLanguageValue(locale, cardContentTemplate.getLabel()),
                            buildHour(arData, nameMap, cardContentTemplate.getSchema()), false));
                }
            }
            String customerName = (String) MapUtil.getOrDefault(arData, cardTemplate.getTitle(), StringUtils.EMPTY);

            String uuid = UUIDUtil.getUuid();
            Map<String, Object> rawDataMap = new HashMap<>();
            rawDataMap.put("ar_data_detail", arData);
            rawDataMap.put("refreshDataId", uuid);
            TabItemCardDetailPage tabItemCardDetailPage = new TabItemCardDetailPage();
            tabItemCardDetailPage.setDataId(uuid);
            tabItemCardDetailPage.setPageTitle(customerName);
            tabItemCardDetailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_DETAIL.toString());
            tabItemCardDetailPage.setRawData(rawDataMap);
            Card card = Card.create(customerName, contentList, tagList, tabItemCardDetailPage);
            card.setDataId(UUIDUtil.getUuid());
            cardList.add(card);
        }
        ztbViewList.setData(cardList);
        return ztbViewList;
    }

    /**
     * 构建名称集合
     *
     * @param locale
     * @return
     */
    private Map<String, String> buildNameMap(String locale) {
        Map<String, String> nameMap = new HashMap<>();
        String mediumRiskName = localeService.getLanguageValue(locale, "一般风险");
        nameMap.put("mediumRiskName", mediumRiskName);
        String creditLevel = localeService.getLanguageValue(locale, "信用等级");
        nameMap.put("creditLevel", creditLevel);
        String hour = localeService.getLanguageValue(locale, "小时");
        nameMap.put("hour", hour);
        return nameMap;
    }

    /**
     * 构建信用等级标签
     *
     * @param creditLevelNo
     * @param nameMap
     * @return
     */
    private Tag buildCreditLevelTag(String creditLevelNo, Map<String, String> nameMap) {
        Tag creditLevelTag = null;

        // 处理A+类似数据，只判断第一个字符
        String creditLevel = creditLevelNo.substring(0, 1).toUpperCase();
        if (HIGH_CREDITLEVEL.indexOf(creditLevel) > -1) {
            creditLevelTag = Tag.createNoRiskTag(nameMap.get("creditLevel") + creditLevelNo);
        } else if (MEDIUM_CREDITLEVEL.indexOf(creditLevel) > -1) {
            creditLevelTag = Tag.createMediumRiskTag(nameMap.get("creditLevel") + creditLevelNo);
        } else {
            creditLevelTag = Tag.createHighRiskTag(nameMap.get("creditLevel") + creditLevelNo);
        }
        return creditLevelTag;
    }

    /**
     * 构建风险等级标签
     * 10.低風險
     * 20.一般風險
     * 30.高風險
     *
     * @param riskLevelData
     * @return
     */
    private Tag buildRiskLevelTag(String riskLevelData) {
        Tag riskLevelTag = null;
        String[] riskLevelArg = riskLevelData.split("\\.");
        if (riskLevelArg.length < 2) {
            return null;
        }
        String tagName = riskLevelArg[1];
        String riskLevelType = riskLevelArg[0];
        switch (riskLevelType) {
            case "30":
                riskLevelTag = Tag.createHighRiskTag(tagName);
                break;
            case "20":
                riskLevelTag = Tag.createMediumRiskTag(tagName);
                break;
            case "10":
                riskLevelTag = Tag.createNoRiskTag(tagName);
                break;
            default:
        }
        return riskLevelTag;
    }

    private CardContent buildCardContent(String name, Object value, Boolean hiddenLabel) {
        return new CardContent(name, Objects.isNull(value) ? "-" : String.valueOf(value), hiddenLabel, 1);
    }

    /**
     * 处理小数点后无用0
     *
     * @param arData
     * @param nameMap
     * @param labelName
     * @return
     */
    private String buildHour(Map<String, Object> arData, Map<String, String> nameMap, String labelName) {
        String value = String.valueOf(MapUtil.getOrDefault(arData, labelName, "0"));
        value = new BigDecimal(value).stripTrailingZeros().toPlainString();
        String hour = value + nameMap.get("hour");
        return hour;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        return null;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
