package com.digiwin.mobile.mobileuibot.task.strategy.custom.account;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.JsRule;
import com.digiwin.mobile.mobileuibot.core.rule.JsRuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.task.model.ReconciliationProgressReasonEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xujin
 * @desc 对账周报进度回报页
 */
@Component("taskDetailBuildReconciliationProgressReportStrategy")
public class TaskDetailBuildReconciliationProgressReportStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReconciliationProgressReportStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Autowired
    private JsRuleService jsRuleService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Reconciliation Progress Report Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        // v2规则目前无法从km获取，先从mongodb获取
        List<JsRule> jsRuleList = jsRuleService.findByPageId(pageSetting.getPageId());
        if (!CollectionUtils.isEmpty(jsRuleList)) {
            List<UiBotRule> uiBotRuleList = new ArrayList<>(2);
            jsRuleList.forEach(jsRule -> {
                UiBotRule uiBotRule = new UiBotRule();
                BeanUtils.copyProperties(jsRule, uiBotRule);
                uiBotRuleList.add(uiBotRule);
            });
            if(uiBotModel != null){
                uiBotModel.setRules(uiBotRuleList);
            }
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect inputWindowSingleSelect = buildInputWindowSingleSelect(schema, locale);
                    pageData.put(schema, inputWindowSingleSelect);
                    break;
                case InputCalendar.COMPONENT_TYPE:
                    InputCalendar inputCalendar = buildInputCalendar(layout, locale);
                    pageData.put(schema, inputCalendar);
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    InputMultiText inputMultiText = buildInputMultiText(schema, locale);
                    pageData.put(schema, inputMultiText);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttonList = buildButton(apiRawData, locale);
                    pageData.put(schema, buttonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    /**
     * 构建日期组件
     *
     * @param layout
     * @param locale
     * @return
     */
    private InputCalendar buildInputCalendar(UiBotLayout layout, String locale) {
        layout.setHeaderName(localeService.getLanguageValue(locale, "预计立账日"));
        InputCalendar inputCalendar = InputCalendar.create(layout, null, locale);
        inputCalendar.setMinDateSelectable(InputCalendarDate.createToday());
        List<InputCalendarDate> calendarDateList = new ArrayList<>();
        calendarDateList.add(InputCalendarDate.createToday());
        inputCalendar.setDateValueList(calendarDateList);
        inputCalendar.setRequired(true);
        return inputCalendar;
    }

    /**
     * 构建单选组件
     *
     * @param schema
     * @param locale
     * @param schema
     * @param locale
     * @return
     */
    private InputWindowSingleSelect buildInputWindowSingleSelect(String schema, String locale) {
        Map<String, Object> rawDataMap = new HashMap<>(1);
        rawDataMap.put("isReconciliationProgress", true);
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(schema);
        windowSingleSelect.setTitle(localeService.getLanguageValue(locale, "新增原因码"));
        windowSingleSelect.setRawData(rawDataMap);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(localeService.getLanguageValue(locale, "请选择"));
        windowSingleSelect.setDefaultSelectId(ReconciliationProgressReasonEnum.D15.getCode());
        windowSingleSelect.setDefaultShowValue(ReconciliationProgressReasonEnum.D15.getDesc());
        windowSingleSelect.setRequired(true);
        return windowSingleSelect;
    }

    /**
     * 构建多行文本组件
     *
     * @param schema
     * @param locale
     * @return
     */
    private InputMultiText buildInputMultiText(String schema, String locale) {
        InputMultiText inputMultiText = null;
        if ("handle_desc".equalsIgnoreCase(schema)) {
            inputMultiText = InputMultiText.create(schema,
                    localeService.getLanguageValue(locale, "处理描述"),
                    "", true,
                    false, false, locale);
        }
        if ("internal_instructions".equalsIgnoreCase(schema)) {
            inputMultiText = InputMultiText.create(schema,
                    localeService.getLanguageValue(locale, "内部说明"),
                    "", true,
                    false, false, locale);
        }
        return inputMultiText;
    }

    /**
     * 构建按钮组件
     *
     * @param apiRawData
     * @param locale
     * @return
     */
    private List<BottomButtonDigiwinAthena> buildButton(ApiRawData apiRawData, String locale) {
        BottomButtonDigiwinAthena offlineButton = new BottomButtonDigiwinAthena();
        offlineButton.setName(localeService.getLanguageValue(locale, "提交"));
        apiRawData.put("buttonType", "progressReport");

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
        buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/reconciliationProgress/submit");
        buttonAction.setRawData(apiRawData);
        offlineButton.setAction(buttonAction);
        offlineButton.setType(BottomButtonStyleEnum.STRESS.getValue());
        return Collections.singletonList(offlineButton);
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
