package com.digiwin.mobile.mobileuibot.task.strategy.custom.aide;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * @author xujin
 * @desc 领料通知任务卡
 */
@Component("taskDetailBuildMaterialNoticeStrategy")
public class TaskDetailBuildMaterialNoticeStrategy implements TaskDetailBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildMaterialNoticeStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_TYPE_MATERIAL_NOTICE;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        StopWatch stopWatch = new StopWatch("Build Materia lNotice Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = JsonUtil.objectToJavaObject(args[0], DigiwinAtmcBacklogDetail.class);
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch, pcUiBotModel, digiwinAtmcBacklogDetail);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch, UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        if (pcUiBotModel.getPageData().get("uiBot__activity") == null) {
            return UiBotModel.emptyUibotModel(locale);
        }

        String digiProxyToken = StringUtils.EMPTY;
        ApiRawData apiRawData = apiRequest.getRawData();
        if(!Objects.isNull(apiRawData)){
            digiProxyToken = apiRawData.getString("digi-proxy-token");
        }

        List<Map<String, Object>> issueNoticeList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("issue_notice");
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    pageData.put(schema, titleBody);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    if ("custom_group_attachment".equalsIgnoreCase(schema)) {
                        CustomGroup attachmentCustomGroup = buildAttachmentFile(issueNoticeList, locale);
                        if(attachmentCustomGroup != null){
                            pageData.put(schema, attachmentCustomGroup);
                        }
                        break;
                    } else if ("custom_group_cardlist".equalsIgnoreCase(schema)) {
                        CustomGroup cardListCustomGroup = buildCardList(issueNoticeList, locale);
                        pageData.put(schema, cardListCustomGroup);
                        break;
                    }
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    Action buttonAction = new Action();
                    buttonAction.setType(ActionTypeEnum.CALL_API.getValue());

                    Map<String, Object> rawDataMap = new HashMap<>();
                    rawDataMap.put("digi-proxy-token", digiProxyToken);
                    rawDataMap.put("actionId", "ca.cim.issue.notice.info.update");
                    Map<String, Object> issueNoticeMap = new HashMap<>(1);
                    issueNoticeMap.put("issue_notice", issueNoticeList);
                    rawDataMap.put("data", issueNoticeMap);
                    UiBotAction pcUiBotAction = pcUiBotModel.getActions().stream().filter(
                                    item -> item.getType().equalsIgnoreCase("ESP"))
                            .findFirst().orElse(null);
                    rawDataMap.put("action", pcUiBotAction);
                    buttonAction.setRawData(rawDataMap);

                    List<BottomButtonDigiwinAthena> buttonList = new ArrayList<>(1);
                    BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
                    button.setName(LocaleUtil.getMobileTextByKey(locale, "提交"));
                    button.setAction(buttonAction);
                    button.setShowDot(true);
                    button.setType(BottomButtonStyleEnum.STRESS.getValue());
                    buttonList.add(button);
                    pageData.put(schema, buttonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    /**
     * 构建附件组件
     *
     * @return
     */
    private CustomGroup buildAttachmentFile(List<Map<String, Object>> issueNoticeList, String locale) {
        Set<String> fileIdList = issueNoticeList.stream()
                .filter(item -> item.get("issue_no_id") != null && StringUtils.isNotEmpty((String) item.get("issue_no_id")))
                .map(item -> (String) item.get("issue_no_id")).collect(Collectors.toSet());

        if(CollectionUtils.isEmpty(fileIdList)){
            return null;
        }

        List<AttachmentFile> attachmentFileList = new ArrayList<>();
        AttachmentFile attachmentFile = null;
        for (String fileId : fileIdList) {
            attachmentFile = new AttachmentFile();
            attachmentFile.setFileId(fileId);

            //应用文件格式没有返回文件格式，是写死pdf的
            attachmentFile.setFileName(fileId + ".pdf");
            attachmentFile.setFileExtension("pdf");
            attachmentFileList.add(attachmentFile);
        }
        Attachment attachment = new Attachment();
        attachment.setTitle(localeService.getLanguageValue(locale, "附件"));
        attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        attachment.setFileList(attachmentFileList);

        CustomGroupContent customGroupContent = new CustomGroupContent();
        String attachmentSchemaId = UUIDUtil.getUuid();
        UiBotLayout uiBotLayout = new UiBotLayout(attachmentSchemaId, Attachment.COMPONENT_TYPE);
        List<UiBotLayout> uiBotLayoutList = new LinkedList<>();
        uiBotLayoutList.add(uiBotLayout);
        customGroupContent.setLayout(uiBotLayoutList);

        UiBotPageData uiBotPageData = new UiBotPageData();
        uiBotPageData.put(attachmentSchemaId, attachment);
        customGroupContent.setPageData(uiBotPageData);
        CustomGroup customGroup = CustomGroup.create("", CustomGroupStyleTypeEnum.STYLE_INPUT_FORM, customGroupContent);
        return customGroup;
    }

    /**
     * 构建卡片列表内容
     *
     * @return
     */
    private CustomGroup buildCardList(List<Map<String, Object>> issueNoticeList, String locale) {
        String cardlistName = localeService.getLanguageValue(locale, "物料清单");
        if (CollectionUtils.isEmpty(issueNoticeList)) {
            return CustomGroup.createEmptyGroup(locale, cardlistName);
        }
        List<UiBotLayout> uiBotLayoutList = new LinkedList<>();
        UiBotLayout uiBotLayout = null;
        UiBotPageData uiBotPageData = new UiBotPageData();

        String issueQty = localeService.getLanguageValue(locale, "发料量");
        String issueNo = localeService.getLanguageValue(locale, "领料单号");
        String woNo = localeService.getLanguageValue(locale, "工单单号");
        Map<String, Object> cardContentMap = new LinkedHashMap<>(3);

        CustomGroupContent customGroupContent = new CustomGroupContent();
        for (Map<String, Object> issueNoticeMap : issueNoticeList) {
            // 提交需要该参数
            issueNoticeMap.put("uibot_checked", true);

            String schemaId = UUIDUtil.getUuid();
            uiBotLayout = new UiBotLayout(schemaId, Card.COMPONENT_TYPE);
            uiBotLayoutList.add(uiBotLayout);

            // 发料量+发料量单位
            cardContentMap.put(issueQty, issueNoticeMap.get("issue_qty") + " " + issueNoticeMap.get("unit_name"));
            cardContentMap.put(issueNo, issueNoticeMap.get("issue_no"));
            cardContentMap.put(woNo, issueNoticeMap.get("wo_no"));

            // 标题：下阶料号+品名+规格
            String title = issueNoticeMap.get("material_item_no") + " " + issueNoticeMap.get("material_name") + " " + issueNoticeMap.get("material_spec");
            uiBotPageData.put(schemaId, Card.create(title, cardContentMap));
        }
        customGroupContent.setLayout(uiBotLayoutList);
        customGroupContent.setPageData(uiBotPageData);
        return CustomGroup.create(cardlistName, CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING, customGroupContent);
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        return null;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
