package com.digiwin.mobile.mobileuibot.task.strategy.custom.aide;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author xujin
 * @desc 委外报工已完成任务卡
 */
@Component("taskDetailBuildOutSourceWorkReportCompleteDetailStrategy")
public class TaskDetailBuildOutSourceWorkReportCompleteDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildOutSourceWorkReportCompleteDetailStrategy.class);

    private static final String OUTSOURCINGTYPE = "1";

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build OutSource Work Complete Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();

        ApiRawData apiRawData = apiRequest.getRawData();
        Map<String, Object> outsourcingReportData = (Map<String, Object>) apiRawData.get("outsourcing_report");
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case Field.COMPONENT_TYPE:
                    Field field = buildField(outsourcingReportData, schema, layout.getLabel(), locale);
                    pageData.put(schema, field);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    buildButton(locale, schema, pageData);
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    /**
     * 构建Field组件
     *
     * @param outsourcingReportData
     * @param schema
     * @param locale
     * @return
     */
    private Field buildField(Map<String, Object> outsourcingReportData, String schema, String label, String locale) {
        String schemaData = outsourcingReportData.get(schema) != null ? String.valueOf(outsourcingReportData.get(schema)) : StringUtils.EMPTY;

        // 产品编号
        if ("item_no".equalsIgnoreCase(schema)) {
            schemaData = outsourcingReportData.get("item_no") + " " +
                    outsourcingReportData.get("item_name") + " " +
                    outsourcingReportData.get("item_spec");
        }

        // 外协类型
        if ("outsourcing_type".equalsIgnoreCase(schema)) {
            if (OUTSOURCINGTYPE.equals(outsourcingReportData.get(schema))) {
                schemaData = localeService.getLanguageValue(locale, "厂内外协");
            } else {
                schemaData = localeService.getLanguageValue(locale, "厂外外协");
            }
        }

        // 工艺名称
        if ("operation_section_name".equalsIgnoreCase(schema)) {
            schemaData = String.valueOf(outsourcingReportData.get("operation_section_name"));
        }

        // 预计交期
        if ("plan_delivery_date".equalsIgnoreCase(schema) || "report_date".equalsIgnoreCase(schema)) {
            if (StringUtils.isNotEmpty(schemaData)) {
                schemaData = schemaData.substring(0, 10);
            }
        }

        // 超交率
        if ("overrun_rate".equalsIgnoreCase(schema)) {
            if (StringUtils.isNotEmpty(schemaData)) {
                schemaData = schemaData + "%";
            }
        }

        String name = localeService.getLanguageValue(locale, label);
        Field field = Field.createLabelLeftValueRightField(name, schemaData);

        // 类别,选了工序号才展示
        String resourceCode = outsourcingReportData.get("resource_code") != null ? String.valueOf(outsourcingReportData.get("resource_code")) : StringUtils.EMPTY;
        if ("work_procedure_type".equalsIgnoreCase(schema) && StringUtils.isEmpty(resourceCode)) {
            field.setHidden(true);
        }
        return field;
    }

    /**
     * 构建按钮组件
     *
     * @param locale
     * @param schema
     * @param pageData
     * @return
     */
    private void buildButton(String locale, String schema, UiBotPageData pageData) {
        List<BottomButtonDigiwinAthena> buttonList = new ArrayList<>(1);
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton(locale);
        buttonList.add(cancelButton);
        pageData.put(schema, buttonList);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
