package com.digiwin.mobile.mobileuibot.task.strategy.custom.aide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.ValidateRuleLevelEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author xujin
 * @desc 委外报工任务卡
 */
@Component("taskDetailBuildOutSourceWorkReportDetailStrategy")
public class TaskDetailBuildOutSourceWorkReportDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildOutSourceWorkReportDetailStrategy.class);

    @Autowired
    private LocaleService localeService;

    private static final String OUTSOURCINGTYPE = "1";

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build OutSource Work Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();

        ApiRawData apiRawData = apiRequest.getRawData();
        Map<String, Object> outsourcingReportData = (Map<String, Object>) apiRawData.get("outsourcing_report");
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    for (UiBotLayout uiBotLayout : customGroupContent.getLayout()) {
                        handleCustomGroup(uiBotLayout, customGroupContent.getPageData(), outsourcingReportData, apiRawData, locale);
                    }
                    pageData.put(schema, customGroup);
                    break;
                case PageButton.COMPONENT_TYPE:
                    // 场内外协才展示报工明细
                    if (!OUTSOURCINGTYPE.equals(outsourcingReportData.get("outsourcing_type"))) {
                        break;
                    }
                    PageButton pageButton = new PageButton();
                    pageButton.setName(localeService.getLanguageValue(locale, layout.getLabel()));

                    Action action = new Action();
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_TASK_DETAIL.toString());
                    action.setJumpPageTitle(localeService.getLanguageValue(locale, layout.getLabel()));
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    action.setDataId(UUIDUtil.getUuid());

                    Map<String, Object> rawDataMap = new HashMap<>(3);
                    rawDataMap.put("outsourcing_report", outsourcingReportData);
                    Map<String, Object> executeContextMap = (Map<String, Object>) apiRawData.get("executeContext");
                    String proxyToken = (String) executeContextMap.get("proxyToken");
                    rawDataMap.put("digi-proxy-token", proxyToken);
                    Map<String, Object> businessUnitMap = (Map<String, Object>) executeContextMap.get("businessUnit");
                    rawDataMap.put("eoc_company_id", businessUnitMap.get("eoc_company_id"));
                    action.setRawData(rawDataMap);
                    pageButton.setAction(action);
                    pageData.put(schema, pageButton);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    buildButton(locale, schema, outsourcingReportData, pageData, apiRawData);
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private void handleCustomGroup(UiBotLayout layout, UiBotPageData pageData, Map<String, Object> outsourcingReportData, ApiRawData apiRawData, String locale) {
        String schema = layout.getSchema();
        String label = layout.getLabel();
        switch (layout.getType()) {
            case Field.COMPONENT_TYPE:
                Field field = buildField(outsourcingReportData, schema, label, locale);
                pageData.put(schema, field);
                break;
            case InputCalendar.COMPONENT_TYPE:
                InputCalendar inputCalendar = buildInputCalendar(layout, locale, schema);
                pageData.put(schema, inputCalendar);
                break;
            case InputNumeric.COMPONENT_TYPE:
                InputNumeric inputNumeric = buildInputNumeric(outsourcingReportData, schema, label, locale);
                pageData.put(schema, inputNumeric);
                break;
            case InputWindowSingleSelect.COMPONENT_TYPE:
                InputWindowSingleSelect inputWindowSingleSelect = buildInputWindowSingleSelect(outsourcingReportData, apiRawData, schema, label, locale);
                pageData.put(schema, inputWindowSingleSelect);
                break;
            default:
                break;
        }
    }

    /**
     * 构建Field组件
     *
     * @param outsourcingReportData
     * @param schema
     * @param locale
     * @return
     */
    private Field buildField(Map<String, Object> outsourcingReportData, String schema, String label, String locale) {
        String name = localeService.getLanguageValue(locale, label);
        String schemaData = outsourcingReportData.get(schema) != null ? String.valueOf(outsourcingReportData.get(schema)) : StringUtils.EMPTY;

        // 产品编号
        if ("item_no".equalsIgnoreCase(schema)) {
            schemaData = outsourcingReportData.get("item_no") + " " + outsourcingReportData.get("item_name") + " " + outsourcingReportData.get("item_spec");
        }

        // 工艺名称
        if ("operation_section_name".equalsIgnoreCase(schema)) {
            schemaData = String.valueOf(outsourcingReportData.get(schema));
        }

        // 外协类型
        if ("outsourcing_type".equalsIgnoreCase(schema)) {
            if (OUTSOURCINGTYPE.equals(outsourcingReportData.get(schema))) {
                schemaData = localeService.getLanguageValue(locale, "厂内外协");
            } else {
                schemaData = localeService.getLanguageValue(locale, "厂外外协");
            }
        }

        // 预计交期
        if ("plan_delivery_date".equalsIgnoreCase(schema)) {
            if (StringUtils.isNotEmpty(schemaData)) {
                schemaData = schemaData.substring(0, 10);
            }
        }

        // 超交率
        if ("overrun_rate".equalsIgnoreCase(schema)) {
            if (StringUtils.isNotEmpty(schemaData)) {
                schemaData = schemaData + "%";
            }
        }

        Field field = Field.createLabelLeftValueRightField(name, schemaData);
        return field;
    }

    /**
     * 构建日期组件
     *
     * @param layout
     * @param locale
     * @param schema
     * @return
     */
    private InputCalendar buildInputCalendar(UiBotLayout layout, String locale, String schema) {
        layout.setHeaderName(localeService.getLanguageValue(locale, layout.getLabel()));
        InputCalendar inputCalendar = InputCalendar.create(layout, null, locale);
        inputCalendar.setMaxDateSelectable(InputCalendarDate.createToday());
        List<InputCalendarDate> calendarDateList = new ArrayList<>();
        calendarDateList.add(InputCalendarDate.createToday());
        inputCalendar.setDateValueList(calendarDateList);
        inputCalendar.setRequired(true);


        List<ValidateRule> validateRuleList = new ArrayList<>(1);
        ValidateRule validateRule1 = new ValidateRule();
        validateRule1.setSchema(schema);
        validateRule1.setScope(ValidateRuleScopeEnum.EDIT.getScope());
        validateRule1.setType(ValidateRuleTypeEnum.DATE.getType());
        validateRule1.setOperatorType(2);
        validateRule1.setParameterDataType(RuleDataTypeEnum.DATE.getDataType());
        validateRule1.setParameterDate(DateTimeUtil.getNowDateMap());
        validateRule1.setLevel(ValidateRuleLevelEnum.WARNING_LEVEL_VERIFICATION.getLevelType());
        validateRule1.setWarningMessage(localeService.getLanguageValue(locale, "报工日期不是当天，请确定日期是否正确"));
        validateRuleList.add(validateRule1);
        inputCalendar.setValidateRuleList(validateRuleList);
        return inputCalendar;
    }

    /**
     * 构建InputNumeric组件
     *
     * @param outsourcingReportData
     * @param schema
     * @param locale
     * @return
     */
    private InputNumeric buildInputNumeric(Map<String, Object> outsourcingReportData, String schema, String label, String locale) {
        InputNumeric inputNumeric = null;
        //报工数量
        if ("report_qty".equalsIgnoreCase(schema)) {
            inputNumeric = buildReportQty(locale, outsourcingReportData, schema, label);
        }

        // 班次和帖/本/孔数
        if ("shift_no".equalsIgnoreCase(schema) || "others_qty".equalsIgnoreCase(schema)) {
            ParseFieldData fieldData = new ParseFieldData();
            fieldData.setLabel(localeService.getLanguageValue(locale, label));
            inputNumeric = InputNumeric.create(locale, fieldData, Collections.emptyList());
            inputNumeric.setText(StringUtils.EMPTY);
            inputNumeric.setPrecision(0);

            // 外协类型为1必填
            inputNumeric.setRequired(OUTSOURCINGTYPE.equals(outsourcingReportData.get("outsourcing_type")));
        }

        // 类别
        if ("work_procedure_type".equalsIgnoreCase(schema)) {
            ParseFieldData fieldData = new ParseFieldData();
            fieldData.setLabel(localeService.getLanguageValue(locale, label));
            inputNumeric = InputNumeric.create(locale, fieldData, Collections.emptyList());
            inputNumeric.setText(StringUtils.EMPTY);
            inputNumeric.setHidden(true);
        }
        return inputNumeric;
    }

    /**
     * 构建单选组件
     *
     * @param outsourcingReportData
     * @param apiRawData
     * @param schema
     * @param locale
     * @return
     */
    private InputWindowSingleSelect buildInputWindowSingleSelect(Map<String, Object> outsourcingReportData, ApiRawData apiRawData, String schema, String label, String locale) {
        UiBotLayout uiBotFieldLayout = new UiBotLayout();
        uiBotFieldLayout.setSchema(schema);
        uiBotFieldLayout.setHeaderName(localeService.getLanguageValue(locale, label));

        // 获取工序号弹框对应的option
        List<Map<String, Object>> operations = (List<Map<String, Object>>) apiRawData.get("operations");
        Optional<Map<String, Object>> optional = operations.stream().filter(e -> "openwindow".equalsIgnoreCase((String) e.get("operate"))).findFirst();
        Map<String, Object> uiBotFieldMap = new HashMap<>();
        if (optional.isPresent()) {
            uiBotFieldMap = optional.get();
        }
        JSONArray oerationList = new JSONArray();
        oerationList.add(uiBotFieldMap);
        uiBotFieldLayout.setOperations(oerationList);
        InputWindowSingleSelect windowSingleSelect = InputWindowSingleSelect.create(uiBotFieldLayout, null, AppContext.getBaseUrl()
                        + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema, locale,
                JSONObject.parseObject(JSONObject.toJSONString(apiRawData.get("executeContext")), UiBotExecuteContext.class));
        windowSingleSelect.getRawData().put("isOutSource", true);
        windowSingleSelect.getRawData().put("parameter", outsourcingReportData);

        // 外协类型为1必填
        windowSingleSelect.setRequired(OUTSOURCINGTYPE.equals(outsourcingReportData.get("outsourcing_type")));
        return windowSingleSelect;
    }

    /**
     * 构建报工数量组件
     *
     * @param locale
     * @param outsourcingReportData
     * @param schema
     * @return
     */
    private InputNumeric buildReportQty(String locale, Map<String, Object> outsourcingReportData, String schema, String label) {
        Integer unitDecimal = (Integer) MapUtil.getOrDefault(outsourcingReportData, "unit_decimal_places", 0);

        //根据unitDecimal保留小数点位数
        String remainingReportQty = String.format("%." + unitDecimal + "f", MapUtil.getOrDefault(outsourcingReportData, "remaining_report_qty", 0.0));

        Button button = new Button();
        button.setName(localeService.getLanguageValue(locale, "同报工剩余数量"));
        button.setType(ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());

        ParseFieldData fieldData = new ParseFieldData();
        fieldData.setLabel(localeService.getLanguageValue(locale, label));
        List<UiBotRule> uiBotRuleList = new ArrayList<>();
        InputNumeric inputNumeric = InputNumeric.create(locale, fieldData, uiBotRuleList, button, remainingReportQty, true);

        List<ValidateRule> validateRuleList = buidlReportQtyRules(locale, outsourcingReportData, schema);
        inputNumeric.setValidateRuleList(validateRuleList);

        return inputNumeric;
    }

    /**
     * 构建报工数量校验规则
     *
     * @param locale
     * @param outsourcingReportData
     * @param schema
     * @return
     */
    private List<ValidateRule> buidlReportQtyRules(String locale, Map<String, Object> outsourcingReportData, String schema) {
        Integer unitDecimal = (Integer) outsourcingReportData.get("unit_decimal_places");
        List<ValidateRule> validateRuleList = new ArrayList<>(2);
        ValidateRule validateRule1 = new ValidateRule();
        validateRule1.setSchema(schema);
        validateRule1.setScope(ValidateRuleScopeEnum.EDIT.getScope());
        validateRule1.setType(ValidateRuleTypeEnum.PATTERN.getType());
        if (unitDecimal > 0) {
            validateRule1.setParameter("^[0-9]+(.[0-9]{1," + unitDecimal + "})?$");
            validateRule1.setErrorMessage(localeService.getLanguageValue(locale, "只能输入数字和小数，小数位限制" + unitDecimal + "位"));
        } else {
            validateRule1.setParameter("^(0|[1-9][0-9]*)$");
            validateRule1.setErrorMessage(localeService.getLanguageValue(locale, "只能输入整数"));
        }
        validateRuleList.add(validateRule1);


        //累计报工数量
        String totalReportQty = String.valueOf(outsourcingReportData.get("total_report_qty"));

        //采购数量
        String purchaseQty = String.valueOf(outsourcingReportData.get("purchase_qty"));

        //超交率
        String overrunRate = String.valueOf(outsourcingReportData.get("overrun_rate"));

        if (StringUtils.isNotEmpty(overrunRate)) {
            // （累计报工+当前报工数量）<=采购数量*(1+超交率%)
            BigDecimal overrunRateBigDecimal = new BigDecimal(String.valueOf(overrunRate));
            BigDecimal rate = overrunRateBigDecimal.divide(new BigDecimal(String.valueOf(100))).add(new BigDecimal(1));
            BigDecimal maxReportQty = rate.multiply(new BigDecimal(String.valueOf(purchaseQty))).subtract(new BigDecimal(totalReportQty));

            ValidateRule validateMaxNumRule = new ValidateRule();
            validateMaxNumRule.setSchema(schema);
            validateMaxNumRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            validateMaxNumRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
            validateMaxNumRule.setParameter(maxReportQty.toString());
            validateMaxNumRule.setOperatorType(4);
            validateMaxNumRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
            validateMaxNumRule.setErrorMessage(localeService.getLanguageValue(locale, "累计报工数量已超过超交率" + overrunRate + "%的限制，请重新输入"));
            validateRuleList.add(validateMaxNumRule);
        }
        return validateRuleList;
    }

    /**
     * 构建按钮组件
     *
     * @param locale
     * @param schema
     * @param outsourcingReportData
     * @param pageData
     * @return
     */
    private void buildButton(String locale, String schema, Map<String, Object> outsourcingReportData, UiBotPageData pageData, ApiRawData apiRawData) {
        List<BottomButtonDigiwinAthena> buttonList = new ArrayList<>(2);
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton(locale);
        buttonList.add(cancelButton);

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API.getValue());

        Map<String, Object> rawDataMap = new HashMap<>();

        Map<String, Object> dataMap = new HashMap(1);
        dataMap.put("outsourcing_report", Collections.singletonList(outsourcingReportData));
        rawDataMap.put("data", dataMap);
        rawDataMap.put("action", apiRawData.get("action"));

        Map<String, Object> verCheckDataMap = new HashMap<>(1);
        Map<String, Object> verCheckDataParameterMap = new HashMap<>(1);
        Map<String, Object> versionInfoMap = new HashMap<>(2);
        versionInfoMap.put("id", outsourcingReportData.get("id"));
        versionInfoMap.put("version", 0);

        verCheckDataParameterMap.put("version_info", Collections.singletonList(versionInfoMap));
        verCheckDataMap.put("parameter", verCheckDataParameterMap);
        verCheckDataMap.put("actionId", "ca.cim.outsourcing.report.ver.check");
        rawDataMap.put("verCheckData", verCheckDataMap);


        Map<String, Object> detailInfoCheckDataMap = new HashMap<>(1);
        Map<String, Object> detailInfoCheckDataParameterMap = new HashMap<>(1);
        Map<String, Object> reportInfoMap = new HashMap<>(2);
        reportInfoMap.put("outsourcing_report_id", outsourcingReportData.get("id"));

        detailInfoCheckDataParameterMap.put("report_info", Collections.singletonList(reportInfoMap));
        detailInfoCheckDataMap.put("parameter", detailInfoCheckDataParameterMap);
        detailInfoCheckDataMap.put("actionId", "ca.cim.outsourcing.report.detail.info.check");
        rawDataMap.put("detailInfoCheckData", detailInfoCheckDataMap);


        Map<String, Object> reportInfoUpdateDataMap = new HashMap<>(1);
        reportInfoUpdateDataMap.put("actionId", "ca.cim.outsourcing.report.info.update");

        rawDataMap.put("reportInfoUpdateData", reportInfoUpdateDataMap);

        Map<String, Object> executeContextMap = (Map<String, Object>) apiRawData.get("executeContext");
        String proxyToken = (String) executeContextMap.get("proxyToken");
        rawDataMap.put("digi-proxy-token", proxyToken);

        buttonAction.setRawData(rawDataMap);

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(localeService.getLanguageValue(locale, "提交"));
        button.setAction(buttonAction);
        button.setShowDot(true);
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        buttonList.add(button);
        pageData.put(schema, buttonList);
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
