package com.digiwin.mobile.mobileuibot.task.strategy.custom.aide;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author xujin
 * @desc 委外报工任务卡
 */
@Component("taskDetailBuildOutSourceWorkReportListStrategy")
public class TaskDetailBuildOutSourceWorkReportListStrategy implements TaskDetailBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildOutSourceWorkReportListStrategy.class);

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_TYPE_OUTSOURCE_REPORT;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        StopWatch stopWatch = new StopWatch("Build OutSource Work List Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = JsonUtil.objectToJavaObject(args[0], DigiwinAtmcBacklogDetail.class);
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch, pcUiBotModel, digiwinAtmcBacklogDetail);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch, UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        ApiRawData apiRawData = apiRequest.getRawData();
        String digiProxyToken = apiRawData.getString("digi-proxy-token");

        UiBotLayout uiBotLayout = UiBotModel.getContentQueryButtonLayout(pcUiBotModel.getLayout());
        Map<String, Object> bodyMap = JsonUtil.objectToJavaObject(uiBotLayout.getQueryButtons().get(1), Map.class);
        bodyMap.put("executeContext", pcUiBotModel.getExecuteContext());
        UiBotModel completeUibotModle = digiwinPcUiBotProxyService.actionShowByProxyToken(locale, apiRequest.getTenantId(), digiProxyToken, iamUserToken, JsonUtil.javaObjectToJsonString(bodyMap));
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    pageData.put(schema, titleBody);
                    break;
                case CustomTabs.COMPONENT_TYPE:
                    CustomTabs customTabs = new CustomTabs();

                    // 待处理页签
                    buildCustomTabs(pcUiBotModel, customTabs, false, locale);

                    // 已完成页签
                    buildCustomTabs(completeUibotModle, customTabs, true, locale);
                    pageData.put(schema, customTabs);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    /**
     * 构建Tab页签数据，包括待处理和已完成
     *
     * @param pcUiBotModel
     * @param customTabs
     * @param isComplete
     * @param locale
     * @return
     */
    private void buildCustomTabs(UiBotModel pcUiBotModel, CustomTabs customTabs, boolean isComplete, String locale) {
        if (pcUiBotModel.getPageData().get("outsourcing_report") == null) {
            customTabs.add(buidlEmptyTab(isComplete, locale));
            return;
        }
        List<Map<String, Object>> outsourcingReportList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("outsourcing_report");
        int needHandleNum = outsourcingReportList.size();
        String tabName = localeService.getLanguageValue(locale, isComplete ? "已完成" : "待处理") + "(" + needHandleNum + ")";

        List<CustomTabContentContainer> customTabContentContainerList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(outsourcingReportList)) {
            String reportRemainName = localeService.getLanguageValue(locale, "报工剩余数量");
            String operationSeqName = localeService.getLanguageValue(locale, "工艺序");
            String handleName = localeService.getLanguageValue(locale, "去处理");

            Map<String, List<Map<String, Object>>> needHandleMapByWoNo = outsourcingReportList.stream().collect(Collectors.groupingBy(item -> (String) item.get("wo_no")));

            CustomTabContentContainer customTabContentContainer = null;
            for (Map.Entry<String, List<Map<String, Object>>> needHandleMap : needHandleMapByWoNo.entrySet()) {
                customTabContentContainer = new CustomTabContentContainer();

                List<BaseMobileComponentWrapper<BaseMobileComponent>> retracableContentContainerList = new ArrayList<>();
                for (Map<String, Object> needHandleItem : needHandleMap.getValue()) {
                    // 提交需要该参数
                    needHandleItem.put("uibot_checked", true);

                    Map<String, Object> cardContentMap = new HashMap<>();

                    List<Button> buttonList = new ArrayList<>();
                    Map<String, Object> rawDataMap = new HashMap<>();
                    rawDataMap.put("outsourcing_report", needHandleItem);
                    rawDataMap.put("isComplete", needHandleItem);

                    String buttonId = UUIDUtil.getUuid();
                    if (!isComplete) {
                        Action action = new Action();
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL.toString());
                        action.setJumpPageTitle(StringUtils.EMPTY);
                        action.setType(ActionTypeEnum.OPEN_TABS.getValue());
                        action.setParentComponent(Retractable.COMPONENT_TYPE);
                        action.setUseParentAction(true);
                        Optional<UiBotLayout> defaultOption = pcUiBotModel.getLayout().stream().filter(e -> "CONTENT_QUERY_BUTTON".equalsIgnoreCase(e.getType())).findFirst();
                        if (defaultOption.isPresent()) {
                            List<UiBotQueryButton> uiBotQueryButtonList = defaultOption.get().getQueryButtons();
                            Optional<UiBotQueryButton> innerOption = uiBotQueryButtonList.stream().filter(e -> "waitting".equalsIgnoreCase(e.getDataStateCode())).findFirst();
                            if (innerOption.isPresent()) {
                                List<Map<String, Object>> operationList = innerOption.get().getOperations();
                                rawDataMap.put("operations", operationList);
                            }
                        } else {
                            rawDataMap.put("operations", null);
                        }
                        rawDataMap.put("executeContext", pcUiBotModel.getExecuteContext());

                        UiBotAction pcUiBotAction = pcUiBotModel.getActions().stream().filter(
                                        item -> item.getType().equalsIgnoreCase("TaskEngine"))
                                .findFirst().orElse(null);
                        rawDataMap.put("action", pcUiBotAction);
                        action.setRawData(rawDataMap);
                        buttonList.add(Button.createButton(handleName, buttonId, BottomButtonStyleEnum.NORMAL.getValue(), action));
                    }

                    // 报工作业名称+编号
                    String cardTitle = needHandleItem.get("operation_name") + " " + needHandleItem.get("operation_no");
                    cardContentMap.put(reportRemainName, MapUtil.getOrDefault(needHandleItem, "remaining_report_qty", "0") + " " + needHandleItem.get("unit_name"));
                    cardContentMap.put(operationSeqName, needHandleItem.get("operation_seq"));

                    //已完成disableClick设为true不需要按钮只点击卡片就能出来详情
                    Card card = Card.create(cardTitle, cardContentMap, buttonList, isComplete);

                    TabItemCardDetailPage tabItemCardDetailPage = new TabItemCardDetailPage();
                    tabItemCardDetailPage.setDataId(buttonId);
                    if (isComplete) {
                        tabItemCardDetailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_COMPLETE_DETAIL.toString());
                    } else {
                        tabItemCardDetailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL.toString());
                    }
                    tabItemCardDetailPage.setRawData(rawDataMap);
                    card.setDetailPage(tabItemCardDetailPage);
                    retracableContentContainerList.add(new BaseMobileComponentWrapper<>(card, Card.COMPONENT_TYPE));
                }
                Map<String, Object> needHandleData = needHandleMap.getValue().get(0);
                String titleDesc = needHandleData.get("item_no") + " " + needHandleData.get("item_name") + " " + needHandleData.get("item_spec");

                Retractable retractable = new Retractable();
                retractable.setTitle(needHandleMap.getKey());
                retractable.setStyle(2);
                retractable.setAlignmentType(2);
                retractable.setDesc(titleDesc);
                retractable.setContent(retracableContentContainerList);
                customTabContentContainer.setData(retractable);
                customTabContentContainer.setContentCmptType(Retractable.COMPONENT_TYPE);
                customTabContentContainerList.add(customTabContentContainer);
            }
        }
        CustomTab customTab = new CustomTab();
        customTab.setName(tabName);
        customTab.setStyle(2);
        customTab.setAlignmentType(1);
        customTab.setContent(customTabContentContainerList);
        customTabs.add(customTab);
    }

    private CustomTab buidlEmptyTab(boolean isComplete, String locale) {
        String tabName = localeService.getLanguageValue(locale, isComplete ? "已完成" : "待处理") + "(0)";
        CustomTab customTab = new CustomTab();
        customTab.setName(tabName);
        customTab.setStyle(2);
        customTab.setAlignmentType(1);
        customTab.setContent(Collections.emptyList());
        return customTab;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        return null;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
