package com.digiwin.mobile.mobileuibot.task.strategy.custom.aide;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author xujin
 * @desc 委外报工报工报工明细维护
 */
@Component("taskDetailBuildOutSourceWorkReportTaskDetailStrategy")
public class TaskDetailBuildOutSourceWorkReportTaskDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildOutSourceWorkReportTaskDetailStrategy.class);

    private static final String ESP_ACTION_EMPLOYEE_DATA_GET = "esp_ca.cim.tt.athena.employee.data.get";

    private static final String ACTION_EMPLOYEE_DATA_GET = "ca.cim.tt.athena.employee.data.get";

    private static final String GROUPID_PREFIX = "Group";


    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build OutSource Work Task Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();

        String digiProxyToken = apiRawData.getString("digi-proxy-token");
        Map<String, Object> outsourcingReport = (Map<String, Object>) apiRawData.get("outsourcing_report");
        // tenantId值应该从任务详情返回的executeContext中取，因为定制逻辑中没有继续向下传递，故临时处理从报工数据中取值
        String tenantId = (String) outsourcingReport.get("tenant_id");

        // 先查询报工明细信息
        List<Map<String, Object>> reportInfoList = getReportDetail(apiRequest, outsourcingReport, digiProxyToken);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    List<UiBotLayout> uiBotLayoutList = customGroupContent.getLayout();

                    List<String> initGroupIds = new ArrayList<>();
                    List<UiBotLayout> uiBotLayoutCopyLinkedList = new LinkedList<>();
                    int suffixIndex = 0;
                    // 初始化渲染content内容,有多少值渲染多少组，每组通过后缀标识唯一性
                    if (!CollectionUtils.isEmpty(reportInfoList)) {
                        for (Map<String, Object> reportInfo : reportInfoList) {
                            List<UiBotLayout> uiBotLayoutCopyList = handleUiBotLayoutList(uiBotLayoutList, customGroupContent, apiRawData, reportInfo, locale, suffixIndex, true, tenantId);
                            uiBotLayoutCopyLinkedList.addAll(uiBotLayoutCopyList);
                            initGroupIds.add(GROUPID_PREFIX + suffixIndex);
                            suffixIndex++;
                        }
                    } else {
                        // 没有值，就渲染一组，指定后缀
                        List<UiBotLayout> uiBotLayoutCopyList = handleUiBotLayoutList(uiBotLayoutList, customGroupContent, apiRawData, Collections.emptyMap(), locale, suffixIndex, false, tenantId);
                        uiBotLayoutCopyLinkedList.addAll(uiBotLayoutCopyList);
                        initGroupIds.add(GROUPID_PREFIX + suffixIndex);
                    }
                    customGroup.setInitGroupIds(initGroupIds);
                    customGroupContent.setLayout(uiBotLayoutCopyLinkedList);

                    // 指定contentCopy格式体，前端根据该结构体来整体操作新增和删除
                    CustomGroupContent customGroupCopyContent = customGroup.getContentCopy();
                    for (UiBotLayout uiBotLayout : customGroupCopyContent.getLayout()) {
                        handleCustomGroup(uiBotLayout, customGroupCopyContent.getPageData(), locale, apiRawData, StringUtils.EMPTY, tenantId);
                    }
                    pageData.put(schema, customGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttonList = buildButton(locale, outsourcingReport, digiProxyToken);
                    pageData.put(schema, buttonList);
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private List<UiBotLayout> handleUiBotLayoutList(List<UiBotLayout> uiBotLayoutList, CustomGroupContent customGroupContent,
                                                    ApiRawData apiRawData, Map<String, Object> reportInfo, String locale, int suffixIndex, boolean hasInitVal, String tenantId) {
        List<UiBotLayout> uiBotLayoutCopyList = uiBotLayoutList.stream().map(e -> {
            UiBotLayout uiBotLayoutCopy = new UiBotLayout();
            BeanUtils.copyProperties(e, uiBotLayoutCopy);
            return uiBotLayoutCopy;
        }).collect(Collectors.toList());
        for (UiBotLayout uiBotLayoutCopyDetail : uiBotLayoutCopyList) {
            String customGroupContentSchema = uiBotLayoutCopyDetail.getSchema();
            if (StringUtils.isNotEmpty(customGroupContentSchema)) {
                uiBotLayoutCopyDetail.setSchema(customGroupContentSchema + "_" + GROUPID_PREFIX + suffixIndex);
            }
            uiBotLayoutCopyDetail.setGroupId(GROUPID_PREFIX + suffixIndex);
            if (hasInitVal) {
                handleCustomGroup(uiBotLayoutCopyDetail, customGroupContent.getPageData(), locale,
                        apiRawData, String.valueOf(MapUtil.getOrDefault(reportInfo, customGroupContentSchema, StringUtils.EMPTY)), tenantId);
            } else {
                handleCustomGroup(uiBotLayoutCopyDetail, customGroupContent.getPageData(), locale, apiRawData, StringUtils.EMPTY, tenantId);
            }
        }
        return uiBotLayoutCopyList;
    }


    /**
     * 查询报工明细信息
     *
     * @param apiRequest
     * @param outsourcingReport
     * @param digiProxyToken
     * @return List
     */
    private List<Map<String, Object>> getReportDetail(ApiRequest apiRequest, Map<String, Object> outsourcingReport, String digiProxyToken) {

        Map<String, Object> reportInfoMap = new HashMap<>(1);
        reportInfoMap.put("outsourcing_report_id", outsourcingReport.get("id"));
        Map<String, Object> parameterMap = new HashMap<>(1);
        parameterMap.put("report_info", Collections.singletonList(reportInfoMap));

        Map<String, Object> requestParamMap = new HashMap<>(2);
        requestParamMap.put("actionId", "ca.cim.outsourcing.report.detail.info.get");
        requestParamMap.put("parameter", parameterMap);

        DigiwinAthenaApiResponse<JSONObject> employeeInfo = digiwinAtdmProxyService
                .handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), digiProxyToken, requestParamMap);
        List<Map<String, Object>> reportInfoList = Optional.ofNullable(employeeInfo).map(DigiwinAthenaApiResponse::getResponse).map(e -> (List<Map<String, Object>>) e.get("report_info")).orElse(Collections.emptyList());
        return reportInfoList;
    }

    /**
     * 根据layout数据组装对应pageData
     *
     * @param layout
     * @param pageData
     * @param locale
     * @param apiRawData
     * @param value
     * @return List
     */
    private void handleCustomGroup(UiBotLayout layout, UiBotPageData pageData, String locale, ApiRawData apiRawData, String value, String tenantId) {
        String schema = layout.getSchema();
        switch (layout.getType()) {
            case InputSingleText.COMPONENT_TYPE:
                InputSingleText inputSingleText = buildInputSingleText(layout, value);
                pageData.put(schema, inputSingleText);
                break;
            case InputNumeric.COMPONENT_TYPE:
                InputNumeric inputNumeric = buildInputNumeric(layout, value, locale);
                pageData.put(schema, inputNumeric);
                break;
            case InputWindowSingleSelect.COMPONENT_TYPE:
                InputWindowSingleSelect inputWindowSingleSelect = buildInputWindowSingleSelect(layout, apiRawData, schema, value, locale, tenantId);
                pageData.put(schema, inputWindowSingleSelect);
                break;
            default:
                break;
        }
    }

    /**
     * 构建InputSingleText组件
     *
     * @param uiBotLayout
     * @return
     */
    private InputSingleText buildInputSingleText(UiBotLayout uiBotLayout, String value) {
        InputSingleText inputSingleText = InputSingleText.create(uiBotLayout.getLabel(), value);
        inputSingleText.setEnable(false);
        if (StringUtils.isEmpty(value)) {
            inputSingleText.setHidden(true);
        }
        return inputSingleText;
    }

    /**
     * 构建InputNumeric组件
     *
     * @param uiBotLayout
     * @param locale
     * @return
     */
    private InputNumeric buildInputNumeric(UiBotLayout uiBotLayout, String value, String locale) {
        InputNumeric inputNumeric = InputNumeric.create(99999999, 2,
                value, localeService.getLanguageValue(locale, uiBotLayout.getLabel()),
                InputNumericTypeEnum.INTEGER.getValue(), false, "");
        inputNumeric.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
        return inputNumeric;
    }

    /**
     * 构建单选组件
     *
     * @param uiBotLayout
     * @param schema
     * @param locale
     * @return
     */
    private InputWindowSingleSelect buildInputWindowSingleSelect(UiBotLayout uiBotLayout, ApiRawData apiRawData, String schema, String value, String locale, String tenantId) {
        Map<String, Object> rawDataMap = buildEmployeeDataSourceList(apiRawData.getString("eoc_company_id"), apiRawData.getString("digi-proxy-token"), tenantId);
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(uiBotLayout.getLabel());
        windowSingleSelect.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema);
        windowSingleSelect.setRawData(rawDataMap);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(localeService.getLanguageValue(locale, "请选择"));
        if (StringUtils.isNotEmpty(value)) {
            windowSingleSelect.setDefaultSelectId(value);
            windowSingleSelect.setDefaultShowValue(value);
        }
        windowSingleSelect.setRequired(true);
        return windowSingleSelect;
    }

    /**
     * 构建按钮组件
     *
     * @param locale
     * @param outsourcingReportData
     * @param digiProxyToken
     * @return
     */
    private List<BottomButtonDigiwinAthena> buildButton(String locale, Map<String, Object> outsourcingReportData, String digiProxyToken) {
        List<BottomButtonDigiwinAthena> buttonList = new ArrayList<>(2);
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton(locale);
        buttonList.add(cancelButton);

        Map<String, Object> requestParamMap = new HashMap<>();
        requestParamMap.put("actionId", "ca.cim.outsourcing.report.detail.info.update");
        requestParamMap.put("outsourcing_report_id", outsourcingReportData.get("id"));
        requestParamMap.put("digi-proxy-token", digiProxyToken);
        requestParamMap.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_TASK_DETAIL.toString());

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
        buttonAction.setRawData(requestParamMap);
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(localeService.getLanguageValue(locale, "保存"));
        button.setAction(buttonAction);
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        buttonList.add(button);
        return buttonList;
    }

    private Map<String, Object> buildEmployeeDataSourceList(String eocCompanyId, String proxyToken, String tenantId) {
        PcUiBotDataSourceDTO pcUiBotDataSourceDTO = new PcUiBotDataSourceDTO();
        pcUiBotDataSourceDTO.setDataKeys(Collections.singletonList("employee_no"));
        pcUiBotDataSourceDTO.setType("ESP");
        pcUiBotDataSourceDTO.setActionId(ESP_ACTION_EMPLOYEE_DATA_GET);

        PcUiBotQueryAction pcUiBotQueryAction = new PcUiBotQueryAction();
        pcUiBotQueryAction.setTitle("员工信息");
        pcUiBotQueryAction.setActionId(ESP_ACTION_EMPLOYEE_DATA_GET);
        pcUiBotQueryAction.setCategory("ESP");

        PcUiBotActionServiceId pcUiBotActionServiceId = new PcUiBotActionServiceId();
        pcUiBotActionServiceId.setName(ACTION_EMPLOYEE_DATA_GET);
        pcUiBotActionServiceId.setHostAcct("athena");
        pcUiBotActionServiceId.setTenant_id(tenantId);
        pcUiBotQueryAction.setServiceId(pcUiBotActionServiceId);

        PcUiBotActionParameterMapping pcUiBotActionParameterMapping = new PcUiBotActionParameterMapping();
        pcUiBotActionParameterMapping.setName("eoc_company_id");
        pcUiBotActionParameterMapping.setType("CONSTANT");
        pcUiBotActionParameterMapping.setValue(eocCompanyId);
        pcUiBotQueryAction.setActionParams(Collections.singletonList(pcUiBotActionParameterMapping));

        Map<String, Object> businessUnitMap = new HashMap<>(1);
        businessUnitMap.put("eoc_company_id", eocCompanyId);
        pcUiBotQueryAction.setBusinessUnit(businessUnitMap);

        pcUiBotDataSourceDTO.setAction(pcUiBotQueryAction);

        List<PcUiBotDataSourceDTO> dataSourceList = new ArrayList<>();
        dataSourceList.add(pcUiBotDataSourceDTO);

        Map<String, Object> dataSourceListMap = new HashMap<>(1);
        dataSourceListMap.put("dataSourceList", dataSourceList);

        Map<String, Object> paramMap = new HashMap<>(2);
        paramMap.put("dataSourceSet", dataSourceListMap);

        Map<String, Object> executeContextMap = new HashMap<>(1);
        executeContextMap.put("proxyToken", proxyToken);
        paramMap.put("executeContext", executeContextMap);
        return paramMap;
    }

    /**
     * 任务明细保存操作
     *
     * @param apiRequestSubmit
     * @return ActionSubmitResult
     */
    public ActionSubmitResult submit(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        List<List<ActionSubmitParam>> groupSubmitParamList = apiRequestSubmit.getGroupSubmitParamList();
        if (CollectionUtils.isEmpty(groupSubmitParamList)) {
            return ActionSubmitResult.create(false, localeService.getLanguageValue(locale, "请输入报工明细"));
        }

        JSONObject rawData = apiRequestSubmit.getRawData();
        Set<String> employeeNoSet = new HashSet<>();
        List<Map<String, Object>> reportInfoDetailList = new ArrayList<>();
        for (List<ActionSubmitParam> actionSubmitParamList : groupSubmitParamList) {
            Map<String, Object> reportInfoDetail = new HashMap<>(6);
            reportInfoDetail.put("outsourcing_report_id", rawData.getString("outsourcing_report_id"));
            for (ActionSubmitParam actionSubmitParam : actionSubmitParamList) {
                switch (actionSubmitParam.getType()) {
                    case InputNumeric.COMPONENT_TYPE:
                        String schema = actionSubmitParam.getSchema();
                        Map<String, Object> paramMap = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), Map.class);
                        if (schema.startsWith("work_hours")) {
                            reportInfoDetail.put("work_hours", paramMap.get("text"));
                        }
                        if (schema.startsWith("machine_hours")) {
                            reportInfoDetail.put("machine_hours", paramMap.get("text"));
                        }
                        if (schema.startsWith("adjust_hours")) {
                            reportInfoDetail.put("adjust_hours", paramMap.get("text"));
                        }
                        break;
                    case InputWindowSingleSelect.COMPONENT_TYPE:
                        paramMap = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), Map.class);
                        //员工编号
                        reportInfoDetail.put("employee_no", paramMap.get("selectId"));
                        // 校验员工工号不能重复
                        if (employeeNoSet.contains(reportInfoDetail.get("employee_no"))) {
                            return ActionSubmitResult.create(false, localeService.getLanguageValue(locale, "员工" + reportInfoDetail.get("employee_no") + "存在多条记录，请核查"));
                        } else {
                            employeeNoSet.add((String) reportInfoDetail.get("employee_no"));
                        }
                        //员工姓名
                        Map<String, Object> detailMap = JsonUtil.objectToJavaObject(paramMap.get("detail"), Map.class);
                        if (detailMap != null) {
                            reportInfoDetail.put("employee_name", detailMap.get("employee_name"));
                        }
                        break;
                    default:
                        break;
                }
            }
            // 校验出勤时数、开机时间、调规时间字段不可同时为空
            if (StringUtil.isEmpty(reportInfoDetail.get("work_hours"))
                    && StringUtil.isEmpty(reportInfoDetail.get("machine_hours"))
                    && StringUtil.isEmpty(reportInfoDetail.get("adjust_hours"))) {
                return ActionSubmitResult.create(false, localeService.getLanguageValue(locale, "出勤时数、开机时间、调规时间字段不可同时为空"));
            }
            reportInfoDetailList.add(reportInfoDetail);
        }
        Map<String, Object> reportInfoMap = new HashMap<>(1);
        reportInfoMap.put("report_info", reportInfoDetailList);

        Map<String, Object> requestParamMap = new HashMap<>(2);
        requestParamMap.put("parameter", reportInfoMap);
        requestParamMap.put("actionId", rawData.getString("actionId"));
        DigiwinAthenaApiResponse<JSONObject> resp = digiwinAtdmProxyService
                .handleByActionId(locale, apiRequestSubmit.getIamUserToken(),
                        apiRequestSubmit.getTenantId(), rawData.getString("digi-proxy-token"), requestParamMap);
        boolean isSuccess = resp.getStatus() == 200 && StringUtil.isEmpty(resp.getErrorMessage());

        Action action = new Action<>();
        if (isSuccess) {
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL.toString());
            action.setSuccessMsg(localeService.getLanguageValue(locale, "保存成功"));
            return ActionSubmitResult.create(true, action);
        } else {
            action.setType(ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());
            action.setToastMsg(localeService.getLanguageValue(locale, "保存失败"));
            return ActionSubmitResult.create(false, action);
        }
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
